/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.mui.volumetric;

import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.casting.RayCastState;
import com.mimvista.internals.linking.ViewLink;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Volumetric3DViewModeOption
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final float a = 100.0f;
    JLabel viewModeTitle;
    JRadioButton orthogonalToggle;
    JRadioButton perspectiveToggle;
    JRadioButton customToggle;
    JCheckBox yesImPro;
    JSlider cameraRayPositionSpreadX;
    JSlider cameraRayPositionSpreadY;
    JSlider cameraRayDirectionSpreadX;
    JSlider cameraRayDirectionSpreadY;

    public Volumetric3DViewModeOption(final ViewController3D viewController3D) {
        RayCastState rayCastState = viewController3D.cJ().j();
        this.viewModeTitle = new JLabel("Viewing Mode");
        this.orthogonalToggle = new JRadioButton("Orthogonal");
        this.perspectiveToggle = new JRadioButton("Perspective");
        this.customToggle = new JRadioButton("Custom");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.orthogonalToggle);
        buttonGroup.add(this.perspectiveToggle);
        buttonGroup.add(this.customToggle);
        if (rayCastState.camera.viewMode == 1) {
            this.orthogonalToggle.setSelected(true);
        } else if (rayCastState.camera.viewMode == 0) {
            this.perspectiveToggle.setSelected(true);
        } else {
            this.customToggle.setSelected(true);
        }
        this.cameraRayPositionSpreadX = new JSlider(1, 300);
        this.cameraRayPositionSpreadY = new JSlider(1, 300);
        this.cameraRayDirectionSpreadX = new JSlider(1, 100);
        this.cameraRayDirectionSpreadY = new JSlider(1, 100);
        viewController3D.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    RayCastState rayCastState = viewController3D.cJ().j();
                    if (rayCastState.camera.viewMode == 1) {
                        Volumetric3DViewModeOption.this.cameraRayPositionSpreadX.setValue((int)rayCastState.camera.h());
                        Volumetric3DViewModeOption.this.cameraRayPositionSpreadY.setValue((int)rayCastState.camera.i());
                    }
                }
                catch (Exception exception) {
                    viewController3D.b(this, ViewLink.ViewEvent.b);
                }
            }
        }, ViewLink.ViewEvent.b);
        this.b(viewController3D);
        this.yesImPro = new JCheckBox("Advanced view options");
        this.yesImPro.setSelected(false);
        this.a();
        this.yesImPro.setVisible(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.viewModeTitle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.yesImPro, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.orthogonalToggle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.perspectiveToggle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.customToggle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.cameraRayPositionSpreadX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.cameraRayPositionSpreadY, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.cameraRayDirectionSpreadX, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.cameraRayDirectionSpreadY, gridBagConstraints);
    }

    public void a(final ViewController3D viewController3D) {
        this.yesImPro.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Volumetric3DViewModeOption.this.a();
            }
        });
        this.orthogonalToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Volumetric3DViewModeOption.this.b(viewController3D);
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.perspectiveToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Volumetric3DViewModeOption.this.b(viewController3D);
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.customToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Volumetric3DViewModeOption.this.b(viewController3D);
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.cameraRayPositionSpreadX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                viewController3D.cJ().b((float)Volumetric3DViewModeOption.this.cameraRayPositionSpreadX.getValue(), viewController3D.cJ().j().camera.i());
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.cameraRayPositionSpreadY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                viewController3D.cJ().b(viewController3D.cJ().j().camera.h(), (float)Volumetric3DViewModeOption.this.cameraRayPositionSpreadY.getValue());
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.cameraRayDirectionSpreadX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                viewController3D.cJ().a((float)Volumetric3DViewModeOption.this.cameraRayDirectionSpreadX.getValue() / 100.0f, viewController3D.cJ().j().camera.k());
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
        this.cameraRayDirectionSpreadY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                viewController3D.cJ().a(viewController3D.cJ().j().camera.j(), (float)Volumetric3DViewModeOption.this.cameraRayDirectionSpreadY.getValue() / 100.0f);
                viewController3D.bB();
                viewController3D.g().Q();
            }
        });
    }

    private void b(ViewController3D viewController3D) {
        if (this.orthogonalToggle.isSelected()) {
            viewController3D.cJ().c(1);
            RayCastState rayCastState = viewController3D.cJ().j();
            this.cameraRayDirectionSpreadX.setEnabled(false);
            this.cameraRayDirectionSpreadX.setValue(0);
            this.cameraRayDirectionSpreadY.setEnabled(false);
            this.cameraRayDirectionSpreadY.setValue(0);
            this.cameraRayPositionSpreadX.setEnabled(true);
            this.cameraRayPositionSpreadX.setValue((int)rayCastState.camera.h());
            this.cameraRayPositionSpreadY.setEnabled(true);
            this.cameraRayPositionSpreadY.setValue((int)rayCastState.camera.i());
        } else if (this.perspectiveToggle.isSelected()) {
            viewController3D.cJ().c(0);
            RayCastState rayCastState = viewController3D.cJ().j();
            this.cameraRayDirectionSpreadX.setEnabled(true);
            this.cameraRayDirectionSpreadX.setValue((int)(rayCastState.camera.j() * 100.0f));
            this.cameraRayDirectionSpreadY.setEnabled(true);
            this.cameraRayDirectionSpreadY.setValue((int)(rayCastState.camera.k() * 100.0f));
            this.cameraRayPositionSpreadX.setEnabled(false);
            this.cameraRayPositionSpreadX.setValue(0);
            this.cameraRayPositionSpreadY.setEnabled(false);
            this.cameraRayPositionSpreadY.setValue(0);
        } else {
            viewController3D.cJ().c(0);
            this.cameraRayDirectionSpreadX.setEnabled(true);
            this.cameraRayDirectionSpreadY.setEnabled(true);
            this.cameraRayPositionSpreadX.setEnabled(true);
            this.cameraRayPositionSpreadY.setEnabled(true);
        }
    }

    private void a() {
        this.cameraRayDirectionSpreadX.setVisible(this.yesImPro.isSelected());
        this.cameraRayDirectionSpreadX.setEnabled(this.yesImPro.isSelected());
        this.cameraRayDirectionSpreadY.setVisible(this.yesImPro.isSelected());
        this.cameraRayDirectionSpreadY.setEnabled(this.yesImPro.isSelected());
        this.cameraRayPositionSpreadX.setVisible(this.yesImPro.isSelected());
        this.cameraRayPositionSpreadX.setEnabled(this.yesImPro.isSelected());
        this.cameraRayPositionSpreadY.setVisible(this.yesImPro.isSelected());
        this.cameraRayPositionSpreadY.setEnabled(this.yesImPro.isSelected());
        this.customToggle.setVisible(this.yesImPro.isSelected());
        this.customToggle.setEnabled(this.yesImPro.isSelected());
    }
}

