/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.network;

import com.google.common.collect.Lists;
import com.mimvista.ExternallyVisible;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@ExternallyVisible
public class NoSSLv3SocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory a = SSLContext.getDefault().getSocketFactory();

    @Override
    public Socket createSocket() throws IOException {
        return this.a.createSocket();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2, boolean bl2) throws IOException {
        Socket socket2 = this.a.createSocket(socket, string, n2, bl2);
        return NoSSLv3SocketFactory.removeSSLv3FromProtocols(socket2);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.a.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.a.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        Socket socket = this.a.createSocket(string, n2);
        return NoSSLv3SocketFactory.removeSSLv3FromProtocols(socket);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        Socket socket = this.a.createSocket(inetAddress, n2);
        return NoSSLv3SocketFactory.removeSSLv3FromProtocols(socket);
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        Socket socket = this.a.createSocket(string, n2, inetAddress, n3);
        return NoSSLv3SocketFactory.removeSSLv3FromProtocols(socket);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        Socket socket = this.a.createSocket(inetAddress, n2, inetAddress2, n3);
        return NoSSLv3SocketFactory.removeSSLv3FromProtocols(socket);
    }

    public static Socket removeSSLv3FromProtocols(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            ArrayList arrayList = Lists.newArrayList();
            for (String string : sSLSocket.getSupportedProtocols()) {
                if ("SSLv3".equalsIgnoreCase(string)) continue;
                arrayList.add(string);
            }
            sSLSocket.setEnabledProtocols(arrayList.toArray(new String[0]));
            return sSLSocket;
        }
        return socket;
    }
}

