/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mimvista.MimJsonSerializable;
import com.mimvista.neuro.AbstractNormalPatient;
import com.mimvista.neuro.ComparisonSet;
import com.mimvista.neuro.ComparisonSetFactory;
import com.mimvista.neuro.PatientSet;
import com.mimvista.neuro.a;
import com.mimvista.neuro.g;
import com.mimvista.util.Messages;
import com.mimvista.viewer.SeriesInfo;
import java.util.List;

@MimJsonSerializable
public class DynamicComparisonSet
extends ComparisonSet {
    public static final String MIM_DEFAULT_NAME = Messages.a("Neuro", "MIM_DEFAULT_NAME");
    public static final String MIM_MATCHING_GENDERS_NAME = Messages.a("Neuro", "MIM_MATCHING_GENDERS_NAME");
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private boolean matchAtten = false;
    @JsonIgnore
    private String sex = "";
    @JsonIgnore
    private String[] keywords = new String[0];
    @JsonIgnore
    private int minAge = 0;
    @JsonIgnore
    private int maxAge = Integer.MAX_VALUE;
    @JsonIgnore
    private String cam = "";
    @JsonIgnore
    private String recon = "";
    @JsonIgnore
    private String atten = "";
    private String patientSetName = "Normals";
    private int ageWindow = 20;
    private boolean matchCamera = false;
    private boolean matchRecon = false;
    private boolean matchSex = false;
    private boolean matchAge = false;

    public DynamicComparisonSet(PatientSet patientSet, String string, ComparisonSetFactory.ComparisonSetType comparisonSetType, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, String string2) {
        super(string2);
        this.isDynamic = true;
        this.name = string;
        this.type = comparisonSetType;
        this.matchAge = bl5;
        this.matchSex = bl2;
        this.matchCamera = bl3;
        this.matchRecon = bl4;
        this.ageWindow = n2;
        this.patientSetName = patientSet.name;
        this.patients = patientSet.c();
    }

    @JsonCreator
    public DynamicComparisonSet(@JsonProperty(value="name") String string, @JsonProperty(value="patientSetName") String string2, @JsonProperty(value="type") ComparisonSetFactory.ComparisonSetType comparisonSetType, @JsonProperty(value="matchSex") boolean bl2, @JsonProperty(value="matchCamera") boolean bl3, @JsonProperty(value="matchRecon") boolean bl4, @JsonProperty(value="matchAge") boolean bl5, @JsonProperty(value="ageWindow") int n2, @JsonProperty(value="id") String string3) {
        this(comparisonSetType.c().e(string2), string, comparisonSetType, bl2, bl3, bl4, bl5, n2, string3);
    }

    public DynamicComparisonSet(String string, ComparisonSetFactory.ComparisonSetType comparisonSetType, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, String string2) {
        this(string, "Normals", comparisonSetType, bl2, bl3, bl4, bl5, n2, string2);
    }

    DynamicComparisonSet(List<AbstractNormalPatient> list, ComparisonSetFactory.ComparisonSetType comparisonSetType, String string) {
        super(string);
        this.isDynamic = true;
        this.patients = list;
        this.type = comparisonSetType;
    }

    public static String getDefaultNameForType(ComparisonSetFactory.ComparisonSetType comparisonSetType) {
        if (comparisonSetType == ComparisonSetFactory.ComparisonSetType.b) {
            return MIM_MATCHING_GENDERS_NAME;
        }
        return MIM_DEFAULT_NAME;
    }

    @Override
    public List<AbstractNormalPatient> getIncludedPatients(String string, String string2) {
        return new g(this.sex, this.minAge, this.maxAge, this.keywords, string, string2, this.cam, this.recon, this.atten).a(this.patients);
    }

    @Override
    public void apply(SeriesInfo seriesInfo) {
        this.setPatientAge(seriesInfo.C());
        this.setPatientSex(seriesInfo.originalSex);
        this.setPatientRecon(seriesInfo.reconstructionMethod);
        String string = seriesInfo.manufacturer;
        string = string.replace(" / MIM Software Inc.", "");
        string = string.replace(" / MIM Software", "");
        string = string.replace(" / MIMvista", "");
        this.setPatientCamera(string + " " + seriesInfo.modelName);
    }

    public void setAgeWindow(int n2) {
        this.ageWindow = n2;
    }

    public void setMatchAge(boolean bl2) {
        this.matchAge = bl2;
    }

    public void setPatientSex(String string) {
        if (this.matchSex) {
            this.sex = string;
        }
    }

    public void setPatientAge(int n2) {
        if (this.matchAge) {
            if (n2 < 0) {
                this.minAge = Integer.MAX_VALUE;
                this.maxAge = Integer.MIN_VALUE;
            } else {
                this.minAge = Math.max(0, n2 - this.ageWindow);
                this.maxAge = n2 + this.ageWindow;
            }
        } else {
            this.minAge = Integer.MIN_VALUE;
            this.maxAge = Integer.MAX_VALUE;
        }
    }

    public void setPatientCamera(String string) {
        if (this.matchCamera) {
            this.cam = string;
        }
    }

    public void setPatientRecon(String string) {
        if (this.matchRecon) {
            this.recon = string;
        }
    }

    public void setPatientAtten(String string) {
        if (this.matchAtten) {
            this.atten = string;
        }
    }

    public void setMatchSex(boolean bl2) {
        this.matchSex = bl2;
    }

    @Override
    public a getFactory() {
        return this.type.c();
    }

    public String getPatientSetName() {
        return this.patientSetName;
    }

    public int getAgeWindow() {
        return this.ageWindow;
    }

    public boolean isMatchAge() {
        return this.matchAge;
    }

    public boolean isMatchCamera() {
        return this.matchCamera;
    }

    public boolean isMatchRecon() {
        return this.matchRecon;
    }

    public boolean isMatchSex() {
        return this.matchSex;
    }

    public ComparisonSetFactory.ComparisonSetType getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + this.ageWindow;
        n3 = 31 * n3 + (this.matchAge ? 1231 : 1237);
        n3 = 31 * n3 + (this.matchCamera ? 1231 : 1237);
        n3 = 31 * n3 + (this.matchRecon ? 1231 : 1237);
        n3 = 31 * n3 + (this.matchSex ? 1231 : 1237);
        n3 = 31 * n3 + (this.patientSetName == null ? 0 : this.patientSetName.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynamicComparisonSet dynamicComparisonSet = (DynamicComparisonSet)object;
        if (this.ageWindow != dynamicComparisonSet.ageWindow) {
            return false;
        }
        if (this.matchAge != dynamicComparisonSet.matchAge) {
            return false;
        }
        if (this.matchCamera != dynamicComparisonSet.matchCamera) {
            return false;
        }
        if (this.matchRecon != dynamicComparisonSet.matchRecon) {
            return false;
        }
        if (this.matchSex != dynamicComparisonSet.matchSex) {
            return false;
        }
        return !(this.patientSetName == null ? dynamicComparisonSet.patientSetName != null : !this.patientSetName.equals(dynamicComparisonSet.patientSetName));
    }
}

