/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro;

import com.mimvista.ExternallyVisible;
import com.mimvista.file.MIMFile;
import com.mimvista.neuro.ComparisonSetFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

@ExternallyVisible
public abstract class SealedPatientSetBuilder {
    private String a;

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println();
            throw new IllegalArgumentException("Invalid arguments (" + Arrays.toString(stringArray) + "). expected a normal type (cardiac or neuro) and a directory.");
        }
        if (!"cardiac".equalsIgnoreCase(stringArray[0]) && !"neuro".equalsIgnoreCase(stringArray[0])) {
            throw new IllegalArgumentException("Invalid argument (" + stringArray[0] + "). Expected normal type (cardiac or neuro)");
        }
        if (!new MIMFile(stringArray[1]).isDirectory()) {
            throw new IllegalArgumentException("Invalid argument (" + stringArray[1] + ").  Expected an extant directory");
        }
        ComparisonSetFactory.ComparisonSetType.valueOf(stringArray[0].toUpperCase()).c().d(stringArray[1]).run();
    }

    public SealedPatientSetBuilder(String string) {
        this.a = string;
    }

    public abstract boolean isValidSetDirectory(File var1);

    public abstract void buildSet(MIMFile var1, File[] var2);

    public void run() {
        final ArrayList arrayList = new ArrayList();
        MIMFile mIMFile = new MIMFile(this.a);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    file.listFiles(this);
                } else {
                    File file2 = file.getParentFile();
                    if (SealedPatientSetBuilder.this.isValidSetDirectory(file2) && !arrayList.contains(file2)) {
                        arrayList.add(file2);
                    }
                }
                return false;
            }
        };
        mIMFile.listFiles(fileFilter);
        if (arrayList.size() == 0) {
            return;
        }
        File[] fileArray = arrayList.toArray(new File[0]);
        Arrays.sort(fileArray, new Comparator<File>(){

            public int a(File file, File file2) {
                return file.getName().compareToIgnoreCase(file2.getName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((File)object, (File)object2);
            }
        });
        this.buildSet(new MIMFile(this.a, "normals.idx"), fileArray);
    }
}

