/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro.algorithm;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.neuro.NeuroMinion;
import com.mimvista.neuro.NeuroTemplate;
import com.mimvista.neuro.algorithm.NeuroVoxelBasedAnalysis;
import com.mimvista.neuro.algorithm.i;
import com.mimvista.neuro.algorithm.k;
import com.mimvista.neuro.atlas.AtlasRegion;
import com.mimvista.neuro.f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import com.mimvista.viewer.Interpolator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;

public class RegionBasedAnalysis {
    public static Messages a = Messages.a("Neuro");
    protected NeuroMinion b;
    private List<RegionAnalysisResult> f;
    private com.mimvista.neuro.c g;
    protected SimpleImageVolume<ImageCube.ImageCubeFloat> c;
    protected ImageCube.ImageCubeFloat d;
    float e = 0.0f;
    private Map<String, b> h = new MapMaker().makeComputingMap((Function)new Function<String, b>(){

        public b a(String string) {
            f f2 = new f(string);
            float f3 = f2.a(RegionBasedAnalysis.this.b);
            return new b(f2, f3);
        }

        public /* synthetic */ Object apply(Object object) {
            return this.a((String)object);
        }
    });

    public RegionBasedAnalysis(NeuroMinion neuroMinion) {
        this.b = neuroMinion;
        this.g = com.mimvista.neuro.c.a();
    }

    public List<RegionAnalysisResult> a(Progress progress) throws NeuroTemplate.UnknownNeuroPropertyException {
        this.c(progress);
        ArrayList arrayList = Lists.newArrayList();
        AtlasRegion atlasRegion = this.g.c("Caudate", "DaTscan Atlas: Caudate");
        AtlasRegion atlasRegion2 = this.g.c("Putamen", "DaTscan Atlas: Putamen");
        RegionAnalysisResult regionAnalysisResult = this.a(atlasRegion, atlasRegion2);
        if (regionAnalysisResult != null) {
            arrayList.add(regionAnalysisResult);
        }
        if ((regionAnalysisResult = this.a(atlasRegion = this.g.c("Anterior Putamen", "DaTscan Atlas: Anterior Putamen"), atlasRegion2 = this.g.c("Posterior Putamen", "DaTscan Atlas: Posterior Putamen"))) != null) {
            arrayList.add(regionAnalysisResult);
        }
        return arrayList;
    }

    public List<RegionAnalysisResult> b(final Progress progress) throws NeuroTemplate.UnknownNeuroPropertyException {
        final List<AtlasRegion> list = this.g.a(this.b.f());
        progress.a(a.getProperty("REGION_BASED_ANALYSIS_TITLE"));
        progress.b_(a.getProperty("REGION_BASED_ANALYSIS_NORM"));
        progress.a(list.size() + 3);
        progress.a();
        this.c(progress);
        progress.b_(a.getProperty("REGION_BASED_ANALYSIS_CALC"));
        this.f = Lists.newArrayList();
        this.f = Collections.synchronizedList(this.f);
        long l2 = System.nanoTime();
        final ArrayList arrayList = Lists.newArrayList((Object[])this.b.b());
        final int n2 = m.c.getCorePoolSize();
        FuncUtils.e e2 = new FuncUtils.e(){

            @Override
            public void f(int n22, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                int n5 = Math.max(1, Math.round((float)arrayList.size() / (float)n2));
                int n6 = n4 * n5;
                for (int i2 = n22; i2 < n3; ++i2) {
                    try {
                        if (progress.n() == Progress.Status.e) {
                            return;
                        }
                        RegionAnalysisResult regionAnalysisResult = RegionBasedAnalysis.this.a((AtlasRegion)list.get(i2), (List<String>)arrayList, n6);
                        RegionBasedAnalysis.this.f.add(regionAnalysisResult);
                    }
                    catch (NeuroTemplate.UnknownNeuroPropertyException unknownNeuroPropertyException) {
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)("Error in neuro RBA of " + ((AtlasRegion)list.get(i2)).f()), throwable, this);
                    }
                    progress.N_();
                }
            }
        };
        FuncUtils.a((ThreadPoolExecutor)m.c, list.size(), e2, "Region Analysis");
        ay.e("Neuro region stat computation took " + NumberFormatFactory.a((double)(System.nanoTime() - l2) / 1000000.0) + "ms");
        if (progress.n() == Progress.Status.e) {
            return null;
        }
        progress.b();
        Collections.sort(this.f, new Comparator<RegionAnalysisResult>(){

            public int a(RegionAnalysisResult regionAnalysisResult, RegionAnalysisResult regionAnalysisResult2) {
                if (Float.isInfinite(regionAnalysisResult.zScore) || Float.isNaN(regionAnalysisResult.zScore)) {
                    if (Float.isInfinite(regionAnalysisResult2.zScore) || Float.isNaN(regionAnalysisResult2.zScore)) {
                        return 0;
                    }
                    return 1;
                }
                if (Float.isInfinite(regionAnalysisResult2.zScore) || Float.isNaN(regionAnalysisResult2.zScore)) {
                    return -1;
                }
                return Float.compare(regionAnalysisResult.zScore, regionAnalysisResult2.zScore);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((RegionAnalysisResult)object, (RegionAnalysisResult)object2);
            }
        });
        return this.f;
    }

    RegionAnalysisResult a(AtlasRegion atlasRegion) throws NeuroTemplate.UnknownNeuroPropertyException {
        ArrayList arrayList = Lists.newArrayList((Object[])this.b.b());
        return this.a(atlasRegion, (List<String>)arrayList, 0);
    }

    private RegionAnalysisResult a(AtlasRegion atlasRegion, List<String> list, int n2) throws NeuroTemplate.UnknownNeuroPropertyException {
        c c2 = new c(atlasRegion);
        this.c(c2, list, n2);
        if (atlasRegion.g()) {
            this.a(c2, list, n2);
            this.b(c2, list, n2);
        }
        return c2.a();
    }

    private RegionAnalysisResult a(AtlasRegion atlasRegion, AtlasRegion atlasRegion2) {
        try {
            a a2 = new a(atlasRegion, atlasRegion2);
            ArrayList arrayList = Lists.newArrayList((Object[])this.b.b());
            this.c(a2, arrayList, 0);
            if (atlasRegion.g() && atlasRegion2.g()) {
                this.a(a2, (List<String>)arrayList, 0);
                this.b(a2, arrayList, 0);
            }
            return a2.a();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error computing multi-region neuro stats", throwable, this);
            return null;
        }
    }

    protected void c(Progress progress) throws NeuroTemplate.UnknownNeuroPropertyException {
        ViewController3D viewController3D = this.b.d();
        this.d = ImageCube.ImageCubeFloat.a(viewController3D.ay(), 0);
        this.c = SimpleImageVolume.aF();
        this.c.a(this.d);
        NeuroVoxelBasedAnalysis.a(this.d, viewController3D.cw());
        progress.c(1);
        this.e = i.b(this.c, this.b);
        progress.c(2);
    }

    private void a(k k2, List<String> list, int n2) throws NeuroTemplate.UnknownNeuroPropertyException {
        String string = "l";
        float f2 = k2.a(string, this.c, "Mean", 100.0f);
        k2.a().leftZScore = this.a(k2, string, list, n2);
        String string2 = "r";
        float f3 = k2.a(string2, this.c, "Mean", 100.0f);
        k2.a().rightZScore = this.a(k2, string2, list, n2);
        k2.a().leftRightSymmetry = (f2 - f3) / ((f2 + f3) / 2.0f) * 100.0f;
    }

    private void b(k k2, List<String> list, int n2) throws NeuroTemplate.UnknownNeuroPropertyException {
        float f2;
        float f3 = k2.a().leftRightSymmetry;
        float[] fArray = this.d(k2, list, n2);
        float f4 = fArray[0];
        float f5 = (f3 - f4) / (f2 = fArray[1]);
        if (Float.isNaN(f5)) {
            f5 = Float.POSITIVE_INFINITY;
        }
        k2.a().leftRightDiffZ = f5;
    }

    private void c(k k2, List<String> list, int n2) throws NeuroTemplate.UnknownNeuroPropertyException {
        String string = "";
        k2.a().zScore = this.a(k2, string, list, n2);
    }

    private Contour a(Contour contour) {
        if (this.b.d() != null && !new Point3f.PointVolumeInfo(contour.a()).equals(new Point3f.PointVolumeInfo(this.b.d().cw()))) {
            contour = com.mimvista.internals.linking.i.a(contour.a(), (ImageFrame)this.b.d().cw()).a(contour, Interpolator.InterpolationType.a, new Predicate(){

                public boolean apply(Object object) {
                    return false;
                }
            }, new o(), new int[]{1, 1, 1}, false);
        }
        return contour;
    }

    private float a(k k2, String string, List<String> list, int n2) throws NeuroTemplate.UnknownNeuroPropertyException {
        float[] fArray = this.b(k2, string, list, n2);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = k2.a(string, this.c, this.b.h(), this.b.i());
        float f5 = (f4 - f2) / f3;
        if (Float.isNaN(f5)) {
            f5 = Float.POSITIVE_INFINITY;
        }
        return f5;
    }

    private float[] b(k k2, String string, List<String> list, int n2) {
        float[] fArray = new float[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n3 = (n2 + i2) % list.size();
            String string2 = list.get(n3);
            fArray[n3] = k2.a(string, string2, this.b.h(), this.b.i());
        }
        float f2 = MathUtils.z(fArray);
        float f3 = MathUtils.b(fArray, f2, true);
        return new float[]{f2, f3};
    }

    private float[] d(k k2, List<String> list, int n2) {
        float[] fArray = new float[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n3 = (n2 + i2) % list.size();
            String string = list.get(n3);
            float f2 = k2.a("l", string, this.b.h(), (float)((int)this.b.i()));
            float f3 = k2.a("r", string, this.b.h(), (float)((int)this.b.i()));
            fArray[n3] = (f2 - f3) / ((f2 + f3) / 2.0f) * 100.0f;
        }
        float f4 = MathUtils.z(fArray);
        float f5 = MathUtils.b(fArray, f4, true);
        return new float[]{f4, f5};
    }

    private f a(String string) {
        b b2 = this.h.get(string);
        return b2.a;
    }

    private float b(String string) {
        b b2 = this.h.get(string);
        return b2.b;
    }

    private class a
    implements k {
        private k b;
        private k c;
        private RegionAnalysisResult d;

        public a(AtlasRegion atlasRegion, AtlasRegion atlasRegion2) {
            this.b = new c(atlasRegion);
            this.c = new c(atlasRegion2);
            this.d = new RegionAnalysisResult(atlasRegion);
            this.d.regionName = atlasRegion.f() + "/" + atlasRegion2.f();
        }

        @Override
        public float a(String string, SimpleImageVolume<ImageCube.ImageCubeFloat> simpleImageVolume, String string2, float f2) throws NeuroTemplate.UnknownNeuroPropertyException {
            return this.b.a(string, simpleImageVolume, string2, f2) / this.c.a(string, simpleImageVolume, string2, f2);
        }

        @Override
        public float a(String string, String string2, String string3, float f2) {
            return this.b.a(string, string2, string3, f2) / this.c.a(string, string2, string3, f2);
        }

        @Override
        public RegionAnalysisResult a() {
            return this.d;
        }
    }

    public class c
    implements k {
        private AtlasRegion b;
        private Contour c;
        private Contour d;
        private Contour e;
        private Contour f;
        private Contour g;
        private Contour h;
        private RegionAnalysisResult i;

        public c(AtlasRegion atlasRegion) {
            this.i = new RegionAnalysisResult(atlasRegion);
            this.b = atlasRegion;
            this.c = AtlasRegion.a(atlasRegion.a(""), false);
            this.f = RegionBasedAnalysis.this.a(this.c.l());
            if (atlasRegion.g()) {
                this.d = AtlasRegion.a(atlasRegion.a("l"), false);
                this.g = RegionBasedAnalysis.this.a(this.d.l());
                this.e = AtlasRegion.a(atlasRegion.a("r"), false);
                this.h = RegionBasedAnalysis.this.a(this.e.l());
            }
        }

        @Override
        public float a(String string, SimpleImageVolume<ImageCube.ImageCubeFloat> simpleImageVolume, String string2, float f2) throws NeuroTemplate.UnknownNeuroPropertyException {
            return this.a(string, simpleImageVolume, string2, f2, RegionBasedAnalysis.this.e);
        }

        public float a(String string, SimpleImageVolume<ImageCube.ImageCubeFloat> simpleImageVolume, String string2, float f2, float f3) throws NeuroTemplate.UnknownNeuroPropertyException {
            Contour contour = string.toLowerCase().startsWith("l") ? this.g : (string.toLowerCase().startsWith("r") ? this.h : this.f);
            return com.mimvista.neuro.algorithm.i.a(simpleImageVolume, contour, string2, f2) / f3;
        }

        @Override
        public float a(String string, String string2, String string3, float f2) {
            Contour contour = string.toLowerCase().startsWith("l") ? this.d : (string.toLowerCase().startsWith("r") ? this.e : this.c);
            f f3 = RegionBasedAnalysis.this.a(string2);
            float f4 = f3.a(this.b, contour, (int)f2, string3, string);
            float f5 = RegionBasedAnalysis.this.b(string2);
            return f4 / f5;
        }

        @Override
        public RegionAnalysisResult a() {
            return this.i;
        }
    }

    private class b {
        final f a;
        final float b;

        private b(f f2, float f3) {
            this.a = f2;
            this.b = f3;
        }
    }

    public static class RegionAnalysisResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public transient AtlasRegion a;
        private String regionName;
        private String zScoreTableStructName;
        public float leftZScore = Float.NaN;
        public float rightZScore = Float.NaN;
        public float zScore = Float.NaN;
        public float leftRightSymmetry = Float.NaN;
        public float leftRightDiffZ = Float.NaN;

        public RegionAnalysisResult(AtlasRegion atlasRegion) {
            this.a = atlasRegion;
        }

        public String a() {
            return this.regionName;
        }

        public String toString() {
            return this.a + ":\t" + this.zScore + "\t" + this.leftZScore + "\t" + this.rightZScore + "\t" + this.leftRightSymmetry + "\t" + this.leftRightDiffZ;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.regionName = this.a.f();
            this.zScoreTableStructName = this.a.b();
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.a = com.mimvista.neuro.c.a().c(this.regionName, this.zScoreTableStructName);
        }
    }
}

