/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro.algorithm.cluster;

import com.google.common.collect.Lists;
import com.mimvista.internals.Contour;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.neuro.algorithm.cluster.generator.ClusterResult;
import com.mimvista.numerics.ImageCube;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ClusterAnalysisOutput
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private ImageCube compositedCube;
    private DynamicVolumeRef clusterVC;
    private ImageCube smoothedCube;
    private Contour bodyMask;
    private int bodyMaskSize;
    private float mean;
    private float stdDev;
    private List<ClusterResult> results;
    private ImageVolumeShort clusterMask;

    public ClusterAnalysisOutput() {
        this.compositedCube = null;
        this.clusterVC = null;
        this.smoothedCube = null;
        this.mean = Float.NaN;
        this.stdDev = Float.NaN;
        this.results = Lists.newArrayList();
        this.clusterMask = null;
    }

    public ClusterAnalysisOutput(ClusterAnalysisOutput clusterAnalysisOutput) {
        this.compositedCube = clusterAnalysisOutput.compositedCube;
        this.clusterVC = clusterAnalysisOutput.clusterVC;
        this.smoothedCube = clusterAnalysisOutput.smoothedCube;
        this.bodyMask = clusterAnalysisOutput.bodyMask != null ? new Contour(clusterAnalysisOutput.bodyMask) : null;
        this.bodyMaskSize = clusterAnalysisOutput.bodyMaskSize;
        this.mean = clusterAnalysisOutput.mean;
        this.stdDev = clusterAnalysisOutput.stdDev;
        this.results = clusterAnalysisOutput.results != null ? Lists.newArrayList(clusterAnalysisOutput.results) : null;
        this.clusterMask = clusterAnalysisOutput.clusterMask;
    }

    public ImageCube a() {
        return this.compositedCube;
    }

    public ViewController b() {
        return this.clusterVC.b();
    }

    public FrameNumber c() {
        return this.clusterVC.d();
    }

    public ImageFrame d() {
        return this.clusterVC.c();
    }

    public ImageCube e() {
        return this.smoothedCube;
    }

    public Contour f() {
        if (this.bodyMask != null && this.clusterVC.c() != null) {
            this.bodyMask.a(this.clusterVC.c());
        }
        return this.bodyMask;
    }

    public int g() {
        return this.bodyMaskSize;
    }

    public float h() {
        return this.mean;
    }

    public float i() {
        return this.stdDev;
    }

    public List<ClusterResult> j() {
        if (this.results == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList(this.results);
        ImageFrame imageFrame = this.clusterVC.c();
        if (imageFrame != null) {
            for (ClusterResult clusterResult : arrayList) {
                clusterResult.a(imageFrame);
            }
        }
        return arrayList;
    }

    public ImageVolumeShort k() {
        return this.clusterMask;
    }

    void a(List<ClusterResult> list) {
        this.results = list == null ? Lists.newArrayList() : Lists.newArrayList(list);
    }

    void a(ImageCube imageCube) {
        this.compositedCube = imageCube;
    }

    void a(ViewController viewController) {
        this.clusterVC = DynamicVolumeRef3D.a(viewController);
    }

    void b(ImageCube imageCube) {
        this.smoothedCube = imageCube;
    }

    void a(Contour contour) {
        this.bodyMask = contour;
        this.bodyMaskSize = contour.L();
    }

    void a(float f2) {
        this.mean = f2;
    }

    void b(float f2) {
        this.stdDev = f2;
    }

    void a(ImageVolumeShort imageVolumeShort) {
        this.clusterMask = imageVolumeShort;
    }

    protected ClusterAnalysisOutput l() {
        try {
            return (ClusterAnalysisOutput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)"Cannot clone cluster analysis output", (Throwable)cloneNotSupportedException, this);
            return null;
        }
    }

    protected /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.l();
    }
}

