/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro.algorithm.cluster;

import com.mimvista.numerics.MathUtils;
import java.io.Serializable;
import java.util.Iterator;

public class ValueRange
implements Serializable,
Iterable<Double> {
    private static final long serialVersionUID = 1L;
    private static final float a = 0.001f;
    private final float min;
    private final float max;
    private final float stepSize;

    public ValueRange(float f2, float f3, float f4) {
        this.min = f2;
        this.max = f3;
        this.stepSize = f4;
    }

    public float a() {
        return this.min;
    }

    public float b() {
        return this.max;
    }

    public float c() {
        return this.stepSize;
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            double a;
            {
                this.a = ValueRange.this.max;
            }

            @Override
            public boolean hasNext() {
                return !Double.isNaN(this.a);
            }

            public Double a() {
                double d2 = this.a;
                this.a = this.b();
                return d2;
            }

            private Double b() {
                double d2 = this.a - (double)ValueRange.this.stepSize;
                if (d2 > (double)ValueRange.this.min) {
                    return d2;
                }
                if (Math.abs(this.a - (double)ValueRange.this.min) > (double)0.001f) {
                    return ValueRange.this.min;
                }
                return Double.NaN;
            }

            @Override
            public void remove() {
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    public boolean equals(Object object) {
        if (object instanceof ValueRange) {
            ValueRange valueRange = (ValueRange)object;
            return MathUtils.a(this.min, valueRange.min, 0.001f) && MathUtils.a(this.max, valueRange.max, 0.001f) && MathUtils.a(this.stepSize, valueRange.stepSize, 0.001f);
        }
        return false;
    }

    public int hashCode() {
        int n2 = 999;
        return (int)(this.min * (float)n2) + (int)(this.max * (float)n2) + (int)(this.stepSize * (float)n2);
    }
}

