/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro.gui;

import com.mimvista.d;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.SessionableWindows;
import com.mimvista.neuro.AbstractNormalPatient;
import com.mimvista.neuro.ComparisonSet;
import com.mimvista.neuro.ComparisonSetFactory;
import com.mimvista.neuro.NeuroMinion;
import com.mimvista.neuro.NeuroTemplate;
import com.mimvista.neuro.algorithm.NeuroVoxelBasedAnalysis;
import com.mimvista.neuro.algorithm.RegionBasedAnalysis;
import com.mimvista.neuro.algorithm.i;
import com.mimvista.neuro.c;
import com.mimvista.numerics.ImageCube;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

public class NeuroStatGraphWindow
extends SessionableWindows.MIMSessionableJFrame {
    private static final long serialVersionUID = 1L;
    public static Messages a = Messages.a("Neuro");
    private NeuroMinion neuroManager;
    private String comparisonSetName;
    private String atlasName;
    private String structureName;
    private String region;
    private JComboBox latSelectBox;
    private JComboBox normSelectBox;
    private ChartPanel graphPanel;
    private int normInd;
    private int latInd = 0;
    private double[] normalAges;
    private int patAge;
    private double[] normalVals;
    private float patVal;
    private boolean hasLat;
    private List<AbstractNormalPatient> includedNormals;
    private String[] latStrings = new String[]{a.getProperty("NEUROG_LAT_NONE"), a.getProperty("NEUROG_LAT_LEFT"), a.getProperty("NEUROG_LAT_RIGHT")};
    private String[] normStrings = new String[]{Messages.a("PropertyCollectionFactory").getProperty("PROPERTYCOLL_FACT_MEAN_A"), Messages.a("PropertyCollectionFactory").getProperty("PROPERTYCOLL_FACT_MEDIAN")};
    private String[] lateralitys = new String[]{"", "l", "r"};
    private String[] normalizations = new String[]{"Mean", "Median"};

    public NeuroStatGraphWindow(NeuroMinion neuroMinion, @d String string, String string2, String string3, String string4) {
        super(MIMFormat.a(a.getProperty("NEUROG_TITLE"), string2), new Rectangle(1000, 600));
        if (Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0 > 580.0 && Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0 > 360.0) {
            this.setSize((int)Math.ceil(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2.0), (int)Math.ceil(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0));
        } else {
            this.setSize(580, 360);
        }
        this.setBoundsKey(a.getProperty("NEUROG_TITLE"));
        this.neuroManager = neuroMinion;
        this.comparisonSetName = string;
        this.atlasName = string3;
        this.region = string2;
        this.structureName = string4;
        this.hasLat = c.a().c(string4, string2).g();
        this.normInd = neuroMinion.h().equalsIgnoreCase("mean") ? 0 : 1;
        this.a();
    }

    private void a() {
        this.f();
        this.b();
        this.c();
        SessionableWindows.a(this.neuroManager.d().g(), this);
    }

    private synchronized void b() {
        RegionBasedAnalysis regionBasedAnalysis;
        this.neuroManager.e().apply(this.neuroManager.d().getUncopiedMutableInfo());
        this.includedNormals = this.neuroManager.e().getIncludedPatients(this.neuroManager.d().getModality(), this.neuroManager.d().getUncopiedMutableInfo().w());
        RegionBasedAnalysis regionBasedAnalysis2 = regionBasedAnalysis = new RegionBasedAnalysis(this.neuroManager);
        regionBasedAnalysis2.getClass();
        RegionBasedAnalysis.c c2 = regionBasedAnalysis2.new RegionBasedAnalysis.c(c.a().c(this.structureName, this.region));
        ViewController3D viewController3D = this.neuroManager.d();
        ImageCube.ImageCubeFloat imageCubeFloat = ImageCube.ImageCubeFloat.a(viewController3D.ay(), 0);
        SimpleImageVolume<ImageCube.ImageCubeFloat> simpleImageVolume = SimpleImageVolume.aF();
        simpleImageVolume.a(imageCubeFloat);
        NeuroVoxelBasedAnalysis.a(imageCubeFloat, viewController3D.cw());
        try {
            float f2 = i.b(simpleImageVolume, this.neuroManager);
            this.patVal = c2.a(this.lateralitys[this.latInd], simpleImageVolume, this.normalizations[this.normInd], this.neuroManager.i(), f2);
        }
        catch (NeuroTemplate.UnknownNeuroPropertyException unknownNeuroPropertyException) {
            ay.d((Object)unknownNeuroPropertyException, this);
        }
        this.patAge = this.neuroManager.d().getUncopiedMutableInfo().C();
        this.normalAges = new double[this.includedNormals.size()];
        this.normalVals = new double[this.includedNormals.size()];
        for (int i2 = 0; i2 < this.includedNormals.size(); ++i2) {
            AbstractNormalPatient abstractNormalPatient = this.includedNormals.get(i2);
            this.normalAges[i2] = abstractNormalPatient.h();
            this.normalVals[i2] = c2.a(this.lateralitys[this.latInd], abstractNormalPatient.n().getAbsolutePath(), this.normalizations[this.normInd], this.neuroManager.i());
        }
    }

    private void c() {
        this.setLayout(new BorderLayout(10, 10));
        this.setMinimumSize(new Dimension(580, 360));
        this.d();
        this.g();
    }

    private void d() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        HashMap<String, String> hashMap = this.e();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JLabel jLabel = new JLabel(a.getProperty("NEUROG_LATERALITY"));
        this.latSelectBox = this.hasLat ? new JComboBox<String>(this.latStrings) : new JComboBox<String>(new String[]{this.latStrings[0]});
        this.latSelectBox.setSelectedIndex(this.latInd);
        this.latSelectBox.setMaximumSize(new Dimension(200, 20));
        this.latSelectBox.addActionListener(actionEvent -> m.e.execute(new Runnable(){

            @Override
            public void run() {
                NeuroStatGraphWindow.this.latInd = NeuroStatGraphWindow.this.latSelectBox.getSelectedIndex();
                NeuroStatGraphWindow.this.b();
                NeuroStatGraphWindow.this.h();
            }
        }));
        JLabel jLabel2 = new JLabel(a.getProperty("NEUROG_NORM"));
        this.normSelectBox = new JComboBox<String>(this.normStrings);
        this.normSelectBox.setSelectedIndex(this.normInd);
        this.normSelectBox.setMaximumSize(new Dimension(200, 20));
        this.normSelectBox.addActionListener(actionEvent -> m.e.execute(new Runnable(){

            @Override
            public void run() {
                NeuroStatGraphWindow.this.normInd = NeuroStatGraphWindow.this.normSelectBox.getSelectedIndex();
                NeuroStatGraphWindow.this.b();
                NeuroStatGraphWindow.this.h();
            }
        }));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jLabel2);
        jPanel2.add(jPanel5);
        jPanel2.add(Box.createVerticalStrut(15));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 2));
        jPanel6.add(Box.createHorizontalGlue());
        jPanel6.add(jLabel);
        jPanel2.add(jPanel6);
        jPanel2.add(Box.createVerticalStrut(15));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 2));
        jPanel7.add(this.normSelectBox);
        jPanel7.add(Box.createHorizontalGlue());
        jPanel3.add(jPanel7);
        jPanel3.add(Box.createVerticalStrut(8));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 2));
        jPanel8.add(this.latSelectBox);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel3.add(jPanel8);
        jPanel3.add(Box.createVerticalStrut(10));
        for (String object2 : hashMap.keySet()) {
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BoxLayout(jPanel9, 2));
            jPanel9.add(Box.createHorizontalGlue());
            jPanel9.add(new JLabel(object2));
            jPanel2.add(jPanel9);
            jPanel2.add(Box.createVerticalStrut(15));
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout(new BoxLayout(jPanel10, 2));
            jPanel10.add(new JLabel(hashMap.get(object2)));
            jPanel10.add(Box.createHorizontalGlue());
            jPanel3.add(jPanel10);
            jPanel3.add(Box.createVerticalStrut(15));
        }
        jPanel2.add(Box.createVerticalGlue());
        jPanel3.add(Box.createVerticalGlue());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "East");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 2));
        JButton jButton = com.mimvista.gui.util.c.d(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NeuroStatGraphWindow.this.setVisible(false);
                NeuroStatGraphWindow.this.dispose();
            }
        }, "");
        jPanel11.add(Box.createHorizontalGlue());
        jPanel11.add(jButton);
        jPanel.add((Component)jPanel11, "South");
        this.add((Component)jPanel, "East");
    }

    private HashMap<String, String> e() {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SeriesInfo seriesInfo = this.neuroManager.d().getUncopiedMutableInfo();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d, yyyy");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("h:mm:ss aaa");
        String string2 = this.neuroManager.g();
        if (string2.equalsIgnoreCase("WHOLE BRAIN")) {
            string2 = a.getProperty("WHOLE_BRAIN");
        }
        if (this.neuroManager.e() != null) {
            string = this.neuroManager.e().getName();
            string = string + " (" + this.includedNormals.size() + ")";
        } else {
            string = "";
        }
        hashMap.put(a.getProperty("NEUROTABLE_PATIENT_NAME"), seriesInfo.patientName);
        hashMap.put(a.getProperty("NEUROTABLE_PATIENT_DATE"), simpleDateFormat.format(seriesInfo.acqDate) + " " + simpleDateFormat2.format(seriesInfo.acqTime));
        hashMap.put(a.getProperty("NEUROTABLE_PATIENT_ID"), seriesInfo.patientId);
        hashMap.put(a.getProperty("NEUROTABLE_COMPARISON"), string);
        hashMap.put(a.getProperty("NEUROZ_ATLAS") + ":", this.atlasName);
        hashMap.put(a.getProperty("NEUROZ_STRUCTURE") + ":", this.structureName);
        return hashMap;
    }

    private void f() {
        String[] stringArray;
        if (this.comparisonSetName != null && (stringArray = this.comparisonSetName.split("~!~")).length == 3) {
            ComparisonSet[] comparisonSetArray;
            for (ComparisonSet comparisonSet : comparisonSetArray = ComparisonSetFactory.a().c(ComparisonSetFactory.ComparisonSetType.a)) {
                if (!comparisonSet.getName().equalsIgnoreCase(stringArray[0])) continue;
                this.neuroManager.a(comparisonSet);
                this.neuroManager.a(stringArray[2]);
            }
        }
    }

    private void g() {
        if (this.graphPanel != null) {
            this.graphPanel.getParent().remove((Component)this.graphPanel);
            this.graphPanel = null;
        }
        DefaultXYDataset defaultXYDataset = this.j();
        JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)"", (String)a.getProperty("STATIC_COMPSET_PP_AGE"), (String)"", (XYDataset)defaultXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        ColorUIResource colorUIResource = MIMLookAndFeel.i();
        jFreeChart.getTitle().setPaint((Paint)colorUIResource);
        jFreeChart.getXYPlot().getDomainAxis().setTickLabelPaint((Paint)colorUIResource);
        jFreeChart.getXYPlot().getDomainAxis().setLabelPaint((Paint)colorUIResource);
        jFreeChart.getXYPlot().getRangeAxis().setTickLabelPaint((Paint)colorUIResource);
        jFreeChart.getXYPlot().getRangeAxis().setLabelPaint((Paint)colorUIResource);
        jFreeChart.setBackgroundPaint((Paint)MIMLookAndFeel.j());
        jFreeChart.getXYPlot().setBackgroundPaint((Paint)MIMLookAndFeel.j());
        jFreeChart.getLegend().setBackgroundPaint((Paint)MIMLookAndFeel.j());
        jFreeChart.getLegend().setItemPaint((Paint)colorUIResource);
        this.a(jFreeChart);
        this.graphPanel = new ChartPanel(jFreeChart);
        this.graphPanel.setBackground((Color)MIMLookAndFeel.j());
        this.i();
        this.add((Component)this.graphPanel, "Center");
    }

    private synchronized void h() {
        this.graphPanel.getChart().getXYPlot().setDataset((XYDataset)this.j());
        this.i();
        this.revalidate();
    }

    private void i() {
        String[] stringArray = new String[]{a.getProperty("NEUROG_NORM_MEAN"), a.getProperty("NEUROG_NORM_MEDIAN")};
        String string = stringArray[this.normInd];
        this.graphPanel.getChart().setTitle(string);
    }

    private DefaultXYDataset j() {
        DefaultXYDataset defaultXYDataset = new DefaultXYDataset();
        double[][] dArrayArray = new double[][]{{this.patAge}, {this.patVal}};
        defaultXYDataset.addSeries((Comparable)((Object)a.getProperty("NEUROG_PATIENT")), (double[][])dArrayArray);
        dArrayArray = new double[][]{this.normalAges, this.normalVals};
        defaultXYDataset.addSeries((Comparable)((Object)a.getProperty("NEUROG_NORMALS")), (double[][])dArrayArray);
        return defaultXYDataset;
    }

    private void a(JFreeChart jFreeChart) {
        Font font = new Font("San-Serif", 0, 12);
        Font font2 = new Font(font.getName(), 1, font.getSize() + 8);
        jFreeChart.getTitle().setFont(font2);
        Font font3 = new Font(font.getName(), 1, font.getSize() + 2);
        jFreeChart.getXYPlot().getDomainAxis().setLabelFont(font3);
        jFreeChart.getXYPlot().getRangeAxis().setLabelFont(font3);
    }
}

