/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro.gui.cluster;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.s;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.mui.am;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.f;
import com.mimvista.neuro.algorithm.cluster.ClusterAnalysisInput;
import com.mimvista.neuro.algorithm.cluster.ClusterAnalysisOutput;
import com.mimvista.neuro.algorithm.cluster.ClusterAnalysisPipeline;
import com.mimvista.neuro.algorithm.cluster.ValueRange;
import com.mimvista.neuro.algorithm.cluster.generator.ClusterResult;
import com.mimvista.neuro.gui.cluster.ClusterMaskListRenderer;
import com.mimvista.neuro.gui.cluster.ClusterResultsRenderer;
import com.mimvista.neuro.gui.cluster.ClusterResultsTableModel;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.CameraSpecsPrefs;
import com.mimvista.preferencesNew.DropdownBoxPrefs;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.swing.DropdownBox;
import com.mimvista.swing.c;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.gnotifier.b;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.Pair;
import com.mimvista.util.ag;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.MIMJProgressBar;
import com.mimvista.util.progress.Progress;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class ClusterAnalysisNotification
extends BasicNotification
implements Serializable {
    private static final long serialVersionUID = -5881886917980459913L;
    private static final int a = 300;
    private static final int b = 140;
    private static final int c = 300;
    private static final int d = 12;
    private static final int e = 6;
    private final FuncUtils.f latch;
    private final ViewController viewController;
    private final ClusterAnalysisPipeline pipeline;
    private final DelayedActionRunner delayedRunner;
    private ClusterAnalysisInput defaultInputValues;
    private JFormattedTextField camResInput;
    private JFormattedTextField gaussianSmooth;
    private JFormattedTextField pValueInput;
    private JFormattedTextField minSDInput;
    private JFormattedTextField minVolInput;
    private JComboBox<Pair<ContourMaskType, VolumetricContourOverlayish>> clusterMaskInput;
    private JComboBox<ZscoreType> useSDRangeInput;
    private JLabel meanOutput;
    private JLabel stdDevOutput;
    private JXTable resultsTable;
    private JComponent progressPanel;
    private Color origColor;
    private JPanel notificationPanel;
    private JPanel inputPanel;
    private JPanel resultsPanel;
    private JPanel scrollPanel;
    private JButton ok;

    public ClusterAnalysisNotification(ViewController viewController, FuncUtils.f f2) {
        this(new ClusterAnalysisPipeline(), viewController, f2);
    }

    public ClusterAnalysisNotification(ClusterAnalysisPipeline clusterAnalysisPipeline) {
        this(clusterAnalysisPipeline, clusterAnalysisPipeline.a().b(), null);
    }

    public ClusterAnalysisNotification(ClusterAnalysisPipeline clusterAnalysisPipeline, FuncUtils.f f2) {
        this(clusterAnalysisPipeline, clusterAnalysisPipeline.a().b(), f2);
    }

    private ClusterAnalysisNotification(ClusterAnalysisPipeline clusterAnalysisPipeline, ViewController viewController, FuncUtils.f f2) {
        super(BasicNotification.NotificationType.e, "", new Notification.a(viewController));
        this.setPriority(1000);
        this.setShouldPopInfo(true);
        this.viewController = viewController;
        this.latch = f2;
        this.delayedRunner = new DelayedActionRunner(300, this.s());
        this.defaultInputValues = clusterAnalysisPipeline.a() == null ? ClusterAnalysisNotification.b(this.viewController) : clusterAnalysisPipeline.a();
        this.pipeline = clusterAnalysisPipeline;
        this.c();
        this.q();
        this.t();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.pipeline == null ? 0 : this.pipeline.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ClusterAnalysisNotification clusterAnalysisNotification = (ClusterAnalysisNotification)object;
        return !(this.pipeline == null ? clusterAnalysisNotification.pipeline != null : !this.pipeline.equals(clusterAnalysisNotification.pipeline));
    }

    @Override
    public boolean isDismissable() {
        return false;
    }

    @Override
    public String getTitle() {
        return Messages.a("Commands", "CREATE_FUSION_CLUSTER_ANALYSIS");
    }

    @Override
    public b getIconRenderer() {
        return new b.b("cluster_analysis");
    }

    public ClusterAnalysisOutput a() {
        return this.pipeline.b();
    }

    public static boolean a(ViewController viewController) {
        if (viewController instanceof s) {
            s s2 = (s)viewController;
            return s2.V().ba().i() != null || s2.C().n().i() != null;
        }
        return viewController.ba().i() != null;
    }

    public void b() {
        u.b().c(this);
    }

    @Override
    public JComponent getContent() {
        return this.scrollPanel;
    }

    private void c() {
        this.notificationPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 400;
                return dimension;
            }
        };
        this.inputPanel = new JPanel();
        this.inputPanel.setBackground(MIMLookAndFeel.G());
        this.resultsPanel = new JPanel();
        this.resultsPanel.setBackground(MIMLookAndFeel.G());
        this.scrollPanel = new JPanel(new BorderLayout());
        this.g();
        this.d();
        this.e();
        this.f();
        this.i();
        this.o();
        this.p();
        this.h();
        DropdownBox.b b2 = new DropdownBox.b(){

            @Override
            public boolean a(boolean bl2) {
                return true;
            }

            @Override
            public JComponent a() {
                return this.b(false);
            }

            @Override
            public JComponent b() {
                return this.b(true);
            }

            private JComponent b(boolean bl2) {
                ClusterAnalysisNotification.this.b(bl2);
                return ClusterAnalysisNotification.this.inputPanel;
            }

            @Override
            public boolean c() {
                return true;
            }
        };
        DropdownBox dropdownBox = new DropdownBox(b2, this.a(true), this.a(false), DropdownBox.DropdownBoxStyle.b, true, DropdownBoxPrefs.clusterNotificationShowAdvanced);
        dropdownBox.b(20);
        dropdownBox.g();
        dropdownBox.setMinimumSize(this.inputPanel.getMinimumSize());
        DropdownBox dropdownBox2 = new DropdownBox(this.resultsPanel, Messages.a("mui", "CLUSTER_RESULTS"), DropdownBox.DropdownBoxStyle.b, false, null);
        dropdownBox2.b(20);
        dropdownBox2.g();
        this.notificationPanel.setBackground(MIMLookAndFeel.E());
        this.notificationPanel.setLayout(new BoxLayout(this.notificationPanel, 3));
        this.notificationPanel.add(Box.createVerticalStrut(12));
        this.notificationPanel.add(com.mimvista.swing.c.a(12, dropdownBox));
        this.notificationPanel.add(Box.createVerticalStrut(12));
        this.notificationPanel.add(com.mimvista.swing.c.a(12, dropdownBox2));
        this.notificationPanel.add(Box.createVerticalStrut(12));
        this.notificationPanel.add(com.mimvista.swing.c.a(12, this.progressPanel));
        this.notificationPanel.add(Box.createVerticalStrut(12));
        this.notificationPanel.add(Box.createVerticalGlue());
        JScrollPane jScrollPane = new JScrollPane(this.notificationPanel);
        jScrollPane.setBorder(MIMLookAndFeel.H());
        jScrollPane.setPreferredSize(new Dimension(u.b().f() - 50, 300));
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        jScrollPane.setMaximumSize(jScrollPane.getPreferredSize());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPanel.add(jScrollPane);
        this.scrollPanel.setPreferredSize(new Dimension(u.b().f() - 2, 300));
        JComponent jComponent = this.k();
        this.scrollPanel.add((Component)jComponent, "South");
    }

    private String a(boolean bl2) {
        return "<html><table><tr><td width=\"200\" align=\"left\">" + Messages.a("mui", "CLUSTER_PARAMS") + "</td><td width = \"200\" align=\"right\">" + (bl2 ? Messages.a("mui", "CLUSTER_FEWER") : Messages.a("mui", "CLUSTER_MORE")) + "</td></tr></table></html>";
    }

    private JLabel a(String string) {
        JLabel jLabel = new JLabel(cn.p(string), 4);
        jLabel.setForeground(MIMLookAndFeel.c());
        Dimension dimension = jLabel.getPreferredSize();
        Dimension dimension2 = new Dimension(140, dimension.height * 2);
        jLabel.setMaximumSize(dimension2);
        jLabel.setMinimumSize(dimension2);
        jLabel.setPreferredSize(dimension2);
        return jLabel;
    }

    private JComponent a(JComponent ... jComponentArray) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createRigidArea(new Dimension(6, 1)));
        boolean bl2 = false;
        for (JComponent jComponent : jComponentArray) {
            box.add(jComponent);
            if (bl2) {
                box.add(Box.createHorizontalGlue());
            } else {
                box.add(Box.createRigidArea(new Dimension(6, 1)));
            }
            bl2 = !bl2;
        }
        return box;
    }

    private void d() {
        float f2 = this.defaultInputValues.f();
        this.camResInput = this.a(Float.valueOf(f2), false);
    }

    private void e() {
        float f2 = this.defaultInputValues.g();
        this.gaussianSmooth = this.a(Float.valueOf(f2), false);
    }

    private void f() {
        ValueRange valueRange = this.defaultInputValues.i();
        float f2 = valueRange.a();
        this.minSDInput = this.a(Float.valueOf(f2), true);
        this.useSDRangeInput = new JComboBox<ZscoreType>(ZscoreType.values());
        ZscoreType zscoreType = ZscoreType.a;
        try {
            zscoreType = ZscoreType.valueOf(CameraSpecsPrefs.zscoreRange.getValue());
        }
        catch (Throwable throwable) {
            ay.d((Object)"Could not parse the z-score type", this);
        }
        this.useSDRangeInput.setSelectedItem(zscoreType);
    }

    private void g() {
        float f2 = this.defaultInputValues.h();
        this.pValueInput = this.a(Float.valueOf(f2), false);
    }

    private void h() {
        float f2 = this.defaultInputValues.a();
        this.minVolInput = this.a(Float.valueOf(f2), false);
    }

    private JFormattedTextField a(Number number, boolean bl2) {
        NumberFormat numberFormat = NumberFormatFactory.f();
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormat);
        jFormattedTextField.setMaximumSize(new Dimension(50, 30));
        jFormattedTextField.setColumns(6);
        if (number != null) {
            jFormattedTextField.setValue(number);
        }
        this.a(jFormattedTextField, bl2);
        return jFormattedTextField;
    }

    private void b(boolean bl2) {
        this.inputPanel.removeAll();
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 3));
        JLabel jLabel = this.a(am.w().getProperty("CLUSTER_PVAL"));
        JLabel jLabel2 = this.a(am.w().getProperty("CLUSTER_CAMERA_RES"));
        JLabel jLabel3 = this.a(am.w().getProperty("CLUSTER_SMOOTH_FWHM"));
        JLabel jLabel4 = this.a(am.w().getProperty("CLUSTER_THRESH"));
        JLabel jLabel5 = this.a(am.w().getProperty("CLUSTER_MASK"));
        JLabel jLabel6 = this.a(am.w().getProperty("CLUSTER_USE_SD_LABEL"));
        JLabel jLabel7 = this.a(MIMFormat.a(am.w().getProperty("CLUSTER_MIN_VOL"), OverlayStatistician.StatUnitCategory.f.c(this.viewController.aw())));
        this.inputPanel.add(Box.createVerticalStrut(6));
        this.inputPanel.add(this.a(jLabel2, this.camResInput, jLabel, this.pValueInput));
        this.inputPanel.add(Box.createVerticalStrut(6));
        if (bl2) {
            this.inputPanel.add(this.a(jLabel5, this.clusterMaskInput));
            this.inputPanel.add(Box.createVerticalStrut(6));
            this.inputPanel.add(this.a(jLabel6, this.useSDRangeInput));
            this.inputPanel.add(Box.createVerticalStrut(6));
            this.inputPanel.add(this.a(jLabel4, this.minSDInput));
            this.inputPanel.add(Box.createVerticalStrut(6));
            this.inputPanel.add(this.a(jLabel7, this.minVolInput));
            this.inputPanel.add(Box.createVerticalStrut(6));
            this.inputPanel.add(this.a(jLabel3, this.gaussianSmooth));
            this.inputPanel.add(Box.createVerticalStrut(6));
        }
        this.scrollPanel.setPreferredSize(this.scrollPanel.getPreferredSize());
        this.scrollPanel.revalidate();
        this.scrollPanel.doLayout();
        this.scrollPanel.repaint();
    }

    private void i() {
        this.resultsPanel.setVisible(false);
        this.resultsPanel.setLayout(new BoxLayout(this.resultsPanel, 3));
        this.resultsPanel.add(Box.createVerticalStrut(6));
        JLabel jLabel = new JLabel(Messages.a("Contour", "MEAN_FULL_STAT"));
        JLabel jLabel2 = new JLabel(Messages.a("Contour", "STDV_FULL_STAT"));
        jLabel.setForeground(MIMLookAndFeel.a());
        jLabel2.setForeground(MIMLookAndFeel.a());
        this.meanOutput = new JLabel();
        this.stdDevOutput = new JLabel();
        this.resultsTable = new JXTable();
        this.resultsTable.setDefaultRenderer(Integer.class, (TableCellRenderer)new ClusterResultsRenderer());
        this.resultsTable.setDefaultRenderer(Float.class, (TableCellRenderer)new ClusterResultsRenderer());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.resultsTable.getTableHeader(), "North");
        jPanel.add((Component)this.resultsTable);
        this.resultsPanel.add(com.mimvista.swing.c.a(Box.createHorizontalStrut(6), jLabel, Box.createHorizontalStrut(6), this.meanOutput, Box.createHorizontalStrut(10), jLabel2, Box.createHorizontalStrut(6), this.stdDevOutput, Box.createHorizontalGlue(), this.j(), Box.createHorizontalStrut(6)));
        this.resultsPanel.add(Box.createVerticalStrut(6));
        this.resultsPanel.add(com.mimvista.swing.c.a(6, jPanel));
        this.resultsPanel.add(Box.createVerticalStrut(6));
    }

    private JComponent j() {
        JButton jButton = new JButton(Messages.a("Neuro", "NEUROTABLE_DRAW"), ImageManipulator.c("pencil", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ClusterAnalysisNotification.this.resultsTable.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    nArray = new int[ClusterAnalysisNotification.this.resultsTable.getRowCount()];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        nArray[i2] = i2;
                    }
                }
                for (int n2 : nArray) {
                    ClusterResultsTableModel clusterResultsTableModel = (ClusterResultsTableModel)ClusterAnalysisNotification.this.resultsTable.getModel();
                    ClusterResult clusterResult = clusterResultsTableModel.c(ClusterAnalysisNotification.this.resultsTable.convertRowIndexToModel(n2));
                    ClusterAnalysisOutput clusterAnalysisOutput = ClusterAnalysisNotification.this.a();
                    ViewController viewController = clusterAnalysisOutput.b();
                    VolumetricContourOverlay volumetricContourOverlay = f.a(viewController, clusterResult.f());
                    volumetricContourOverlay.a(clusterAnalysisOutput.c());
                    volumetricContourOverlay.c(clusterResult.b());
                    viewController.ba().a((Overlayish)volumetricContourOverlay, true);
                    viewController.bz();
                }
                ClusterAnalysisNotification.this.viewController.g().Q();
            }
        });
        return jButton;
    }

    private JComponent k() {
        Box box = com.mimvista.swing.c.a(this.n(), Box.createHorizontalGlue(), this.l(), Box.createHorizontalStrut(6), this.m());
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalStrut(12));
        box2.add(box);
        return box2;
    }

    private JButton l() {
        this.ok = com.mimvista.gui.util.c.c(this.c(false), "");
        return this.ok;
    }

    private JButton m() {
        JButton jButton = com.mimvista.gui.util.c.a(this.c(true), "");
        return jButton;
    }

    private JButton n() {
        JButton jButton = new JButton(Messages.a("GUI", "ABSTRACTIN_RESET"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterAnalysisNotification.this.a(ClusterAnalysisNotification.b(ClusterAnalysisNotification.this.viewController));
            }
        });
        return jButton;
    }

    private void a(ClusterAnalysisInput clusterAnalysisInput) {
        this.camResInput.setValue(Float.valueOf(clusterAnalysisInput.f()));
        this.pValueInput.setValue(Float.valueOf(clusterAnalysisInput.h()));
        this.gaussianSmooth.setValue(Float.valueOf(clusterAnalysisInput.g()));
        this.minVolInput.setValue(Float.valueOf(clusterAnalysisInput.a()));
        ValueRange valueRange = clusterAnalysisInput.i();
        this.minSDInput.setValue(Float.valueOf(valueRange.a()));
        this.delayedRunner.b();
    }

    private void o() {
        this.progressPanel = Box.createVerticalBox();
    }

    private void p() {
        ContourMaskType contourMaskType = this.defaultInputValues.d();
        Vector<Pair<ContourMaskType, VolumetricContourOverlayish>> vector = new Vector<Pair<ContourMaskType, VolumetricContourOverlayish>>();
        if (ClusterAnalysisNotification.a(this.viewController)) {
            vector.add(Pair.get(ContourMaskType.a, null));
        }
        vector.add(Pair.get(ContourMaskType.b, null));
        for (VolumetricContourOverlayish object : this.viewController.ba().Q()) {
            vector.add(Pair.get(ContourMaskType.c, object));
        }
        this.clusterMaskInput = new JComboBox(vector);
        this.clusterMaskInput.setRenderer(new ClusterMaskListRenderer());
        String string = CameraSpecsPrefs.maskName.getValue();
        for (Pair pair : vector) {
            if (contourMaskType == ContourMaskType.c) {
                if (pair.y == null || ((VolumetricContourOverlayish)pair.y).aq() != this.defaultInputValues.e() && !((VolumetricContourOverlayish)pair.y).getName().equals(string)) continue;
                this.clusterMaskInput.setSelectedItem(pair);
                break;
            }
            if (pair.x != contourMaskType) continue;
            this.clusterMaskInput.setSelectedItem(pair);
            break;
        }
    }

    private void a(JFormattedTextField jFormattedTextField, boolean bl2) {
        if (this.origColor == null) {
            this.origColor = jFormattedTextField.getBackground();
        }
        if (this.b(jFormattedTextField, bl2)) {
            jFormattedTextField.setBackground(this.origColor);
        } else {
            jFormattedTextField.setBackground(MIMLookAndFeel.r().darker().darker());
        }
    }

    private void q() {
        this.a(this.camResInput);
        this.a(this.gaussianSmooth);
        this.a(this.minSDInput);
        this.a(this.pValueInput);
        this.a(this.minVolInput);
        this.a(this.clusterMaskInput);
        this.a(this.useSDRangeInput);
        this.r();
        this.pipeline.a(this.v());
    }

    private void a(final JFormattedTextField jFormattedTextField) {
        jFormattedTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (jFormattedTextField == ClusterAnalysisNotification.this.minSDInput) {
                    ClusterAnalysisNotification.this.a(jFormattedTextField, true);
                } else {
                    ClusterAnalysisNotification.this.a(jFormattedTextField, false);
                }
                ClusterAnalysisNotification.this.delayedRunner.b();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
    }

    private void a(JComboBox jComboBox) {
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClusterAnalysisNotification.this.delayedRunner.b();
            }
        });
    }

    private void r() {
        this.resultsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n2 = ClusterAnalysisNotification.this.resultsTable.getSelectedRow();
                n2 = ClusterAnalysisNotification.this.resultsTable.convertRowIndexToModel(n2);
                ClusterResult clusterResult = ((ClusterResultsTableModel)ClusterAnalysisNotification.this.resultsTable.getModel()).c(n2);
                ClusterAnalysisNotification.this.viewController.a(clusterResult.f().n());
                ClusterAnalysisNotification.this.viewController.g().Q();
            }
        });
    }

    private Runnable s() {
        return new Runnable(){

            @Override
            public void run() {
                ClusterAnalysisNotification.this.t();
            }
        };
    }

    private void t() {
        try {
            if (this.A()) {
                ClusterAnalysisInput clusterAnalysisInput = this.B();
                FuncUtils.m<ClusterAnalysisOutput> m2 = this.u();
                this.pipeline.a(clusterAnalysisInput, m2);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error computing cluster analysis", throwable, this);
            this.w();
            this.pipeline.c();
        }
    }

    private FuncUtils.m<ClusterAnalysisOutput> u() {
        return new FuncUtils.m<ClusterAnalysisOutput>(){

            public void a(ClusterAnalysisOutput clusterAnalysisOutput) {
                if (clusterAnalysisOutput == null) {
                    ClusterAnalysisNotification.this.w();
                    ClusterAnalysisNotification.this.meanOutput.setText(Messages.a("TherapyResponse", "NULL_FILL"));
                    ClusterAnalysisNotification.this.stdDevOutput.setText(Messages.a("TherapyResponse", "NULL_FILL"));
                    ClusterAnalysisNotification.this.resultsPanel.setVisible(false);
                    ClusterAnalysisNotification.this.pipeline.c();
                } else {
                    String string = clusterAnalysisOutput.d().getUncopiedMutableInfo().v();
                    String string2 = NumberFormatFactory.a(Float.valueOf(clusterAnalysisOutput.h()));
                    ClusterAnalysisNotification.this.meanOutput.setText(string2 + " " + string);
                    String string3 = NumberFormatFactory.a(Float.valueOf(clusterAnalysisOutput.i()));
                    ClusterAnalysisNotification.this.stdDevOutput.setText(string3 + " " + string);
                    clusterAnalysisOutput.b().bz();
                    ClusterAnalysisNotification.this.viewController.g().Q();
                    ClusterAnalysisNotification.this.resultsTable.setModel((TableModel)new ClusterResultsTableModel(clusterAnalysisOutput));
                    ClusterAnalysisNotification.this.resultsTable.revalidate();
                    ClusterAnalysisNotification.this.resultsTable.repaint();
                    ClusterAnalysisNotification.this.scrollPanel.revalidate();
                    ClusterAnalysisNotification.this.scrollPanel.repaint();
                }
            }

            @Override
            public /* synthetic */ void doIt(Object object) {
                this.a((ClusterAnalysisOutput)object);
            }
        };
    }

    private ClusterAnalysisPipeline.a v() {
        return new ClusterAnalysisPipeline.a(){

            @Override
            public void a(Progress progress) {
                ClusterAnalysisNotification.this.ok.setEnabled(false);
                ClusterAnalysisNotification.this.a(progress);
            }

            @Override
            public void a() {
                ClusterAnalysisNotification.this.ok.setEnabled(true);
                ClusterAnalysisNotification.this.y();
            }
        };
    }

    private void a(final Progress progress) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                ClusterAnalysisNotification.this.progressPanel.removeAll();
                MIMJProgressBar mIMJProgressBar = new MIMJProgressBar(progress, true);
                ClusterAnalysisNotification.this.progressPanel.add(mIMJProgressBar);
                ClusterAnalysisNotification.this.x();
            }
        });
    }

    private void w() {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                ClusterAnalysisNotification.this.progressPanel.removeAll();
                JLabel jLabel = new JLabel(am.w().getProperty("CLUSTER_ERROR"));
                jLabel.setForeground(MIMLookAndFeel.r());
                ClusterAnalysisNotification.this.progressPanel.add(jLabel);
                ClusterAnalysisNotification.this.x();
            }
        });
    }

    private void x() {
        this.progressPanel.setVisible(true);
        this.resultsPanel.setVisible(false);
        this.notificationPanel.revalidate();
        this.notificationPanel.repaint();
    }

    private void y() {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                ClusterAnalysisNotification.this.progressPanel.setVisible(false);
                ClusterAnalysisNotification.this.resultsPanel.setVisible(true);
                ClusterAnalysisNotification.this.notificationPanel.revalidate();
                ClusterAnalysisNotification.this.notificationPanel.repaint();
            }
        });
    }

    private ActionListener c(final boolean bl2) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (bl2) {
                        ClusterAnalysisNotification.this.a(ClusterAnalysisNotification.this.defaultInputValues);
                    } else {
                        ClusterAnalysisNotification.this.z();
                    }
                    u.b().d(ClusterAnalysisNotification.this);
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error setting cluster params on series info", throwable, this);
                }
                finally {
                    if (ClusterAnalysisNotification.this.latch != null) {
                        ClusterAnalysisNotification.this.latch.b();
                    }
                }
            }
        };
    }

    private void z() {
        if (this.b(this.camResInput, false)) {
            CameraSpecsPrefs.resolutionByModelName.b(this.viewController.getUncopiedMutableInfo().modelName).setValue(Float.valueOf(this.b(this.camResInput)));
        }
        if (this.b(this.gaussianSmooth, false)) {
            CameraSpecsPrefs.clusterSmoothFwhm.setValue(Float.valueOf(this.b(this.gaussianSmooth)));
        }
        if (this.b(this.minSDInput, true)) {
            CameraSpecsPrefs.clusterStddev.setValue(Float.valueOf(this.b(this.minSDInput)));
        }
        if (this.b(this.pValueInput, false)) {
            CameraSpecsPrefs.clusterPval.setValue(Float.valueOf(this.b(this.pValueInput)));
        }
        if (this.b(this.minVolInput, false)) {
            CameraSpecsPrefs.minimumVolume.setValue(Float.valueOf(this.b(this.minVolInput)));
        }
        CameraSpecsPrefs.zscoreRange.setValue(((ZscoreType)this.useSDRangeInput.getSelectedItem()).name());
        Pair pair = (Pair)this.clusterMaskInput.getSelectedItem();
        CameraSpecsPrefs.maskType.setValue(((ContourMaskType)pair.x).name());
        if (pair.y != null) {
            CameraSpecsPrefs.maskName.setValue(((VolumetricContourOverlayish)pair.y).getName());
        }
    }

    public static ClusterAnalysisInput b(ViewController viewController) {
        float f2 = ((Float)CameraSpecsPrefs.resolutionByModelName.b(viewController.getUncopiedMutableInfo().modelName).getValue()).floatValue();
        float f3 = CameraSpecsPrefs.clusterSmoothFwhm.getValue().floatValue();
        float f4 = CameraSpecsPrefs.clusterPval.getValue().floatValue();
        float f5 = CameraSpecsPrefs.clusterStddev.getValue().floatValue();
        float f6 = CameraSpecsPrefs.clusterMaxSd.getValue().floatValue();
        float f7 = CameraSpecsPrefs.minimumVolume.getValue().floatValue();
        float f8 = CameraSpecsPrefs.clusterSdStep.getValue().floatValue();
        ContourMaskType contourMaskType = ContourMaskType.b;
        if (ClusterAnalysisNotification.a(viewController)) {
            contourMaskType = ContourMaskType.a;
        } else {
            try {
                contourMaskType = ContourMaskType.valueOf(CameraSpecsPrefs.maskType.getValue());
            }
            catch (Throwable throwable) {
                ay.d((Object)"Could not parse data mask type", ClusterAnalysisNotification.class);
            }
        }
        ValueRange valueRange = new ValueRange(f5, f6, f8);
        return new ClusterAnalysisInput(viewController, contourMaskType, null, f2, f3, valueRange, f4, f7);
    }

    public static ValueRange a(ZscoreType zscoreType, float f2) {
        float f3 = Math.abs(CameraSpecsPrefs.clusterSdStep.getValue().floatValue());
        f3 = Math.max(f3, 0.1f);
        float f4 = CameraSpecsPrefs.clusterMaxSd.getValue().floatValue();
        if (zscoreType == ZscoreType.a) {
            f4 = f2;
        }
        ValueRange valueRange = new ValueRange(f2, f4, f3);
        return valueRange;
    }

    private boolean b(JFormattedTextField jFormattedTextField, boolean bl2) {
        try {
            return !Float.isNaN(this.b(jFormattedTextField)) && (bl2 || this.b(jFormattedTextField) >= 0.0f);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean A() {
        return this.b(this.camResInput, false) && this.b(this.gaussianSmooth, false) && this.b(this.minSDInput, true) && this.b(this.pValueInput, false) && this.b(this.minVolInput, false);
    }

    private ClusterAnalysisInput B() {
        float f2 = this.b(this.camResInput);
        float f3 = this.gaussianSmooth.getText().isEmpty() ? 0.0f : this.b(this.gaussianSmooth);
        float f4 = this.b(this.pValueInput);
        float f5 = this.b(this.minVolInput);
        Pair pair = (Pair)this.clusterMaskInput.getSelectedItem();
        ContourMaskType contourMaskType = (ContourMaskType)pair.x;
        Contour contour = pair.y == null ? null : ((VolumetricContourOverlayish)pair.y).aq();
        ValueRange valueRange = ClusterAnalysisNotification.a((ZscoreType)this.useSDRangeInput.getSelectedItem(), this.b(this.minSDInput));
        return new ClusterAnalysisInput(this.viewController, contourMaskType, contour, f2, f3, valueRange, f4, f5);
    }

    private float b(JFormattedTextField jFormattedTextField) {
        try {
            Object object = jFormattedTextField.getFormatter().stringToValue(jFormattedTextField.getText());
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
        }
        catch (Throwable throwable) {
            ay.c((Object)("Could not parse value: " + jFormattedTextField.getText()), this);
        }
        return Float.NaN;
    }

    public static enum ZscoreType implements ag
    {
        a,
        b;


        public String toString() {
            return this.getExternalizedString();
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("mui", "CLUSTER_USE_SD_" + this.name());
        }
    }

    public static enum ContourMaskType implements ag
    {
        a,
        b,
        c;


        @Override
        public String getExternalizedString() {
            if ("NEURO".equals(this.name())) {
                return Messages.a("mui", "CLUSTER_NEURO_MASK");
            }
            if ("WHOLE_BODY".equals(this.name())) {
                return Messages.a("Commands", "WHOLEBODYCONTOUR_NAME");
            }
            if ("CUSTOM".equals(this.name())) {
                return Messages.a("Commands", "CLUSTERANALYSIS_MASK_CONTOUR");
            }
            return super.toString();
        }
    }
}

