/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.neuro.gui.cluster;

import com.google.common.collect.Lists;
import com.mimvista.neuro.algorithm.cluster.ClusterAnalysisOutput;
import com.mimvista.neuro.algorithm.cluster.generator.ClusterResult;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ClusterResultsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    final int NAME_COL;
    final int ZSCORE_COL;
    final int VOLUME_COL;
    final int PVALUE_COL;
    final List<ClusterResult> results;
    final boolean showName;

    public ClusterResultsTableModel(ClusterAnalysisOutput clusterAnalysisOutput) {
        this(clusterAnalysisOutput.j(), true);
    }

    public ClusterResultsTableModel(Collection<ClusterResult> collection, boolean bl2) {
        this.results = Lists.newArrayList(collection);
        Collections.sort(this.results);
        this.showName = bl2;
        this.NAME_COL = bl2 ? 0 : -1;
        this.ZSCORE_COL = this.NAME_COL + 1;
        this.VOLUME_COL = this.ZSCORE_COL + 1;
        this.PVALUE_COL = this.VOLUME_COL + 1;
    }

    @Override
    public int getColumnCount() {
        return this.showName ? 4 : 3;
    }

    @Override
    public int getRowCount() {
        return this.results.size();
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        if (n2 == this.NAME_COL) {
            return Integer.class;
        }
        return Float.class;
    }

    @Override
    public String getColumnName(int n2) {
        if (n2 == this.NAME_COL) {
            return Messages.a("Contour", "CONT_COLL_PANEL_NAME");
        }
        if (n2 == this.ZSCORE_COL) {
            return Messages.a("mui", "CLUSTER_STDDEV");
        }
        if (n2 == this.VOLUME_COL) {
            return Messages.a("Contour", "VOLUME_FULL_STAT") + " (mL)";
        }
        return Messages.a("mui", "CLUSTER_PVAL");
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        ClusterResult clusterResult = this.c(n2);
        if (n3 == this.NAME_COL) {
            return clusterResult.a();
        }
        if (n3 == this.ZSCORE_COL) {
            return Float.valueOf(clusterResult.e());
        }
        if (n3 == this.VOLUME_COL) {
            return Float.valueOf(clusterResult.f().M());
        }
        return Float.valueOf(clusterResult.c());
    }

    public String a(int n2, int n3) {
        ClusterResult clusterResult = this.c(n2);
        if (n3 == this.NAME_COL) {
            return clusterResult.b();
        }
        Object object = this.getValueAt(n2, n3);
        if (object instanceof Float) {
            return NumberFormatFactory.a((Number)object);
        }
        return Messages.a("TherapyResponse", "NULL_FILL");
    }

    public boolean a(int n2) {
        return n2 == this.ZSCORE_COL;
    }

    public boolean b(int n2) {
        return this.c(n2).i();
    }

    public ClusterResult c(int n2) {
        return this.results.get(n2);
    }
}

