/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import org.apache.commons.math3.util.FastMath;

public class FastAtan2 {
    private static long a = Double.doubleToLongBits(0.0);
    private static long b = Double.doubleToLongBits(-0.0);

    public static double a(double d2, double d3) {
        long l2 = Double.doubleToLongBits(d2);
        if (l2 == a) {
            return Double.doubleToLongBits(d3) >= 0L ? 0.0 : Math.PI;
        }
        if (l2 == b) {
            return Double.doubleToLongBits(d3) >= 0L ? -0.0 : -Math.PI;
        }
        double d4 = Math.abs(d3);
        double d5 = Math.abs(d2);
        double d6 = Double.isInfinite(d4) && Double.isInfinite(d5) ? 1.0 : Math.min(d4, d5) / Math.max(d4, d5);
        double d7 = d6 * d6;
        double d8 = ((-0.0464964749 * d7 + 0.15931422) * d7 - 0.327622764) * d7 * d6 + d6;
        if (d5 > d4) {
            d8 = 1.5707963267948966 - d8;
        }
        if (d3 < 0.0) {
            d8 = Math.PI - d8;
        }
        if (d2 < 0.0) {
            d8 = -d8;
        }
        return d8;
    }

    public static void main(String[] stringArray) {
        int n2;
        int n3;
        int n4;
        int n5 = 5000;
        double[] dArray = new double[n5 * n5];
        double[] dArray2 = new double[n5 * n5];
        double[] dArray3 = new double[n5 * n5];
        long l2 = System.nanoTime();
        int n6 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 0;
            while (n3 < n5) {
                dArray3[n6] = FastAtan2.a(n4, n3);
                ++n3;
                ++n6;
            }
        }
        FuncUtils.a(l2, "Approx atan2");
        l2 = System.nanoTime();
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = 0;
            while (n2 < n5) {
                dArray[n4] = Math.atan2(n3, n2);
                ++n2;
                ++n4;
            }
        }
        FuncUtils.a(l2, "Math.atan2");
        l2 = System.nanoTime();
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n7 = 0;
            while (n7 < n5) {
                dArray2[n3] = FastMath.atan2((double)n2, (double)n7);
                ++n7;
                ++n3;
            }
        }
        FuncUtils.a(l2, "FastMath.atan2");
        System.out.println("FastMath error: " + MathUtils.h(MathUtils.c(MathUtils.a(dArray2, dArray))));
        System.out.println("Approx error: " + MathUtils.h(MathUtils.c(MathUtils.a(dArray3, dArray))));
        System.exit(0);
    }
}

