/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.util.contrast.a;

public class FastLog {
    private static final int a = 14;
    private static final float[] b = FastLog.a(14);

    private static float[] a(int n2) {
        int n3 = 1 << n2;
        int n4 = 1065353216;
        float f2 = Float.intBitsToFloat(n4);
        int n5 = 1 << 23 - n2;
        float[] fArray = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray[i2] = (float)(Math.log(f2) / Math.log(2.0));
            f2 = Float.intBitsToFloat(n4 += n5);
        }
        return fArray;
    }

    public static float a(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        int n3 = (n2 >> 23 & 0xFF) - 127;
        n2 &= 0x7FFFFF;
        f2 = b[n2 >>= 9];
        return (f2 + (float)n3) * 0.6931472f;
    }

    public static float b(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        int n3 = (n2 >> 23 & 0xFF) - 127;
        n2 &= 0x7FFFFF;
        f2 = b[n2 >>= 9];
        return (f2 + (float)n3) * 0.30103f;
    }

    public static float c(float f2) {
        int n2 = Float.floatToRawIntBits(f2);
        int n3 = (n2 >> 23 & 0xFF) - 127;
        n2 &= 0x7FFFFF;
        f2 = b[n2 >>= 9];
        return f2 + (float)n3;
    }

    public static void main(String[] stringArray) {
        int n2 = 500000000;
        int n3 = 10000;
        double[] dArray = new double[n3];
        float[] fArray = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = Math.random();
            fArray[i2] = (float)dArray[i2];
        }
        long l2 = System.nanoTime();
        double d2 = 0.0;
        for (int i3 = 0; i3 < n2; ++i3) {
            d2 += Math.log(dArray[i3 % n3]) / Math.log(2.0);
        }
        long l3 = System.nanoTime();
        String string = com.mimvista.util.contrast.a.a().format((double)(l3 - l2) * 1.0E-6);
        System.out.println("Java Math.log took " + string + "ms, sum = " + d2);
        l2 = System.nanoTime();
        d2 = 0.0;
        for (int i4 = 0; i4 < n2; ++i4) {
            d2 += (double)FastLog.c(fArray[i4 % n3]);
        }
        l3 = System.nanoTime();
        string = com.mimvista.util.contrast.a.a().format((double)(l3 - l2) * 1.0E-6);
        System.out.println("ICSI FastLog.log took " + string + "ms, sum = " + d2);
    }
}

