/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.google.common.collect.Lists;
import com.mimvista.numerics.Vector3fPro;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.List;

public class IOP
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector3fPro xVector;
    private Vector3fPro yVector;

    public IOP(Vector3fPro vector3fPro, Vector3fPro vector3fPro2) {
        this.xVector = new Vector3fPro(vector3fPro);
        this.yVector = new Vector3fPro(vector3fPro2);
    }

    public IOP(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.xVector = new Vector3fPro(f2, f3, f4);
        this.yVector = new Vector3fPro(f5, f6, f7);
    }

    public static IOP a(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length < 6) {
            ay.c((Object)("Bad IOP array? Length: " + fArray.length), IOP.class);
            return null;
        }
        if (fArray.length > 6) {
            ay.c((Object)("Bad IOP array? Length: " + fArray.length), IOP.class);
        }
        return new IOP(fArray);
    }

    private IOP(float[] fArray) {
        this.xVector = new Vector3fPro(fArray[0], fArray[1], fArray[2]);
        this.yVector = new Vector3fPro(fArray[3], fArray[4], fArray[5]);
    }

    public Vector3fPro a() {
        return new Vector3fPro(this.xVector);
    }

    public Vector3fPro b() {
        return new Vector3fPro(this.yVector);
    }

    public Vector3fPro c() {
        Vector3fPro vector3fPro = new Vector3fPro();
        vector3fPro.cross(this.xVector, this.yVector);
        return vector3fPro;
    }

    public Vector3fPro d() {
        Vector3fPro vector3fPro = new Vector3fPro();
        vector3fPro.cross(this.xVector, this.yVector);
        vector3fPro.negate();
        return vector3fPro;
    }

    public String toString() {
        return "X: " + (Object)((Object)this.xVector) + " Y: " + (Object)((Object)this.yVector);
    }

    public static List<Double> a(IOP iOP) {
        if (iOP == null) {
            return null;
        }
        return Lists.newArrayList((Object[])new Double[]{iOP.xVector.x, iOP.xVector.y, iOP.xVector.z, iOP.yVector.x, iOP.yVector.y, iOP.yVector.z});
    }

    public static float[] b(IOP iOP) {
        if (iOP == null) {
            return null;
        }
        float[] fArray = new float[]{iOP.xVector.x, iOP.xVector.y, iOP.xVector.z, iOP.yVector.x, iOP.yVector.y, iOP.yVector.z};
        return fArray;
    }
}

