/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.numerics.ArrayListImageCubeByte;
import com.mimvista.numerics.ArrayListImageCubeDouble;
import com.mimvista.numerics.ArrayListImageCubeFloat;
import com.mimvista.numerics.ArrayListImageCubeShort;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.t;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class ImageCube<T, IT extends ImageSlice<T>>
implements Serializable,
Iterable<IT> {
    private static final long serialVersionUID = 8051898135189003797L;

    public abstract void f();

    public abstract void a(ImageSlice<T> var1);

    public abstract void a(T var1);

    public abstract void a(Collection<T> var1);

    public abstract void c();

    public abstract int e();

    public abstract void a(int var1, ImageSlice<T> var2);

    public abstract IT f(int var1);

    public abstract IT e(int var1);

    public abstract IT c(int var1, IT var2);

    public abstract IT d(int var1);

    public abstract IT b(int var1, IT var2);

    public abstract ImageCube<T, IT> i();

    public abstract List<T> b();

    public IT a(int n2, int n3) {
        if (n3 == 2) {
            return this.f(n2);
        }
        if (n3 == 1) {
            return this.d(n2);
        }
        if (n3 == 0) {
            return this.e(n2);
        }
        throw new IllegalArgumentException("axis must be 0,1,2");
    }

    public abstract float a(float var1, float var2, float var3, float var4);

    public abstract float a(float var1, float var2, float var3);

    public abstract float g();

    public abstract float h();

    public abstract IT b(int var1, int var2);

    public abstract int[] d();

    public abstract void a(int[] var1);

    public abstract float a_(int var1, int var2, int var3);

    public abstract short c(int var1, int var2, int var3);

    public static abstract class ImageCubeFloat
    extends ImageCube<float[], ImageSlice.ImageSliceFloat> {
        private static final long serialVersionUID = 2261587312710564525L;

        public static ImageCubeFloat a(int[] nArray, int n2) {
            return new ArrayListImageCubeFloat(nArray);
        }

        public static ImageCubeFloat b(int[] nArray) {
            ArrayListImageCubeFloat arrayListImageCubeFloat = new ArrayListImageCubeFloat(nArray);
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ((ImageCube)arrayListImageCubeFloat).a(new float[nArray[0] * nArray[1]]);
            }
            return arrayListImageCubeFloat;
        }

        public static ImageCubeFloat a(int n2, int n3, int n4, int n5) {
            return new ArrayListImageCubeFloat(n2, n3, n4);
        }

        @Override
        public ImageSlice.ImageSliceFloat c(int n2, int n3) {
            return new ImageSlice.ImageSliceFloat(n2, n3);
        }

        @Override
        public abstract float a_(int var1, int var2, int var3);

        public void a(int n2, int n3, int n4, float f2) {
            ((ImageSlice.ImageSliceFloat)this.f(n4)).a(n2, n3, f2);
        }

        public ImageCubeFloat j() {
            ImageCubeFloat imageCubeFloat;
            int[] nArray = this.d();
            if (!Arrays.equals(nArray, (imageCubeFloat = ImageCubeFloat.a(nArray, 0)).d())) {
                throw new IllegalArgumentException("The source and destination must have the same dimensions.");
            }
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                imageCubeFloat.a(((ImageSlice.ImageSliceFloat)this.f(i2)).c());
            }
            return imageCubeFloat;
        }

        public float[] k() {
            float f2 = Float.NEGATIVE_INFINITY;
            float f3 = Float.POSITIVE_INFINITY;
            List list = this.b();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                float[] fArray = (float[])list.get(i2);
                for (int i3 = 0; i3 < fArray.length; ++i3) {
                    float f4 = fArray[i3];
                    if (f4 > f2) {
                        f2 = f4;
                    }
                    if (!(f4 < f3)) continue;
                    f3 = f4;
                }
            }
            return new float[]{f2, f3};
        }

        public float a(int[] nArray, ImageCubeFloat imageCubeFloat) {
            float f2 = 0.0f;
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ImageSlice.ImageSliceFloat imageSliceFloat = (ImageSlice.ImageSliceFloat)imageCubeFloat.f(i2);
                ImageSlice.ImageSliceFloat imageSliceFloat2 = (ImageSlice.ImageSliceFloat)this.f(i2);
                for (int i3 = 0; i3 < nArray[1] * nArray[0]; ++i3) {
                    float f3 = Math.abs(((float[])imageSliceFloat2.data)[i3] - ((float[])imageSliceFloat.data)[i3]);
                    if (!(f3 > f2)) continue;
                    f2 = f3;
                }
            }
            return f2;
        }

        public float a(int[] nArray, float[] fArray) {
            float f2 = 0.0f;
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ImageSlice.ImageSliceFloat imageSliceFloat = (ImageSlice.ImageSliceFloat)this.f(i2);
                for (int i3 = 0; i3 < nArray[1] * nArray[0]; ++i3) {
                    float f3 = Math.abs(fArray[i3 + i2 * nArray[1] * nArray[0]] - ((float[])imageSliceFloat.data)[i3]);
                    if (!(f3 > f2)) continue;
                    f2 = f3;
                }
            }
            return f2;
        }

        public float b(int[] nArray, ImageCubeFloat imageCubeFloat) {
            float f2 = 0.0f;
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ImageSlice.ImageSliceFloat imageSliceFloat = (ImageSlice.ImageSliceFloat)imageCubeFloat.f(i2);
                ImageSlice.ImageSliceFloat imageSliceFloat2 = (ImageSlice.ImageSliceFloat)this.f(i2);
                for (int i3 = 0; i3 < nArray[1] * nArray[0]; ++i3) {
                    float f3 = (float)Math.pow(((float[])imageSliceFloat2.data)[i3] - ((float[])imageSliceFloat.data)[i3], 2.0);
                    f2 += f3;
                }
            }
            return (float)Math.sqrt(f2 / (float)(nArray[2] * nArray[1] * nArray[0]));
        }

        public float b(int[] nArray, float[] fArray) {
            float f2 = 0.0f;
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ImageSlice.ImageSliceFloat imageSliceFloat = (ImageSlice.ImageSliceFloat)this.f(i2);
                for (int i3 = 0; i3 < nArray[1] * nArray[0]; ++i3) {
                    float f3 = (float)Math.pow(fArray[i3 + i2 * nArray[1] * nArray[0]] - ((float[])imageSliceFloat.data)[i3], 2.0);
                    f2 += f3;
                }
            }
            return (float)Math.sqrt(f2 / (float)(nArray[2] * nArray[1] * nArray[0]));
        }

        @Override
        public float a(float f2, float f3, float f4) {
            int n2;
            int n3;
            int n4 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n5 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n6 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f5 = f2 - (float)n4 - 0.5f;
            float f6 = f3 - (float)n5 - 0.5f;
            float f7 = f4 - (float)n6 - 0.5f;
            int[] nArray = this.d();
            int n7 = n6 > 0 ? (n6 < nArray[2] ? n6 : nArray[2] - 1) : 0;
            int n8 = n6 + (f7 >= 0.0f ? 1 : -1);
            int n9 = n8 > 0 ? (n8 < nArray[2] ? n8 : nArray[2] - 1) : (n3 = 0);
            int n10 = n5 > 0 ? (n5 < nArray[1] ? n5 : nArray[1] - 1) : 0;
            int n11 = n5 + (f6 >= 0.0f ? 1 : -1);
            int n12 = n11 > 0 ? (n11 < nArray[1] ? n11 : nArray[1] - 1) : (n2 = 0);
            int n13 = n4 > 0 ? (n4 < nArray[0] ? n4 : nArray[0] - 1) : 0;
            int n14 = n4 + (f5 >= 0.0f ? 1 : -1);
            int n15 = n14 > 0 ? (n14 < nArray[0] ? n14 : nArray[0] - 1) : 0;
            float[] fArray = (float[])this.b().get(n7);
            float f8 = fArray[n13 + (n10 *= nArray[0])];
            float f9 = fArray[n13 + (n2 *= nArray[0])];
            float f10 = fArray[n15 + n10];
            float f11 = fArray[n15 + n2];
            fArray = (float[])this.b().get(n3);
            float f12 = fArray[n13 + n10];
            float f13 = fArray[n13 + n2];
            float f14 = fArray[n15 + n10];
            float f15 = fArray[n15 + n2];
            f5 = f5 >= 0.0f ? f5 : -f5;
            f6 = f6 >= 0.0f ? f6 : -f6;
            f7 = f7 >= 0.0f ? f7 : -f7;
            float f16 = f8 + f5 * (f10 - f8);
            float f17 = f9 + f5 * (f11 - f9);
            float f18 = f16 + f6 * (f17 - f16);
            float f19 = f12 + f5 * (f14 - f12);
            float f20 = f13 + f5 * (f15 - f13);
            float f21 = f19 + f6 * (f20 - f19);
            return f18 + f7 * (f21 - f18);
        }

        @Override
        public strictfp float a(float f2, float f3, float f4, float f5) {
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            float f12;
            float f13;
            float[] fArray;
            int n2 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n3 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n4 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f14 = f2 - (float)n2 - 0.5f;
            float f15 = f3 - (float)n3 - 0.5f;
            float f16 = f4 - (float)n4 - 0.5f;
            int[] nArray = this.d();
            int n5 = n4 + (f16 >= 0.0f ? 1 : -1);
            int n6 = n3 + (f15 >= 0.0f ? 1 : -1);
            int n7 = n2 + (f14 >= 0.0f ? 1 : -1);
            float f17 = f5;
            boolean bl2 = n2 > -1 && n2 < nArray[0];
            boolean bl3 = n7 > -1 && n7 < nArray[0];
            boolean bl4 = n3 > -1 && n3 < nArray[1];
            boolean bl5 = n6 > -1 && n6 < nArray[1];
            boolean bl6 = n4 > -1 && n4 < nArray[2];
            boolean bl7 = n5 > -1 && n5 < nArray[2];
            n3 *= nArray[0];
            n6 *= nArray[0];
            if (bl6) {
                fArray = (float[])this.b().get(n4);
                if (bl2) {
                    f13 = bl4 ? fArray[n2 + n3] : f17;
                    f12 = bl5 ? fArray[n2 + n6] : f17;
                } else {
                    f13 = f17;
                    f12 = f17;
                }
                if (bl3) {
                    f11 = bl4 ? fArray[n7 + n3] : f17;
                    f10 = bl5 ? fArray[n7 + n6] : f17;
                } else {
                    f11 = f17;
                    f10 = f17;
                }
            } else {
                f13 = f17;
                f12 = f17;
                f11 = f17;
                f10 = f17;
            }
            if (bl7) {
                fArray = (float[])this.b().get(n5);
                if (bl2) {
                    f9 = bl4 ? fArray[n2 + n3] : f17;
                    f8 = bl5 ? fArray[n2 + n6] : f17;
                } else {
                    f9 = f17;
                    f8 = f17;
                }
                if (bl3) {
                    f7 = bl4 ? fArray[n7 + n3] : f17;
                    f6 = bl5 ? fArray[n7 + n6] : f17;
                } else {
                    f7 = f17;
                    f6 = f17;
                }
            } else {
                f9 = f17;
                f8 = f17;
                f7 = f17;
                f6 = f17;
            }
            f14 = f14 >= 0.0f ? f14 : -f14;
            f15 = f15 >= 0.0f ? f15 : -f15;
            f16 = f16 >= 0.0f ? f16 : -f16;
            float f18 = f13 + f14 * (f11 - f13);
            float f19 = f12 + f14 * (f10 - f12);
            float f20 = f18 + f15 * (f19 - f18);
            float f21 = f9 + f14 * (f7 - f9);
            float f22 = f8 + f14 * (f6 - f8);
            float f23 = f21 + f15 * (f22 - f21);
            return f20 + f16 * (f23 - f20);
        }

        @Override
        public /* synthetic */ ImageSlice b(int n2, int n3) {
            return this.c(n2, n3);
        }

        @Override
        public /* synthetic */ ImageCube i() {
            return this.j();
        }
    }

    public static abstract class ImageCubeDouble
    extends ImageCube<double[], ImageSlice.ImageSliceDouble> {
        private static final long serialVersionUID = 2261587312710564525L;

        public static ImageCubeDouble a(int[] nArray, int n2) {
            return new ArrayListImageCubeDouble(nArray);
        }

        public static ImageCubeDouble b(int[] nArray) {
            ArrayListImageCubeDouble arrayListImageCubeDouble = new ArrayListImageCubeDouble(nArray);
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ((ImageCube)arrayListImageCubeDouble).a(new double[nArray[0] * nArray[1]]);
            }
            return arrayListImageCubeDouble;
        }

        public static ImageCubeDouble a(int n2, int n3, int n4, int n5) {
            return new ArrayListImageCubeDouble(n2, n3, n4);
        }

        public abstract double b(int var1, int var2, int var3);

        @Override
        public abstract float a_(int var1, int var2, int var3);

        public void a(int n2, int n3, int n4, float f2) {
            ((ImageSlice.ImageSliceDouble)this.f(n4)).a(n2, n3, f2);
        }

        @Override
        public ImageSlice.ImageSliceDouble c(int n2, int n3) {
            return new ImageSlice.ImageSliceDouble(n2, n3);
        }

        public ImageCubeDouble j() {
            ImageCubeDouble imageCubeDouble;
            int[] nArray = this.d();
            if (!Arrays.equals(nArray, (imageCubeDouble = ImageCubeDouble.a(nArray, 0)).d())) {
                throw new IllegalArgumentException("The source and destination must have the same dimensions.");
            }
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                imageCubeDouble.a(((ImageSlice.ImageSliceDouble)this.f(i2)).c());
            }
            return imageCubeDouble;
        }

        public double[] k() {
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            for (double[] dArray : this.b()) {
                for (int i2 = 0; i2 < dArray.length; ++i2) {
                    double d4 = dArray[i2];
                    if (d4 > d2) {
                        d2 = d4;
                    }
                    if (!(d4 < d3)) continue;
                    d3 = d4;
                }
            }
            return new double[]{d2, d3};
        }

        @Override
        public float a(float f2, float f3, float f4) {
            int n2;
            int n3;
            int n4 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n5 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n6 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f5 = f2 - (float)n4 - 0.5f;
            float f6 = f3 - (float)n5 - 0.5f;
            float f7 = f4 - (float)n6 - 0.5f;
            int[] nArray = this.d();
            int n7 = n6 > 0 ? (n6 < nArray[2] ? n6 : nArray[2] - 1) : 0;
            int n8 = n6 + (f7 >= 0.0f ? 1 : -1);
            int n9 = n8 > 0 ? (n8 < nArray[2] ? n8 : nArray[2] - 1) : (n3 = 0);
            int n10 = n5 > 0 ? (n5 < nArray[1] ? n5 : nArray[1] - 1) : 0;
            int n11 = n5 + (f6 >= 0.0f ? 1 : -1);
            int n12 = n11 > 0 ? (n11 < nArray[1] ? n11 : nArray[1] - 1) : (n2 = 0);
            int n13 = n4 > 0 ? (n4 < nArray[0] ? n4 : nArray[0] - 1) : 0;
            int n14 = n4 + (f5 >= 0.0f ? 1 : -1);
            int n15 = n14 > 0 ? (n14 < nArray[0] ? n14 : nArray[0] - 1) : 0;
            double[] dArray = (double[])this.b().get(n7);
            double d2 = dArray[n13 + (n10 *= nArray[0])];
            double d3 = dArray[n13 + (n2 *= nArray[0])];
            double d4 = dArray[n15 + n10];
            double d5 = dArray[n15 + n2];
            dArray = (double[])this.b().get(n3);
            double d6 = dArray[n13 + n10];
            double d7 = dArray[n13 + n2];
            double d8 = dArray[n15 + n10];
            double d9 = dArray[n15 + n2];
            f5 = f5 >= 0.0f ? f5 : -f5;
            f6 = f6 >= 0.0f ? f6 : -f6;
            f7 = f7 >= 0.0f ? f7 : -f7;
            double d10 = d2 + (double)f5 * (d4 - d2);
            double d11 = d3 + (double)f5 * (d5 - d3);
            double d12 = d10 + (double)f6 * (d11 - d10);
            double d13 = d6 + (double)f5 * (d8 - d6);
            double d14 = d7 + (double)f5 * (d9 - d7);
            double d15 = d13 + (double)f6 * (d14 - d13);
            return (float)(d12 + (double)f7 * (d15 - d12));
        }

        @Override
        public strictfp float a(float f2, float f3, float f4, float f5) {
            return (float)this.a(f2, f3, f4, (double)f5);
        }

        public strictfp double a(float f2, float f3, float f4, double d2) {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double[] dArray;
            int n2 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n3 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n4 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f5 = f2 - (float)n2 - 0.5f;
            float f6 = f3 - (float)n3 - 0.5f;
            float f7 = f4 - (float)n4 - 0.5f;
            int[] nArray = this.d();
            int n5 = n4 + (f7 >= 0.0f ? 1 : -1);
            int n6 = n3 + (f6 >= 0.0f ? 1 : -1);
            int n7 = n2 + (f5 >= 0.0f ? 1 : -1);
            double d11 = d2;
            boolean bl2 = n2 > -1 && n2 < nArray[0];
            boolean bl3 = n7 > -1 && n7 < nArray[0];
            boolean bl4 = n3 > -1 && n3 < nArray[1];
            boolean bl5 = n6 > -1 && n6 < nArray[1];
            boolean bl6 = n4 > -1 && n4 < nArray[2];
            boolean bl7 = n5 > -1 && n5 < nArray[2];
            n3 *= nArray[0];
            n6 *= nArray[0];
            if (bl6) {
                dArray = (double[])this.b().get(n4);
                if (bl2) {
                    d10 = bl4 ? dArray[n2 + n3] : d11;
                    d9 = bl5 ? dArray[n2 + n6] : d11;
                } else {
                    d10 = d11;
                    d9 = d11;
                }
                if (bl3) {
                    d8 = bl4 ? dArray[n7 + n3] : d11;
                    d7 = bl5 ? dArray[n7 + n6] : d11;
                } else {
                    d8 = d11;
                    d7 = d11;
                }
            } else {
                d10 = d11;
                d9 = d11;
                d8 = d11;
                d7 = d11;
            }
            if (bl7) {
                dArray = (double[])this.b().get(n5);
                if (bl2) {
                    d6 = bl4 ? dArray[n2 + n3] : d11;
                    d5 = bl5 ? dArray[n2 + n6] : d11;
                } else {
                    d6 = d11;
                    d5 = d11;
                }
                if (bl3) {
                    d4 = bl4 ? dArray[n7 + n3] : d11;
                    d3 = bl5 ? dArray[n7 + n6] : d11;
                } else {
                    d4 = d11;
                    d3 = d11;
                }
            } else {
                d6 = d11;
                d5 = d11;
                d4 = d11;
                d3 = d11;
            }
            f5 = f5 >= 0.0f ? f5 : -f5;
            f6 = f6 >= 0.0f ? f6 : -f6;
            f7 = f7 >= 0.0f ? f7 : -f7;
            double d12 = d10 + (double)f5 * (d8 - d10);
            double d13 = d9 + (double)f5 * (d7 - d9);
            double d14 = d12 + (double)f6 * (d13 - d12);
            double d15 = d6 + (double)f5 * (d4 - d6);
            double d16 = d5 + (double)f5 * (d3 - d5);
            double d17 = d15 + (double)f6 * (d16 - d15);
            return d14 + (double)f7 * (d17 - d14);
        }

        @Override
        public /* synthetic */ ImageSlice b(int n2, int n3) {
            return this.c(n2, n3);
        }

        @Override
        public /* synthetic */ ImageCube i() {
            return this.j();
        }
    }

    public static abstract class ImageCubeShort
    extends AbstractIntegralImageCube<short[], ImageSlice.ImageSliceShort> {
        private static final long serialVersionUID = 721992857550996836L;

        public static ImageCubeShort a(int[] nArray, int n2) {
            return new ArrayListImageCubeShort(nArray);
        }

        public static ImageCubeShort a(int n2, int n3, int n4, int n5) {
            return new ArrayListImageCubeShort(n2, n3, n4);
        }

        public static ImageCubeShort b(int[] nArray) {
            return ImageCubeShort.a(nArray, (short)0);
        }

        public static ImageCubeShort a(int[] nArray, short s2) {
            ArrayListImageCubeShort arrayListImageCubeShort = new ArrayListImageCubeShort(nArray);
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                short[] sArray = new short[nArray[0] * nArray[1]];
                if (s2 != 0) {
                    Arrays.fill(sArray, s2);
                }
                ((ImageCube)arrayListImageCubeShort).a(sArray);
            }
            return arrayListImageCubeShort;
        }

        public static ImageCubeShort d(int n2, int n3, int n4) {
            return ImageCubeShort.b(new int[]{n2, n3, n4});
        }

        public static ImageCubeShort a(t t2) {
            ArrayListImageCubeShort arrayListImageCubeShort = new ArrayListImageCubeShort(t2.f());
            for (int i2 = 0; i2 < t2.e(); ++i2) {
                arrayListImageCubeShort.a(((short[][])t2.h())[i2]);
            }
            return arrayListImageCubeShort;
        }

        @Override
        public ImageSlice.ImageSliceShort c(int n2, int n3) {
            return new ImageSlice.ImageSliceShort(n2, n3);
        }

        public void a(int n2, int n3, int n4, short s2) {
            ((ImageSlice.ImageSliceShort)this.f(n4)).a(n2, n3, s2);
        }

        @Override
        public abstract short c(int var1, int var2, int var3);

        public ImageCubeShort j() {
            int[] nArray = this.d();
            ImageCubeShort imageCubeShort = ImageCubeShort.a(nArray, 0);
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)this.f(i2);
                if (imageSliceShort == null) continue;
                imageCubeShort.a(imageSliceShort.c());
            }
            return imageCubeShort;
        }

        public int a(int[] nArray, ImageCubeShort imageCubeShort) {
            int n2 = 0;
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)imageCubeShort.f(i2);
                ImageSlice.ImageSliceShort imageSliceShort2 = (ImageSlice.ImageSliceShort)this.f(i2);
                for (int i3 = 0; i3 < nArray[1] * nArray[0]; ++i3) {
                    int n3 = Math.abs(((short[])imageSliceShort2.data)[i3] - ((short[])imageSliceShort.data)[i3]);
                    if (n3 <= n2) continue;
                    n2 = n3;
                }
            }
            return n2;
        }

        public boolean k() {
            int[] nArray = this.d();
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                for (int i3 = 0; i3 < nArray[1]; ++i3) {
                    for (int i4 = 0; i4 < nArray[0]; ++i4) {
                        if (this.b(i4, i3, i2) <= 0) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        public void l() {
            int n2 = this.d()[0];
            int n3 = this.d()[1];
            for (short[] sArray : this.b()) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    for (int i3 = 0; i3 < n2 / 2; ++i3) {
                        short s2 = sArray[i3 + i2 * n2];
                        sArray[i3 + i2 * n2] = sArray[(i2 + 1) * n2 - 1 - i3];
                        sArray[(i2 + 1) * n2 - 1 - i3] = s2;
                    }
                }
            }
        }

        public void m() {
            int n2 = this.d()[0];
            int n3 = this.d()[1];
            for (short[] sArray : this.b()) {
                short[] sArray2 = new short[sArray.length];
                System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
                for (int i2 = 0; i2 < n3; ++i2) {
                    System.arraycopy(sArray2, i2 * n2, sArray, (n3 - 1 - i2) * n2, n2);
                }
            }
        }

        @Override
        public strictfp float a(float f2, float f3, float f4, float f5) {
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            float f12;
            float f13;
            short[] sArray;
            int n2 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n3 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n4 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f14 = f2 - (float)n2 - 0.5f;
            float f15 = f3 - (float)n3 - 0.5f;
            float f16 = f4 - (float)n4 - 0.5f;
            int[] nArray = this.d();
            int n5 = n4 + (f16 >= 0.0f ? 1 : -1);
            int n6 = n3 + (f15 >= 0.0f ? 1 : -1);
            int n7 = n2 + (f14 >= 0.0f ? 1 : -1);
            boolean bl2 = n2 > -1 && n2 < nArray[0];
            boolean bl3 = n7 > -1 && n7 < nArray[0];
            boolean bl4 = n3 > -1 && n3 < nArray[1];
            boolean bl5 = n6 > -1 && n6 < nArray[1];
            boolean bl6 = n4 > -1 && n4 < nArray[2];
            boolean bl7 = n5 > -1 && n5 < nArray[2];
            n3 *= nArray[0];
            n6 *= nArray[0];
            if (bl6) {
                sArray = (short[])this.b().get(n4);
                if (bl2) {
                    f13 = bl4 ? (float)sArray[n2 + n3] : f5;
                    f12 = bl5 ? (float)sArray[n2 + n6] : f5;
                } else {
                    f13 = f5;
                    f12 = f5;
                }
                if (bl3) {
                    f11 = bl4 ? (float)sArray[n7 + n3] : f5;
                    f10 = bl5 ? (float)sArray[n7 + n6] : f5;
                } else {
                    f11 = f5;
                    f10 = f5;
                }
            } else {
                f13 = f5;
                f12 = f5;
                f11 = f5;
                f10 = f5;
            }
            if (bl7) {
                sArray = (short[])this.b().get(n5);
                if (bl2) {
                    f9 = bl4 ? (float)sArray[n2 + n3] : f5;
                    f8 = bl5 ? (float)sArray[n2 + n6] : f5;
                } else {
                    f9 = f5;
                    f8 = f5;
                }
                if (bl3) {
                    f7 = bl4 ? (float)sArray[n7 + n3] : f5;
                    f6 = bl5 ? (float)sArray[n7 + n6] : f5;
                } else {
                    f7 = f5;
                    f6 = f5;
                }
            } else {
                f9 = f5;
                f8 = f5;
                f7 = f5;
                f6 = f5;
            }
            f14 = f14 >= 0.0f ? f14 : -f14;
            f15 = f15 >= 0.0f ? f15 : -f15;
            f16 = f16 >= 0.0f ? f16 : -f16;
            float f17 = f13 + f14 * (f11 - f13);
            float f18 = f12 + f14 * (f10 - f12);
            float f19 = f17 + f15 * (f18 - f17);
            float f20 = f9 + f14 * (f7 - f9);
            float f21 = f8 + f14 * (f6 - f8);
            float f22 = f20 + f15 * (f21 - f20);
            return f19 + f16 * (f22 - f19);
        }

        @Override
        public strictfp float a(float f2, float f3, float f4) {
            int n2;
            int n3;
            int n4 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n5 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n6 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f5 = f2 - (float)n4 - 0.5f;
            float f6 = f3 - (float)n5 - 0.5f;
            float f7 = f4 - (float)n6 - 0.5f;
            int[] nArray = this.d();
            int n7 = n6 > 0 ? (n6 < nArray[2] ? n6 : nArray[2] - 1) : 0;
            int n8 = n6 + (f7 >= 0.0f ? 1 : -1);
            int n9 = n8 > 0 ? (n8 < nArray[2] ? n8 : nArray[2] - 1) : (n3 = 0);
            int n10 = n5 > 0 ? (n5 < nArray[1] ? n5 : nArray[1] - 1) : 0;
            int n11 = n5 + (f6 >= 0.0f ? 1 : -1);
            int n12 = n11 > 0 ? (n11 < nArray[1] ? n11 : nArray[1] - 1) : (n2 = 0);
            int n13 = n4 > 0 ? (n4 < nArray[0] ? n4 : nArray[0] - 1) : 0;
            int n14 = n4 + (f5 >= 0.0f ? 1 : -1);
            int n15 = n14 > 0 ? (n14 < nArray[0] ? n14 : nArray[0] - 1) : 0;
            short[] sArray = (short[])this.b().get(n7);
            short s2 = sArray[n13 + (n10 *= nArray[0])];
            short s3 = sArray[n13 + (n2 *= nArray[0])];
            short s4 = sArray[n15 + n10];
            short s5 = sArray[n15 + n2];
            sArray = (short[])this.b().get(n3);
            short s6 = sArray[n13 + n10];
            short s7 = sArray[n13 + n2];
            short s8 = sArray[n15 + n10];
            short s9 = sArray[n15 + n2];
            f5 = f5 >= 0.0f ? f5 : -f5;
            f6 = f6 >= 0.0f ? f6 : -f6;
            f7 = f7 >= 0.0f ? f7 : -f7;
            float f8 = (float)s2 + f5 * (float)(s4 - s2);
            float f9 = (float)s3 + f5 * (float)(s5 - s3);
            float f10 = f8 + f6 * (f9 - f8);
            float f11 = (float)s6 + f5 * (float)(s8 - s6);
            float f12 = (float)s7 + f5 * (float)(s9 - s7);
            float f13 = f11 + f6 * (f12 - f11);
            return f10 + f7 * (f13 - f10);
        }

        @Override
        public /* synthetic */ ImageSlice b(int n2, int n3) {
            return this.c(n2, n3);
        }

        @Override
        public /* synthetic */ ImageCube i() {
            return this.j();
        }
    }

    public static abstract class ImageCubeByte
    extends AbstractIntegralImageCube<byte[], ImageSlice.ImageSliceByte> {
        private static final long serialVersionUID = 10012824782644376L;

        public static ImageCubeByte a(int[] nArray, int n2) {
            return new ArrayListImageCubeByte(nArray);
        }

        public static ImageCubeByte a(int n2, int n3, int n4, int n5) {
            return new ArrayListImageCubeByte(n2, n3, n4);
        }

        public static ImageCubeByte b(int[] nArray) {
            return ImageCubeByte.a(nArray, (byte)0);
        }

        public static ImageCubeByte a(int[] nArray, byte by2) {
            ArrayListImageCubeByte arrayListImageCubeByte = new ArrayListImageCubeByte(nArray);
            for (int i2 = 0; i2 < nArray[2]; ++i2) {
                byte[] byArray = new byte[nArray[0] * nArray[1]];
                if (by2 != 0) {
                    Arrays.fill(byArray, by2);
                }
                ((ImageCube)arrayListImageCubeByte).a(byArray);
            }
            return arrayListImageCubeByte;
        }

        public static ImageCubeByte a(ByteBuffer byteBuffer, int[] nArray) {
            ImageCubeByte imageCubeByte = ImageCubeByte.a(nArray, 0);
            imageCubeByte.a(byteBuffer);
            return imageCubeByte;
        }

        public static ImageCubeByte a(t t2) {
            ArrayListImageCubeByte arrayListImageCubeByte = new ArrayListImageCubeByte(t2.f());
            for (int i2 = 0; i2 < arrayListImageCubeByte.d()[2]; ++i2) {
                arrayListImageCubeByte.a(((byte[][])t2.h())[i2]);
            }
            return arrayListImageCubeByte;
        }

        @Override
        public ImageSlice.ImageSliceByte c(int n2, int n3) {
            return new ImageSlice.ImageSliceByte(n2, n3);
        }

        @Override
        public void a(ByteBuffer byteBuffer) {
            byteBuffer.rewind();
            this.c();
            for (int i2 = 0; i2 < this.d()[2]; ++i2) {
                byte[] byArray = new byte[this.d()[0] * this.d()[1]];
                byteBuffer.get(byArray);
                this.a(byArray);
            }
        }

        public void b(byte[] byArray) {
            this.c();
            int n2 = this.d()[0] * this.d()[1];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.d()[2]) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n3, byArray2, 0, n2);
                this.a(byArray2);
                ++n4;
                n3 += n2;
            }
        }

        public void a(ByteBuffer byteBuffer, int n2) {
            this.a(byteBuffer.array(), n2);
        }

        public void a(byte[] byArray, int n2) {
            for (int i2 = 0; i2 < this.e(); ++i2) {
                ImageSlice.ImageSliceByte imageSliceByte = (ImageSlice.ImageSliceByte)this.f(i2);
                int n3 = i2 * ((byte[])imageSliceByte.data).length;
                for (int i3 = 0; i3 < ((byte[])imageSliceByte.data).length; ++i3) {
                    byArray[n3 + i3] = ((byte[])imageSliceByte.data)[i3] >= n2 ? 127 : 0;
                }
            }
        }

        public void a(ByteBuffer byteBuffer, byte by2) {
            this.a(byteBuffer.array(), by2);
        }

        public void a(byte[] byArray, byte by2) {
            for (int i2 = 0; i2 < this.e(); ++i2) {
                int n2 = 127;
                int n3 = 0;
                ImageSlice.ImageSliceByte imageSliceByte = (ImageSlice.ImageSliceByte)this.f(i2);
                int n4 = i2 * ((byte[])imageSliceByte.data).length;
                for (int i3 = 0; i3 < ((byte[])imageSliceByte.data).length; ++i3) {
                    byArray[n4 + i3] = ((byte[])imageSliceByte.data)[i3] == by2 ? n2 : n3;
                }
            }
        }

        public ImageCubeByte j() {
            ArrayListImageCubeByte arrayListImageCubeByte = new ArrayListImageCubeByte((int[])this.d().clone());
            for (int i2 = 0; i2 < this.d()[2]; ++i2) {
                arrayListImageCubeByte.a(((ImageSlice.ImageSliceByte)this.f(i2)).c());
            }
            return arrayListImageCubeByte;
        }

        public abstract byte a(int var1, int var2, int var3);

        @Override
        public strictfp float a(float f2, float f3, float f4, float f5) {
            byte by2;
            byte by3;
            byte by4;
            byte by5;
            byte by6;
            byte by7;
            byte by8;
            byte by9;
            byte[] byArray;
            int n2 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n3 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n4 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f6 = f2 - (float)n2 - 0.5f;
            float f7 = f3 - (float)n3 - 0.5f;
            float f8 = f4 - (float)n4 - 0.5f;
            int[] nArray = this.d();
            int n5 = n4 + (f8 >= 0.0f ? 1 : -1);
            int n6 = n3 + (f7 >= 0.0f ? 1 : -1);
            int n7 = n2 + (f6 >= 0.0f ? 1 : -1);
            byte by10 = (byte)f5;
            boolean bl2 = n2 > -1 && n2 < nArray[0];
            boolean bl3 = n7 > -1 && n7 < nArray[0];
            boolean bl4 = n3 > -1 && n3 < nArray[1];
            boolean bl5 = n6 > -1 && n6 < nArray[1];
            boolean bl6 = n4 > -1 && n4 < nArray[2];
            boolean bl7 = n5 > -1 && n5 < nArray[2];
            n3 *= nArray[0];
            n6 *= nArray[0];
            if (bl6) {
                byArray = (byte[])this.b().get(n4);
                if (bl2) {
                    by9 = bl4 ? byArray[n2 + n3] : by10;
                    by8 = bl5 ? byArray[n2 + n6] : by10;
                } else {
                    by9 = by10;
                    by8 = by10;
                }
                if (bl3) {
                    by7 = bl4 ? byArray[n7 + n3] : by10;
                    by6 = bl5 ? byArray[n7 + n6] : by10;
                } else {
                    by7 = by10;
                    by6 = by10;
                }
            } else {
                by9 = by10;
                by8 = by10;
                by7 = by10;
                by6 = by10;
            }
            if (bl7) {
                byArray = (byte[])this.b().get(n5);
                if (bl2) {
                    by5 = bl4 ? byArray[n2 + n3] : by10;
                    by4 = bl5 ? byArray[n2 + n6] : by10;
                } else {
                    by5 = by10;
                    by4 = by10;
                }
                if (bl3) {
                    by3 = bl4 ? byArray[n7 + n3] : by10;
                    by2 = bl5 ? byArray[n7 + n6] : by10;
                } else {
                    by3 = by10;
                    by2 = by10;
                }
            } else {
                by5 = by10;
                by4 = by10;
                by3 = by10;
                by2 = by10;
            }
            f6 = f6 >= 0.0f ? f6 : -f6;
            f7 = f7 >= 0.0f ? f7 : -f7;
            f8 = f8 >= 0.0f ? f8 : -f8;
            float f9 = (float)by9 + f6 * (float)(by7 - by9);
            float f10 = (float)by8 + f6 * (float)(by6 - by8);
            float f11 = f9 + f7 * (f10 - f9);
            float f12 = (float)by5 + f6 * (float)(by3 - by5);
            float f13 = (float)by4 + f6 * (float)(by2 - by4);
            float f14 = f12 + f7 * (f13 - f12);
            return f11 + f8 * (f14 - f11);
        }

        @Override
        public strictfp float a(float f2, float f3, float f4) {
            int n2;
            int n3;
            int n4 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n5 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            int n6 = f4 < 0.0f ? (int)StrictMath.floor(f4) : (int)f4;
            float f5 = f2 - (float)n4 - 0.5f;
            float f6 = f3 - (float)n5 - 0.5f;
            float f7 = f4 - (float)n6 - 0.5f;
            int[] nArray = this.d();
            int n7 = n6 > 0 ? (n6 < nArray[2] ? n6 : nArray[2] - 1) : 0;
            int n8 = n6 + (f7 >= 0.0f ? 1 : -1);
            int n9 = n8 > 0 ? (n8 < nArray[2] ? n8 : nArray[2] - 1) : (n3 = 0);
            int n10 = n5 > 0 ? (n5 < nArray[1] ? n5 : nArray[1] - 1) : 0;
            int n11 = n5 + (f6 >= 0.0f ? 1 : -1);
            int n12 = n11 > 0 ? (n11 < nArray[1] ? n11 : nArray[1] - 1) : (n2 = 0);
            int n13 = n4 > 0 ? (n4 < nArray[0] ? n4 : nArray[0] - 1) : 0;
            int n14 = n4 + (f5 >= 0.0f ? 1 : -1);
            int n15 = n14 > 0 ? (n14 < nArray[0] ? n14 : nArray[0] - 1) : 0;
            byte[] byArray = (byte[])this.b().get(n7);
            byte by2 = byArray[n13 + (n10 *= nArray[0])];
            byte by3 = byArray[n13 + (n2 *= nArray[0])];
            byte by4 = byArray[n15 + n10];
            byte by5 = byArray[n15 + n2];
            byArray = (byte[])this.b().get(n3);
            byte by6 = byArray[n13 + n10];
            byte by7 = byArray[n13 + n2];
            byte by8 = byArray[n15 + n10];
            byte by9 = byArray[n15 + n2];
            f5 = f5 >= 0.0f ? f5 : -f5;
            f6 = f6 >= 0.0f ? f6 : -f6;
            f7 = f7 >= 0.0f ? f7 : -f7;
            float f8 = (float)by2 + f5 * (float)(by4 - by2);
            float f9 = (float)by3 + f5 * (float)(by5 - by3);
            float f10 = f8 + f6 * (f9 - f8);
            float f11 = (float)by6 + f5 * (float)(by8 - by6);
            float f12 = (float)by7 + f5 * (float)(by9 - by7);
            float f13 = f11 + f6 * (f12 - f11);
            return f10 + f7 * (f13 - f10);
        }

        @Override
        public /* synthetic */ ImageSlice b(int n2, int n3) {
            return this.c(n2, n3);
        }

        @Override
        public /* synthetic */ ImageCube i() {
            return this.j();
        }
    }

    public static abstract class AbstractIntegralImageCube<T, IT extends ImageSlice.AbstractIntegralImageSlice<T>>
    extends ImageCube<T, IT> {
        private static final long serialVersionUID = 1L;

        public abstract int b(int var1, int var2, int var3);

        @Override
        public float a_(int n2, int n3, int n4) {
            return this.b(n2, n3, n4);
        }

        @Override
        public short c(int n2, int n3, int n4) {
            return (short)this.b(n2, n3, n4);
        }
    }
}

