/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.numerics.Interpolate;
import java.io.Serializable;

public abstract class ImageSlice<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int width;
    public int height;
    public T data;

    public abstract double a(int var1, int var2);

    public abstract double a(int var1);

    public void a(int n2, int n3, int n4, T t2, int n5) {
        System.arraycopy(this.data, n2 + n3 * this.width, t2, n5, n4);
    }

    public void b(int n2, int n3, int n4, T t2, int n5) {
        System.arraycopy(t2, n5, this.data, n2 + n3 * this.width, n4);
    }

    public abstract ImageSlice<T> a();

    public abstract ImageSlice<T> b();

    public static <X> ImageSlice<X> a(X x2, int n2, int n3) {
        if (x2 instanceof byte[]) {
            return new ImageSliceByte((byte[])x2, n2, n3);
        }
        if (x2 instanceof short[]) {
            return new ImageSliceShort((short[])x2, n2, n3);
        }
        if (x2 instanceof int[]) {
            return new ImageSliceInt((int[])x2, n2, n3);
        }
        if (x2 instanceof float[]) {
            return new ImageSliceFloat((float[])x2, n2, n3);
        }
        throw new IllegalArgumentException("Whatever type " + x2.getClass() + " is, we don't like it.");
    }

    public static <X> ImageSlice<X> a(Class<X> clazz, int n2, int n3) {
        if (clazz.equals(byte[].class)) {
            return new ImageSliceByte(n2, n3);
        }
        if (clazz.equals(short[].class)) {
            return new ImageSliceShort(n2, n3);
        }
        if (clazz.equals(int[].class)) {
            return new ImageSliceInt(n2, n3);
        }
        if (clazz.equals(float[].class)) {
            return new ImageSliceFloat(n2, n3);
        }
        throw new IllegalArgumentException("Whatever type " + clazz + " is, we don't like it.");
    }

    public static class ImageSliceByte
    extends AbstractIntegralImageSlice<byte[]> {
        private static final long serialVersionUID = 1L;

        public ImageSliceByte(byte[] byArray, int n2, int n3) {
            this.data = byArray;
            this.width = n2;
            this.height = n3;
        }

        public ImageSliceByte(int n2, int n3) {
            this.width = n2;
            this.height = n3;
            this.data = new byte[n2 * n3];
        }

        @Override
        public double a(int n2, int n3) {
            return ((byte[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public double a(int n2) {
            return ((byte[])this.data)[n2];
        }

        public float c(int n2, int n3) {
            return ((byte[])this.data)[n2 + n3 * this.width];
        }

        public float c(int n2) {
            return ((byte[])this.data)[n2];
        }

        @Override
        public int b(int n2, int n3) {
            return ((byte[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public int b(int n2) {
            return ((byte[])this.data)[n2];
        }

        public void a(int n2, int n3, byte by2) {
            ((byte[])this.data)[n2 + n3 * this.width] = by2;
        }

        public void a(int n2, byte by2) {
            ((byte[])this.data)[n2] = by2;
        }

        public byte d(int n2, int n3) {
            return ((byte[])this.data)[n2 + n3 * this.width];
        }

        public byte d(int n2) {
            return ((byte[])this.data)[n2];
        }

        public ImageSliceByte c() {
            ImageSliceByte imageSliceByte = new ImageSliceByte((byte[])((byte[])this.data).clone(), this.width, this.height);
            return imageSliceByte;
        }

        public ImageSliceByte d() {
            ImageSliceByte imageSliceByte = new ImageSliceByte(this.height, this.width);
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int i3 = 0; i3 < this.height; ++i3) {
                    ((byte[])imageSliceByte.data)[i3 + i2 * this.height] = ((byte[])this.data)[i2 + i3 * this.width];
                }
            }
            return imageSliceByte;
        }

        @Override
        public /* synthetic */ ImageSlice b() {
            return this.d();
        }

        @Override
        public /* synthetic */ ImageSlice a() {
            return this.c();
        }
    }

    public static class ImageSliceDouble
    extends AbstractFloatingPointImageSlice<double[]> {
        private static final long serialVersionUID = 1L;

        public ImageSliceDouble(double[] dArray, int n2, int n3) {
            this.data = dArray;
            this.width = n2;
            this.height = n3;
        }

        public ImageSliceDouble(int n2, int n3) {
            this.width = n2;
            this.height = n3;
            this.data = new double[n2 * n3];
        }

        public float a(float f2, float f3) {
            int n2 = (int)f2;
            int n3 = n2 + 1;
            int n4 = (int)f3;
            int n5 = n4 + 1;
            if (n2 >= 0 && n2 < this.width - 2 && n4 >= 0 && n4 < this.height - 2) {
                int n6 = n2 + n4 * this.width;
                return Interpolate.a(f2, f3, n2, n3, n4, n5, (float)((double[])this.data)[n6], (float)((double[])this.data)[n6 + 1], (float)((double[])this.data)[n6 + this.width], (float)((double[])this.data)[n6 + this.width + 1]);
            }
            if (n2 < 0) {
                n3 = 0;
                n2 = 0;
            } else if (n2 >= this.width - 1) {
                n2 = n3 = this.width - 1;
            }
            if (n4 < 0) {
                n5 = 0;
                n4 = 0;
            } else if (n4 >= this.height - 1) {
                n4 = n5 = this.height - 1;
            }
            return Interpolate.a(f2, f3, n2, n3, n4, n5, this.b(n2, n4), this.b(n3, n4), this.b(n2, n5), this.b(n3, n5));
        }

        @Override
        public void a(int n2, int n3, int n4, float[] fArray, int n5) {
            System.arraycopy(this.data, n2 + n3 * this.width, fArray, n5, n4);
        }

        public void a(int n2, int n3, float f2) {
            ((double[])this.data)[n2 + n3 * this.width] = f2;
        }

        public void a(int n2, float f2) {
            ((double[])this.data)[n2] = f2;
        }

        @Override
        public float b(int n2, int n3) {
            return (float)((double[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public float b(int n2) {
            return (float)((double[])this.data)[n2];
        }

        @Override
        public double a(int n2, int n3) {
            return ((double[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public double a(int n2) {
            return ((double[])this.data)[n2];
        }

        @Override
        public void b(int n2, int n3, int n4, float[] fArray, int n5) {
            System.arraycopy(fArray, n5, this.data, n2 + n3 * this.width, n4);
        }

        public ImageSliceDouble c() {
            ImageSliceDouble imageSliceDouble = new ImageSliceDouble((double[])((double[])this.data).clone(), this.width, this.height);
            return imageSliceDouble;
        }

        public static ImageSliceFloat a(ImageSliceShort imageSliceShort) {
            float[] fArray = new float[((short[])imageSliceShort.data).length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray[i2] = ((short[])imageSliceShort.data)[i2];
            }
            return (ImageSliceFloat)ImageSliceFloat.a(fArray, imageSliceShort.width, imageSliceShort.height);
        }

        public ImageSliceDouble d() {
            ImageSliceDouble imageSliceDouble = new ImageSliceDouble(this.height, this.width);
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int i3 = 0; i3 < this.height; ++i3) {
                    ((double[])imageSliceDouble.data)[i3 + i2 * this.height] = ((double[])this.data)[i2 + i3 * this.width];
                }
            }
            return imageSliceDouble;
        }

        @Override
        public /* synthetic */ ImageSlice b() {
            return this.d();
        }

        @Override
        public /* synthetic */ ImageSlice a() {
            return this.c();
        }
    }

    public static class ImageSliceFloat
    extends AbstractFloatingPointImageSlice<float[]> {
        private static final long serialVersionUID = 1L;

        public ImageSliceFloat(float[] fArray, int n2, int n3) {
            this.data = fArray;
            this.width = n2;
            this.height = n3;
        }

        public ImageSliceFloat(int n2, int n3) {
            this.width = n2;
            this.height = n3;
            this.data = new float[n2 * n3];
        }

        public float a(float f2, float f3) {
            int n2 = (int)f2;
            int n3 = n2 + 1;
            int n4 = (int)f3;
            int n5 = n4 + 1;
            if (n2 >= 0 && n2 < this.width - 2 && n4 >= 0 && n4 < this.height - 2) {
                int n6 = n2 + n4 * this.width;
                return Interpolate.a(f2, f3, n2, n3, n4, n5, ((float[])this.data)[n6], ((float[])this.data)[n6 + 1], ((float[])this.data)[n6 + this.width], ((float[])this.data)[n6 + this.width + 1]);
            }
            if (n2 < 0) {
                n3 = 0;
                n2 = 0;
            } else if (n2 >= this.width - 1) {
                n2 = n3 = this.width - 1;
            }
            if (n4 < 0) {
                n5 = 0;
                n4 = 0;
            } else if (n4 >= this.height - 1) {
                n4 = n5 = this.height - 1;
            }
            return Interpolate.a(f2, f3, n2, n3, n4, n5, this.b(n2, n4), this.b(n3, n4), this.b(n2, n5), this.b(n3, n5));
        }

        @Override
        public void a(int n2, int n3, int n4, float[] fArray, int n5) {
            System.arraycopy(this.data, n2 + n3 * this.width, fArray, n5, n4);
        }

        public void a(int n2, int n3, float f2) {
            ((float[])this.data)[n2 + n3 * this.width] = f2;
        }

        public void a(int n2, float f2) {
            ((float[])this.data)[n2] = f2;
        }

        @Override
        public float b(int n2, int n3) {
            return ((float[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public float b(int n2) {
            return ((float[])this.data)[n2];
        }

        @Override
        public double a(int n2, int n3) {
            return ((float[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public double a(int n2) {
            return ((float[])this.data)[n2];
        }

        @Override
        public void b(int n2, int n3, int n4, float[] fArray, int n5) {
            System.arraycopy(fArray, n5, this.data, n2 + n3 * this.width, n4);
        }

        public ImageSliceFloat c() {
            ImageSliceFloat imageSliceFloat = new ImageSliceFloat((float[])((float[])this.data).clone(), this.width, this.height);
            return imageSliceFloat;
        }

        public static ImageSliceFloat a(ImageSliceShort imageSliceShort) {
            float[] fArray = new float[((short[])imageSliceShort.data).length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray[i2] = ((short[])imageSliceShort.data)[i2];
            }
            return (ImageSliceFloat)ImageSliceFloat.a(fArray, imageSliceShort.width, imageSliceShort.height);
        }

        public ImageSliceFloat d() {
            ImageSliceFloat imageSliceFloat = new ImageSliceFloat(this.height, this.width);
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int i3 = 0; i3 < this.height; ++i3) {
                    ((float[])imageSliceFloat.data)[i3 + i2 * this.height] = ((float[])this.data)[i2 + i3 * this.width];
                }
            }
            return imageSliceFloat;
        }

        @Override
        public /* synthetic */ ImageSlice b() {
            return this.d();
        }

        @Override
        public /* synthetic */ ImageSlice a() {
            return this.c();
        }
    }

    public static class ImageSliceInt
    extends AbstractIntegralImageSlice<int[]> {
        private static final long serialVersionUID = 1L;

        public ImageSliceInt(int[] nArray, int n2, int n3) {
            this.data = nArray;
            this.width = n2;
            this.height = n3;
        }

        public ImageSliceInt(int n2, int n3) {
            this.width = n2;
            this.height = n3;
            this.data = new int[n2 * n3];
        }

        @Override
        public double a(int n2, int n3) {
            return ((int[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public double a(int n2) {
            return ((int[])this.data)[n2];
        }

        public void a(int n2, int n3, int n4) {
            ((int[])this.data)[n2 + n3 * this.width] = n4;
        }

        public void c(int n2, int n3) {
            ((int[])this.data)[n2] = n3;
        }

        @Override
        public int b(int n2, int n3) {
            return ((int[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public int b(int n2) {
            return ((int[])this.data)[n2];
        }

        public ImageSliceInt c() {
            ImageSliceInt imageSliceInt = new ImageSliceInt((int[])((int[])this.data).clone(), this.width, this.height);
            return imageSliceInt;
        }

        public ImageSliceInt d() {
            ImageSliceInt imageSliceInt = new ImageSliceInt(this.height, this.width);
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int i3 = 0; i3 < this.height; ++i3) {
                    ((int[])imageSliceInt.data)[i3 + i2 * this.height] = ((int[])this.data)[i2 + i3 * this.width];
                }
            }
            return imageSliceInt;
        }

        @Override
        public /* synthetic */ ImageSlice b() {
            return this.d();
        }

        @Override
        public /* synthetic */ ImageSlice a() {
            return this.c();
        }
    }

    public static class ImageSliceShort
    extends AbstractIntegralImageSlice<short[]> {
        private static final long serialVersionUID = 1L;

        public ImageSliceShort(short[] sArray, int n2, int n3) {
            this.data = sArray;
            this.width = n2;
            this.height = n3;
        }

        public ImageSliceShort(int n2, int n3) {
            this.width = n2;
            this.height = n3;
            this.data = new short[n2 * n3];
        }

        public ImageSliceShort(int n2, int n3, short s2) {
            this(n2, n3);
            for (int i2 = 0; i2 < ((short[])this.data).length; ++i2) {
                ((short[])this.data)[i2] = s2;
            }
        }

        @Override
        public double a(int n2, int n3) {
            return ((short[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public double a(int n2) {
            return ((short[])this.data)[n2];
        }

        public float c(int n2, int n3) {
            return ((short[])this.data)[n2 + n3 * this.width];
        }

        public float c(int n2) {
            return ((short[])this.data)[n2];
        }

        @Override
        public int b(int n2, int n3) {
            return ((short[])this.data)[n2 + n3 * this.width];
        }

        @Override
        public int b(int n2) {
            return ((short[])this.data)[n2];
        }

        public void a(int n2, int n3, short s2) {
            ((short[])this.data)[n2 + n3 * this.width] = s2;
        }

        public void a(int n2, short s2) {
            ((short[])this.data)[n2] = s2;
        }

        public short d(int n2, int n3) {
            return ((short[])this.data)[n2 + n3 * this.width];
        }

        public short d(int n2) {
            return ((short[])this.data)[n2];
        }

        public ImageSliceShort c() {
            ImageSliceShort imageSliceShort = new ImageSliceShort((short[])((short[])this.data).clone(), this.width, this.height);
            return imageSliceShort;
        }

        public ImageSliceShort d() {
            ImageSliceShort imageSliceShort = new ImageSliceShort(this.height, this.width);
            for (int i2 = 0; i2 < this.width; ++i2) {
                for (int i3 = 0; i3 < this.height; ++i3) {
                    ((short[])imageSliceShort.data)[i3 + i2 * this.height] = ((short[])this.data)[i2 + i3 * this.width];
                }
            }
            return imageSliceShort;
        }

        public float a(float f2, float f3, float f4) {
            float f5;
            float f6;
            float f7;
            float f8;
            int n2 = f2 < 0.0f ? (int)StrictMath.floor(f2) : (int)f2;
            int n3 = f3 < 0.0f ? (int)StrictMath.floor(f3) : (int)f3;
            float f9 = f2 - (float)n2 - 0.5f;
            float f10 = f3 - (float)n3 - 0.5f;
            int n4 = n3 + (f10 >= 0.0f ? 1 : -1);
            int n5 = n2 + (f9 >= 0.0f ? 1 : -1);
            boolean bl2 = n2 > -1 && n2 < this.width;
            boolean bl3 = n5 > -1 && n5 < this.width;
            boolean bl4 = n3 > -1 && n3 < this.height;
            boolean bl5 = n4 > -1 && n4 < this.height;
            n3 *= this.width;
            n4 *= this.width;
            if (bl2) {
                f8 = bl4 ? (float)((short[])this.data)[n2 + n3] : f4;
                f7 = bl5 ? (float)((short[])this.data)[n2 + n4] : f4;
            } else {
                f8 = f4;
                f7 = f4;
            }
            if (bl3) {
                f6 = bl4 ? (float)((short[])this.data)[n5 + n3] : f4;
                f5 = bl5 ? (float)((short[])this.data)[n5 + n4] : f4;
            } else {
                f6 = f4;
                f5 = f4;
            }
            f9 = f9 >= 0.0f ? f9 : -f9;
            f10 = f10 >= 0.0f ? f10 : -f10;
            float f11 = f8 + f9 * (f6 - f8);
            float f12 = f7 + f9 * (f5 - f7);
            return f11 + f10 * (f12 - f11);
        }

        @Override
        public /* synthetic */ ImageSlice b() {
            return this.d();
        }

        @Override
        public /* synthetic */ ImageSlice a() {
            return this.c();
        }
    }

    public static abstract class AbstractFloatingPointImageSlice<T>
    extends ImageSlice<T> {
        private static final long serialVersionUID = 1L;

        public abstract float b(int var1, int var2);

        public abstract float b(int var1);
    }

    public static abstract class AbstractIntegralImageSlice<T>
    extends ImageSlice<T> {
        private static final long serialVersionUID = 1L;

        public abstract int b(int var1, int var2);

        public abstract int b(int var1);
    }
}

