/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.Point3d;
import com.mimvista.numerics.Point3f;
import com.mimvista.util.ay;
import java.awt.image.DataBuffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public final class MathUtils {
    public static final byte[] a = new byte[]{0, 127, 0, 127, 127, 127, 0, 127, 0};
    public static final byte[] b = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127};
    public static final byte[] c = new byte[27];
    public static final byte[] d = new byte[27];

    private MathUtils() {
    }

    public static float[] a(Float[] floatArray) {
        float[] fArray = new float[floatArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = floatArray[i2] == null ? Float.NaN : floatArray[i2].floatValue();
        }
        return fArray;
    }

    public static double[] a(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = doubleArray[i2] == null ? Double.NaN : doubleArray[i2];
        }
        return dArray;
    }

    public static Double[] a(double[] dArray) {
        Double[] doubleArray = new Double[dArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            doubleArray[i2] = dArray[i2];
        }
        return doubleArray;
    }

    public static float[] a(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        float[] fArray3 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = Math.max(fArray[i2], fArray2[i2]);
        }
        return fArray3;
    }

    public static int[] a(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = Math.max(nArray[i2], nArray2[i2]);
        }
        return nArray3;
    }

    public static int[] b(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = Math.min(nArray[i2], nArray2[i2]);
        }
        return nArray3;
    }

    public static float[] b(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        float[] fArray3 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = Math.min(fArray[i2], fArray2[i2]);
        }
        return fArray3;
    }

    public static void a(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(byArray[i2] ^ byArray2[i2 % byArray2.length]);
        }
    }

    public static boolean a(double d2, double d3, double d4) {
        return Math.abs(d2 - d3) / Math.max(Math.abs(d2), Math.abs(d3)) <= d4;
    }

    public static boolean a(Float f2, Float f3, float f4) {
        if (f2 == null && f3 == null) {
            return true;
        }
        if (f2 == null && f3 != null) {
            return false;
        }
        if (f2 != null && f3 == null) {
            return false;
        }
        return MathUtils.a(f2.floatValue(), f3.floatValue(), f4);
    }

    public static boolean a(float f2, float f3, float f4) {
        return Math.abs(f2 - f3) <= f4;
    }

    public static boolean b(double d2, double d3, double d4) {
        return Math.abs(d2 - d3) <= d4;
    }

    public static boolean a(float[] fArray, float[] fArray2, float f2) {
        if (fArray == null || fArray2 == null) {
            return false;
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (MathUtils.a(fArray[i2], fArray2[i2], f2)) continue;
            return false;
        }
        return true;
    }

    public static boolean a(double[] dArray, double[] dArray2, double d2) {
        if (dArray == null || dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (MathUtils.b(dArray[i2], dArray2[i2], d2)) continue;
            return false;
        }
        return true;
    }

    public static float[] c(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        float[] fArray3 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = fArray[i2] * fArray2[i2];
        }
        return fArray3;
    }

    public static float[] a(float[] fArray, int[] nArray) {
        if (fArray.length != nArray.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = fArray[i2] * (float)nArray[i2];
        }
        return fArray2;
    }

    public static int[] c(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = nArray[i2] * nArray2[i2];
        }
        return nArray3;
    }

    public static void a(int[] nArray, int[] nArray2, float[] fArray) {
        if (nArray.length != nArray2.length || nArray.length != fArray.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2] * nArray2[i2];
        }
    }

    public static float[] d(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        float[] fArray3 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = fArray[i2] / fArray2[i2];
        }
        return fArray3;
    }

    public static float[] b(float[] fArray, int[] nArray) {
        if (fArray.length != nArray.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = fArray[i2] / (float)nArray[i2];
        }
        return fArray2;
    }

    public static float[] a(int[] nArray, float[] fArray) {
        if (nArray.length != fArray.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        float[] fArray2 = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray2[i2] = (float)nArray[i2] / fArray[i2];
        }
        return fArray2;
    }

    public static int[] d(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("array1 and array2 must have the same dimensions!");
        }
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = nArray[i2] / nArray2[i2];
        }
        return nArray3;
    }

    public static float[] a(int[] nArray) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = nArray[i2];
        }
        return fArray;
    }

    public static int[] a(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            nArray[i2] = (int)fArray[i2];
        }
        return nArray;
    }

    public static float[] b(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            fArray[i2] = (float)dArray[i2];
        }
        return fArray;
    }

    public static double[] b(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    public static float[] a(float f2) {
        return new float[]{f2, f2, f2};
    }

    public static int[] a(int n2) {
        return new int[]{n2, n2, n2};
    }

    public static float[] a(float f2, int n2) {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = f2;
        }
        return fArray;
    }

    public static double[] a(double d2, int n2) {
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = d2;
        }
        return dArray;
    }

    public static float[] c(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = -fArray[i2];
        }
        return fArray2;
    }

    public static int[] b(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = -nArray[i2];
        }
        return nArray2;
    }

    public static float[] d(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = Math.abs(fArray[i2]);
        }
        return fArray2;
    }

    public static double[] c(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            dArray2[i2] = Math.abs(dArray[i2]);
        }
        return dArray2;
    }

    public static int[] c(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = Math.abs(nArray[i2]);
        }
        return nArray2;
    }

    public static boolean a(float[] fArray, float f2) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            bl2 &= fArray[i2] <= f2;
        }
        return bl2;
    }

    public static float[] a(int[] nArray, float f2) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = (float)nArray[i2] / f2;
        }
        return fArray;
    }

    public static float[] b(float[] fArray, float f2) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = fArray[i2] / f2;
        }
        return fArray2;
    }

    public static float[] e(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[MathUtils.l(fArray.length, fArray2.length)];
        for (int i2 = 0; i2 < fArray3.length; ++i2) {
            fArray3[i2] = fArray[i2] / fArray2[i2];
        }
        return fArray3;
    }

    public static int[] e(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[MathUtils.l(nArray.length, nArray2.length)];
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            nArray3[i2] = nArray[i2] / nArray2[i2];
        }
        return nArray3;
    }

    public static float[] c(float[] fArray, int[] nArray) {
        float[] fArray2 = new float[MathUtils.l(fArray.length, nArray.length)];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = fArray[i2] / (float)nArray[i2];
        }
        return fArray2;
    }

    public static float[] f(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[MathUtils.l(fArray.length, fArray2.length)];
        for (int i2 = 0; i2 < fArray3.length; ++i2) {
            fArray3[i2] = fArray[i2] * fArray2[i2];
        }
        return fArray3;
    }

    public static float[] b(int[] nArray, float[] fArray) {
        float[] fArray2 = new float[MathUtils.l(nArray.length, fArray.length)];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = (float)nArray[i2] * fArray[i2];
        }
        return fArray2;
    }

    public static int[] f(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[MathUtils.l(nArray.length, nArray2.length)];
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            nArray3[i2] = nArray[i2] * nArray2[i2];
        }
        return nArray3;
    }

    public static float[] g(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[MathUtils.l(fArray.length, fArray2.length)];
        for (int i2 = 0; i2 < fArray3.length; ++i2) {
            fArray3[i2] = fArray[i2] + fArray2[i2];
        }
        return fArray3;
    }

    public static int[] g(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[MathUtils.l(nArray.length, nArray2.length)];
        for (int i2 = 0; i2 < nArray3.length; ++i2) {
            nArray3[i2] = nArray[i2] + nArray2[i2];
        }
        return nArray3;
    }

    public static float[] e(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = (float)Math.ceil(fArray[i2]);
        }
        return fArray2;
    }

    public static float[] f(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = (float)Math.floor(fArray[i2]);
        }
        return fArray2;
    }

    public static float[] a(float[] fArray, int n2) {
        float f2 = (float)Math.pow(10.0, n2);
        double d2 = Math.pow(10.0, n2 - 1);
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            int n3 = Math.round(f2 * fArray[i2]);
            fArray2[i2] = (float)((double)n3 / d2 / 10.0);
        }
        return fArray2;
    }

    public static float b(float f2, int n2) {
        if (Float.isNaN(f2) || n2 < 1) {
            return f2;
        }
        float f3 = (float)Math.pow(10.0, n2);
        double d2 = Math.pow(10.0, n2 - 1);
        int n3 = Math.round(f3 * f2);
        return (float)((double)n3 / d2 / 10.0);
    }

    public static double b(double d2, int n2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2) || n2 < 1) {
            return d2;
        }
        double d3 = Math.pow(10.0, n2);
        double d4 = Math.pow(10.0, n2 - 1);
        long l2 = Math.round(d3 * d2);
        return (double)l2 / d4 / 10.0;
    }

    public static float[] g(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = Math.round(fArray[i2]);
        }
        return fArray2;
    }

    public static float[][] a(float[][] fArray) {
        float[][] fArrayArray = new float[fArray.length][];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArrayArray[i2] = MathUtils.g(fArray[i2]);
        }
        return fArrayArray;
    }

    public static float[] c(float[] fArray, float f2) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = fArray[i2] < f2 ? f2 : fArray[i2];
        }
        return fArray2;
    }

    public static double c(double d2, double d3, double d4) {
        if (d2 < d3) {
            d2 = d3;
        } else if (d2 > d4) {
            d2 = d4;
        }
        return d2;
    }

    public static float b(float f2, float f3, float f4) {
        if (f2 < f3) {
            f2 = f3;
        } else if (f2 > f4) {
            f2 = f4;
        }
        return f2;
    }

    public static int a(int n2, int n3, int n4) {
        if (n2 < n3) {
            n2 = n3;
        } else if (n2 > n4) {
            n2 = n4;
        }
        return n2;
    }

    public static byte a(byte by2, byte by3, byte by4) {
        if (by2 < by3) {
            by2 = by3;
        }
        if (by2 > by4) {
            by2 = by4;
        }
        return by2;
    }

    public static float[] h(float[] fArray, float[] fArray2) {
        int n2 = fArray.length > fArray2.length ? fArray2.length : fArray.length;
        float[] fArray3 = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray3[i2] = fArray[i2] - fArray2[i2];
        }
        return fArray3;
    }

    public static double[] a(double[] dArray, double[] dArray2) {
        int n2 = dArray.length > dArray2.length ? dArray2.length : dArray.length;
        double[] dArray3 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray3[i2] = dArray[i2] - dArray2[i2];
        }
        return dArray3;
    }

    public static int[] h(int[] nArray, int[] nArray2) {
        int n2 = nArray.length > nArray2.length ? nArray2.length : nArray.length;
        int[] nArray3 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray3[i2] = nArray[i2] - nArray2[i2];
        }
        return nArray3;
    }

    public static ByteBuffer a(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.capacity() != byteBuffer2.capacity()) {
            throw new IllegalArgumentException("bb1 and bb2 must have the same capacity!");
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(byteBuffer.capacity());
        for (int i2 = 0; i2 < byteBuffer.capacity(); ++i2) {
            byteBuffer3.put(i2, (byte)(byteBuffer.get(i2) + byteBuffer2.get(i2)));
        }
        return byteBuffer3;
    }

    public static ByteBuffer b(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer.capacity() != byteBuffer2.capacity()) {
            throw new IllegalArgumentException("bb1 and bb2 must have the same capacity!");
        }
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(byteBuffer.capacity());
        for (int i2 = 0; i2 < byteBuffer.capacity(); ++i2) {
            byteBuffer3.put(i2, (byte)(byteBuffer.get(i2) - byteBuffer2.get(i2)));
        }
        return byteBuffer3;
    }

    public static int[] a(ByteBuffer byteBuffer, byte by2, Relationship relationship) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        switch (relationship) {
            case a: {
                for (int i2 = 0; i2 < byteBuffer.capacity(); ++i2) {
                    if (byteBuffer.get(i2) >= by2) continue;
                    arrayList.add(i2);
                }
                break;
            }
            case b: {
                for (int i3 = 0; i3 < byteBuffer.capacity(); ++i3) {
                    if (byteBuffer.get(i3) > by2) continue;
                    arrayList.add(i3);
                }
                break;
            }
            case c: {
                for (int i4 = 0; i4 < byteBuffer.capacity(); ++i4) {
                    if (byteBuffer.get(i4) != by2) continue;
                    arrayList.add(i4);
                }
                break;
            }
            case d: {
                for (int i5 = 0; i5 < byteBuffer.capacity(); ++i5) {
                    if (byteBuffer.get(i5) < by2) continue;
                    arrayList.add(i5);
                }
                break;
            }
            case e: {
                for (int i6 = 0; i6 < byteBuffer.capacity(); ++i6) {
                    if (byteBuffer.get(i6) <= by2) continue;
                    arrayList.add(i6);
                }
                break;
            }
        }
        return MathUtils.b(arrayList.toArray());
    }

    private static int[] b(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            nArray[i2] = (Integer)objectArray[i2];
        }
        return nArray;
    }

    public static int[] a(float[] fArray, float f2, Relationship relationship) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        switch (relationship) {
            case a: {
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    if (!(fArray[i2] < f2)) continue;
                    arrayList.add(i2);
                }
                break;
            }
            case b: {
                for (int i3 = 0; i3 < fArray.length; ++i3) {
                    if (!(fArray[i3] <= f2)) continue;
                    arrayList.add(i3);
                }
                break;
            }
            case c: {
                for (int i4 = 0; i4 < fArray.length; ++i4) {
                    if (fArray[i4] != f2) continue;
                    arrayList.add(i4);
                }
                break;
            }
            case d: {
                for (int i5 = 0; i5 < fArray.length; ++i5) {
                    if (!(fArray[i5] >= f2)) continue;
                    arrayList.add(i5);
                }
                break;
            }
            case e: {
                for (int i6 = 0; i6 < fArray.length; ++i6) {
                    if (!(fArray[i6] > f2)) continue;
                    arrayList.add(i6);
                }
                break;
            }
        }
        return MathUtils.b(arrayList.toArray());
    }

    public static int[] a(short[] sArray, int n2, Relationship relationship) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        switch (relationship) {
            case a: {
                for (int i2 = 0; i2 < sArray.length; ++i2) {
                    if (sArray[i2] >= n2) continue;
                    arrayList.add(i2);
                }
                break;
            }
            case b: {
                for (int i3 = 0; i3 < sArray.length; ++i3) {
                    if (sArray[i3] > n2) continue;
                    arrayList.add(i3);
                }
                break;
            }
            case c: {
                for (int i4 = 0; i4 < sArray.length; ++i4) {
                    if (sArray[i4] != n2) continue;
                    arrayList.add(i4);
                }
                break;
            }
            case d: {
                for (int i5 = 0; i5 < sArray.length; ++i5) {
                    if (sArray[i5] < n2) continue;
                    arrayList.add(i5);
                }
                break;
            }
            case e: {
                for (int i6 = 0; i6 < sArray.length; ++i6) {
                    if (sArray[i6] <= n2) continue;
                    arrayList.add(i6);
                }
                break;
            }
        }
        return MathUtils.b(arrayList.toArray());
    }

    public static int[][] a(float[][] fArray, float f2, Relationship relationship) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        switch (relationship) {
            case a: {
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    for (int i3 = 0; i3 < fArray[0].length; ++i3) {
                        if (!(fArray[i2][i3] < f2)) continue;
                        arrayList.add(new int[]{i2, i3});
                    }
                }
                break;
            }
            case b: {
                for (int i4 = 0; i4 < fArray.length; ++i4) {
                    for (int i5 = 0; i5 < fArray[0].length; ++i5) {
                        if (!(fArray[i4][i5] <= f2)) continue;
                        arrayList.add(new int[]{i4, i5});
                    }
                }
                break;
            }
            case c: {
                for (int i6 = 0; i6 < fArray.length; ++i6) {
                    for (int i7 = 0; i7 < fArray[0].length; ++i7) {
                        if (fArray[i6][i7] != f2) continue;
                        arrayList.add(new int[]{i6, i7});
                    }
                }
                break;
            }
            case d: {
                for (int i8 = 0; i8 < fArray.length; ++i8) {
                    for (int i9 = 0; i9 < fArray[0].length; ++i9) {
                        if (!(fArray[i8][i9] >= f2)) continue;
                        arrayList.add(new int[]{i8, i9});
                    }
                }
                break;
            }
            case e: {
                for (int i10 = 0; i10 < fArray.length; ++i10) {
                    for (int i11 = 0; i11 < fArray[0].length; ++i11) {
                        if (!(fArray[i10][i11] > f2)) continue;
                        arrayList.add(new int[]{i10, i11});
                    }
                }
                break;
            }
        }
        return MathUtils.c(arrayList.toArray());
    }

    public static int[] a(float[][] fArray, int n2, float f2, float f3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(MathUtils.m(10, fArray.length / 10));
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2][n2] >= f2) || !(fArray[i2][n2] < f3)) continue;
            arrayList.add(i2);
        }
        return MathUtils.b(arrayList.toArray());
    }

    public static int[] a(int[][] nArray, int n2, int n3, int n4) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(MathUtils.m(10, nArray.length / 10));
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2][n2] < n3 || nArray[i2][n2] >= n4) continue;
            arrayList.add(i2);
        }
        return MathUtils.b(arrayList.toArray());
    }

    public static int[][] a(int[][][] nArray, int n2, Relationship relationship) {
        int n3;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(MathUtils.m(10, nArray.length * nArray[0].length * nArray[0][0].length));
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (n3 = 0; n3 < nArray[i2].length; ++n3) {
                block9: for (int i3 = 0; i3 < nArray[i2][n3].length; ++i3) {
                    switch (relationship) {
                        case a: {
                            if (nArray[i2][n3][i3] >= n2) continue block9;
                            arrayList.add(new int[]{i2, n3, i3});
                            continue block9;
                        }
                        case b: {
                            if (nArray[i2][n3][i3] > n2) continue block9;
                            arrayList.add(new int[]{i2, n3, i3});
                            continue block9;
                        }
                        case c: {
                            if (nArray[i2][n3][i3] != n2) continue block9;
                            arrayList.add(new int[]{i2, n3, i3});
                            continue block9;
                        }
                        case d: {
                            if (nArray[i2][n3][i3] < n2) continue block9;
                            arrayList.add(new int[]{i2, n3, i3});
                            continue block9;
                        }
                        case e: {
                            if (nArray[i2][n3][i3] <= n2) continue block9;
                            arrayList.add(new int[]{i2, n3, i3});
                        }
                    }
                }
            }
        }
        int[][] nArrayArray = new int[arrayList.size()][];
        for (n3 = 0; n3 < nArrayArray.length; ++n3) {
            nArrayArray[n3] = (int[])arrayList.get(n3);
        }
        return nArrayArray;
    }

    public static int[][] a(ImageCube.AbstractIntegralImageCube abstractIntegralImageCube, int n2, Relationship relationship) {
        int n3;
        int[] nArray = abstractIntegralImageCube.d();
        ArrayList<int[]> arrayList = new ArrayList<int[]>(MathUtils.m(10, (int)MathUtils.d(nArray)));
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            for (n3 = 0; n3 < nArray[1]; ++n3) {
                block9: for (int i3 = 0; i3 < nArray[0]; ++i3) {
                    switch (relationship) {
                        case a: {
                            if (abstractIntegralImageCube.b(i3, n3, i2) >= n2) continue block9;
                            arrayList.add(new int[]{i3, n3, i2});
                            continue block9;
                        }
                        case b: {
                            if (abstractIntegralImageCube.b(i3, n3, i2) > n2) continue block9;
                            arrayList.add(new int[]{i3, n3, i2});
                            continue block9;
                        }
                        case c: {
                            if (abstractIntegralImageCube.b(i3, n3, i2) != n2) continue block9;
                            arrayList.add(new int[]{i3, n3, i2});
                            continue block9;
                        }
                        case d: {
                            if (abstractIntegralImageCube.b(i3, n3, i2) < n2) continue block9;
                            arrayList.add(new int[]{i3, n3, i2});
                            continue block9;
                        }
                        case e: {
                            if (abstractIntegralImageCube.b(i3, n3, i2) <= n2) continue block9;
                            arrayList.add(new int[]{i3, n3, i2});
                        }
                    }
                }
            }
        }
        int[][] nArrayArray = new int[arrayList.size()][];
        for (n3 = 0; n3 < nArrayArray.length; ++n3) {
            nArrayArray[n3] = (int[])arrayList.get(n3);
        }
        return nArrayArray;
    }

    private static int[][] c(Object[] objectArray) {
        int[][] nArrayArray = new int[objectArray.length][];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            nArrayArray[i2] = (int[])objectArray[i2];
        }
        return nArrayArray;
    }

    public static long[] h(float[] fArray) {
        long[] lArray = new long[fArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = (long)fArray[i2];
        }
        return lArray;
    }

    public static double[] i(float[] fArray) {
        double[] dArray = new double[fArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    public static Float a(Double d2) {
        return d2 == null ? null : Float.valueOf(d2.floatValue());
    }

    public static Double[] b(Float[] floatArray) {
        Double[] doubleArray = new Double[floatArray.length];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            doubleArray[i2] = floatArray[i2] == null ? null : Double.valueOf(floatArray[i2].doubleValue());
        }
        return doubleArray;
    }

    public static int[] j(float[] fArray) {
        int[] nArray = new int[fArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = (int)fArray[i2];
        }
        return nArray;
    }

    public static float i(float[] fArray, float[] fArray2) {
        float f2 = 0.0f;
        int n2 = fArray.length > fArray2.length ? fArray2.length : fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f3 = fArray[i2] - fArray2[i2];
            f2 += f3 * f3;
        }
        return (float)Math.sqrt(f2);
    }

    public static float i(int[] nArray, int[] nArray2) {
        float f2 = 0.0f;
        int n2 = nArray.length > nArray2.length ? nArray2.length : nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2] - nArray2[i2];
            f2 += (float)(n3 * n3);
        }
        return (float)Math.sqrt(f2);
    }

    public static boolean j(float[] fArray, float[] fArray2) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (fArray[i2] == fArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean b(float[] fArray, float[] fArray2, float f2) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(Math.abs(fArray[i2] - fArray2[i2]) > f2)) continue;
            return false;
        }
        return true;
    }

    public static float k(float[] fArray) {
        float f2 = 1.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 *= fArray[i2];
        }
        return f2;
    }

    public static double d(double[] dArray) {
        double d2 = 1.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 *= dArray[i2];
        }
        return d2;
    }

    public static long d(int[] nArray) {
        long l2 = 1L;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            l2 *= (long)nArray[i2];
        }
        return l2;
    }

    public static long a(int[] nArray, int n2, int n3) {
        long l2 = 1L;
        for (int i2 = n2; i2 < n3; ++i2) {
            l2 *= (long)nArray[i2];
        }
        return l2;
    }

    public static int a(short[] sArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] < 0) continue;
            ++n2;
        }
        return n2;
    }

    public static int l(float[] fArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] >= 0.0f)) continue;
            ++n2;
        }
        return n2;
    }

    public static int m(float[] fArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] > 0.0f)) continue;
            ++n2;
        }
        return n2;
    }

    public static int e(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += nArray[i2];
        }
        return n2;
    }

    public static double e(double[] dArray) {
        double d2 = 0.0;
        for (double d3 : dArray) {
            d2 += d3;
        }
        return d2;
    }

    public static float n(float[] fArray) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2];
        }
        return f2;
    }

    public static int a(int[][][] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                for (int i4 = 0; i4 < nArray[i2][i3].length; ++i4) {
                    n2 += nArray[i2][i3][i4];
                }
            }
        }
        return n2;
    }

    public static int a(ImageCube.AbstractIntegralImageCube abstractIntegralImageCube) {
        int n2 = 0;
        int[] nArray = abstractIntegralImageCube.d();
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                    n2 += abstractIntegralImageCube.b(i4, i3, i2);
                }
            }
        }
        return n2;
    }

    public static float c(float f2, float f3, float f4) {
        return f2 > f4 ? f4 : (f2 < f3 ? f3 : f2);
    }

    public static double d(double d2, double d3, double d4) {
        return d2 > d4 ? d4 : (d2 < d3 ? d3 : d2);
    }

    public static int b(int n2, int n3, int n4) {
        return n2 > n4 ? n4 : (n2 < n3 ? n3 : n2);
    }

    public static float o(float[] fArray) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2] * fArray[i2];
        }
        return (float)Math.sqrt(f2);
    }

    public static float[] p(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        float f2 = MathUtils.o(fArray);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = fArray[i2] / f2;
        }
        return fArray2;
    }

    public static float[] b(int n2) {
        if (n2 == 2) {
            return new float[]{1.0f, 0.0f, 0.0f, 0.0f};
        }
        if (n2 == 1) {
            return new float[]{0.0f, 1.0f, 0.0f, 0.0f};
        }
        if (n2 == 0) {
            return new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        }
        throw new IllegalArgumentException("Axis must be 0,1,2 you gave: " + n2);
    }

    public static float[] q(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = fArray[fArray.length - i2 - 1];
        }
        return fArray2;
    }

    public static void r(float[] fArray) {
        for (int i2 = 0; i2 < fArray.length / 2; ++i2) {
            int n2 = fArray.length - i2 - 1;
            float f2 = fArray[i2];
            fArray[i2] = fArray[n2];
            fArray[n2] = f2;
        }
    }

    public static void a(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length / 2; ++i2) {
            int n2 = objectArray.length - i2 - 1;
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n2];
            objectArray[n2] = object;
        }
    }

    public static float[] a(float[] fArray, float[] ... fArray2) {
        int n2 = fArray.length;
        for (float[] fArray3 : fArray2) {
            n2 += fArray3.length;
        }
        float[] fArray4 = new float[n2];
        System.arraycopy(fArray, 0, fArray4, 0, fArray.length);
        int n3 = fArray.length;
        for (float[] fArray5 : fArray2) {
            System.arraycopy(fArray5, 0, fArray4, n3, fArray5.length);
            n3 += fArray5.length;
        }
        if (n3 != fArray4.length) {
            throw new RuntimeException("Not all the data in arrays are copied in the returned array!");
        }
        return fArray4;
    }

    public static int[] a(int[] nArray, int[] ... nArray2) throws Exception {
        int n2 = nArray.length;
        for (int[] nArray3 : nArray2) {
            n2 += nArray3.length;
        }
        int[] nArray4 = new int[n2];
        System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
        int n3 = nArray.length;
        for (int[] nArray5 : nArray2) {
            System.arraycopy(nArray5, 0, nArray4, n3, nArray5.length);
            n3 += nArray5.length;
        }
        if (n3 != nArray4.length) {
            throw new Exception("Not all the data in arrays are copied in the returned array!");
        }
        return nArray4;
    }

    public static float s(float[] fArray) throws IllegalArgumentException {
        return MathUtils.a(fArray, 0, fArray.length - 1);
    }

    public static float a(float[] fArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= fArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        float f2 = fArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Float.compare(fArray[i2], f2) >= 0) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static double f(double[] dArray) throws IllegalArgumentException {
        return MathUtils.a(dArray, 0, dArray.length - 1);
    }

    public static double a(double[] dArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (dArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= dArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        double d2 = dArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Double.compare(dArray[i2], d2) >= 0) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static short b(short[] sArray) throws IllegalArgumentException {
        return MathUtils.a(sArray, 0, sArray.length - 1);
    }

    public static short a(short[] sArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= sArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        short s2 = sArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (sArray[i2] >= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static int f(int[] nArray) throws IllegalArgumentException {
        return MathUtils.b(nArray, 0, nArray.length - 1);
    }

    public static int b(int[] nArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        int n4 = nArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (nArray[i2] >= n4) continue;
            n4 = nArray[i2];
        }
        return n4;
    }

    public static Number a(DataBuffer dataBuffer) throws IllegalArgumentException {
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.g(dataBuffer);
        }
        return MathUtils.h(dataBuffer);
    }

    private static double g(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        double d2 = dataBuffer.getElemDouble(0);
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            double d3 = dataBuffer.getElemDouble(i2);
            if (Double.compare(d3, d2) >= 0) continue;
            d2 = d3;
        }
        return d2;
    }

    private static int h(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getElem(0);
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            int n3 = dataBuffer.getElem(i2);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static byte a(ByteBuffer byteBuffer) {
        byte by2 = 127;
        for (byte by3 : byteBuffer.array()) {
            if (by3 >= by2) continue;
            by2 = by3;
        }
        return by2;
    }

    public static byte b(ByteBuffer byteBuffer) {
        byte by2 = -128;
        for (byte by3 : byteBuffer.array()) {
            if (by3 <= by2) continue;
            by2 = by3;
        }
        return by2;
    }

    public static boolean a(int n2, int n3) {
        return n2 >= 0 && n2 < n3;
    }

    public static boolean c(ByteBuffer byteBuffer) {
        for (byte by2 : byteBuffer.array()) {
            if (by2 <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean g(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean b(int[][][] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[0].length; ++i3) {
                for (int i4 = 0; i4 < nArray[0][0].length; ++i4) {
                    if (nArray[i2][i3][i4] <= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean a(Number number) {
        if (number == null) {
            return false;
        }
        double d2 = number.doubleValue();
        return !Double.isInfinite(d2) && !Double.isNaN(d2);
    }

    public static int t(float[] fArray) throws IllegalArgumentException {
        return MathUtils.b(fArray, 0, fArray.length - 1);
    }

    public static int b(float[] fArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= fArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        float f2 = fArray[n2];
        int n4 = n2;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Float.compare(fArray[i2], f2) >= 0) continue;
            f2 = fArray[i2];
            n4 = i2;
        }
        return n4;
    }

    public static int c(short[] sArray) throws IllegalArgumentException {
        return MathUtils.b(sArray, 0, sArray.length - 1);
    }

    public static int b(short[] sArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= sArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        short s2 = sArray[n2];
        int n4 = n2;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (sArray[i2] >= s2) continue;
            s2 = sArray[i2];
            n4 = i2;
        }
        return n4;
    }

    public static int b(DataBuffer dataBuffer) throws IllegalArgumentException {
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.i(dataBuffer);
        }
        return MathUtils.j(dataBuffer);
    }

    private static int i(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        double d2 = dataBuffer.getElemDouble(0);
        int n2 = 0;
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            double d3 = dataBuffer.getElemDouble(i2);
            if (Double.compare(d3, d2) >= 0) continue;
            d2 = d3;
            n2 = i2;
        }
        return n2;
    }

    private static int j(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getElem(0);
        int n3 = 0;
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            int n4 = dataBuffer.getElem(i2);
            if (n4 >= n2) continue;
            n2 = n4;
            n3 = i2;
        }
        return n3;
    }

    public static float u(float[] fArray) throws IllegalArgumentException {
        return MathUtils.c(fArray, 0, fArray.length - 1);
    }

    public static float c(float[] fArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= fArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        float f2 = fArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Float.compare(fArray[i2], f2) <= 0) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static double g(double[] dArray) throws IllegalArgumentException {
        return MathUtils.b(dArray, 0, dArray.length - 1);
    }

    public static double b(double[] dArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (dArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= dArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        double d2 = dArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Double.compare(dArray[i2], d2) <= 0) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static short d(short[] sArray) throws IllegalArgumentException {
        return MathUtils.c(sArray, 0, sArray.length - 1);
    }

    public static short c(short[] sArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= sArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        short s2 = sArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (sArray[i2] <= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static int h(int[] nArray) throws IllegalArgumentException {
        return MathUtils.c(nArray, 0, nArray.length - 1);
    }

    public static int c(int[] nArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        int n4 = nArray[n2];
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (nArray[i2] <= n4) continue;
            n4 = nArray[i2];
        }
        return n4;
    }

    public static float a(float[][] fArray, int[] nArray, int n2) {
        float f2 = Float.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!(fArray[nArray[i2]][n2] > f2)) continue;
            f2 = fArray[nArray[i2]][n2];
        }
        return f2;
    }

    public static float d(float[] fArray, int[] nArray) {
        float f2 = Float.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!(fArray[nArray[i2]] > f2)) continue;
            f2 = fArray[nArray[i2]];
        }
        return f2;
    }

    public static float b(float[][] fArray, int[] nArray, int n2) {
        float f2 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!(fArray[nArray[i2]][n2] < f2)) continue;
            f2 = fArray[nArray[i2]][n2];
        }
        return f2;
    }

    public static float e(float[] fArray, int[] nArray) {
        float f2 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!(fArray[nArray[i2]] < f2)) continue;
            f2 = fArray[nArray[i2]];
        }
        return f2;
    }

    public static int[] a(int[][] nArray, int n2) {
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2][n2] > n3) {
                n3 = nArray[i2][n2];
            }
            if (nArray[i2][n2] >= n4) continue;
            n4 = nArray[i2][n2];
        }
        return new int[]{n3, n4};
    }

    public static float[] a(float[][] fArray, int n2) {
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (fArray[i2][n2] > f2) {
                f2 = fArray[i2][n2];
            }
            if (!(fArray[i2][n2] < f3)) continue;
            f3 = fArray[i2][n2];
        }
        return new float[]{f2, f3};
    }

    public static int[] a(int[][] nArray, int[] nArray2, int n2) {
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (nArray[nArray2[i2]][n2] > n3) {
                n3 = nArray[nArray2[i2]][n2];
            }
            if (nArray[nArray2[i2]][n2] >= n4) continue;
            n4 = nArray[nArray2[i2]][n2];
        }
        return new int[]{n3, n4};
    }

    public static float[] c(float[][] fArray, int[] nArray, int n2) {
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (fArray[nArray[i2]][n2] > f2) {
                f2 = fArray[nArray[i2]][n2];
            }
            if (!(fArray[nArray[i2]][n2] < f3)) continue;
            f3 = fArray[nArray[i2]][n2];
        }
        return new float[]{f2, f3};
    }

    public static float[] b(float[][] fArray) {
        float f2 = Float.NEGATIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            for (int i3 = 0; i3 < fArray[i2].length; ++i3) {
                if (fArray[i2][i3] > f2) {
                    f2 = fArray[i2][i3];
                }
                if (!(fArray[i2][i3] < f3)) continue;
                f3 = fArray[i2][i3];
            }
        }
        return new float[]{f2, f3};
    }

    public static int[] c(int[][][] nArray) {
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                for (int i4 = 0; i4 < nArray[i2][i3].length; ++i4) {
                    if (nArray[i2][i3][i4] > n2) {
                        n2 = nArray[i2][i3][i4];
                    }
                    if (nArray[i2][i3][i4] >= n3) continue;
                    n3 = nArray[i2][i3][i4];
                }
            }
        }
        return new int[]{n2, n3};
    }

    public static int[] b(ImageCube.AbstractIntegralImageCube abstractIntegralImageCube) {
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int[] nArray = abstractIntegralImageCube.d();
        int n4 = 0;
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                    n4 = abstractIntegralImageCube.b(i4, i3, i2);
                    if (n4 > n2) {
                        n2 = n4;
                    }
                    if (n4 >= n3) continue;
                    n3 = n4;
                }
            }
        }
        return new int[]{n2, n3};
    }

    public static Number c(DataBuffer dataBuffer) throws IllegalArgumentException {
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.k(dataBuffer);
        }
        return MathUtils.l(dataBuffer);
    }

    private static double k(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        double d2 = dataBuffer.getElemDouble(0);
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            double d3 = dataBuffer.getElemDouble(i2);
            if (Double.compare(d3, d2) <= 0) continue;
            d2 = d3;
        }
        return d2;
    }

    private static int l(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getElem(0);
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            int n3 = dataBuffer.getElem(i2);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static float v(float[] fArray) {
        return MathUtils.a(true, fArray);
    }

    public static float a(boolean bl2, float[] fArray) {
        float[] fArray2;
        if (bl2) {
            fArray2 = (float[])fArray.clone();
            Arrays.sort(fArray2);
        } else {
            fArray2 = fArray;
        }
        int n2 = fArray2.length / 2;
        int n3 = n2 + (fArray2.length % 2 - 1);
        if (n2 == n3) {
            return fArray2[n2];
        }
        return (fArray2[n2] + fArray2[n3]) / 2.0f;
    }

    public static int w(float[] fArray) throws IllegalArgumentException {
        return MathUtils.d(fArray, 0, fArray.length - 1);
    }

    public static int d(float[] fArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= fArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        float f2 = fArray[n2];
        int n4 = n2;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Float.compare(fArray[i2], f2) <= 0) continue;
            f2 = fArray[i2];
            n4 = i2;
        }
        return n4;
    }

    public static int e(short[] sArray) throws IllegalArgumentException {
        return MathUtils.d(sArray, 0, sArray.length - 1);
    }

    public static int d(short[] sArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= sArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        short s2 = sArray[n2];
        int n4 = n2;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Float.compare(sArray[i2], s2) <= 0) continue;
            s2 = sArray[i2];
            n4 = i2;
        }
        return n4;
    }

    public static int i(int[] nArray) throws IllegalArgumentException {
        return MathUtils.d(nArray, 0, nArray.length - 1);
    }

    public static int d(int[] nArray, int n2, int n3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("Starting index is larger than ending index.");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Starting index should not be negative.");
        }
        if (n3 >= nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Ending index should not be beyond array index range.");
        }
        int n4 = nArray[n2];
        int n5 = n2;
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            if (Float.compare(nArray[i2], n4) <= 0) continue;
            n4 = nArray[i2];
            n5 = i2;
        }
        return n5;
    }

    public static int d(DataBuffer dataBuffer) throws IllegalArgumentException {
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.m(dataBuffer);
        }
        return MathUtils.n(dataBuffer);
    }

    private static int m(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        double d2 = dataBuffer.getElemDouble(0);
        int n2 = 0;
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            double d3 = dataBuffer.getElemDouble(i2);
            if (Double.compare(d3, d2) <= 0) continue;
            d2 = d3;
            n2 = i2;
        }
        return n2;
    }

    private static int n(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getElem(0);
        int n3 = 0;
        for (int i2 = 1; i2 < dataBuffer.getSize(); ++i2) {
            int n4 = dataBuffer.getElem(i2);
            if (n4 <= n2) continue;
            n2 = n4;
            n3 = i2;
        }
        return n3;
    }

    public static float x(float[] fArray) {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2];
        }
        return f2;
    }

    public static float y(float[] fArray) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2] * fArray[i2];
        }
        return f2;
    }

    public static long f(short[] sArray) {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            l2 += (long)sArray[i2];
        }
        return l2;
    }

    public static long j(int[] nArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            l2 += (long)nArray[i2];
        }
        return l2;
    }

    public static int a(boolean[] blArray) {
        return MathUtils.a(blArray, blArray.length);
    }

    public static int a(boolean[] blArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!blArray[i2]) continue;
            ++n3;
        }
        return n3;
    }

    public static double h(double[] dArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += dArray[i2];
        }
        return d2;
    }

    public static float e(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.o(dataBuffer);
        }
        return MathUtils.p(dataBuffer);
    }

    private static float o(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < dataBuffer.getSize(); ++i2) {
            f2 = (float)((double)f2 + dataBuffer.getElemDouble(i2));
        }
        return f2;
    }

    private static float p(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < dataBuffer.getSize(); ++i2) {
            f2 += (float)dataBuffer.getElem(i2);
        }
        return f2;
    }

    public static float z(float[] fArray) throws IllegalArgumentException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.x(fArray) / (float)fArray.length;
    }

    public static float g(short[] sArray) throws IllegalArgumentException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return (float)MathUtils.f(sArray) / (float)sArray.length;
    }

    public static double i(double[] dArray) throws IllegalArgumentException {
        if (dArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.h(dArray) / (double)dArray.length;
    }

    public static float k(int[] nArray) throws IllegalArgumentException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return (float)MathUtils.j(nArray) / (float)nArray.length;
    }

    public static float f(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.q(dataBuffer);
        }
        return MathUtils.r(dataBuffer);
    }

    private static float q(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.o(dataBuffer) / (float)dataBuffer.getSize();
    }

    private static float r(DataBuffer dataBuffer) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.p(dataBuffer) / (float)dataBuffer.getSize();
    }

    public static float a(float[] fArray, boolean bl2) throws IllegalArgumentException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.a(fArray, MathUtils.z(fArray), bl2);
    }

    public static float a(float[] fArray, float f2, boolean bl2) throws IllegalArgumentException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f3 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f4 = fArray[i2] - f2;
            f3 += f4 * f4;
        }
        f3 = bl2 ? (f3 /= (float)(fArray.length - 1)) : (f3 /= (float)fArray.length);
        return f3;
    }

    public static float a(int[] nArray, boolean bl2) throws IllegalArgumentException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.a(nArray, MathUtils.k(nArray), bl2);
    }

    public static float a(short[] sArray, boolean bl2) throws IllegalArgumentException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.a(sArray, MathUtils.g(sArray), bl2);
    }

    public static float a(int[] nArray, float f2, boolean bl2) throws IllegalArgumentException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f3 = 0.0f;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            float f4 = (float)nArray[i2] - f2;
            f3 += f4 * f4;
        }
        f3 = bl2 ? (f3 /= (float)(nArray.length - 1)) : (f3 /= (float)nArray.length);
        return f3;
    }

    public static float a(short[] sArray, float f2, boolean bl2) throws IllegalArgumentException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f3 = 0.0f;
        for (short s2 : sArray) {
            f3 = (float)((double)f3 + Math.pow((float)s2 - f2, 2.0));
        }
        f3 = bl2 ? (f3 /= (float)(sArray.length - 1)) : (f3 /= (float)sArray.length);
        return f3;
    }

    public static float a(DataBuffer dataBuffer, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.d(dataBuffer, bl2);
        }
        return MathUtils.c(dataBuffer, bl2);
    }

    public static float a(DataBuffer dataBuffer, float f2, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.d(dataBuffer, f2, bl2);
        }
        return MathUtils.c(dataBuffer, f2, bl2);
    }

    private static float c(DataBuffer dataBuffer, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.c(dataBuffer, MathUtils.r(dataBuffer), bl2);
    }

    private static float c(DataBuffer dataBuffer, float f2, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f3 = 0.0f;
        for (int i2 = 0; i2 < dataBuffer.getSize(); ++i2) {
            f3 = (float)((double)f3 + Math.pow((float)dataBuffer.getElem(i2) - f2, 2.0));
        }
        f3 = bl2 ? (f3 /= (float)(dataBuffer.getSize() - 1)) : (f3 /= (float)dataBuffer.getSize());
        return f3;
    }

    private static float d(DataBuffer dataBuffer, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.d(dataBuffer, MathUtils.q(dataBuffer), bl2);
    }

    private static float d(DataBuffer dataBuffer, float f2, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        float f3 = 0.0f;
        for (int i2 = 0; i2 < dataBuffer.getSize(); ++i2) {
            f3 = (float)((double)f3 + Math.pow(dataBuffer.getElemDouble(i2) - (double)f2, 2.0));
        }
        f3 = bl2 ? (f3 /= (float)(dataBuffer.getSize() - 1)) : (f3 /= (float)dataBuffer.getSize());
        return f3;
    }

    public static float b(float[] fArray, boolean bl2) throws IllegalArgumentException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.b(fArray, MathUtils.z(fArray), bl2);
    }

    public static float b(float[] fArray, float f2, boolean bl2) throws IllegalArgumentException {
        if (fArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return (float)Math.sqrt(MathUtils.a(fArray, f2, bl2));
    }

    public static float b(int[] nArray, boolean bl2) throws IllegalArgumentException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.b(nArray, MathUtils.k(nArray), bl2);
    }

    public static float b(short[] sArray, boolean bl2) throws IllegalArgumentException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.b(sArray, MathUtils.g(sArray), bl2);
    }

    public static float b(int[] nArray, float f2, boolean bl2) throws IllegalArgumentException {
        if (nArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return (float)Math.sqrt(MathUtils.a(nArray, f2, bl2));
    }

    public static float b(short[] sArray, float f2, boolean bl2) throws IllegalArgumentException {
        if (sArray.length < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return (float)Math.sqrt(MathUtils.a(sArray, f2, bl2));
    }

    public static float b(DataBuffer dataBuffer, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.f(dataBuffer, bl2);
        }
        return MathUtils.e(dataBuffer, bl2);
    }

    public static float b(DataBuffer dataBuffer, float f2, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        int n2 = dataBuffer.getDataType();
        if (n2 == 5 || n2 == 4) {
            return MathUtils.f(dataBuffer, f2, bl2);
        }
        return MathUtils.e(dataBuffer, f2, bl2);
    }

    private static float e(DataBuffer dataBuffer, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.e(dataBuffer, MathUtils.r(dataBuffer), bl2);
    }

    private static float e(DataBuffer dataBuffer, float f2, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return (float)Math.sqrt(MathUtils.c(dataBuffer, f2, bl2));
    }

    private static float f(DataBuffer dataBuffer, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return MathUtils.f(dataBuffer, MathUtils.q(dataBuffer), bl2);
    }

    private static float f(DataBuffer dataBuffer, float f2, boolean bl2) throws IllegalArgumentException {
        if (dataBuffer.getSize() < 1) {
            throw new IllegalArgumentException("Too little data.");
        }
        return (float)Math.sqrt(MathUtils.d(dataBuffer, f2, bl2));
    }

    public static int[] a(Point3i point3i) {
        int[] nArray = new int[]{point3i.x, point3i.y, point3i.z};
        return nArray;
    }

    public static float[] f(float[] fArray, int[] nArray) {
        float[] fArray2 = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray2[i2] = fArray[nArray[i2]];
        }
        return fArray2;
    }

    public static float[] d(float[][] fArray, int[] nArray, int n2) {
        float[] fArray2 = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray2[i2] = fArray[nArray[i2]][n2];
        }
        return fArray2;
    }

    public static float b(float f2) {
        return (float)Math.exp(Gamma.logGamma((double)f2));
    }

    public static double a(double d2) {
        return Math.exp(Gamma.logGamma((double)d2));
    }

    public static float c(float f2) throws MaxCountExceededException {
        return (float)Erf.erf((double)f2);
    }

    public static double b(double d2) throws MaxCountExceededException {
        return Erf.erf((double)d2);
    }

    public static long j(int[] nArray, int[] nArray2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            l2 += (long)nArray[i2] * MathUtils.a(nArray2, 0, i2);
        }
        return l2;
    }

    public static int[] a(long l2, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = nArray2.length - 1; i2 >= 0; --i2) {
            long l3 = MathUtils.a(nArray, 0, i2);
            nArray2[i2] = (int)(l2 / l3);
            l2 -= (long)nArray2[i2] * l3;
        }
        return nArray2;
    }

    public static int[] a(int n2, int[] nArray) {
        return MathUtils.a((long)n2, nArray);
    }

    public static int[][] a(Object object, int[] nArray) {
        if (object instanceof int[] || object instanceof long[] || object instanceof Integer[] || object instanceof Long[]) {
            if (object instanceof int[]) {
                return MathUtils.o((int[])object, nArray);
            }
            if (object instanceof long[]) {
                return MathUtils.a((long[])object, nArray);
            }
            if (object instanceof Integer[]) {
                return MathUtils.a((Integer[])object, nArray);
            }
            return MathUtils.a((Long[])object, nArray);
        }
        throw new IllegalArgumentException("indices can only be array of int, long, Integer or Long!");
    }

    private static int[][] o(int[] nArray, int[] nArray2) {
        int[][] nArray3 = new int[nArray.length][3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = MathUtils.a(nArray[i2], nArray2);
        }
        return nArray3;
    }

    private static int[][] a(long[] lArray, int[] nArray) {
        int[][] nArray2 = new int[lArray.length][3];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            nArray2[i2] = MathUtils.a(lArray[i2], nArray);
        }
        return nArray2;
    }

    private static int[][] a(Integer[] integerArray, int[] nArray) {
        int[][] nArray2 = new int[integerArray.length][3];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray2[i2] = MathUtils.a((int)integerArray[i2], nArray);
        }
        return nArray2;
    }

    private static int[][] a(Long[] longArray, int[] nArray) {
        int[][] nArray2 = new int[longArray.length][3];
        for (int i2 = 0; i2 < longArray.length; ++i2) {
            nArray2[i2] = MathUtils.a(longArray[i2], nArray);
        }
        return nArray2;
    }

    public static float[] a(int n2, float f2) {
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = (float)i2 * f2;
        }
        return fArray;
    }

    public static boolean c(int[] nArray, float[] fArray) {
        if (nArray.length != fArray.length) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (Float.compare(nArray[i2], fArray[i2]) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean k(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static Vector3f d(float f2) {
        double d2 = (double)(f2 / 180.0f) * Math.PI;
        return new Vector3f((float)Math.cos(d2), (float)(-Math.sin(d2)), 0.0f);
    }

    public static Vector3f[] a(Vector3f[] vector3fArray) {
        Vector3f[] vector3fArray2 = new Vector3f[vector3fArray.length];
        for (int i2 = 0; i2 < vector3fArray.length; ++i2) {
            vector3fArray2[i2] = (Vector3f)vector3fArray[i2].clone();
        }
        return vector3fArray2;
    }

    public static Point3f[] a(Point3f[] point3fArray) {
        Point3f[] point3fArray2 = new Point3f[point3fArray.length];
        for (int i2 = 0; i2 < point3fArray.length; ++i2) {
            point3fArray2[i2] = (Point3f)((Object)point3fArray[i2].clone());
        }
        return point3fArray2;
    }

    public static Point3i[] a(Point3i[] point3iArray) {
        Point3i[] point3iArray2 = new Point3i[point3iArray.length];
        for (int i2 = 0; i2 < point3iArray.length; ++i2) {
            point3iArray2[i2] = (Point3i)point3iArray[i2].clone();
        }
        return point3iArray2;
    }

    public static short[] a(short[] sArray, short s2) {
        short[] sArray2 = (short[])sArray.clone();
        int n2 = 0;
        while (n2 < sArray2.length) {
            int n3 = n2++;
            sArray2[n3] = (short)(sArray2[n3] + s2);
        }
        return sArray2;
    }

    public static int[] a(int[] nArray, int n2) {
        int[] nArray2 = (int[])nArray.clone();
        int n3 = 0;
        while (n3 < nArray2.length) {
            int n4 = n3++;
            nArray2[n4] = nArray2[n4] + n2;
        }
        return nArray2;
    }

    public static float[] d(float[] fArray, float f2) {
        float[] fArray2 = (float[])fArray.clone();
        int n2 = 0;
        while (n2 < fArray2.length) {
            int n3 = n2++;
            fArray2[n3] = fArray2[n3] + f2;
        }
        return fArray2;
    }

    public static void a(int[][][] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2].length; ++i3) {
                int n3 = 0;
                while (n3 < nArray[i2][i3].length) {
                    int[] nArray2 = nArray[i2][i3];
                    int n4 = n3++;
                    nArray2[n4] = nArray2[n4] + n2;
                }
            }
        }
    }

    public static float[] b(int[] nArray, float f2) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = (float)nArray[i2] % f2;
        }
        return fArray;
    }

    public static float[] e(float[] fArray, float f2) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            fArray2[i2] = fArray[i2] % f2;
        }
        return fArray2;
    }

    public static void a(ImageCube.ImageCubeShort imageCubeShort, int n2) {
        int[] nArray = imageCubeShort.d();
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                    int n3 = imageCubeShort.c(i4, i3, i2) + n2;
                    imageCubeShort.a(i4, i3, i2, (short)n3);
                }
            }
        }
    }

    public static int[] c(int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = i2;
        }
        return nArray;
    }

    public static int[] A(float[] fArray) {
        int n2 = 1;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            n2 = (int)((float)n2 * fArray[i2]);
        }
        int[] nArray = new int[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            nArray[i3] = i3;
        }
        return nArray;
    }

    public static double[] a(double[] dArray, double d2) {
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2] = dArray[i2] * d2;
        }
        return dArray2;
    }

    public static float[] f(float[] fArray, float f2) {
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = fArray[i2] * f2;
        }
        return fArray2;
    }

    public static float[] c(int[] nArray, float f2) {
        float[] fArray = new float[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            fArray[i2] = (float)nArray[i2] * f2;
        }
        return fArray;
    }

    public static int[] b(int[] nArray, int n2) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2] * n2;
        }
        return nArray2;
    }

    public static float[] k(float[] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = fArray[i2] + fArray2[i2];
        }
        return fArray3;
    }

    public static int[] d(int n2) {
        if (n2 > 2 || n2 < 0) {
            throw new IllegalArgumentException("currentPlane must be between 0 and 2!");
        }
        switch (n2) {
            case 0: {
                return new int[]{1, 2};
            }
            case 1: {
                return new int[]{0, 2};
            }
        }
        return new int[]{0, 1};
    }

    public static float l(float[] fArray, float[] fArray2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f3 = Math.abs(fArray[i2] - fArray2[i2]);
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public static double b(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d3 = Math.abs(dArray[i2] - dArray2[i2]);
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static float m(float[] fArray, float[] fArray2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            float f3 = (float)Math.pow(fArray[i2] - fArray2[i2], 2.0);
            f2 += f3;
        }
        return (float)Math.sqrt(f2 / (float)fArray.length);
    }

    public static float B(float[] fArray) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            f2 += fArray[i2] * fArray[i2];
        }
        return (float)Math.sqrt(f2 / (float)fArray.length);
    }

    public static double c(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d3 = Math.pow(dArray[i2] - dArray2[i2], 2.0);
            d2 += d3;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    public static boolean d(float f2, float f3, float f4) {
        return Math.abs(f2 - f3) < f4;
    }

    public static float e(float f2) {
        return (float)(Math.log10(f2) / Math.log10(2.0));
    }

    public static double a(double d2, double d3) {
        long l2 = Double.doubleToLongBits(d2);
        long l3 = (long)(d3 * (double)(l2 - 4606921280493453312L)) + 4606921280493453312L;
        return Double.longBitsToDouble(l3);
    }

    public static int b(int n2, int n3) {
        if (n2 < n3) {
            return MathUtils.b(n3, n2);
        }
        if (n3 == 0) {
            return n2;
        }
        return MathUtils.b(n3, n2 % n3);
    }

    public static int[] l(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = MathUtils.b(nArray[i2], nArray2[i2]);
        }
        return nArray3;
    }

    public static int c(int n2, int n3) {
        return n2 * n3 / MathUtils.b(n2, n3);
    }

    public static int[] m(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray3[i2] = MathUtils.c(nArray[i2], nArray2[i2]);
        }
        return nArray3;
    }

    public static short h(short[] sArray) {
        Short s2 = Short.MAX_VALUE;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] >= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static float C(float[] fArray) {
        float f2 = Float.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] < f2)) continue;
            f2 = fArray[i2];
        }
        return f2;
    }

    public static float D(float ... fArray) {
        return MathUtils.C(fArray);
    }

    public static double j(double[] dArray) {
        double d2 = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] < d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    public static double k(double[] dArray) {
        double d2 = Double.NEGATIVE_INFINITY;
        for (double d3 : dArray) {
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static float E(float ... fArray) {
        return MathUtils.F(fArray);
    }

    public static byte a(byte[] byArray) {
        byte by2 = -128;
        for (byte by3 : byArray) {
            if (by3 <= by2) continue;
            by2 = by3;
        }
        return by2;
    }

    public static short i(short[] sArray) {
        short s2 = Short.MIN_VALUE;
        for (short s3 : sArray) {
            if (s3 <= s2) continue;
            s2 = s3;
        }
        return s2;
    }

    public static float F(float[] fArray) {
        float f2 = Float.NEGATIVE_INFINITY;
        for (float f3 : fArray) {
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    public static int l(int ... nArray) {
        int n2 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static int m(int ... nArray) {
        int n2 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static short f(float f2) {
        if (f2 > 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (f2 < -32768.0f) {
            return Short.MIN_VALUE;
        }
        return (short)(f2 >= 0.0f ? f2 + 0.5f : f2 - 0.5f);
    }

    public static short c(double d2) {
        if (d2 > 32767.0) {
            return Short.MAX_VALUE;
        }
        if (d2 < -32768.0) {
            return Short.MIN_VALUE;
        }
        return (short)(d2 >= 0.0 ? d2 + 0.5 : d2 - 0.5);
    }

    public static char g(float f2) {
        if (f2 > 65535.0f) {
            return '\uffff';
        }
        if (f2 < 0.0f) {
            return '\u0000';
        }
        return (char)((double)f2 + 0.5);
    }

    public static int h(float f2) {
        if (f2 >= 0.0f) {
            return (int)(f2 + 0.5f);
        }
        return (int)(f2 - 0.5f);
    }

    public static int e(int n2) {
        if (n2 < 0) {
            return -1;
        }
        if (n2 > 0) {
            return 1;
        }
        return 0;
    }

    public static float[] a(float[] fArray, float[] fArray2, TTestVarType tTestVarType) {
        float f2;
        float f3;
        if (tTestVarType == TTestVarType.a && fArray.length != fArray2.length) {
            return null;
        }
        if (tTestVarType == TTestVarType.b) {
            boolean bl2;
            float f4 = MathUtils.z(fArray);
            float f5 = MathUtils.a(fArray, f4, true);
            float f6 = MathUtils.z(fArray2);
            float f7 = MathUtils.a(fArray2, f6, true);
            boolean bl3 = bl2 = fArray.length == fArray2.length;
            if (bl2) {
                double d2 = Math.sqrt((f5 + f7) / 2.0f);
                f3 = (f4 - f6) / (float)(d2 * Math.sqrt(2.0f / (float)fArray.length));
            } else {
                double d3 = Math.sqrt(((float)(fArray.length - 1) * f5 + (float)(fArray2.length - 1) * f7) / (float)(fArray.length + fArray2.length - 2));
                f3 = (f4 - f6) / (float)(d3 * Math.sqrt(1.0f / (float)fArray.length + 1.0f / (float)fArray2.length));
            }
            f2 = fArray.length + fArray2.length - 2;
        } else if (tTestVarType == TTestVarType.c) {
            float f8 = MathUtils.z(fArray);
            float f9 = MathUtils.a(fArray, f8, true);
            float f10 = MathUtils.z(fArray2);
            float f11 = MathUtils.a(fArray2, f10, true);
            f3 = (f8 - f10) / (float)Math.sqrt(f9 / (float)fArray.length + f11 / (float)fArray2.length);
            f2 = (float)(Math.pow(f9 / (float)fArray.length + f11 / (float)fArray2.length, 2.0) / (Math.pow(f9 / (float)fArray.length, 2.0) / (double)(fArray.length - 1) + Math.pow(f11 / (float)fArray2.length, 2.0) / (double)(fArray2.length - 1)));
        } else {
            float[] fArray3 = new float[fArray.length];
            float f12 = 0.0f;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray3[i2] = fArray[i2] - fArray2[i2];
                f12 += fArray3[i2];
            }
            f12 /= (float)fArray.length;
            double d4 = 0.0;
            for (int i3 = 0; i3 < fArray3.length; ++i3) {
                d4 += Math.pow(fArray3[i3] - f12, 2.0);
            }
            d4 = Math.sqrt(d4 / (double)(fArray3.length - 1));
            f3 = f12 / (float)(d4 / Math.sqrt(fArray3.length));
            f2 = fArray3.length - 1;
        }
        return new float[]{f3, f2};
    }

    public static float a(float f2, float f3, TTestTailType tTestTailType) {
        float f4 = f3 / (f3 + f2 * f2);
        float f5 = f3 / 2.0f;
        float f6 = 0.5f;
        float f7 = MathUtils.e(f4, f5, f6);
        if (tTestTailType == TTestTailType.a) {
            f7 /= 2.0f;
        }
        return f7;
    }

    public static float e(float f2, float f3, float f4) {
        try {
            return (float)Beta.regularizedBeta((double)f2, (double)f3, (double)f4);
        }
        catch (MaxCountExceededException maxCountExceededException) {
            ay.d((Object)maxCountExceededException, MathUtils.class);
            return Float.NaN;
        }
    }

    public static byte i(float f2) {
        return (byte)(f2 > 127.0f ? 127.0f : (f2 < -128.0f ? -128.0f : f2));
    }

    public static List<Integer> n(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Integer n3 = nArray2[i2];
            arrayList.add(n3);
        }
        return arrayList;
    }

    public static int[] a(Collection<Integer> collection) {
        int[] nArray = new int[collection.size()];
        int n2 = 0;
        for (Integer n3 : collection) {
            nArray[n2++] = n3;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        System.out.println(MathUtils.c(1, 3));
    }

    public static boolean n(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null || nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Arguments to isMultiple() must be integer arrays with same length");
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray2[i2] % nArray[i2] == 0) continue;
            return false;
        }
        return nArray.length > 0;
    }

    public static Number[] o(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        Number[] numberArray = new Number[nArray.length];
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            numberArray[i2] = nArray[i2];
        }
        return numberArray;
    }

    public static Number[] G(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        Number[] numberArray = new Number[fArray.length];
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            numberArray[i2] = Float.valueOf(fArray[i2]);
        }
        return numberArray;
    }

    public static double b(double d2, double d3) {
        int n2;
        if (Double.isInfinite(d2) || Double.isInfinite(d3)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        int n3 = MathUtils.d(d2);
        if (n3 > (n2 = MathUtils.d(d3)) + 27) {
            return Math.abs(d2);
        }
        if (n2 > n3 + 27) {
            return Math.abs(d3);
        }
        int n4 = (n3 + n2) / 2;
        double d4 = MathUtils.c(d2, -n4);
        double d5 = MathUtils.c(d3, -n4);
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        return MathUtils.c(d6, n4);
    }

    public static int d(double d2) {
        return (int)(Double.doubleToLongBits(d2) >>> 52 & 0x7FFL) - 1023;
    }

    public static double c(double d2, int n2) {
        if (n2 > -1023 && n2 < 1024) {
            return d2 * Double.longBitsToDouble((long)(n2 + 1023) << 52);
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2) || d2 == 0.0) {
            return d2;
        }
        if (n2 < -2098) {
            return d2 > 0.0 ? 0.0 : -0.0;
        }
        if (n2 > 2097) {
            return d2 > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        long l2 = Double.doubleToLongBits(d2);
        long l3 = l2 & Long.MIN_VALUE;
        int n3 = (int)(l2 >>> 52) & 0x7FF;
        long l4 = l2 & 0xFFFFFFFFFFFFFL;
        int n4 = n3 + n2;
        if (n2 < 0) {
            if (n4 > 0) {
                return Double.longBitsToDouble(l3 | (long)n4 << 52 | l4);
            }
            if (n4 > -53) {
                long l5 = (l4 |= 0x10000000000000L) & 1L << -n4;
                l4 >>>= 1 - n4;
                if (l5 != 0L) {
                    ++l4;
                }
                return Double.longBitsToDouble(l3 | l4);
            }
            return l3 == 0L ? 0.0 : -0.0;
        }
        if (n3 == 0) {
            while (l4 >>> 52 != 1L) {
                l4 <<= 1;
                --n4;
            }
            l4 &= 0xFFFFFFFFFFFFFL;
            if (++n4 < 2047) {
                return Double.longBitsToDouble(l3 | (long)n4 << 52 | l4);
            }
            return l3 == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (n4 < 2047) {
            return Double.longBitsToDouble(l3 | (long)n4 << 52 | l4);
        }
        return l3 == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
    }

    public static int f(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Size must be >= 1");
        }
        double d2 = FastMath.log((double)2.0, (double)n2);
        return (int)Math.pow(2.0, Math.ceil(d2));
    }

    public static RealMatrix l(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            Arrays.fill(dArray2[i2], 0.0);
            dArray2[i2][i2] = dArray[i2];
        }
        RealMatrix realMatrix = MatrixUtils.createRealMatrix((double[][])dArray2);
        return realMatrix;
    }

    public static double m(double[] dArray) {
        return MathUtils.a(dArray, true, true);
    }

    public static double a(double[] dArray, boolean bl2, boolean bl3) {
        double[] dArray2;
        if (bl2) {
            dArray2 = bl3 ? (double[])dArray.clone() : dArray;
            Arrays.sort(dArray2);
        } else {
            dArray2 = dArray;
        }
        int n2 = dArray2.length / 2;
        int n3 = n2 + (dArray2.length % 2 - 1);
        if (n2 == n3) {
            return dArray2[n2];
        }
        return (dArray2[n2] + dArray2[n3]) / 2.0;
    }

    public static float[][] a(float[][] fArray, float f2, float f3) {
        float[][] fArray2 = new float[fArray.length][fArray[0].length];
        float f4 = f2 - f3;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            for (int i3 = 0; i3 < fArray[i2].length; ++i3) {
                fArray2[i2][i3] = (fArray[i2][i3] - f3) / f4;
            }
        }
        return fArray2;
    }

    public static float[][] a(List<? extends Point3f> list) {
        float[][] fArrayArray = new float[list.size()][];
        for (int i2 = 0; i2 < fArrayArray.length; ++i2) {
            fArrayArray[i2] = list.get(i2).f();
        }
        return fArrayArray;
    }

    public static float[] e(float[] fArray, int n2, int n3) {
        float[] fArray2 = new float[n3 - n2 + 1];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            fArray2[n4++] = fArray[i2];
        }
        return fArray2;
    }

    public static Matrix3f a(Matrix4f matrix4f) {
        Matrix3f matrix3f = new Matrix3f();
        matrix4f.getRotationScale(matrix3f);
        return matrix3f;
    }

    public static double n(double[] dArray) {
        double d2 = 0.0;
        for (double d3 : dArray) {
            d2 += d3 * d3;
        }
        return FastMath.sqrt((double)d2);
    }

    public static float H(float[] fArray) {
        float f2 = 0.0f;
        for (float f3 : fArray) {
            float f4;
            float f5 = Math.abs(f3);
            if (!(f4 > f2)) continue;
            f2 = f5;
        }
        return f2;
    }

    public static Vector3d a(RealMatrix realMatrix) {
        return MathUtils.a(realMatrix, false);
    }

    public static Vector3d a(RealMatrix realMatrix, boolean bl2) {
        double d2;
        double d3;
        if (realMatrix.getRowDimension() != 4) {
            throw new DimensionMismatchException(realMatrix.getRowDimension(), 4);
        }
        if (realMatrix.getColumnDimension() != 4) {
            throw new DimensionMismatchException(realMatrix.getColumnDimension(), 4);
        }
        double[][] dArray = realMatrix.getData();
        if (dArray[2][0] != 1.0 && dArray[2][0] != -1.0) {
            double d4 = -Math.asin(dArray[2][0]);
            double d5 = Math.PI - d4;
            double d6 = Math.atan2(dArray[2][1] / Math.cos(d4), dArray[2][2] / Math.cos(d4));
            double d7 = Math.atan2(dArray[2][1] / Math.cos(d5), dArray[2][2] / Math.cos(d5));
            double d8 = Math.atan2(dArray[1][0] / Math.cos(d4), dArray[0][0] / Math.cos(d4));
            double d9 = Math.atan2(dArray[1][0] / Math.cos(d5), dArray[0][0] / Math.cos(d5));
            if (!bl2) {
                return new Vector3d(d6, d4, d8);
            }
            return new Vector3d(d7, d5, d9);
        }
        double d10 = 0.0;
        if (dArray[2][0] == -1.0) {
            d3 = 1.5707963267948966;
            d2 = d10 + Math.atan2(dArray[0][1], dArray[0][2]);
        } else {
            d3 = -1.5707963267948966;
            d2 = -d10 + Math.atan2(-dArray[0][1], -dArray[0][2]);
        }
        return new Vector3d(d2, d3, d10);
    }

    public static Point3d b(RealMatrix realMatrix) {
        return new Point3d(realMatrix.getEntry(0, 3), realMatrix.getEntry(1, 3), realMatrix.getEntry(2, 3));
    }

    public static RealMatrix a(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Math.sin(d5);
        double d9 = Math.cos(d5);
        double d10 = Math.sin(d6);
        double d11 = Math.cos(d6);
        double d12 = Math.sin(d7);
        double d13 = Math.cos(d7);
        double[][] dArray = new double[4][4];
        dArray[0] = new double[]{d13 * d11, d13 * d10 * d8 - d12 * d9, d13 * d10 * d9 + d12 * d8, d2};
        dArray[1] = new double[]{d12 * d11, d12 * d10 * d8 + d13 * d9, d12 * d10 * d9 - d13 * d8, d3};
        dArray[2] = new double[]{-d10, d11 * d8, d11 * d9, d4};
        dArray[3] = new double[]{0.0, 0.0, 0.0, 1.0};
        return MatrixUtils.createRealMatrix((double[][])dArray);
    }

    public static Matrix4f c(RealMatrix realMatrix) {
        double[][] dArray = realMatrix.getData();
        float[] fArray = new float[dArray.length * dArray[0].length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            for (int i3 = 0; i3 < dArray[0].length; ++i3) {
                fArray[i2 * dArray.length + i3] = (float)dArray[i2][i3];
            }
        }
        return new Matrix4f(fArray);
    }

    public static RealMatrix b(Matrix4f matrix4f) {
        double[][] dArray = new double[4][4];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            for (int i3 = 0; i3 < dArray[i2].length; ++i3) {
                dArray[i2][i3] = matrix4f.getElement(i2, i3);
            }
        }
        return MatrixUtils.createRealMatrix((double[][])dArray);
    }

    public static boolean f(float f2, float f3, float f4) {
        if (f3 < f4) {
            return f2 >= f3 && f2 <= f4;
        }
        return f2 >= f4 && f2 <= f3;
    }

    static {
        int[] nArray = new int[]{3, 3, 3};
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int i3 = 0; i3 < 3; ++i3) {
                for (int i4 = 0; i4 < 3; ++i4) {
                    MathUtils.d[(int)MathUtils.j((int[])new int[]{i2, i3, i4}, (int[])nArray)] = 127;
                    int n2 = 0;
                    if (i2 == 1) {
                        ++n2;
                    }
                    if (i3 == 1) {
                        ++n2;
                    }
                    if (i4 == 1) {
                        ++n2;
                    }
                    if (n2 < 2) continue;
                    MathUtils.c[(int)MathUtils.j((int[])new int[]{i2, i3, i4}, (int[])nArray)] = 127;
                }
            }
        }
    }

    public static enum TTestVarType {
        a,
        b,
        c;

    }

    public static enum TTestTailType {
        a,
        b;

    }

    public static enum Relationship {
        a,
        b,
        c,
        d,
        e;

    }
}

