/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint2d;
import com.mimvista.numerics.VoxelPoint2f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple4f;

public class MetricPoint2f
extends Point2f {
    private static final long serialVersionUID = 1L;
    private PresentationType plane;

    public MetricPoint2f(float f2, float f3, PresentationType presentationType) {
        super(f2, f3);
        this.plane = presentationType;
    }

    public MetricPoint2f(float[] fArray, PresentationType presentationType) {
        super(fArray);
        this.plane = presentationType;
    }

    public MetricPoint2f a() {
        return new MetricPoint2f(this.x, this.y, this.plane);
    }

    public VoxelPoint2f a(SimpleImageFrame simpleImageFrame) {
        float[] fArray = simpleImageFrame.J();
        return new VoxelPoint2f((this.x + fArray[this.plane.a()[0]]) / simpleImageFrame.b()[this.plane.a()[0]], (this.y + fArray[this.plane.a()[1]]) / simpleImageFrame.b()[this.plane.a()[1]], this.plane);
    }

    public VoxelPoint2d a(Point3f.PointVolumeInfo pointVolumeInfo) {
        return new VoxelPoint2d((this.x + pointVolumeInfo.originOffsetMM[this.plane.a()[0]]) / pointVolumeInfo.voxel[this.plane.a()[0]], (this.y + pointVolumeInfo.originOffsetMM[this.plane.a()[1]]) / pointVolumeInfo.voxel[this.plane.a()[1]]);
    }

    public static void a(Point2f point2f, PresentationType presentationType, SimpleImageFrame simpleImageFrame) {
        float[] fArray = simpleImageFrame.J();
        point2f.x = (point2f.x + fArray[presentationType.a()[0]]) / simpleImageFrame.b()[presentationType.a()[0]];
        point2f.y = (point2f.y + fArray[presentationType.a()[1]]) / simpleImageFrame.b()[presentationType.a()[1]];
    }

    public void a(Matrix4f matrix4f) {
        Point4f point4f = new Point4f(0.0f, 0.0f, 0.0f, 1.0f);
        float[] fArray = new float[4];
        fArray[this.plane.a()[0]] = this.x;
        fArray[this.plane.a()[1]] = this.y;
        fArray[3] = 1.0f;
        point4f.set(fArray);
        matrix4f.transform((Tuple4f)point4f);
        point4f.get(fArray);
        this.x = fArray[this.plane.a()[0]];
        this.y = fArray[this.plane.a()[1]];
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.plane == null ? 0 : this.plane.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MetricPoint2f metricPoint2f = (MetricPoint2f)((Object)object);
        return this.plane == metricPoint2f.plane;
    }

    @Override
    public /* synthetic */ Point2f b() {
        return this.a();
    }
}

