/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MetricViewingPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VolumePoint3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;

public class MetricPoint3f
extends VolumePoint3f {
    private static final long serialVersionUID = -7911624972297456527L;

    public MetricPoint3f(SimpleImageFrame simpleImageFrame) {
        this(new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public MetricPoint3f(float f2, float f3, float f4, Point3f.PointVolumeInfo pointVolumeInfo) {
        super(f2, f3, f4, pointVolumeInfo);
    }

    public MetricPoint3f(float f2, float f3, float f4, SimpleImageFrame simpleImageFrame) {
        super(f2, f3, f4, new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public MetricPoint3f(float[] fArray, SimpleImageFrame simpleImageFrame) {
        super(fArray, new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public MetricPoint3f(Point3f.PointVolumeInfo pointVolumeInfo) {
        super(pointVolumeInfo);
    }

    public MetricPoint3f(MetricPoint3f metricPoint3f) {
        super(metricPoint3f.x, metricPoint3f.y, metricPoint3f.z, metricPoint3f.pvi);
    }

    public MetricPoint3f(Tuple3f tuple3f, SimpleImageFrame simpleImageFrame) {
        super(tuple3f, new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public MetricPoint3f(int[] nArray, SimpleImageFrame simpleImageFrame) {
        this(new float[]{nArray[0], nArray[1], nArray[2]}, simpleImageFrame);
    }

    public MetricPoint3f(float[] fArray, Point3f.PointVolumeInfo pointVolumeInfo) {
        this(fArray[0], fArray[1], fArray[2], pointVolumeInfo);
    }

    public MetricPoint3f a() {
        MetricPoint3f metricPoint3f = new MetricPoint3f(this);
        return metricPoint3f;
    }

    public void a(VoxelPoint3f voxelPoint3f, Point3f.PointVolumeInfo pointVolumeInfo) {
        float[] fArray = pointVolumeInfo.originOffsetMM;
        voxelPoint3f.x = (this.x + fArray[0]) / pointVolumeInfo.voxel[0];
        voxelPoint3f.y = (this.y + fArray[1]) / pointVolumeInfo.voxel[1];
        voxelPoint3f.z = (this.z + fArray[2]) / pointVolumeInfo.voxel[2];
    }

    public void a(VoxelPoint3f voxelPoint3f, SimpleImageFrame simpleImageFrame) {
        this.a(voxelPoint3f, new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public void a(VoxelPoint3f voxelPoint3f) {
        this.a(voxelPoint3f, this.pvi);
    }

    public VoxelPoint3f a(Point3f.PointVolumeInfo pointVolumeInfo) {
        VoxelPoint3f voxelPoint3f = new VoxelPoint3f(pointVolumeInfo);
        this.a(voxelPoint3f, pointVolumeInfo);
        return voxelPoint3f;
    }

    public VoxelPoint3f b() {
        return this.a(this.pvi);
    }

    public void a(VoxelIndexPoint3f voxelIndexPoint3f, Point3f.PointVolumeInfo pointVolumeInfo) {
        float[] fArray = pointVolumeInfo.originOffsetMM;
        voxelIndexPoint3f.x = (this.x + fArray[0]) / pointVolumeInfo.voxel[0] - 0.5f;
        voxelIndexPoint3f.y = (this.y + fArray[1]) / pointVolumeInfo.voxel[1] - 0.5f;
        voxelIndexPoint3f.z = (this.z + fArray[2]) / pointVolumeInfo.voxel[2] - 0.5f;
    }

    public void a(VoxelIndexPoint3f voxelIndexPoint3f) {
        this.a(voxelIndexPoint3f, this.pvi);
    }

    public VoxelIndexPoint3f b(Point3f.PointVolumeInfo pointVolumeInfo) {
        VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(pointVolumeInfo);
        this.a(voxelIndexPoint3f, pointVolumeInfo);
        return voxelIndexPoint3f;
    }

    public VoxelIndexPoint3f c() {
        return this.b(this.pvi);
    }

    public VoxelPoint3f a(SimpleImageFrame simpleImageFrame) {
        return this.c(new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public VoxelPoint3f c(Point3f.PointVolumeInfo pointVolumeInfo) {
        return this.a(pointVolumeInfo);
    }

    public MetricViewingPoint3f a(Matrix4f matrix4f) {
        MetricViewingPoint3f metricViewingPoint3f = new MetricViewingPoint3f(this.x, this.y, this.z, this.pvi);
        matrix4f = new Matrix4f(matrix4f);
        matrix4f.invert();
        matrix4f.transform((javax.vecmath.Point3f)metricViewingPoint3f);
        return metricViewingPoint3f;
    }

    public DicomPoint3f b(SimpleImageFrame simpleImageFrame) {
        return this.d(new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public DicomPoint3f d() {
        return this.d(this.pvi);
    }

    public void a(DicomPoint3f dicomPoint3f) {
        this.a(dicomPoint3f, dicomPoint3f.pvi);
    }

    public DicomPoint3f d(Point3f.PointVolumeInfo pointVolumeInfo) {
        DicomPoint3f dicomPoint3f = new DicomPoint3f(pointVolumeInfo);
        this.a(dicomPoint3f, pointVolumeInfo);
        return dicomPoint3f;
    }

    public void a(DicomPoint3f dicomPoint3f, Point3f.PointVolumeInfo pointVolumeInfo) {
        dicomPoint3f.set(pointVolumeInfo.dicomCenter);
        float[] fArray = pointVolumeInfo.iop;
        float[] fArray2 = SimpleOrientationHelper.a(fArray, pointVolumeInfo.appliedGantryDetectorTilt);
        dicomPoint3f.x += this.x * fArray[0] + this.y * fArray[3] - this.z * fArray2[0];
        dicomPoint3f.y += this.x * fArray[1] + this.y * fArray[4] - this.z * fArray2[1];
        dicomPoint3f.z += this.x * fArray[2] + this.y * fArray[5] - this.z * fArray2[2];
    }

    public void b(DicomPoint3f dicomPoint3f) {
        dicomPoint3f.x = 0.0f;
        dicomPoint3f.y = 0.0f;
        dicomPoint3f.z = 0.0f;
        float[] fArray = this.pvi.iop;
        float[] fArray2 = SimpleOrientationHelper.a(fArray, this.pvi.appliedGantryDetectorTilt);
        dicomPoint3f.x += this.x * fArray[0] + this.y * fArray[3] - this.z * fArray2[0];
        dicomPoint3f.y += this.x * fArray[1] + this.y * fArray[4] - this.z * fArray2[1];
        dicomPoint3f.z += this.x * fArray[2] + this.y * fArray[5] - this.z * fArray2[2];
    }

    @Override
    public /* synthetic */ Point3f e() {
        return this.a();
    }
}

