/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.numerics.MultipliedVoxelPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VolumePoint3i;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelIndexPoint3i;
import com.mimvista.numerics.VoxelPoint3f;
import java.util.Arrays;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;

public class MultipliedIndexPoint3i
extends VolumePoint3i {
    private static final long serialVersionUID = 1L;
    private int[] multiplier = new int[]{1, 1, 1};

    public static MultipliedIndexPoint3i a(int n2, int n3, int n4, int[] nArray, Point3f.PointVolumeInfo pointVolumeInfo) {
        MultipliedIndexPoint3i multipliedIndexPoint3i = new MultipliedIndexPoint3i(0, 0, 0, nArray, pointVolumeInfo);
        multipliedIndexPoint3i.x = n2 * nArray[0];
        multipliedIndexPoint3i.y = n3 * nArray[1];
        multipliedIndexPoint3i.z = n4 * nArray[2];
        return multipliedIndexPoint3i;
    }

    public static MultipliedIndexPoint3i a(int n2, int n3, int n4, int[] nArray, SimpleImageFrame simpleImageFrame) {
        return MultipliedIndexPoint3i.a(n2, n3, n4, nArray, new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public static MultipliedIndexPoint3i b(int n2, int n3, int n4, int[] nArray, SimpleImageFrame simpleImageFrame) {
        return new MultipliedIndexPoint3i(n2, n3, n4, nArray, simpleImageFrame);
    }

    public static MultipliedIndexPoint3i b(int n2, int n3, int n4, int[] nArray, Point3f.PointVolumeInfo pointVolumeInfo) {
        return new MultipliedIndexPoint3i(n2, n3, n4, nArray, pointVolumeInfo);
    }

    public static MultipliedIndexPoint3i a(VoxelIndexPoint3f voxelIndexPoint3f, int[] nArray) {
        MultipliedIndexPoint3i multipliedIndexPoint3i = new MultipliedIndexPoint3i(0, 0, 0, nArray, voxelIndexPoint3f.pvi);
        MultipliedIndexPoint3i.a(voxelIndexPoint3f, nArray, multipliedIndexPoint3i);
        return multipliedIndexPoint3i;
    }

    public static void a(VoxelIndexPoint3f voxelIndexPoint3f, int[] nArray, MultipliedIndexPoint3i multipliedIndexPoint3i) {
        multipliedIndexPoint3i.x = Math.round((voxelIndexPoint3f.x + 0.5f) * (float)nArray[0] - 0.5f);
        multipliedIndexPoint3i.y = Math.round((voxelIndexPoint3f.y + 0.5f) * (float)nArray[1] - 0.5f);
        multipliedIndexPoint3i.z = Math.round((voxelIndexPoint3f.z + 0.5f) * (float)nArray[2] - 0.5f);
    }

    public static MultipliedIndexPoint3i a(VoxelPoint3f voxelPoint3f, int[] nArray) {
        MultipliedIndexPoint3i multipliedIndexPoint3i = new MultipliedIndexPoint3i(0, 0, 0, nArray, voxelPoint3f.pvi);
        multipliedIndexPoint3i.x = (int)Math.floor(voxelPoint3f.x * (float)nArray[0]);
        multipliedIndexPoint3i.y = (int)Math.floor(voxelPoint3f.y * (float)nArray[1]);
        multipliedIndexPoint3i.z = (int)Math.floor(voxelPoint3f.z * (float)nArray[2]);
        return multipliedIndexPoint3i;
    }

    public static MultipliedIndexPoint3i a(MultipliedVoxelPoint3f multipliedVoxelPoint3f) {
        return new MultipliedIndexPoint3i((int)multipliedVoxelPoint3f.x, (int)multipliedVoxelPoint3f.y, (int)multipliedVoxelPoint3f.z, multipliedVoxelPoint3f.a(), multipliedVoxelPoint3f.pvi);
    }

    private MultipliedIndexPoint3i(SimpleImageFrame simpleImageFrame) {
        this(0, 0, 0, simpleImageFrame.C(), new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public MultipliedIndexPoint3i(int n2, int n3, int n4, int[] nArray, Point3f.PointVolumeInfo pointVolumeInfo) {
        super(n2, n3, n4, pointVolumeInfo);
        this.a(nArray);
    }

    private MultipliedIndexPoint3i(int n2, int n3, int n4, int[] nArray, SimpleImageFrame simpleImageFrame) {
        this(n2, n3, n4, nArray, new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    private MultipliedIndexPoint3i(int n2, int n3, int n4, SimpleContour simpleContour) {
        this(n2, n3, n4, simpleContour.v(), new Point3f.PointVolumeInfo(simpleContour.q()));
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Arrays.hashCode(this.multiplier);
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MultipliedIndexPoint3i multipliedIndexPoint3i = (MultipliedIndexPoint3i)((Object)object);
        return Arrays.equals(this.multiplier, multipliedIndexPoint3i.multiplier);
    }

    public int[] a() {
        return this.multiplier;
    }

    public void a(int[] nArray) {
        if (nArray.length != 3) {
            throw new IllegalArgumentException("multiplier must be of size 3");
        }
        this.multiplier = nArray;
    }

    public VoxelIndexPoint3i b() {
        return new VoxelIndexPoint3i(this.x / this.multiplier[0], this.y / this.multiplier[1], this.z / this.multiplier[2], this.pvi);
    }

    public VoxelIndexPoint3f c() {
        VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(0.0f, 0.0f, 0.0f, this.pvi);
        this.a(voxelIndexPoint3f);
        return voxelIndexPoint3f;
    }

    public MultipliedVoxelPoint3f d() {
        return new MultipliedVoxelPoint3f((float)this.x + 0.5f, (float)this.y + 0.5f, (float)this.z + 0.5f, this.multiplier, this.pvi);
    }

    public void a(VoxelIndexPoint3f voxelIndexPoint3f) {
        voxelIndexPoint3f.x = ((float)this.x + 0.5f) / (float)this.multiplier[0] - 0.5f;
        voxelIndexPoint3f.y = ((float)this.y + 0.5f) / (float)this.multiplier[1] - 0.5f;
        voxelIndexPoint3f.z = ((float)this.z + 0.5f) / (float)this.multiplier[2] - 0.5f;
    }

    public static void a(Tuple3i tuple3i, int[] nArray) {
        tuple3i.x *= nArray[0];
        tuple3i.y *= nArray[1];
        tuple3i.z *= nArray[2];
    }

    public static void a(Tuple3f tuple3f, int[] nArray) {
        tuple3f.x *= (float)nArray[0];
        tuple3f.y *= (float)nArray[1];
        tuple3f.z *= (float)nArray[2];
    }

    public static void b(Tuple3i tuple3i, int[] nArray) {
        tuple3i.x /= nArray[0];
        tuple3i.y /= nArray[1];
        tuple3i.z /= nArray[2];
    }

    public static void b(Tuple3f tuple3f, int[] nArray) {
        tuple3f.x /= (float)nArray[0];
        tuple3f.y /= (float)nArray[1];
        tuple3f.z /= (float)nArray[2];
    }

    public static MultipliedIndexPoint3i a(SimpleImageFrame simpleImageFrame) {
        return MultipliedIndexPoint3i.a(0, 0, 0, simpleImageFrame.C(), simpleImageFrame);
    }

    public static MultipliedIndexPoint3i a(int n2, int n3, int n4, SimpleContour simpleContour) {
        return new MultipliedIndexPoint3i(n2, n3, n4, simpleContour);
    }

    public MultipliedIndexPoint3i e() {
        return (MultipliedIndexPoint3i)((Object)super.clone());
    }

    public /* synthetic */ Object clone() {
        return this.e();
    }
}

