/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.MetricPoint2f;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;

public class MultipliedVoxelPoint2f
extends Point2f {
    private static final long serialVersionUID = 1L;
    private PresentationType plane;
    private int xMult;
    private int yMult;

    public MultipliedVoxelPoint2f(float f2, float f3, PresentationType presentationType, int n2, int n3) {
        super(f2, f3);
        this.plane = presentationType;
        this.xMult = n2;
        this.yMult = n3;
    }

    public MultipliedVoxelPoint2f(float[] fArray, PresentationType presentationType, int n2, int n3) {
        super(fArray);
        this.plane = presentationType;
        this.xMult = n2;
        this.yMult = n3;
    }

    public MultipliedVoxelPoint2f a() {
        return new MultipliedVoxelPoint2f(this.x, this.y, this.plane, this.xMult, this.yMult);
    }

    public PresentationType c() {
        return this.plane;
    }

    public static void a(Point2f point2f, PresentationType presentationType, SimpleImageFrame simpleImageFrame, int n2, int n3) {
        float[] fArray = simpleImageFrame.J();
        point2f.x = point2f.x * simpleImageFrame.b()[presentationType.a()[0]] / (float)n2 - fArray[presentationType.a()[0]];
        point2f.y = point2f.y * simpleImageFrame.b()[presentationType.a()[1]] / (float)n3 - fArray[presentationType.a()[1]];
    }

    public MetricPoint2f a(SimpleImageFrame simpleImageFrame) {
        return this.a(new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public MetricPoint2f a(Point3f.PointVolumeInfo pointVolumeInfo) {
        if (this.plane == null) {
            return null;
        }
        float[] fArray = pointVolumeInfo.originOffsetMM;
        MetricPoint2f metricPoint2f = new MetricPoint2f(this.x * pointVolumeInfo.voxel[this.plane.a()[0]] / (float)this.xMult - fArray[this.plane.a()[0]], this.y * pointVolumeInfo.voxel[this.plane.a()[1]] / (float)this.yMult - fArray[this.plane.a()[1]], this.plane);
        return metricPoint2f;
    }

    @Override
    public /* synthetic */ Point2f b() {
        return this.a();
    }
}

