/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedVoxelPoint3f;
import com.mimvista.numerics.Point3d;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VolumePoint3d;
import com.mimvista.numerics.VoxelPoint3d;
import java.util.Arrays;

public class MultipliedVoxelPoint3d
extends VolumePoint3d {
    private static final long serialVersionUID = 1L;
    private int[] multiplier;

    public MultipliedVoxelPoint3d(Point3f.PointVolumeInfo pointVolumeInfo, int[] nArray) {
        super(pointVolumeInfo);
        this.multiplier = nArray;
    }

    public MultipliedVoxelPoint3d(double d2, double d3, double d4, int[] nArray, Point3f.PointVolumeInfo pointVolumeInfo) {
        super(d2, d3, d4, pointVolumeInfo);
        this.multiplier = nArray;
    }

    public MultipliedVoxelPoint3d(MultipliedVoxelPoint3f multipliedVoxelPoint3f) {
        this(multipliedVoxelPoint3f.x, multipliedVoxelPoint3f.y, multipliedVoxelPoint3f.z, multipliedVoxelPoint3f.a(), multipliedVoxelPoint3f.pvi);
    }

    public MultipliedVoxelPoint3d(MultipliedVoxelPoint3d multipliedVoxelPoint3d) {
        this(multipliedVoxelPoint3d.x, multipliedVoxelPoint3d.y, multipliedVoxelPoint3d.z, multipliedVoxelPoint3d.multiplier, multipliedVoxelPoint3d.pvi);
    }

    public MultipliedVoxelPoint3d(VoxelPoint3d voxelPoint3d, int[] nArray) {
        this(voxelPoint3d.x * (double)nArray[0], voxelPoint3d.y * (double)nArray[1], voxelPoint3d.z * (double)nArray[2], nArray, voxelPoint3d.pvi);
    }

    public MultipliedVoxelPoint3d a() {
        return new MultipliedVoxelPoint3d(this);
    }

    public MultipliedVoxelPoint3f b() {
        return new MultipliedVoxelPoint3f((float)this.x, (float)this.y, (float)this.z, this.multiplier, this.pvi);
    }

    public void a(MetricPoint3f metricPoint3f, Point3f.PointVolumeInfo pointVolumeInfo) {
        float[] fArray = pointVolumeInfo.originOffsetMM;
        metricPoint3f.x = (float)(this.x * (double)pointVolumeInfo.voxel[0] / (double)this.multiplier[0] - (double)fArray[0]);
        metricPoint3f.y = (float)(this.y * (double)pointVolumeInfo.voxel[1] / (double)this.multiplier[1] - (double)fArray[1]);
        metricPoint3f.z = (float)(this.z * (double)pointVolumeInfo.voxel[2] / (double)this.multiplier[2] - (double)fArray[2]);
    }

    public void a(MetricPoint3f metricPoint3f) {
        this.a(metricPoint3f, this.pvi);
    }

    public MetricPoint3f a(Point3f.PointVolumeInfo pointVolumeInfo) {
        MetricPoint3f metricPoint3f = new MetricPoint3f(pointVolumeInfo);
        this.a(metricPoint3f, pointVolumeInfo);
        return metricPoint3f;
    }

    public MetricPoint3f c() {
        return this.a(this.pvi);
    }

    public VoxelPoint3d d() {
        VoxelPoint3d voxelPoint3d = new VoxelPoint3d(this.pvi);
        voxelPoint3d.x = this.x / (double)this.multiplier[0];
        voxelPoint3d.y = this.y / (double)this.multiplier[1];
        voxelPoint3d.z = this.z / (double)this.multiplier[2];
        return voxelPoint3d;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Arrays.hashCode(this.multiplier);
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MultipliedVoxelPoint3d multipliedVoxelPoint3d = (MultipliedVoxelPoint3d)((Object)object);
        return Arrays.equals(this.multiplier, multipliedVoxelPoint3d.multiplier);
    }

    @Override
    public /* synthetic */ Point3d e() {
        return this.a();
    }
}

