/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.numerics.AbstractVoxelPoint3f;
import com.mimvista.numerics.MultipliedIndexPoint3i;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint3f;
import java.util.Arrays;

public class MultipliedVoxelPoint3f
extends AbstractVoxelPoint3f {
    private static final long serialVersionUID = 1L;
    private int[] multiplier;

    public MultipliedVoxelPoint3f(Point3f.PointVolumeInfo pointVolumeInfo, int[] nArray) {
        super(pointVolumeInfo);
        this.multiplier = nArray;
    }

    public MultipliedVoxelPoint3f(MultipliedIndexPoint3i multipliedIndexPoint3i) {
        this(multipliedIndexPoint3i.g(), multipliedIndexPoint3i.a());
        this.x = (float)multipliedIndexPoint3i.x + 0.5f;
        this.y = (float)multipliedIndexPoint3i.y + 0.5f;
        this.z = (float)multipliedIndexPoint3i.z + 0.5f;
    }

    public MultipliedVoxelPoint3f(VoxelPoint3f voxelPoint3f, int[] nArray) {
        super(voxelPoint3f);
        this.multiplier = nArray;
        this.x *= (float)nArray[0];
        this.y *= (float)nArray[1];
        this.z *= (float)nArray[2];
    }

    public MultipliedVoxelPoint3f(float f2, float f3, float f4, int[] nArray, Point3f.PointVolumeInfo pointVolumeInfo) {
        super(f2, f3, f4, pointVolumeInfo);
        this.multiplier = nArray;
    }

    public int[] a() {
        return (int[])this.multiplier.clone();
    }

    public int a(int n2) {
        return this.multiplier[n2];
    }

    public MultipliedVoxelPoint3f b() {
        return new MultipliedVoxelPoint3f(this.x, this.y, this.z, (int[])this.multiplier.clone(), this.pvi);
    }

    public MultipliedIndexPoint3i c() {
        return MultipliedIndexPoint3i.a(this);
    }

    public VoxelPoint3f d() {
        return new VoxelPoint3f(this.x / (float)this.multiplier[0], this.y / (float)this.multiplier[1], this.z / (float)this.multiplier[2], this.pvi);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Arrays.hashCode(this.multiplier);
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        MultipliedVoxelPoint3f multipliedVoxelPoint3f = (MultipliedVoxelPoint3f)((Object)object);
        return Arrays.equals(this.multiplier, multipliedVoxelPoint3f.multiplier);
    }

    @Override
    public /* synthetic */ Point3f e() {
        return this.b();
    }
}

