/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.ae;
import com.mimvista.numerics.af;
import com.mimvista.numerics.optimization.c;
import com.mimvista.properties.af;
import com.mimvista.util.ay;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class ParticleSwarmOptimization
implements c<ae>,
Serializable {
    private static final long serialVersionUID = 4672964319990595393L;
    private static final float a = 0.729f;
    private static final float b = 2.0f;
    private PsoParameters parameters;
    private Particle[] particles;
    private float[] globalBest;
    private float globalScore;
    private Random r;
    private File logFolder;
    private int iteration = 0;
    private transient af.b<ae> c;
    private transient Map<ae, Float> d = new HashMap<ae, Float>();

    public ParticleSwarmOptimization() {
        this(System.currentTimeMillis());
    }

    public ParticleSwarmOptimization(long l2) {
        this.parameters = new PsoParameters();
        this.globalScore = this.parameters.shouldMinimize ? Float.MAX_VALUE : -3.4028235E38f;
        this.r = new Random(l2);
    }

    public ParticleSwarmOptimization(PsoParameters psoParameters, af.b<ae> b2) {
        this(psoParameters, b2, 0xABACABBL);
    }

    public ParticleSwarmOptimization(PsoParameters psoParameters, af.b<ae> b2, long l2) {
        this.parameters = psoParameters.a();
        this.c = b2;
        this.globalScore = psoParameters.shouldMinimize ? Float.MAX_VALUE : -3.4028235E38f;
        this.r = new Random(l2);
        this.b();
    }

    public ae a() {
        for (int i2 = 0; i2 < this.parameters.dimensions; ++i2) {
            if (!(this.parameters.lowerBound[i2] > this.parameters.upperBound[i2])) continue;
            throw new IllegalStateException("PSO bounds are invalid - lower bound is numerically greater than upper bound.");
        }
        this.f();
        this.d();
        this.iteration = 0;
        this.f();
        while (this.iteration++ < this.parameters.numIterations) {
            if (this.iteration % 1000 == 0) {
                ay.e("Iteration " + this.iteration);
            }
            this.e();
            this.d();
            this.f();
        }
        return new ae((float[])this.globalBest.clone());
    }

    @Override
    public void a(float[] fArray, float[] fArray2) {
        if (fArray.length != fArray2.length) {
            throw new RuntimeException("Array sizes do not match!");
        }
        float[] fArray3 = new float[fArray.length];
        float[] fArray4 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray3[i2] = fArray[i2] - fArray2[i2];
            fArray4[i2] = fArray[i2] + fArray2[i2];
        }
        this.b(fArray3, fArray4);
    }

    @Override
    public void a(int n2) {
        this.parameters.numIterations = n2;
    }

    @Override
    public void a(af.b<ae> b2) {
        this.c = b2;
    }

    @Override
    public void a(float f2) {
    }

    public void b(float[] fArray, float[] fArray2) {
        this.parameters.dimensions = Math.min(fArray.length, fArray2.length);
        this.parameters.lowerBound = (float[])fArray.clone();
        this.parameters.upperBound = (float[])fArray2.clone();
        if (this.parameters.numParticles < 0) {
            this.parameters.numParticles = Math.min(14, this.parameters.dimensions * 3);
        }
        this.b();
    }

    public void a(File file) {
        this.logFolder = file;
    }

    private void b() {
        this.particles = new Particle[this.parameters.numParticles];
        for (int i2 = 0; i2 < this.particles.length; ++i2) {
            this.particles[i2] = new Particle(this.parameters.dimensions, this.parameters.shouldMinimize);
            for (int i3 = 0; i3 < this.parameters.dimensions; ++i3) {
                float f2 = this.r.nextFloat();
                float f3 = this.parameters.upperBound[i3] - this.parameters.lowerBound[i3];
                f2 *= f3;
                this.particles[i2].position[i3] = f2 += this.parameters.lowerBound[i3];
                f2 = this.r.nextFloat();
                f2 -= 0.5f;
                f2 *= 2.0f;
                this.particles[i2].velocity[i3] = f2 *= f3;
            }
            this.particles[i2].localBest = (float[])this.particles[i2].position.clone();
        }
    }

    private void d() {
        for (Particle particle : this.particles) {
            float f2 = particle.a();
            if (this.parameters.shouldMinimize) {
                if (!(f2 < this.globalScore)) continue;
                this.globalScore = f2;
                this.globalBest = (float[])particle.position.clone();
                continue;
            }
            if (!(f2 > this.globalScore)) continue;
            this.globalScore = f2;
            this.globalBest = (float[])particle.position.clone();
        }
    }

    private void e() {
        for (Particle particle : this.particles) {
            for (int i2 = 0; i2 < this.parameters.dimensions; ++i2) {
                float f2 = this.r.nextFloat();
                float f3 = this.r.nextFloat();
                particle.velocity[i2] = 0.729f * particle.velocity[i2] + 2.0f * f2 * (particle.localBest[i2] - particle.position[i2]) + 2.0f * f3 * (this.globalBest[i2] - particle.position[i2]);
                particle.position[i2] = MathUtils.c(particle.position[i2], this.parameters.lowerBound[i2], this.parameters.upperBound[i2]);
                while (!this.a(particle.position[i2] + particle.velocity[i2], this.parameters.lowerBound[i2], this.parameters.upperBound[i2])) {
                    int n2 = i2;
                    particle.velocity[n2] = particle.velocity[n2] * -0.5f;
                }
                int n3 = i2;
                particle.position[n3] = particle.position[n3] + particle.velocity[i2];
            }
        }
    }

    private boolean a(float f2, float f3, float f4) {
        return f2 >= f3 && f2 <= f4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f() {
        if (this.logFolder != null) {
            Object object;
            for (int i2 = 0; i2 < this.particles.length; ++i2) {
                object = this.b(i2);
                Particle particle = this.particles[i2];
                ((af)object).setConfig("" + this.iteration, Arrays.toString(particle.position));
                object = af.getPrefs(this.logFolder.getAbsolutePath(), "ParticleState.txt");
            }
            FileOutputStream fileOutputStream = null;
            object = null;
            try {
                fileOutputStream = new FileOutputStream(new File(this.logFolder, "PSO.st"));
                object = new ObjectOutputStream(fileOutputStream);
                ((ObjectOutputStream)object).writeObject(this);
            }
            catch (Exception exception) {
                ay.d((Object)"Exception saving PSO state", (Throwable)exception, this.getClass());
            }
            finally {
                if (object != null) {
                    try {
                        ((ObjectOutputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private af b(int n2) {
        return af.getPrefs(this.logFolder.getAbsolutePath(), "Particle" + n2 + ".txt");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.d = new HashMap<ae, Float>();
    }

    public static void main(String[] stringArray) {
        PsoParameters psoParameters = new PsoParameters(2, new float[]{-10.0f, -10.0f}, new float[]{10.0f, 10.0f});
        psoParameters.numIterations = 60;
        psoParameters.shouldMinimize = true;
        ParticleSwarmOptimization particleSwarmOptimization = new ParticleSwarmOptimization(psoParameters, new af.b<ae>(){

            @Override
            public int a() {
                return 2;
            }

            @Override
            public float a(ae ae2) {
                return 2.0f - this.a(ae2.a[0]) - this.a(ae2.a[1]);
            }

            @Override
            private float a(float f2) {
                double d2 = Math.sin((double)(f2 + 10.0f) * Math.PI / 20.0);
                double d3 = Math.cos(f2);
                return (float)(d2 * d3);
            }
        });
        ae ae2 = particleSwarmOptimization.a();
        System.out.println("Answer should be 0, 0:");
        System.out.println(Arrays.toString(ae2.a));
    }

    @Override
    public /* synthetic */ Object c() {
        return this.a();
    }

    private class Particle
    implements Serializable {
        private static final long serialVersionUID = 5884711742710485490L;
        float[] position;
        float[] localBest;
        float[] velocity;
        float bestScore;

        Particle(int n2, boolean bl2) {
            this.position = new float[n2];
            this.localBest = new float[n2];
            this.velocity = new float[n2];
            this.bestScore = bl2 ? Float.MAX_VALUE : -3.4028235E38f;
        }

        float a() {
            ae ae2 = new ae(this.position, false);
            Float f2 = (Float)ParticleSwarmOptimization.this.d.get(ae2);
            if (f2 != null) {
                return f2.floatValue();
            }
            float f3 = ParticleSwarmOptimization.this.c.a(ae2);
            ParticleSwarmOptimization.this.d.put(ae2, Float.valueOf(f3));
            if (ParticleSwarmOptimization.this.logFolder != null) {
                af af2 = af.getPrefs(ParticleSwarmOptimization.this.logFolder.getAbsolutePath(), "Scores.txt");
                af2.setConfig(Arrays.toString(this.position), f3);
                af2.storeConfig();
            }
            if (f3 < this.bestScore) {
                this.bestScore = f3;
                this.localBest = (float[])this.position.clone();
            }
            return f3;
        }
    }

    public static class PsoParameters
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -5815252170661083404L;
        public int dimensions = -1;
        public int numParticles = -1;
        public int numIterations = 100;
        public float[] lowerBound = null;
        public float[] upperBound = null;
        public boolean shouldMinimize = true;

        public PsoParameters() {
        }

        public PsoParameters(int n2, float[] fArray, float[] fArray2) {
            this.dimensions = n2;
            this.lowerBound = (float[])fArray.clone();
            this.upperBound = (float[])fArray2.clone();
            this.numIterations = 20 * n2;
            this.numParticles = 8 * n2;
            this.shouldMinimize = true;
        }

        protected PsoParameters a() {
            try {
                PsoParameters psoParameters = (PsoParameters)super.clone();
                psoParameters.lowerBound = (float[])this.lowerBound.clone();
                psoParameters.upperBound = (float[])this.upperBound.clone();
                return psoParameters;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }

        protected /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.a();
        }
    }
}

