/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.numerics.MathUtils;
import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class Point3f
extends javax.vecmath.Point3f {
    private static final long serialVersionUID = 1L;

    public Point3f() {
    }

    public Point3f(float f2, float f3, float f4) {
        super(f2, f3, f4);
    }

    public Point3f(float[] fArray) {
        super(fArray);
    }

    public Point3f(Tuple3f tuple3f) {
        super(tuple3f);
    }

    public float[] f() {
        return new float[]{this.x, this.y, this.z};
    }

    public Point3f e() {
        return new Point3f(this.x, this.y, this.z);
    }

    public float b(int n2) {
        if (n2 == 0) {
            return this.x;
        }
        if (n2 == 1) {
            return this.y;
        }
        return this.z;
    }

    public void a(int n2, float f2) {
        if (n2 == 0) {
            this.x = f2;
        } else if (n2 == 1) {
            this.y = f2;
        } else {
            this.z = f2;
        }
    }

    public void a(float[][] fArray) {
        float f2 = fArray[0][0] * this.x + fArray[1][0] * this.y + fArray[2][0] * this.z + fArray[3][0];
        float f3 = fArray[0][1] * this.x + fArray[1][1] * this.y + fArray[2][1] * this.z + fArray[3][1];
        float f4 = fArray[0][2] * this.x + fArray[1][2] * this.y + fArray[2][2] * this.z + fArray[3][2];
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public void a(float[][] fArray, Point3f point3f) {
        this.x = fArray[0][0] * point3f.x + fArray[1][0] * point3f.y + fArray[2][0] * point3f.z + fArray[3][0];
        this.y = fArray[0][1] * point3f.x + fArray[1][1] * point3f.y + fArray[2][1] * point3f.z + fArray[3][1];
        this.z = fArray[0][2] * point3f.x + fArray[1][2] * point3f.y + fArray[2][2] * point3f.z + fArray[3][2];
    }

    public void b(float[][] fArray) {
        float f2 = fArray[0][0] * this.x + fArray[0][1] * this.y + fArray[0][2] * this.z + fArray[0][3];
        float f3 = fArray[1][0] * this.x + fArray[1][1] * this.y + fArray[1][2] * this.z + fArray[1][3];
        float f4 = fArray[2][0] * this.x + fArray[2][1] * this.y + fArray[2][2] * this.z + fArray[2][3];
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public void b(Matrix4f matrix4f) {
        Point4f point4f = new Point4f(0.0f, 0.0f, 0.0f, 1.0f);
        point4f.x = this.x;
        point4f.y = this.y;
        point4f.z = this.z;
        matrix4f.transform((Tuple4f)point4f);
        this.x = point4f.x;
        this.y = point4f.y;
        this.z = point4f.z;
    }

    public void a(Matrix4f matrix4f, Point3f point3f) {
        Point4f point4f = new Point4f(0.0f, 0.0f, 0.0f, 1.0f);
        point4f.x = point3f.x;
        point4f.y = point3f.y;
        point4f.z = point3f.z;
        matrix4f.transform((Tuple4f)point4f);
        point3f.x = this.x;
        point3f.y = this.y;
        point3f.z = this.z;
    }

    public boolean a(Point3f point3f, float f2) {
        return Math.abs(point3f.x - this.x) < f2 && Math.abs(point3f.y - this.y) < f2 && Math.abs(point3f.z - this.z) < f2;
    }

    public Vector3f g() {
        return new Vector3f(this.x, this.y, this.z);
    }

    public void a(Tuple3f tuple3f) {
        this.x *= tuple3f.x;
        this.y *= tuple3f.y;
        this.z *= tuple3f.z;
    }

    public boolean a(Tuple3f tuple3f, float f2) {
        return this.x <= tuple3f.x + f2 && this.y <= tuple3f.y + f2 && this.z <= tuple3f.z + f2;
    }

    public boolean b(Tuple3f tuple3f, float f2) {
        return this.x >= tuple3f.x - f2 && this.y >= tuple3f.y - f2 && this.z >= tuple3f.z - f2;
    }

    public void h() {
        this.x = 1.0f / this.x;
        this.y = 1.0f / this.y;
        this.z = 1.0f / this.z;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = (int)((float)(31 * n3) + this.x);
        n3 = (int)((float)(31 * n3) + this.y);
        n3 = (int)((float)(31 * n3) + this.z);
        return n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Point3f point3f = (Point3f)((Object)object);
        if (this.x != point3f.x) {
            return false;
        }
        if (this.y != point3f.y) {
            return false;
        }
        return this.z == point3f.z;
    }

    public void a(float[] fArray) {
        this.x += fArray[0];
        this.y += fArray[1];
        this.z += fArray[2];
    }

    public void b(float[] fArray) {
        this.x -= fArray[0];
        this.y -= fArray[1];
        this.z -= fArray[2];
    }

    public void a(Tuple3f tuple3f, Tuple3f tuple3f2) {
        this.x = MathUtils.c(this.x, tuple3f.x, tuple3f2.x);
        this.y = MathUtils.c(this.y, tuple3f.y, tuple3f2.y);
        this.z = MathUtils.c(this.z, tuple3f.z, tuple3f2.z);
    }

    public static class PointVolumeInfo
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -3640358983028127625L;
        public final float[] dicomCenter;
        public final Float appliedGantryDetectorTilt;
        public final float[] iop;
        public final float[] voxel;
        public final float[] originOffsetMM;

        public PointVolumeInfo(SimpleImageFrame simpleImageFrame) {
            this((float[])simpleImageFrame.G().clone(), simpleImageFrame.getUncopiedMutableInfo().H(), (float[])simpleImageFrame.getUncopiedMutableInfo().imageOrientation.clone(), (float[])simpleImageFrame.b().clone(), (float[])simpleImageFrame.J().clone());
        }

        public PointVolumeInfo(float[] fArray, Float f2, float[] fArray2, float[] fArray3, float[] fArray4) {
            this.dicomCenter = fArray;
            this.appliedGantryDetectorTilt = f2;
            this.iop = fArray2;
            this.voxel = fArray3;
            this.originOffsetMM = fArray4;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.appliedGantryDetectorTilt == null ? 0 : this.appliedGantryDetectorTilt.hashCode());
            n3 = 31 * n3 + Arrays.hashCode(this.dicomCenter);
            n3 = 31 * n3 + Arrays.hashCode(this.iop);
            n3 = 31 * n3 + Arrays.hashCode(this.originOffsetMM);
            n3 = 31 * n3 + Arrays.hashCode(this.voxel);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PointVolumeInfo pointVolumeInfo = (PointVolumeInfo)object;
            if (this.appliedGantryDetectorTilt == null ? pointVolumeInfo.appliedGantryDetectorTilt != null : !this.appliedGantryDetectorTilt.equals(pointVolumeInfo.appliedGantryDetectorTilt)) {
                return false;
            }
            if (!Arrays.equals(this.dicomCenter, pointVolumeInfo.dicomCenter)) {
                return false;
            }
            if (!Arrays.equals(this.iop, pointVolumeInfo.iop)) {
                return false;
            }
            if (!Arrays.equals(this.originOffsetMM, pointVolumeInfo.originOffsetMM)) {
                return false;
            }
            return Arrays.equals(this.voxel, pointVolumeInfo.voxel);
        }

        public boolean a(PointVolumeInfo pointVolumeInfo, float f2) {
            return MathUtils.a(this.dicomCenter, pointVolumeInfo.dicomCenter, f2) && MathUtils.a(this.iop, pointVolumeInfo.iop, f2) && MathUtils.a(this.voxel, pointVolumeInfo.voxel, f2) && MathUtils.a(this.originOffsetMM, pointVolumeInfo.originOffsetMM, f2) && (this.appliedGantryDetectorTilt == null && pointVolumeInfo.appliedGantryDetectorTilt == null || this.appliedGantryDetectorTilt != null && pointVolumeInfo.appliedGantryDetectorTilt != null && MathUtils.a(this.appliedGantryDetectorTilt, pointVolumeInfo.appliedGantryDetectorTilt, f2));
        }

        public PointVolumeInfo a() {
            try {
                return (PointVolumeInfo)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.a();
        }
    }
}

