/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.google.common.collect.Lists;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.MetricPoint2f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MetricViewingPoint3f;
import com.mimvista.numerics.MultipliedVoxelPoint2f;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint2f;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;

public class Polylines {

    public static class MultipliedVoxelViewingPolyline2f
    extends PlanarPolyline2f {
        private static final long serialVersionUID = -2252441832265388721L;
        private Point3f.PointVolumeInfo pvi;
        private Matrix3f rot;
        private int[] mult;

        public MultipliedVoxelViewingPolyline2f(List<Point2f> list, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo, Matrix3f matrix3f, int[] nArray) {
            super(list, presentationType);
            this.pvi = pointVolumeInfo;
            this.rot = matrix3f;
            this.mult = nArray;
        }

        public Point3f.PointVolumeInfo a() {
            return this.pvi;
        }

        public MultipliedVoxelViewingPolyline2f b() {
            return new MultipliedVoxelViewingPolyline2f(this.g(), this.plane, this.pvi, this.rot, this.mult);
        }

        public int[] c() {
            return (int[])this.mult.clone();
        }

        @Override
        public /* synthetic */ Polyline2f d() {
            return this.b();
        }
    }

    public static class MultipliedVoxelPolyline2f
    extends PlanarPolyline2f {
        private static final long serialVersionUID = -655107034001125330L;
        private Point3f.PointVolumeInfo pvi;
        private int[] mult;

        public MultipliedVoxelPolyline2f(List<Point2f> list, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo, int[] nArray) {
            super(list, presentationType);
            this.pvi = pointVolumeInfo;
            this.mult = nArray;
        }

        public int[] a() {
            return (int[])this.mult.clone();
        }

        public VoxelPolyline2f b() {
            List<Point2f> list = this.g();
            for (Point2f point2f : list) {
                point2f.x /= (float)this.mult[this.plane.a()[0]];
                point2f.y /= (float)this.mult[this.plane.a()[1]];
            }
            return new VoxelPolyline2f(list, this.plane, this.pvi);
        }

        public Point3f.PointVolumeInfo c() {
            return this.pvi;
        }

        public MultipliedVoxelPolyline2f e() {
            return new MultipliedVoxelPolyline2f(this.g(), this.plane, this.pvi, this.mult);
        }

        public static List<MultipliedVoxelPolyline2f> a(List<List<Point2f>> list, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo, int[] nArray) {
            ArrayList arrayList = Lists.newArrayList();
            for (List<Point2f> list2 : list) {
                arrayList.add(new MultipliedVoxelPolyline2f(list2, presentationType, pointVolumeInfo, nArray));
            }
            return arrayList;
        }

        @Override
        public /* synthetic */ Polyline2f d() {
            return this.e();
        }
    }

    public static class ScreenPolyline2f
    extends Polyline2f {
        private static final long serialVersionUID = 6027433634682600553L;

        public ScreenPolyline2f(List<Point2f> list) {
            super(list);
        }

        public ScreenPolyline2f() {
        }

        public static List<ScreenPolyline2f> a(List<List<Point2f>> list) {
            ArrayList arrayList = Lists.newArrayList();
            for (List<Point2f> list2 : list) {
                arrayList.add(new ScreenPolyline2f(list2));
            }
            return arrayList;
        }

        public ScreenPolyline2f a() {
            return new ScreenPolyline2f(this.g());
        }

        @Override
        public /* synthetic */ Polyline2f d() {
            return this.a();
        }
    }

    public static class MetricViewingPolyline2f
    extends PlanarPolyline2f {
        private static final long serialVersionUID = 9175251150995940079L;
        private Point3f.PointVolumeInfo pvi;
        private Matrix3f rot;
        private float metricViewingZValue;

        public MetricViewingPolyline2f(List<Point2f> list, float f2, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo, Matrix3f matrix3f) {
            super(list, presentationType);
            this.pvi = pointVolumeInfo;
            this.rot = matrix3f;
            this.metricViewingZValue = f2;
        }

        public a a() {
            ArrayList arrayList = Lists.newArrayList();
            MetricViewingPoint3f metricViewingPoint3f = new MetricViewingPoint3f(0.0f, 0.0f, this.metricViewingZValue, this.pvi);
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.setIdentity();
            matrix4f.setRotationScale(this.rot);
            for (Point2f point2f : this) {
                metricViewingPoint3f.x = point2f.x;
                metricViewingPoint3f.y = point2f.y;
                arrayList.add(metricViewingPoint3f.a(matrix4f));
            }
            return new a(arrayList);
        }

        @Override
        public Polyline2f d() {
            return new MetricViewingPolyline2f(this.points, this.metricViewingZValue, this.plane, this.pvi, this.rot);
        }

        public Point3f.PointVolumeInfo b() {
            return this.pvi;
        }
    }

    public static class a {
        private List<MetricPoint3f> a;

        public a(List<MetricPoint3f> list) {
            this.a = list == null ? Lists.newArrayList() : Lists.newArrayList(list);
        }

        public List<MetricPoint3f> a() {
            return this.a;
        }

        public int b() {
            if (this.a == null) {
                return 0;
            }
            return this.a.size();
        }

        public MetricPoint3f a(int n2) {
            return this.a.get(n2);
        }

        public a c() {
            return new a(this.d());
        }

        public List<MetricPoint3f> d() {
            ArrayList arrayList = Lists.newArrayList();
            for (MetricPoint3f metricPoint3f : this.a) {
                arrayList.add(metricPoint3f.a());
            }
            return arrayList;
        }
    }

    public static class VoxelViewingPolyline2f
    extends PlanarPolyline2f {
        private static final long serialVersionUID = 4778041164512466842L;
        private Point3f.PointVolumeInfo pvi;
        private Matrix3f rot;
        private float voxelViewingZValue;

        public VoxelViewingPolyline2f(List<Point2f> list, float f2, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo, Matrix3f matrix3f) {
            super(list, presentationType);
            this.pvi = pointVolumeInfo;
            this.rot = matrix3f;
            this.voxelViewingZValue = f2;
        }

        public Point3f.PointVolumeInfo a() {
            return this.pvi;
        }

        public float b() {
            return this.voxelViewingZValue;
        }

        public VoxelViewingPolyline2f c() {
            return new VoxelViewingPolyline2f(this.g(), this.voxelViewingZValue, this.plane, this.pvi, this.rot);
        }

        public VoxelPolyline2f e() {
            return new VoxelPolyline2f(this.g(), this.plane, this.pvi);
        }

        public VoxelPolyline2f k() {
            Matrix3f matrix3f = new Matrix3f();
            matrix3f.setIdentity();
            if (this.rot.epsilonEquals(matrix3f, 1.0E-5f)) {
                return this.e();
            }
            return null;
        }

        public MetricViewingPolyline2f l() {
            List<Point2f> list = this.g();
            float[] fArray = this.pvi.originOffsetMM;
            float f2 = this.voxelViewingZValue * this.pvi.voxel[2] - fArray[2];
            for (Point2f point2f : list) {
                point2f.x = point2f.x * this.pvi.voxel[0] - fArray[0];
                point2f.y = point2f.y * this.pvi.voxel[1] - fArray[1];
            }
            return new MetricViewingPolyline2f(list, f2, this.plane, this.pvi, this.rot);
        }

        public static List<VoxelViewingPolyline2f> a(List<List<Point2f>> list, float f2, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo, Matrix3f matrix3f) {
            ArrayList arrayList = Lists.newArrayList();
            for (List<Point2f> list2 : list) {
                arrayList.add(new VoxelViewingPolyline2f(list2, f2, presentationType, pointVolumeInfo, matrix3f));
            }
            return arrayList;
        }

        public Matrix3f m() {
            return this.rot;
        }

        @Override
        public /* synthetic */ Polyline2f d() {
            return this.c();
        }
    }

    public static class MetricPolyline2f
    extends PlanarPolyline2f {
        private static final long serialVersionUID = 5271124169091178349L;
        private Point3f.PointVolumeInfo pvi;

        public MetricPolyline2f(List<Point2f> list, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo) {
            super(list, presentationType);
            this.pvi = pointVolumeInfo;
        }

        public List<MetricPoint2f> a() {
            ArrayList arrayList = Lists.newArrayList();
            for (Point2f point2f : this.points) {
                arrayList.add(new MetricPoint2f(point2f.x, point2f.y, this.plane));
            }
            return arrayList;
        }

        public Point3f.PointVolumeInfo b() {
            return this.pvi;
        }

        public MetricPolyline2f c() {
            return new MetricPolyline2f(this.g(), this.f(), this.b());
        }

        @Override
        public /* synthetic */ Polyline2f d() {
            return this.c();
        }
    }

    public static class VoxelPolyline2f
    extends PlanarPolyline2f {
        private static final long serialVersionUID = 6930128134253596060L;
        private Point3f.PointVolumeInfo pvi;

        public VoxelPolyline2f(List<Point2f> list, PresentationType presentationType, Point3f.PointVolumeInfo pointVolumeInfo) {
            super(list, presentationType);
            this.pvi = pointVolumeInfo;
        }

        public VoxelViewingPolyline2f a(float f2) {
            List<Point2f> list = this.g();
            Matrix3f matrix3f = new Matrix3f();
            matrix3f.setIdentity();
            return new VoxelViewingPolyline2f(list, f2, this.plane, this.pvi, matrix3f);
        }

        public MetricPolyline2f a() {
            ArrayList arrayList = Lists.newArrayList();
            for (Point2f point2f : this.points) {
                arrayList.add(new VoxelPoint2f(point2f.d(), PresentationType.a).a(this.pvi));
            }
            return new MetricPolyline2f(arrayList, this.plane, this.pvi);
        }

        public MultipliedVoxelPolyline2f a(int[] nArray) {
            ArrayList arrayList = Lists.newArrayList();
            for (Point2f point2f : this.points) {
                arrayList.add(new MultipliedVoxelPoint2f(point2f.x * (float)nArray[0], point2f.y * (float)nArray[1], this.plane, nArray[0], nArray[1]));
            }
            return new MultipliedVoxelPolyline2f(arrayList, this.plane, this.pvi, nArray);
        }

        public VoxelPolyline2f b() {
            return new VoxelPolyline2f(this.g(), this.plane, this.pvi);
        }

        @Override
        public /* synthetic */ Polyline2f d() {
            return this.b();
        }
    }

    public static class PlainPolyline2f
    extends Polyline2f {
        private static final long serialVersionUID = -8550112528012334256L;

        public PlainPolyline2f(List<Point2f> list) {
            super(list);
        }

        public static List<PlainPolyline2f> a(List<List<Point2f>> list) {
            ArrayList arrayList = Lists.newArrayList();
            for (List<Point2f> list2 : list) {
                arrayList.add(new PlainPolyline2f(list2));
            }
            return arrayList;
        }

        public PlainPolyline2f a() {
            return new PlainPolyline2f(this.g());
        }

        @Override
        public /* synthetic */ Polyline2f d() {
            return this.a();
        }
    }

    public static abstract class PlanarPolyline2f
    extends Polyline2f {
        private static final long serialVersionUID = -7199925849234413877L;
        public PresentationType plane;

        public PlanarPolyline2f(List<Point2f> list, PresentationType presentationType) {
            super(list);
            this.plane = presentationType;
        }

        public PresentationType f() {
            return this.plane;
        }
    }

    public static abstract class Polyline2f
    implements Serializable,
    Iterable<Point2f> {
        private static final long serialVersionUID = 230684517151074186L;
        public List<Point2f> points;

        public Polyline2f(List<Point2f> list) {
            this.points = list;
        }

        public Polyline2f() {
            this.points = Lists.newArrayList();
        }

        @Override
        public Iterator<Point2f> iterator() {
            return this.points.iterator();
        }

        public List<Point2f> g() {
            ArrayList arrayList = Lists.newArrayList();
            for (Point2f point2f : this.points) {
                arrayList.add(point2f.b());
            }
            return arrayList;
        }

        public Point2f a(int n2) {
            return this.points.get(n2);
        }

        public int h() {
            return this.points.size();
        }

        public void a(Point2f point2f) {
            this.points.add(point2f);
        }

        public void a(int n2, Point2f point2f) {
            this.points.add(n2, point2f);
        }

        public void b(int n2, Point2f point2f) {
            this.points.set(n2, point2f);
        }

        public void a(int n2, List<Point2f> list) {
            this.points.addAll(n2, list);
        }

        public void i() {
            this.points.clear();
        }

        public List<Point2f> j() {
            return this.points;
        }

        public void b(List<Point2f> list) {
            this.points = list;
        }

        public abstract Polyline2f d();
    }
}

