/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import com.google.common.collect.Lists;
import com.mimvista.numerics.aw;
import com.mimvista.numerics.ax;
import com.mimvista.util.ay;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point2d;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.fitting.HarmonicFitter;
import org.apache.commons.math3.optimization.fitting.PolynomialFitter;
import org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.util.BigReal;

public class Regression {
    public static PolynomialFunction a(Iterable<Point2d> iterable, int n2) {
        int n3 = 0;
        PolynomialFitter polynomialFitter = new PolynomialFitter(n2, (DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (Point2d point2d : iterable) {
            if (Double.isInfinite(point2d.x) || Double.isNaN(point2d.x) || Double.isInfinite(point2d.y) || Double.isNaN(point2d.y)) {
                ++n3;
                continue;
            }
            polynomialFitter.addObservedPoint(point2d.x, point2d.y);
        }
        if (n3 > 0) {
            ay.c((Object)(n3 + " points were omitted from the polynomial fitter because they were infinite or NaN."), Regression.class);
        }
        return new PolynomialFunction(polynomialFitter.fit());
    }

    public static aw a(Iterable<Point2d> iterable) {
        ax ax2 = new ax((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (Point2d point2d : iterable) {
            ax2.addObservedPoint(point2d.x, point2d.y);
        }
        return new aw(ax2.a());
    }

    public static PolynomialSplineFunction a(Collection<Point2d> collection) {
        double[] dArray = new double[collection.size()];
        double[] dArray2 = new double[collection.size()];
        int n2 = 0;
        for (Point2d point2d : collection) {
            dArray[n2] = point2d.x;
            dArray2[n2] = point2d.y;
            ++n2;
        }
        SplineInterpolator splineInterpolator = new SplineInterpolator();
        return splineInterpolator.interpolate(dArray, dArray2);
    }

    public static UnivariateFunction a(List<Point2d> list) {
        return com.mimvista.numerics.c.a.a(list);
    }

    public static UnivariateFunction b(Collection<Point2d> collection) {
        HarmonicFitter harmonicFitter = new HarmonicFitter((DifferentiableMultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());
        for (Point2d point2d : collection) {
            harmonicFitter.addObservedPoint(point2d.x, point2d.y);
        }
        Object object = harmonicFitter.fit();
        return new UnivariateFunction((double[])object){
            final /* synthetic */ double[] a;
            {
                this.a = dArray;
            }

            public double value(double d2) {
                return this.a[0] * Math.cos(d2 * this.a[1] + this.a[2]);
            }
        };
    }

    public static UnivariateFunction c(Collection<Point2d> collection) {
        return new a(collection);
    }

    public static float[] a(float[][] fArray) {
        try {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            float f12 = 0.0f;
            float f13 = 0.0f;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                f2 += fArray[i2][0] * fArray[i2][0];
                f5 += fArray[i2][0] * fArray[i2][2];
                f6 = f3 += fArray[i2][0] * fArray[i2][1];
                f7 += fArray[i2][1] * fArray[i2][1];
                f9 += fArray[i2][1] * fArray[i2][2];
                f10 = f4 += fArray[i2][0];
                f11 = f8 += fArray[i2][1];
                f12 += 1.0f;
                f13 += fArray[i2][2];
            }
            float f14 = f2 * (f7 * f12 - f8 * f11) - f3 * (f6 * f12 - f8 * f10) + f4 * (f6 * f11 - f7 * f10);
            float f15 = f5 * (f7 * f12 - f8 * f11) - f3 * (f9 * f12 - f8 * f13) + f4 * (f9 * f11 - f7 * f13);
            float f16 = f2 * (f9 * f12 - f8 * f13) - f5 * (f6 * f12 - f8 * f10) + f4 * (f6 * f13 - f9 * f10);
            float f17 = f2 * (f7 * f13 - f9 * f11) - f3 * (f6 * f13 - f9 * f10) + f5 * (f6 * f11 - f7 * f10);
            return new float[]{f15 / f14, f16 / f14, f17 / f14};
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static double[] a(double[] dArray, double[] dArray2, int n2) {
        if (dArray.length != dArray2.length) {
            return null;
        }
        int n3 = dArray.length;
        BigReal[][] bigRealArrayArray = new BigReal[n3][];
        for (int i2 = 0; i2 < n3; ++i2) {
            bigRealArrayArray[i2] = new BigReal[n2 + 1];
            bigRealArrayArray[i2][0] = BigReal.ONE;
            for (int i3 = 1; i3 < n2 + 1; ++i3) {
                bigRealArrayArray[i2][i3] = bigRealArrayArray[i2][i3 - 1].multiply(new BigReal(dArray[i2]));
            }
        }
        FieldMatrix fieldMatrix = MatrixUtils.createFieldMatrix((FieldElement[][])bigRealArrayArray);
        BigReal[] bigRealArray = new BigReal[dArray2.length];
        for (int i4 = 0; i4 < dArray2.length; ++i4) {
            bigRealArray[i4] = new BigReal(dArray2[i4]);
        }
        FieldMatrix fieldMatrix2 = MatrixUtils.createColumnFieldMatrix((FieldElement[])bigRealArray);
        FieldMatrix fieldMatrix3 = fieldMatrix.transpose();
        FieldMatrix fieldMatrix4 = fieldMatrix3.multiply(fieldMatrix);
        FieldLUDecomposition fieldLUDecomposition = new FieldLUDecomposition(fieldMatrix4);
        fieldMatrix4 = fieldLUDecomposition.getSolver().getInverse();
        fieldMatrix4 = fieldMatrix4.multiply(fieldMatrix3).multiply(fieldMatrix2);
        BigReal[] bigRealArray2 = (BigReal[])fieldMatrix4.getColumn(0);
        double[] dArray3 = new double[bigRealArray2.length];
        for (int i5 = 0; i5 < bigRealArray2.length; ++i5) {
            dArray3[i5] = bigRealArray2[i5].doubleValue();
        }
        return dArray3;
    }

    public static void main(String[] stringArray) {
        int n2;
        double[] dArray = new double[]{0.1, 0.15, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] dArray2 = new double[]{1.033, 1.029, 1.027, 1.028, 1.03, 1.0, 0.938, 0.866, 0.707, 0.555, 0.427, 0.32, 0.248, 0.187, 0.142, 0.103};
        int n3 = 5;
        double[] dArray3 = Regression.a(dArray, dArray2, n3);
        System.out.println("Coefficients: ");
        for (n2 = 0; n2 < dArray3.length; ++n2) {
            System.out.println(dArray3[n2]);
        }
        System.out.println("");
        System.out.println("Errors from the original data points: ");
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d2 = 0.0;
            for (int i2 = 0; i2 < dArray3.length; ++i2) {
                d2 += dArray3[i2] * Math.pow(dArray[n2], i2);
            }
            double d3 = (d2 - dArray2[n2]) / dArray2[n2] * 100.0;
            System.out.println(d3 + "%");
        }
    }

    public static class a
    implements UnivariateFunction {
        List<Point2d> a;

        public a(Collection<Point2d> collection) {
            this.a = Lists.newArrayList(collection);
            Collections.sort(this.a, new Comparator<Point2d>(){

                public int a(Point2d point2d, Point2d point2d2) {
                    return (int)Math.signum(point2d.x - point2d2.x);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((Point2d)object, (Point2d)object2);
                }
            });
        }

        public double value(double d2) {
            if (this.a.isEmpty()) {
                return Double.NaN;
            }
            if (this.a.get((int)0).x > d2) {
                return this.a.get((int)0).y;
            }
            for (int i2 = 0; i2 < this.a.size() - 1; ++i2) {
                Point2d point2d = this.a.get(i2 + 1);
                if (point2d.x < d2) continue;
                Point2d point2d2 = this.a.get(i2);
                double d3 = point2d.x - point2d2.x;
                double d4 = point2d.y - point2d2.y;
                return (d2 - point2d2.x) / d3 * d4 + point2d2.y;
            }
            return this.a.get((int)(this.a.size() - 1)).y;
        }
    }
}

