/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class aw
implements DifferentiableUnivariateFunction {
    private final double[] a;

    public aw(double[] dArray) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull((Object)dArray);
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new NoDataException((Localizable)LocalizedFormats.ARRAY_ELEMENT);
        }
        this.a = new double[n2];
        System.arraycopy(dArray, 0, this.a, 0, n2);
    }

    public double value(double d2) {
        return aw.a(this.a, d2);
    }

    public UnivariateFunction derivative() {
        return new UnivariateFunction(){

            public double value(double d2) {
                return aw.this.a[1] / (2.0 * FastMath.sqrt((double)d2));
            }
        };
    }

    protected static double a(double[] dArray, double d2) throws NullArgumentException, NoDataException {
        MathUtils.checkNotNull((Object)dArray);
        int n2 = dArray.length;
        if (n2 != 2) {
            throw new NoDataException((Localizable)LocalizedFormats.ARRAY_ELEMENT);
        }
        if (d2 < 0.0) {
            throw new NoDataException((Localizable)LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN);
        }
        return FastMath.sqrt((double)d2) * dArray[1] + dArray[0];
    }

    public static class a
    implements ParametricUnivariateFunction {
        public double[] gradient(double d2, double ... dArray) {
            double[] dArray2 = new double[]{1.0, FastMath.sqrt((double)d2)};
            return dArray2;
        }

        public double value(double d2, double ... dArray) {
            return aw.a(dArray, d2);
        }
    }
}

