/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics.contourtools;

import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.util.progress.Progress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public class PointSetDiameter {
    private static final float a = 0.01f;
    private float b = -1.0f;
    private Point3f c = null;
    private Point3f d = null;

    public float a() throws IllegalStateException {
        if (this.b == -1.0f) {
            throw new IllegalStateException("Diameter has not been calculated yet!");
        }
        return this.b;
    }

    public Point3f[] b() throws IllegalStateException {
        if (this.c == null || this.d == null) {
            throw new IllegalStateException("Diameter has not been calculated yet!");
        }
        return new Point3f[]{this.c, this.d};
    }

    public static float[] a(Collection<MetricPoint3f> collection) {
        float[] fArray = new float[collection.size() * 3];
        int n2 = 0;
        for (MetricPoint3f metricPoint3f : collection) {
            fArray[n2] = metricPoint3f.x;
            fArray[++n2] = metricPoint3f.y;
            fArray[++n2] = metricPoint3f.z;
            ++n2;
        }
        return fArray;
    }

    public float a(Collection<MetricPoint3f> collection, Progress progress) throws IllegalArgumentException {
        return this.a(0.01f, collection, progress);
    }

    public float a(float f2, Collection<MetricPoint3f> collection, Progress progress) throws IllegalArgumentException, IllegalStateException {
        return this.a(f2, PointSetDiameter.a(collection), progress);
    }

    public float a(float f2, float[] fArray, Progress progress) throws IllegalArgumentException {
        if (fArray.length % 3 != 0) {
            throw new IllegalArgumentException("The point list does not contain a complete set of coordinates!");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("No points found!");
        }
        float[] fArray2 = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (int i2 = 0; i2 < fArray.length; i2 += 3) {
            if (fArray[i2] < fArray2[0]) {
                fArray2[0] = fArray[i2];
            }
            if (fArray[i2] > fArray2[3]) {
                fArray2[3] = fArray[i2];
            }
            if (fArray[i2 + 1] < fArray2[1]) {
                fArray2[1] = fArray[i2 + 1];
            }
            if (fArray[i2 + 1] > fArray2[4]) {
                fArray2[4] = fArray[i2 + 1];
            }
            if (fArray[i2 + 2] < fArray2[2]) {
                fArray2[2] = fArray[i2 + 2];
            }
            if (!(fArray[i2 + 2] > fArray2[5])) continue;
            fArray2[5] = fArray[i2 + 2];
        }
        a a2 = new a(fArray2);
        for (float f3 = 1.0f; f3 > 0.1f; f3 -= 0.1f) {
            this.a(f2, fArray, f3, a2, progress);
            if (progress.n() == Progress.Status.e) {
                return -1.0f;
            }
            if (this.c != null && this.d != null) break;
        }
        if (this.c == null && this.d == null) {
            throw new IllegalStateException("No diameter could be found!");
        }
        return this.b;
    }

    public float a(float f2, float[] fArray, float f3, a a2, Progress progress) {
        PriorityQueue<c> priorityQueue = new PriorityQueue<c>(10, new d());
        b b2 = new b(a2, fArray);
        float f4 = a2.a(f3);
        c c2 = new c(b2, b2);
        priorityQueue.add(c2);
        while (priorityQueue.peek() != null) {
            List<c> list;
            if (progress.n() == Progress.Status.e) {
                return -1.0f;
            }
            c c3 = (c)priorityQueue.poll();
            if (c3.a.b() <= 0 || c3.b.b() <= 0 || !(c3.a() > (1.0f + f2) * f4) || (list = c3.c()) == null) continue;
            priorityQueue.addAll(list);
            for (c c4 : list) {
                float[] fArray2 = c4.b();
                float f5 = fArray2[0];
                if (!(f5 > f4)) continue;
                f4 = f5;
                this.c = new Point3f(fArray2[1], fArray2[2], fArray2[3]);
                this.d = new Point3f(fArray2[4], fArray2[5], fArray2[6]);
            }
        }
        this.b = f4;
        return f4;
    }

    private class d
    implements Comparator {
        private d() {
        }

        public int compare(Object object, Object object2) {
            float f2;
            float f3 = ((c)object).a();
            if (f3 < (f2 = ((c)object2).a())) {
                return 1;
            }
            if (f3 > f2) {
                return -1;
            }
            return 0;
        }
    }

    private class c {
        b a;
        b b;

        public c(b b2, b b3) {
            this.a = b2;
            this.b = b3;
        }

        public float a() {
            float[] fArray = this.a.b.d();
            float[] fArray2 = this.b.b.d();
            return MathUtils.i(fArray, fArray2) + this.a.b.a(fArray) + this.b.b.a(fArray2);
        }

        public float[] b() {
            int n2;
            int n3;
            float f2;
            float[] fArray = this.a.a();
            float[] fArray2 = this.b.a();
            if (fArray.length == 0 || fArray2.length == 0) {
                return new float[]{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f};
            }
            boolean bl2 = false;
            if (bl2) {
                f2 = Float.NEGATIVE_INFINITY;
                int n4 = -1;
                int n5 = -1;
                for (int i2 = 0; i2 < fArray.length; i2 += 3) {
                    for (int i3 = 0; i3 < fArray2.length; i3 += 3) {
                        float f3 = fArray[i2] - fArray2[i3];
                        float f4 = fArray[i2 + 1] - fArray2[i3 + 1];
                        float f5 = fArray[i2 + 2] - fArray2[i3 + 2];
                        float f6 = f3 * f3 + f4 * f4 + f5 * f5;
                        if (!(f6 > f2)) continue;
                        f2 = f6;
                        n4 = i2;
                        n5 = i3;
                    }
                }
                n3 = n4;
                n2 = n5;
            } else {
                boolean bl3 = true;
                if (bl3) {
                    n3 = fArray.length / 3 / 2 * 3;
                    n2 = fArray2.length / 3 / 2 * 3;
                } else {
                    n3 = (int)Math.round(Math.random() * (double)fArray.length - 1.0);
                    n3 -= n3 % 3;
                    n2 = (int)Math.round(Math.random() * (double)fArray2.length - 1.0);
                    n2 -= n2 % 3;
                }
            }
            f2 = MathUtils.i(new float[]{fArray[n3], fArray[n3 + 1], fArray[n3 + 2]}, new float[]{fArray2[n2], fArray2[n2 + 1], fArray2[n2 + 2]});
            return new float[]{f2, fArray[n3], fArray[n3 + 1], fArray[n3 + 2], fArray2[n2], fArray2[n2 + 1], fArray2[n2 + 2]};
        }

        public List<c> c() {
            ArrayList<c> arrayList = new ArrayList<c>(4);
            int n2 = this.a.b();
            int n3 = this.b.b();
            if (n2 <= 1 && n3 <= 1) {
                return null;
            }
            if (n2 <= 1) {
                b[] bArray = this.b.c();
                arrayList.add(new c(this.a, bArray[0]));
                arrayList.add(new c(this.a, bArray[1]));
            } else if (n3 <= 1) {
                b[] bArray = this.a.c();
                arrayList.add(new c(bArray[0], this.b));
                arrayList.add(new c(bArray[1], this.b));
            } else if (this.a == this.b) {
                b[] bArray = this.a.c();
                arrayList.add(new c(bArray[0], bArray[0]));
                arrayList.add(new c(bArray[0], bArray[1]));
                arrayList.add(new c(bArray[1], bArray[1]));
            } else {
                b[] bArray = this.a.c();
                b[] bArray2 = this.b.c();
                arrayList.add(new c(bArray[0], bArray2[0]));
                arrayList.add(new c(bArray[0], bArray2[1]));
                arrayList.add(new c(bArray[1], bArray2[0]));
                arrayList.add(new c(bArray[1], bArray2[1]));
            }
            return arrayList;
        }
    }

    private class b {
        private a b;
        private b c = null;
        private b d = null;
        private float[] e;

        public b(a a2, float[] fArray) throws IllegalArgumentException {
            if (fArray.length % 3 != 0) {
                throw new IllegalArgumentException("All of the coordinates must have x, y, and z.");
            }
            if (a2 == null) {
                throw new IllegalArgumentException("Bounding box cannot be null.");
            }
            this.e = fArray;
            this.b = a2;
        }

        public float[] a() {
            if (this.e != null) {
                return this.e;
            }
            float[] fArray = new float[]{};
            float[] fArray2 = new float[]{};
            if (this.c != null) {
                fArray = this.c.a();
            }
            if (this.d != null) {
                fArray2 = this.d.a();
            }
            float[] fArray3 = new float[fArray.length + fArray2.length];
            System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
            System.arraycopy(fArray2, 0, fArray3, fArray.length, fArray2.length);
            return fArray3;
        }

        public int b() {
            return this.a().length / 3;
        }

        public b[] c() {
            int n2;
            if (this.c != null && this.d != null) {
                return new b[]{this.c, this.d};
            }
            Axis axis = this.b.c();
            float[] fArray = this.b.d();
            float[] fArray2 = this.b.a();
            float[] fArray3 = this.b.b();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            ArrayList<Float> arrayList2 = new ArrayList<Float>();
            float[] fArray4 = null;
            float[] fArray5 = null;
            switch (axis) {
                case a: {
                    fArray4 = new float[]{fArray2[0], fArray2[1], fArray2[2], fArray[0], fArray3[1], fArray3[2]};
                    fArray5 = new float[]{fArray[0], fArray2[1], fArray2[2], fArray3[0], fArray3[1], fArray3[2]};
                    for (n2 = 0; n2 < this.e.length; n2 += 3) {
                        if (this.e[n2] < fArray[0]) {
                            arrayList.add(Float.valueOf(this.e[n2]));
                            arrayList.add(Float.valueOf(this.e[n2 + 1]));
                            arrayList.add(Float.valueOf(this.e[n2 + 2]));
                            continue;
                        }
                        arrayList2.add(Float.valueOf(this.e[n2]));
                        arrayList2.add(Float.valueOf(this.e[n2 + 1]));
                        arrayList2.add(Float.valueOf(this.e[n2 + 2]));
                    }
                    break;
                }
                case b: {
                    fArray4 = new float[]{fArray2[0], fArray2[1], fArray2[2], fArray3[0], fArray[1], fArray3[2]};
                    fArray5 = new float[]{fArray2[0], fArray[1], fArray2[2], fArray3[0], fArray3[1], fArray3[2]};
                    for (n2 = 1; n2 < this.e.length; n2 += 3) {
                        if (this.e[n2] < fArray[1]) {
                            arrayList.add(Float.valueOf(this.e[n2 - 1]));
                            arrayList.add(Float.valueOf(this.e[n2]));
                            arrayList.add(Float.valueOf(this.e[n2 + 1]));
                            continue;
                        }
                        arrayList2.add(Float.valueOf(this.e[n2 - 1]));
                        arrayList2.add(Float.valueOf(this.e[n2]));
                        arrayList2.add(Float.valueOf(this.e[n2 + 1]));
                    }
                    break;
                }
                case c: {
                    fArray4 = new float[]{fArray2[0], fArray2[1], fArray2[2], fArray3[0], fArray3[1], fArray[2]};
                    fArray5 = new float[]{fArray2[0], fArray2[1], fArray[2], fArray3[0], fArray3[1], fArray3[2]};
                    for (n2 = 2; n2 < this.e.length; n2 += 3) {
                        if (this.e[n2] < fArray[2]) {
                            arrayList.add(Float.valueOf(this.e[n2 - 2]));
                            arrayList.add(Float.valueOf(this.e[n2 - 1]));
                            arrayList.add(Float.valueOf(this.e[n2]));
                            continue;
                        }
                        arrayList2.add(Float.valueOf(this.e[n2 - 2]));
                        arrayList2.add(Float.valueOf(this.e[n2 - 1]));
                        arrayList2.add(Float.valueOf(this.e[n2]));
                    }
                    break;
                }
            }
            a a2 = new a(fArray4);
            a a3 = new a(fArray5);
            float[] fArray6 = new float[arrayList.size()];
            float[] fArray7 = new float[arrayList2.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                fArray6[n2] = ((Float)arrayList.get(n2)).floatValue();
            }
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                fArray7[n2] = ((Float)arrayList2.get(n2)).floatValue();
            }
            this.e = null;
            this.c = new b(a2, fArray6);
            this.d = new b(a3, fArray7);
            return new b[]{this.c, this.d};
        }
    }

    private class a {
        private float b;
        private float c;
        private float d;
        private float e;
        private float f;
        private float g;
        private Axis h;

        public a(float[] fArray) {
            this.b = fArray[0];
            this.c = fArray[1];
            this.d = fArray[2];
            this.e = fArray[3];
            this.f = fArray[4];
            this.g = fArray[5];
            this.h = null;
        }

        public float[] a() {
            return new float[]{this.b, this.c, this.d};
        }

        public float[] b() {
            return new float[]{this.e, this.f, this.g};
        }

        public Axis c() {
            if (this.h == null) {
                this.h = Axis.a;
                float f2 = this.e - this.b;
                if (f2 < this.f - this.c) {
                    f2 = this.f - this.c;
                    this.h = Axis.b;
                }
                if (f2 < this.g - this.d) {
                    this.h = Axis.c;
                }
            }
            return this.h;
        }

        public float a(float f2) {
            if (this.h == null) {
                this.c();
            }
            float f3 = this.e - this.b;
            if (this.h == Axis.b) {
                f3 = this.f - this.c;
            }
            if (this.h == Axis.c) {
                f3 = this.g - this.d;
            }
            return f3 * f2;
        }

        public float[] d() {
            return new float[]{(this.e - this.b) / 2.0f + this.b, (this.f - this.c) / 2.0f + this.c, (this.g - this.d) / 2.0f + this.d};
        }

        public float a(float[] fArray) {
            return MathUtils.i(new float[]{this.e, this.f, this.g}, fArray);
        }
    }

    public static enum Axis {
        a,
        b,
        c;

    }
}

