/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics.contourtools;

import com.google.common.collect.Lists;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.mui.az;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MetricViewingPoint3f;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3d;
import com.mimvista.numerics.Point3f;
import com.mimvista.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.apache.commons.math3.util.FastMath;

public class l {
    public static final float a = 1.0E-4f;

    public static Point2f a(List<Point2f> list) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = list.size();
        for (Point2f point2f : list) {
            f2 += point2f.x;
            f3 += point2f.y;
        }
        return new Point2f(f2 /= (float)n2, f3 /= (float)n2);
    }

    public static Point3f a(Iterable<? extends Point3f> iterable) {
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        float f2 = 0.0f;
        for (Point3f point3f2 : iterable) {
            point3f.add((Tuple3f)point3f2);
            f2 += 1.0f;
        }
        point3f.scale(1.0f / f2);
        return point3f;
    }

    public static Point2f a(Point2f point2f, Point2f point2f2, float f2) {
        Point2f point2f3 = new Point2f();
        l.a(point2f, point2f2, f2, point2f3);
        return point2f3;
    }

    public static void a(Point2f point2f, Point2f point2f2, float f2, Point2f point2f3) {
        float f3 = point2f2.x - point2f.x;
        float f4 = point2f2.y - point2f.y;
        double d2 = Math.cos(f2) * (double)f3 + Math.sin(f2) * (double)f4;
        double d3 = -Math.sin(f2) * (double)f3 + Math.cos(f2) * (double)f4;
        point2f3.x = (float)(d2 + (double)point2f.x);
        point2f3.y = (float)(d3 + (double)point2f.y);
    }

    public static float[] a(Point2f point2f, Point2f point2f2) {
        float f2 = point2f2.y - point2f.y;
        float f3 = point2f.x - point2f2.x;
        float f4 = f2 * point2f.x + f3 * point2f.y;
        return new float[]{f2, f3, f4};
    }

    public static float a(Point2f point2f, Point2f point2f2, Point2f point2f3) throws IllegalArgumentException {
        if (point2f.equals((Tuple2f)point2f2)) {
            throw new IllegalArgumentException("The same point twice does not define a line!");
        }
        float f2 = point2f2.y - point2f.y;
        float f3 = point2f.x - point2f2.x;
        float f4 = -(f2 * point2f.x + f3 * point2f.y);
        return (float)((double)Math.abs(f2 * point2f3.x + f3 * point2f3.y + f4) / Math.sqrt(f2 * f2 + f3 * f3));
    }

    public static float a(Point3f point3f, Point3f point3f2, Point3f point3f3) throws IllegalArgumentException {
        if (point3f.equals((Tuple3f)point3f2)) {
            throw new IllegalArgumentException("The same point twice does not define a line!");
        }
        Vector3f vector3f = new Vector3f();
        vector3f.add((Tuple3f)point3f2);
        vector3f.sub((Tuple3f)point3f);
        Vector3f vector3f2 = new Vector3f((Tuple3f)point3f3);
        Vector3f vector3f3 = new Vector3f((Tuple3f)point3f);
        float f2 = vector3f2.dot(vector3f) - vector3f3.dot(vector3f);
        Vector3f vector3f4 = (Vector3f)vector3f3.clone();
        vector3f4.scaleAdd(f2 /= vector3f.dot(vector3f), (Tuple3f)vector3f, (Tuple3f)vector3f4);
        Vector3f vector3f5 = (Vector3f)vector3f4.clone();
        vector3f5.sub((Tuple3f)vector3f2);
        return vector3f5.length();
    }

    public static Point2f a(Point2f point2f, Point2f point2f2, Point2f point2f3, Point2f point2f4) throws IllegalArgumentException {
        Point2f point2f5 = new Point2f();
        if (l.a(point2f, point2f2, point2f3, point2f4, point2f5)) {
            return point2f5;
        }
        return null;
    }

    public static boolean a(Point2f point2f, Point2f point2f2, Point2f point2f3, Point2f point2f4, Point2f point2f5) throws IllegalArgumentException {
        if (point2f.x == point2f2.x && point2f.y == point2f2.y || point2f3.x == point2f4.x && point2f3.y == point2f4.y) {
            throw new IllegalArgumentException("You are trying to define a line with only one point!");
        }
        float[] fArray = l.a(point2f, point2f2);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float[] fArray2 = l.a(point2f3, point2f4);
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float f7 = fArray2[2];
        float f8 = f2 * f6 - f5 * f3;
        if (Math.abs(f8) < 1.0E-4f) {
            return false;
        }
        point2f5.x = (f6 * f4 - f3 * f7) / f8;
        point2f5.y = (f2 * f7 - f5 * f4) / f8;
        return true;
    }

    public static Point3f a(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        Pair<Point3f, Point3f> pair = l.b(point3f, point3f2, point3f3, point3f4);
        Point3f point3f5 = (Point3f)((Object)pair.x);
        Point3f point3f6 = (Point3f)((Object)pair.y);
        float f2 = point3f5.distance(point3f6);
        if (f2 < 1.0E-4f) {
            return point3f5;
        }
        return null;
    }

    public static Pair<Point3f, Point3f> b(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        float f2;
        float f3;
        float f4;
        Vector3f vector3f = new Vector3f((Tuple3f)point3f2);
        vector3f.sub((Tuple3f)point3f);
        Vector3f vector3f2 = new Vector3f((Tuple3f)point3f4);
        vector3f2.sub((Tuple3f)point3f3);
        Vector3f vector3f3 = new Vector3f((Tuple3f)point3f);
        vector3f3.sub((Tuple3f)point3f3);
        float f5 = vector3f.dot(vector3f);
        float f6 = vector3f.dot(vector3f2);
        float f7 = vector3f2.dot(vector3f2);
        float f8 = vector3f.dot(vector3f3);
        float f9 = vector3f2.dot(vector3f3);
        float f10 = f4 = f5 * f7 - f6 * f6;
        float f11 = f4;
        if (f4 < 1.0E-4f) {
            f3 = 0.0f;
            f10 = 1.0f;
            f2 = f9;
            f11 = f7;
        } else {
            f3 = f6 * f9 - f7 * f8;
            f2 = f5 * f9 - f6 * f8;
            if (f3 < 0.0f) {
                f3 = 0.0f;
                f2 = f9;
                f11 = f7;
            } else if (f3 > f10) {
                f3 = f10;
                f2 = f9 + f6;
                f11 = f7;
            }
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
            if (-f8 < 0.0f) {
                f3 = 0.0f;
            } else if (-f8 > f5) {
                f3 = f10;
            } else {
                f3 = -f8;
                f10 = f5;
            }
        } else if (f2 > f11) {
            f2 = f11;
            if (-f8 + f6 < 0.0f) {
                f3 = 0.0f;
            } else if (-f8 + f6 > f5) {
                f3 = f10;
            } else {
                f3 = -f8 + f6;
                f10 = f5;
            }
        }
        float f12 = Math.abs(f3) < 1.0E-4f ? 0.0f : f3 / f10;
        float f13 = Math.abs(f2) < 1.0E-4f ? 0.0f : f2 / f11;
        Point3f point3f5 = new Point3f((Tuple3f)vector3f);
        point3f5.scale(f12);
        point3f5.add((Tuple3f)point3f);
        Point3f point3f6 = new Point3f((Tuple3f)vector3f2);
        point3f6.scale(f13);
        point3f6.add((Tuple3f)point3f3);
        return Pair.get(point3f5, point3f6);
    }

    public static Point2f b(Point2f point2f, Point2f point2f2, Point2f point2f3, Point2f point2f4) throws IllegalArgumentException {
        Point2f point2f5 = new Point2f();
        if (l.b(point2f, point2f2, point2f3, point2f4, point2f5)) {
            return point2f5;
        }
        return null;
    }

    public static boolean b(Point2f point2f, Point2f point2f2, Point2f point2f3, Point2f point2f4, Point2f point2f5) throws IllegalArgumentException {
        float f2;
        float f3;
        float f4;
        float f5;
        if (!l.a(point2f, point2f2, point2f3, point2f4, point2f5)) {
            return false;
        }
        if (point2f3.x <= point2f4.x) {
            f5 = point2f3.x;
            f4 = point2f4.x;
        } else {
            f5 = point2f4.x;
            f4 = point2f3.x;
        }
        if (point2f3.y <= point2f4.y) {
            f3 = point2f3.y;
            f2 = point2f4.y;
        } else {
            f3 = point2f4.y;
            f2 = point2f3.y;
        }
        return !(point2f5.x < f5 - 1.0E-4f || point2f5.x > f4 + 1.0E-4f || point2f5.y < f3 - 1.0E-4f || point2f5.y > f2 + 1.0E-4f || point2f5.x > point2f.x + 1.0E-4f && point2f2.x <= point2f.x + 1.0E-4f || point2f5.x < point2f.x - 1.0E-4f && point2f2.x >= point2f.x - 1.0E-4f || point2f5.y > point2f.y + 1.0E-4f && point2f2.y <= point2f.y + 1.0E-4f) && (!(point2f5.y < point2f.y - 1.0E-4f) || !(point2f2.y >= point2f.y - 1.0E-4f));
    }

    public static boolean c(Point2f point2f, Point2f point2f2, Point2f point2f3, Point2f point2f4, Point2f point2f5) {
        float f2 = point2f2.y - point2f.y;
        float f3 = point2f.x - point2f2.x;
        float f4 = f2 * point2f.x + f3 * point2f.y;
        float f5 = point2f4.y - point2f3.y;
        float f6 = point2f3.x - point2f4.x;
        float f7 = f5 * point2f3.x + f6 * point2f3.y;
        float f8 = f2 * f6 - f5 * f3;
        if (f8 >= 1.0E-4f || f8 <= -1.0E-4f) {
            float f9;
            float f10;
            float f11;
            float f12;
            float f13 = (f6 * f4 - f3 * f7) / f8;
            float f14 = (f2 * f7 - f5 * f4) / f8;
            if (point2f3.x <= point2f4.x) {
                f12 = point2f3.x;
                f11 = point2f4.x;
            } else {
                f12 = point2f4.x;
                f11 = point2f3.x;
            }
            if (point2f3.y <= point2f4.y) {
                f10 = point2f3.y;
                f9 = point2f4.y;
            } else {
                f10 = point2f4.y;
                f9 = point2f3.y;
            }
            float f15 = f13 + 1.0E-4f;
            float f16 = f13 - 1.0E-4f;
            float f17 = f14 + 1.0E-4f;
            float f18 = f14 - 1.0E-4f;
            if (f15 < f12 || f16 > f11 || f17 < f10 || f18 > f9 || f16 > point2f.x && point2f2.x <= point2f.x + 1.0E-4f || f15 < point2f.x && point2f2.x >= point2f.x - 1.0E-4f || f18 > point2f.y && point2f2.y <= point2f.y + 1.0E-4f || f17 < point2f.y && point2f2.y >= point2f.y - 1.0E-4f) {
                return false;
            }
            point2f5.x = f13;
            point2f5.y = f14;
            return true;
        }
        return false;
    }

    public static Float a(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f) {
        float f2 = vector3f.dot(new Vector3f(point3f3.x, point3f3.y, point3f3.z)) - vector3f.x * point3f.x - vector3f.y * point3f.y - vector3f.z * point3f.z;
        float f3 = vector3f.x * (point3f2.x - point3f.x) + vector3f.y * (point3f2.y - point3f.y) + vector3f.z * (point3f2.z - point3f.z);
        if (Math.abs(f3) < 1.0E-4f) {
            if (Math.abs(f2) < 1.0E-4f) {
                return Float.valueOf(Float.NaN);
            }
            return null;
        }
        return Float.valueOf(f2 / f3);
    }

    public static Vector3f b(Point3f point3f, Point3f point3f2, Point3f point3f3) throws IllegalArgumentException {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        vector3f2.sub((Tuple3f)point3f2, (Tuple3f)point3f);
        vector3f3.sub((Tuple3f)point3f3, (Tuple3f)point3f);
        vector3f.cross(vector3f2, vector3f3);
        if (Math.abs(vector3f.x) < 1.0E-4f && Math.abs(vector3f.y) < 1.0E-4f && Math.abs(vector3f.z) < 1.0E-4f) {
            throw new IllegalArgumentException("Points are collinear.");
        }
        vector3f.normalize();
        return vector3f;
    }

    public static Vector3d a(Point3d point3d, Point3d point3d2, Point3d point3d3) throws IllegalArgumentException {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d2.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        vector3d3.sub((Tuple3d)point3d3, (Tuple3d)point3d);
        vector3d.cross(vector3d2, vector3d3);
        if (Math.abs(vector3d.x) < (double)1.0E-4f && Math.abs(vector3d.y) < (double)1.0E-4f && Math.abs(vector3d.z) < (double)1.0E-4f) {
            throw new IllegalArgumentException("Points are collinear.");
        }
        vector3d.normalize();
        return vector3d;
    }

    public static Point3f[] b(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f) {
        Float f2 = l.a(point3f, point3f2, point3f3, vector3f);
        if (f2 == null || f2.floatValue() < -1.0E-4f || f2.floatValue() > 1.0001f) {
            return new Point3f[0];
        }
        if (f2.isNaN()) {
            return new Point3f[]{(Point3f)((Object)point3f.clone()), (Point3f)((Object)point3f2.clone())};
        }
        Point3f point3f4 = new Point3f();
        point3f4.sub((Tuple3f)point3f2, (Tuple3f)point3f);
        point3f4.scaleAdd(f2.floatValue(), (Tuple3f)point3f);
        return new Point3f[]{point3f4};
    }

    public static Optional<Point3f[]> a(Point3f point3f2, Vector3f vector3f, Point3f point3f3, Vector3f vector3f2) {
        Vector3f vector3f3 = l.a(vector3f, vector3f2);
        if (vector3f3.length() < 1.0E-4f) {
            return Optional.empty();
        }
        Optional<Point3f> optional = l.a(point3f2, vector3f, point3f3, vector3f2, new Point3f(), new Vector3f(vector3f3.x, vector3f3.y, vector3f3.z));
        return optional.map(point3f -> {
            Point3f point3f2 = point3f.e();
            point3f2.add((Tuple3f)vector3f3);
            return new Point3f[]{point3f, point3f2};
        });
    }

    static Optional<Point3f> a(Point3f point3f, Vector3f vector3f, Point3f point3f2, Vector3f vector3f2, Point3f point3f3, Vector3f vector3f3) {
        float f2 = vector3f.x;
        float f3 = vector3f.y;
        float f4 = vector3f.z;
        float f5 = -l.a((Tuple3f)vector3f, (Tuple3f)point3f);
        float f6 = vector3f2.x;
        float f7 = vector3f2.y;
        float f8 = vector3f2.z;
        float f9 = -l.a((Tuple3f)vector3f2, (Tuple3f)point3f2);
        float f10 = vector3f3.x;
        float f11 = vector3f3.y;
        float f12 = vector3f3.z;
        float f13 = -l.a((Tuple3f)vector3f3, (Tuple3f)point3f3);
        float f14 = f7 * f12 - f11 * f8;
        float f15 = f8 * f10 - f12 * f6;
        float f16 = f6 * f11 - f10 * f7;
        float f17 = f2 * f14 + f3 * f15 + f4 * f16;
        if (FastMath.abs((float)f17) < 1.0E-4f) {
            return Optional.empty();
        }
        float f18 = 1.0f / f17;
        return Optional.of(new Point3f((-f14 * f5 - (f4 * f11 - f12 * f3) * f9 - (f8 * f3 - f4 * f7) * f13) * f18, (-f15 * f5 - (f12 * f2 - f4 * f10) * f9 - (f4 * f6 - f8 * f2) * f13) * f18, (-f16 * f5 - (f3 * f10 - f11 * f2) * f9 - (f7 * f2 - f3 * f6) * f13) * f18));
    }

    public static Vector3f a(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        return vector3f3;
    }

    static float a(Tuple3f tuple3f, Tuple3f tuple3f2) {
        return tuple3f.x * tuple3f2.x + tuple3f.y * tuple3f2.y + tuple3f.z * tuple3f2.z;
    }

    public static Vector3f a(Point3f point3f, Point3f point3f2) {
        Vector3f vector3f = new Vector3f();
        vector3f.sub((Tuple3f)point3f2, (Tuple3f)point3f);
        return vector3f;
    }

    public static Vector3f a(Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f(vector3f);
        vector3f2.normalize();
        return vector3f2;
    }

    public static Vector3f b(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f(vector3f);
        vector3f3.sub((Tuple3f)vector3f2);
        return vector3f3;
    }

    public static float[] b(Vector3f vector3f) {
        return new float[]{vector3f.x, vector3f.y, vector3f.z};
    }

    public static boolean a(Point3f[] point3fArray, Vector3f vector3f, Point3f point3f) {
        Vector3f vector3f2 = new Vector3f(point3fArray[0].x - point3f.x, point3fArray[0].y - point3f.y, point3fArray[0].z - point3f.z);
        int n2 = (int)Math.signum(vector3f2.dot(vector3f));
        float f2 = 0.1f;
        for (Point3f point3f2 : point3fArray) {
            vector3f2 = new Vector3f(point3f2.x - point3f.x, point3f2.y - point3f.y, point3f2.z - point3f.z);
            float f3 = vector3f2.dot(vector3f);
            if (Math.abs(f3) < f2) {
                return true;
            }
            int n3 = (int)Math.signum(f3);
            if (n3 == n2) continue;
            return true;
        }
        return false;
    }

    public static Vector3f c(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = (Vector3f)vector3f2.clone();
        vector3f3.scale(vector3f.dot(vector3f2));
        vector3f3.sub((Tuple3f)vector3f, (Tuple3f)vector3f3);
        return vector3f3;
    }

    public static Vector3f[] c(Vector3f vector3f) {
        vector3f.normalize();
        Vector3f vector3f2 = l.c(new Vector3f(1.0f, 0.0f, 0.0f), vector3f);
        if (vector3f2.epsilonEquals((Tuple3f)new Vector3f(0.0f, 0.0f, 0.0f), 0.01f)) {
            vector3f2 = l.c(new Vector3f(0.0f, 1.0f, 0.0f), vector3f);
        }
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f2, vector3f);
        return new Vector3f[]{vector3f2, vector3f3};
    }

    public static Point2f a(Point3f point3f, Point3f point3f2, Vector3f vector3f, Vector3f vector3f2) {
        vector3f.normalize();
        vector3f2.normalize();
        Vector3f vector3f3 = new Vector3f();
        vector3f3.sub((Tuple3f)point3f, (Tuple3f)point3f2);
        return new Point2f(vector3f3.dot(vector3f), vector3f3.dot(vector3f2));
    }

    public static c[] a(Point3f[] point3fArray, Vector3f vector3f, Point3f point3f, Vector3f vector3f2) throws IllegalArgumentException {
        if (point3fArray.length != 3) {
            throw new IllegalArgumentException("You need exactly three vertices to define a triangle.");
        }
        if (!l.a(point3fArray, vector3f2, point3f)) {
            return new c[0];
        }
        Point3f[][] point3fArrayArray = new Point3f[][]{{point3fArray[0], point3fArray[1]}, {point3fArray[1], point3fArray[2]}, {point3fArray[2], point3fArray[0]}};
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>(2);
        for (Point3f[] point3fArray2 : point3fArrayArray) {
            Point3f[] point3fArray3 = l.b(point3fArray2[0], point3fArray2[1], point3f, vector3f2);
            arrayList.addAll(Arrays.asList(point3fArray3));
        }
        return l.a(arrayList, vector3f, vector3f2);
    }

    public static c[] a(List<? extends Point3f> list, Vector3f vector3f, Vector3f vector3f2) throws IllegalArgumentException {
        Vector3f vector3f3 = l.c(vector3f, vector3f2);
        return (c[])l.a(list, (Pt point3f, Pt point3f2) -> new c((Point3f)((Object)point3f), (Point3f)((Object)point3f2), vector3f3)).toArray(c[]::new);
    }

    public static <Rt, Pt extends Point3f> Stream<Rt> a(List<Pt> list, BiFunction<Pt, Pt, Rt> biFunction) {
        switch (list.size()) {
            case 2: {
                return Stream.of(biFunction.apply(list.get(0), list.get(1)));
            }
            case 3: {
                float f2 = ((Point3f)((Object)list.get(0))).distanceSquared((javax.vecmath.Point3f)list.get(1));
                float f3 = ((Point3f)((Object)list.get(0))).distanceSquared((javax.vecmath.Point3f)list.get(2));
                float f4 = ((Point3f)((Object)list.get(1))).distanceSquared((javax.vecmath.Point3f)list.get(2));
                if (f4 < f2 && f4 < f3) {
                    return Stream.of(biFunction.apply(list.get(0), list.get(2)));
                }
                return Stream.of(biFunction.apply(list.get(1), list.get(2)));
            }
            case 4: {
                float f5 = ((Point3f)((Object)list.get(1))).distanceSquared((javax.vecmath.Point3f)list.get(0));
                float f6 = ((Point3f)((Object)list.get(2))).distanceSquared((javax.vecmath.Point3f)list.get(0));
                float f7 = ((Point3f)((Object)list.get(3))).distanceSquared((javax.vecmath.Point3f)list.get(0));
                if (f5 < f6 && f5 < f7 || f6 < f5 && f6 < f7) {
                    return Stream.of(biFunction.apply(list.get(0), list.get(3)));
                }
                return Stream.of(biFunction.apply(list.get(0), list.get(2)));
            }
            case 6: {
                return Stream.of(biFunction.apply(list.get(0), list.get(1)), biFunction.apply(list.get(2), list.get(3)), biFunction.apply(list.get(4), list.get(5)));
            }
        }
        return Stream.empty();
    }

    public static <X extends Point2f> List<X> b(List<X> list) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        list.forEach(point2f -> linkedHashMap.put(new Point3f(point2f.x, point2f.y, 0.0f), point2f));
        ArrayList arrayList = Lists.newArrayList(linkedHashMap.keySet());
        return l.c(arrayList).stream().map(point3f -> (Point2f)((Object)((Object)linkedHashMap.get(point3f)))).collect(Collectors.toList());
    }

    public static <X extends Point3f> List<X> c(List<X> list) {
        Point3f point3f4;
        if (list.size() < 3) {
            return list;
        }
        Point3f point3f2 = (Point3f)((Object)list.get(0));
        final Point3f point3f3 = new Point3f();
        for (Point3f point3f4 : list) {
            point3f3.x += point3f4.x / (float)list.size();
            point3f3.y += point3f4.y / (float)list.size();
            point3f3.z += point3f4.z / (float)list.size();
        }
        Vector3f vector3f = l.b((Point3f)((Object)list.get(0)), (Point3f)((Object)list.get(1)), (Point3f)((Object)list.get(2)));
        point3f4 = new Vector3f();
        point3f4.sub((Tuple3f)point3f2, (Tuple3f)point3f3);
        Vector3f vector3f2 = new Vector3f();
        vector3f2.cross((Vector3f)point3f4, vector3f);
        ArrayList arrayList = Lists.newArrayList(list);
        Collections.sort(arrayList, new Comparator<X>((Vector3f)point3f4, vector3f2){
            final /* synthetic */ Vector3f b;
            final /* synthetic */ Vector3f c;
            {
                this.b = vector3f;
                this.c = vector3f2;
            }

            public int a(X x2, X x3) {
                Vector3f vector3f = new Vector3f();
                Vector3f vector3f2 = new Vector3f();
                vector3f.sub(x2, (Tuple3f)point3f3);
                vector3f2.sub(x3, (Tuple3f)point3f3);
                float f2 = this.b.dot(vector3f);
                float f3 = this.c.dot(vector3f);
                float f4 = this.b.dot(vector3f2);
                float f5 = this.c.dot(vector3f2);
                Vector2f vector2f = new Vector2f(1.0f, 0.0f);
                Vector2f vector2f2 = new Vector2f(f2, f3);
                Vector2f vector2f3 = new Vector2f(f4, f5);
                float f6 = vector2f2.angle(vector2f);
                float f7 = vector2f3.angle(vector2f);
                Vector2f vector2f4 = new Vector2f(0.0f, 0.0f);
                Vector2f vector2f5 = new Vector2f(1.0f, 0.0f);
                if (com.mimvista.contouring.b.a((Tuple2f)vector2f4, (Tuple2f)vector2f5, (Tuple2f)vector2f2) > 0.0f) {
                    f6 *= -1.0f;
                }
                Vector2f vector2f6 = new Vector2f(0.0f, 0.0f);
                Vector2f vector2f7 = new Vector2f(1.0f, 0.0f);
                if (com.mimvista.contouring.b.a((Tuple2f)vector2f6, (Tuple2f)vector2f7, (Tuple2f)vector2f3) > 0.0f) {
                    f7 *= -1.0f;
                }
                return Float.compare(f6, f7);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Object)((Object)((Point3f)((Object)object))), (Object)((Object)((Point3f)((Object)object2))));
            }
        });
        return arrayList;
    }

    public static boolean c(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        return point3f.x >= point3f2.x && point3f.x <= point3f3.x && point3f.y >= point3f2.y && point3f.y <= point3f3.y && point3f.z >= point3f2.z && point3f.z <= point3f3.z;
    }

    public static Point3f d(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Point3f point3f4 = new Point3f();
        if (point3f.x >= point3f2.x && point3f.x <= point3f3.x) {
            point3f4.x = point3f.x;
        } else {
            float f2 = point3f4.x = point3f.x <= point3f2.x ? point3f2.x : point3f3.x;
        }
        if (point3f.y >= point3f2.y && point3f.y <= point3f3.y) {
            point3f4.y = point3f.y;
        } else {
            float f3 = point3f4.y = point3f.y <= point3f2.y ? point3f2.y : point3f3.y;
        }
        point3f4.z = point3f.z >= point3f2.z && point3f.z <= point3f3.z ? point3f.z : (point3f.z <= point3f2.z ? point3f2.z : point3f3.z);
        return point3f4;
    }

    public static Point3f e(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Vector3f vector3f = new Vector3f();
        vector3f.sub((Tuple3f)point3f3, (Tuple3f)point3f2);
        Vector3f vector3f2 = new Vector3f();
        vector3f2.sub((Tuple3f)point3f, (Tuple3f)point3f2);
        float f2 = vector3f.dot(vector3f2);
        if (f2 <= 0.0f) {
            return point3f2;
        }
        float f3 = vector3f.dot(vector3f);
        if (f3 <= f2) {
            return point3f3;
        }
        float f4 = f2 / f3;
        Point3f point3f4 = new Point3f((Tuple3f)vector3f);
        point3f4.scale(f4);
        point3f4.add((Tuple3f)point3f2);
        return point3f4;
    }

    public static boolean a(b b2, Tuple3f tuple3f) {
        Vector3f vector3f = new Vector3f((Tuple3f)b2.b());
        Vector3f vector3f2 = new Vector3f(tuple3f);
        vector3f.sub((Tuple3f)vector3f2);
        return b2.a().dot(vector3f) >= 0.0f;
    }

    public static class c {
        private Point3f a;
        private Point3f b;
        private Vector3f c;

        public c(Point3f point3f, Point3f point3f2, Vector3f vector3f) {
            this.a = point3f;
            this.b = point3f2;
            this.c = vector3f;
        }

        public Point3f[] a() {
            return new Point3f[]{this.a, this.b};
        }

        public Vector3f b() {
            return this.c;
        }

        public boolean c() {
            return this.a.epsilonEquals((Tuple3f)this.b, 1.0E-4f);
        }
    }

    public static abstract class com.mimvista.numerics.contourtools.l$a {
        protected final Vector3f a;
        protected final Point3f b;
        protected final Point3f c;

        public abstract float a(Point3f var1);

        public abstract Point3f a(com.mimvista.numerics.contourtools.l$b var1);

        public abstract boolean a();

        private com.mimvista.numerics.contourtools.l$a(Point3f point3f, Point3f point3f2) {
            if (point3f.distance(point3f2) < 1.0E-4f) {
                throw new IllegalArgumentException("Line is ill-conditioned");
            }
            this.b = point3f.e();
            this.c = point3f2.e();
            this.a = l.a(point3f, point3f2);
            this.a.normalize();
        }

        private com.mimvista.numerics.contourtools.l$a(Point3f point3f, Vector3f vector3f) {
            this.b = point3f.e();
            this.a = new Vector3f(vector3f);
            this.a.normalize();
            this.c = point3f.e();
            this.c.add((Tuple3f)vector3f);
        }

        public com.mimvista.numerics.contourtools.l$a a(com.mimvista.numerics.contourtools.l$b b2, com.mimvista.numerics.contourtools.l$b b3) {
            Point3f point3f = this.a(b2);
            Point3f point3f2 = this.a(b3);
            if (point3f == null && point3f2 == null) {
                if (com.mimvista.numerics.contourtools.l$a.a(this.b, this.c).a(b2, b3) != null) {
                    return com.mimvista.numerics.contourtools.l$a.b(this.b, this.c);
                }
                return null;
            }
            if (point3f == null) {
                return b2.a(this.b) < b2.a(this.c) ? com.mimvista.numerics.contourtools.l$a.b(this.b, point3f2) : com.mimvista.numerics.contourtools.l$a.b(this.c, point3f2);
            }
            if (point3f2 == null) {
                return b3.a(this.b) < b3.a(this.c) ? com.mimvista.numerics.contourtools.l$a.b(this.b, point3f) : com.mimvista.numerics.contourtools.l$a.b(this.b, point3f2);
            }
            return com.mimvista.numerics.contourtools.l$a.b(point3f, point3f2);
        }

        public static com.mimvista.numerics.contourtools.l$a a(Point3f point3f, Point3f point3f2) {
            return com.mimvista.numerics.contourtools.l$a.a(point3f, l.a(point3f, point3f2));
        }

        public static com.mimvista.numerics.contourtools.l$a a(Point3f point3f, Vector3f vector3f) {
            return new a(point3f, vector3f);
        }

        public static com.mimvista.numerics.contourtools.l$a b(Point3f point3f, Point3f point3f2) {
            return new b(point3f, point3f2);
        }

        public void a(double d2, Point3f ... point3fArray) {
            double d3 = this.b.x;
            double d4 = this.b.y;
            double d5 = this.b.z;
            double d6 = this.a.x;
            double d7 = this.a.y;
            double d8 = this.a.z;
            double d9 = Math.cos(d2);
            double d10 = Math.sin(d2);
            double d11 = 1.0 - d9;
            for (Point3f point3f : point3fArray) {
                double d12 = point3f.x;
                double d13 = point3f.y;
                double d14 = point3f.z;
                point3f.x = (float)((d3 * (d7 * d7 + d8 * d8) - d6 * (d4 * d7 + d5 * d8 - d6 * d12 - d7 * d13 - d8 * d14)) * d11 + d12 * d9 + (-d5 * d7 + d4 * d8 - d8 * d13 + d7 * d14) * d10);
                point3f.y = (float)((d4 * (d6 * d6 + d8 * d8) - d7 * (d3 * d6 + d5 * d8 - d6 * d12 - d7 * d13 - d8 * d14)) * d11 + d13 * d9 + (d5 * d6 - d3 * d8 + d8 * d12 - d6 * d14) * d10);
                point3f.z = (float)((d5 * (d6 * d6 + d7 * d7) - d8 * (d3 * d6 + d4 * d7 - d6 * d12 - d7 * d13 - d8 * d14)) * d11 + d14 * d9 + (-d4 * d6 + d3 * d7 - d7 * d12 + d6 * d13) * d10);
            }
        }

        static class a
        extends com.mimvista.numerics.contourtools.l$a {
            a(Point3f point3f, Vector3f vector3f) {
                super(point3f, vector3f);
            }

            @Override
            public boolean a() {
                return false;
            }

            @Override
            public float a(Point3f point3f) {
                return l.a(this.a, l.a(this.b, point3f)).length();
            }

            @Override
            public Point3f a(com.mimvista.numerics.contourtools.l$b b2) {
                Float f2 = l.a(this.b, this.c, b2.b, b2.a);
                if (f2 == null || f2.isNaN()) {
                    return null;
                }
                Point3f point3f = new Point3f((Tuple3f)this.a);
                point3f.scaleAdd(f2.floatValue() * this.b.distance(this.c), (Tuple3f)this.b);
                return point3f;
            }
        }

        static class b
        extends com.mimvista.numerics.contourtools.l$a {
            b(Point3f point3f, Point3f point3f2) {
                super(point3f, point3f2);
            }

            @Override
            public boolean a() {
                return true;
            }

            @Override
            public float a(Point3f point3f) {
                float f2;
                float f3;
                Vector3f vector3f = l.a(this.b, this.c);
                Vector3f vector3f2 = l.a(this.b, point3f);
                float f4 = l.a((Tuple3f)vector3f2, (Tuple3f)vector3f);
                if (f3 <= -1.0E-4f) {
                    return point3f.distance(this.b);
                }
                float f5 = l.a((Tuple3f)vector3f, (Tuple3f)vector3f);
                if (f2 <= f4) {
                    return point3f.distance(this.c);
                }
                vector3f.scaleAdd(f4 / f5, (Tuple3f)this.b);
                vector3f.sub((Tuple3f)point3f);
                return vector3f.length();
            }

            @Override
            public Point3f a(com.mimvista.numerics.contourtools.l$b b2) {
                Point3f[] point3fArray = l.b(this.b, this.c, b2.b, b2.a);
                return point3fArray == null || point3fArray.length != 1 ? null : point3fArray[0];
            }
        }
    }

    public static class b {
        final Vector3f a;
        final Point3f b;

        public b(Point3f point3f, Point3f point3f2, Point3f point3f3) {
            this.a = l.b(point3f, (Point3f)((Object)point3f2.clone()), (Point3f)((Object)point3f3.clone()));
            this.b = (Point3f)((Object)point3f.clone());
        }

        public b(Point3f point3f, Vector3f vector3f) {
            this.a = new Vector3f(vector3f);
            this.b = new Point3f((Tuple3f)point3f);
        }

        public Vector3f a() {
            return this.a;
        }

        public Point3f b() {
            return this.b;
        }

        public float a(Point3f point3f) {
            return FastMath.abs((float)(l.a((Tuple3f)this.a, (Tuple3f)l.a(this.b, point3f)) / this.a.length()));
        }

        public Optional<a> a(b b2) {
            Optional<Point3f[]> optional = l.a(this.b, this.a, b2.b, b2.a);
            return optional.map(point3fArray -> com.mimvista.numerics.contourtools.l$a.a(point3fArray[0], point3fArray[1]));
        }

        public static Optional<Point3f> a(b b2, b b3, b b4) {
            return l.a(b2.b, b2.a, b3.b, b3.a, b4.b, b4.a);
        }

        public String toString() {
            return "[Plane|Normal:" + this.a.toString() + ",Point:" + this.b.toString() + "]";
        }

        public static int a(int n2, int n3, Tuple3f tuple3f) {
            n3 = (int)((float)(n2 * n3) + tuple3f.x);
            n3 = (int)((float)(n2 * n3) + tuple3f.y);
            n3 = (int)((float)(n2 * n3) + tuple3f.z);
            return n3;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.a == null ? 0 : com.mimvista.numerics.contourtools.l$b.a(31, n3, (Tuple3f)this.a));
            n3 = 31 * n3 + (this.b == null ? 0 : com.mimvista.numerics.contourtools.l$b.a(31, n3, (Tuple3f)this.b));
            return n3;
        }

        public static boolean a(Tuple3f tuple3f, Tuple3f tuple3f2) {
            return tuple3f.x == tuple3f2.x && tuple3f.y == tuple3f2.y && tuple3f.z == tuple3f2.z;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            b b2 = (b)object;
            if (this.a == null ? b2.a != null : !com.mimvista.numerics.contourtools.l$b.a((Tuple3f)this.a, (Tuple3f)b2.a)) {
                return false;
            }
            return !(this.b == null ? b2.b != null : !com.mimvista.numerics.contourtools.l$b.a((Tuple3f)this.b, (Tuple3f)b2.b));
        }

        public static b a(ViewStateNew viewStateNew, az az2) {
            MetricPoint3f metricPoint3f = viewStateNew.metricCoords;
            MetricViewingPoint3f metricViewingPoint3f = metricPoint3f.a(viewStateNew.rotationMatrix);
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
            fArray[az2.D()[2]] = 1.0f;
            MetricViewingPoint3f metricViewingPoint3f2 = metricViewingPoint3f.b();
            metricViewingPoint3f2.add((Tuple3f)new Vector3f(fArray));
            Vector3f vector3f = l.a(metricViewingPoint3f.a(viewStateNew.rotationMatrix), (Point3f)metricViewingPoint3f2.a(viewStateNew.rotationMatrix));
            metricViewingPoint3f.a(az2.D()[2], az2.af());
            metricPoint3f.set((Tuple3f)metricViewingPoint3f.a(viewStateNew.rotationMatrix));
            return new b(metricPoint3f, vector3f);
        }
    }
}

