/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics.downscatter;

import com.google.common.collect.Lists;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.linking.FORLinkHelper;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.b.m;
import com.mimvista.numerics.downscatter.b;
import com.mimvista.numerics.downscatter.c;
import com.mimvista.preferencesNew.DebugPrefs;
import com.mimvista.util.w;
import java.util.Optional;
import java.util.function.Supplier;

public class a {
    public static int[][] a(b.b b2, float f2, float f3, float f4) {
        int n2 = (int)Math.ceil(f2 * 2.0f / f3);
        int n3 = (int)Math.ceil(f2 * 2.0f / f4);
        if (n2 % 2 == 0) {
            ++n2;
        }
        if (n3 % 2 == 0) {
            ++n3;
        }
        double[][] dArray = new double[n2][n3];
        float f5 = (float)n2 / 2.0f;
        float f6 = (float)n3 / 2.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d2;
                float f7 = (float)i2 + 0.5f;
                float f8 = (f5 - f7) * f3;
                float f9 = (float)i3 + 0.5f;
                float f10 = (f6 - f9) * f4;
                double d3 = Math.sqrt(f8 * f8 + f10 * f10);
                double d4 = d3;
                double d5 = d4 <= 0.0 ? 0.0 : (d2 = 1.0 / Math.pow(d3 + 1.0, b2.exponentialDecayFactorForSmooth));
                dArray[i2][i3] = d5;
            }
        }
        double d6 = dArray[0][0];
        for (int i4 = 0; i4 < n3; ++i4) {
            d6 = Math.max(d6, MathUtils.k(dArray[i4]));
        }
        int[][] nArray = new int[n2][n3];
        for (int i5 = 0; i5 < n2; ++i5) {
            for (int i6 = 0; i6 < n3; ++i6) {
                nArray[i6][i5] = MathUtils.c(dArray[i6][i5] / d6 * 32767.0);
            }
        }
        return nArray;
    }

    public static ViewController3D a(ViewController3D viewController3D, ViewController3D viewController3D2, Supplier<b.b> supplier) {
        int[] nArray;
        b b2 = c.a();
        Optional<b.b> optional = b2.getParametersFor(viewController3D2, viewController3D);
        b.b b3 = optional.orElseGet(supplier);
        if (b3 == null) {
            return null;
        }
        float f2 = 180.0f;
        if (viewController3D.at().n() > 1 || viewController3D2.at().n() > 1) {
            throw new IllegalArgumentException("Downscatter correction does not support dynamic vols");
        }
        ImageVolumeShort imageVolumeShort = viewController3D.cw();
        ImageVolumeShort imageVolumeShort2 = viewController3D2.cw();
        ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)imageVolumeShort2.ad();
        ImageCube.ImageCubeShort imageCubeShort2 = (ImageCube.ImageCubeShort)imageVolumeShort.ad();
        if (imageCubeShort.d()[2] > 1 || imageCubeShort2.d()[2] > 1) {
            throw new IllegalArgumentException("Downscatter correction does not support 3D vols");
        }
        int[] nArray2 = imageVolumeShort2.a();
        if (nArray2[0] != (nArray = imageVolumeShort.a())[0]) {
            throw new IllegalArgumentException("X dims not equal: " + nArray2[0] + " ~ " + nArray[0]);
        }
        if (nArray2[1] != nArray[1]) {
            throw new IllegalArgumentException("Y dims not equal: " + nArray2[1] + " ~ " + nArray[1]);
        }
        float[] fArray = imageVolumeShort2.b();
        int[][] nArray3 = a.a(b3, f2, fArray[0], fArray[1]);
        ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)imageCubeShort.f(0);
        m m2 = new m();
        ImageVolumeShort imageVolumeShort3 = imageVolumeShort2.W();
        ImageSlice.ImageSliceShort imageSliceShort2 = (ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)imageVolumeShort3.ad()).f(0);
        m2.a(imageSliceShort, imageSliceShort2, new int[]{imageSliceShort.width, imageSliceShort.height}, nArray3, 1, true, true);
        for (int i2 = 0; i2 < imageSliceShort2.height; ++i2) {
            for (int i3 = 0; i3 < imageSliceShort2.width; ++i3) {
                if (imageSliceShort2.d(i3, i2) >= 0) continue;
                throw new IllegalArgumentException("Overflow occurred during smoothing step.");
            }
        }
        Session session = viewController3D.g();
        if (DebugPrefs.showSmoothedInVolForDownscatter.getValue().booleanValue()) {
            w.a(session, imageVolumeShort3, null);
        }
        ImageVolumeShort imageVolumeShort4 = imageVolumeShort.W();
        ImageCube.ImageCubeShort imageCubeShort3 = (ImageCube.ImageCubeShort)imageVolumeShort4.ad();
        ImageSlice.ImageSliceShort imageSliceShort3 = (ImageSlice.ImageSliceShort)imageCubeShort3.f(0);
        ImageSlice.ImageSliceShort imageSliceShort4 = (ImageSlice.ImageSliceShort)imageCubeShort2.f(0);
        RescaleConverter rescaleConverter = imageVolumeShort3.getUncopiedMutableInfo().rescale;
        RescaleConverter rescaleConverter2 = imageVolumeShort.getUncopiedMutableInfo().rescale;
        RescaleConverter rescaleConverter3 = imageVolumeShort4.getUncopiedMutableInfo().rescale;
        for (int i4 = 0; i4 < imageSliceShort3.height; ++i4) {
            for (int i5 = 0; i5 < imageSliceShort3.width; ++i5) {
                float f3 = rescaleConverter2.apply(imageSliceShort4.d(i5, i4));
                float f4 = rescaleConverter.apply(imageSliceShort2.d(i5, i4));
                float f5 = (float)(b3.downscatterRatio * (double)f4);
                float f6 = Math.max(f3 - f5, 0.0f);
                imageSliceShort3.a(i5, i4, (short)rescaleConverter3.removeWithBounds(f6));
            }
        }
        ViewController3D viewController3D3 = w.a(session, imageVolumeShort4, null);
        FORLinkHelper.a(Lists.newArrayList((Object[])new Long[]{viewController3D3.aV()}), session);
        return viewController3D3;
    }
}

