/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.numerics.optimization;

import com.google.common.collect.Lists;
import com.mimvista.numerics.af;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GeneticAlgorithm<T extends Gene> {
    protected GaParameters d;
    protected List<Organism> e = Lists.newArrayList();
    private T a;
    private int b = -1;
    private float c;
    private int i = 0;
    private float[] j;
    private boolean k = false;
    private List<a<T>> l = Lists.newArrayList();
    public Random f;
    public transient af.b<T> g;
    private transient Map<T, Float> m = new ConcurrentHashMap<T, Float>();
    boolean h = false;

    public void a(a<T> a2) {
        this.l.add(a2);
    }

    public GeneticAlgorithm() {
        this(1000L);
    }

    public GeneticAlgorithm(long l2) {
        this.f = new Random(l2);
    }

    public void a(boolean bl2) {
        this.h = bl2;
    }

    public void a(int n2) {
        this.d.numIterations = n2;
    }

    public T b() {
        this.c = this.d.shouldMinimize ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        this.a();
        this.c();
        this.d();
        this.i = 0;
        while (this.i++ < this.d.numIterations) {
            if (this.k && this.i % 1000 == 0) {
                ay.e("Iteration " + this.i);
            }
            this.b(this.i);
        }
        ay.b((Object)("Global best set on: " + this.b + " / " + this.d.numIterations), "");
        ay.b((Object)("Global best score: " + new Organism(this, this.a).a()), "");
        return (T)((Gene)this.a).a();
    }

    private void c() {
        int n2;
        int n3 = 0;
        int n4 = (int)((double)this.e.size() * 0.1);
        int n5 = (int)((double)this.e.size() * 0.5);
        this.j = new float[this.e.size()];
        for (n2 = 0; n2 < n4; ++n2) {
            this.j[n2] = 10 + n4 - n2;
            n3 = (int)((float)n3 + this.j[n2]);
        }
        for (n2 = n4; n2 < n5; ++n2) {
            this.j[n2] = 5.0f;
            n3 = (int)((float)n3 + this.j[n2]);
        }
        for (n2 = n5; n2 < this.e.size(); ++n2) {
            this.j[n2] = 1.0f;
            n3 = (int)((float)n3 + this.j[n2]);
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < this.e.size(); ++i2) {
            this.j[i2] = (f2 += this.j[i2]) / (float)n3;
        }
    }

    protected abstract void a();

    public void b(int n2) {
        if (this.k) {
            bg.b("iteration " + n2);
        }
        float f2 = 1.0f;
        if (this.d.activitySchedule != null) {
            f2 = this.d.activitySchedule.a(Float.valueOf(n2));
        }
        for (Organism iterator : this.e) {
            iterator.a(f2);
        }
        this.d();
        if (this.l.size() != 0) {
            ArrayList arrayList = Lists.newArrayList();
            for (Organism organism : this.e) {
                arrayList.add(organism.gene);
            }
            for (a<T> a2 : this.l) {
                a2.a(this.a, arrayList);
            }
        }
        this.e();
        if (this.k) {
            bg.e("iteration " + n2);
        }
    }

    private void e() {
        Organism organism;
        int n2;
        int n3;
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.d.numOrganisms);
        Collections.sort(this.e);
        if (!this.d.shouldMinimize) {
            Collections.reverse(this.e);
        }
        for (n3 = 0; n3 < this.e.size(); ++n3) {
            this.e.get((int)n3).nProb = this.j[n3];
        }
        if (this.k) {
            ay.e("Iter Best: " + this.e.get((int)0).currentScore + ", " + this.e.get((int)0).nProb);
            ay.e("Iter Worst: " + this.e.get((int)(this.e.size() - 1)).currentScore + ", " + this.e.get((int)(this.e.size() - 1)).nProb);
        }
        n3 = (int)(this.d.retainPercentage * (float)this.d.numOrganisms);
        int n4 = (int)(this.d.passThroughPercentage * (float)this.d.numOrganisms);
        int n5 = this.d.numOrganisms - n3 - n4;
        for (n2 = 0; n2 < n4; ++n2) {
            arrayList.add(this.e.get(n2));
        }
        for (n2 = 0; n2 < n5; ++n2) {
            organism = this.f();
            Organism organism2 = this.a(organism);
            arrayList.add(organism.a(organism2));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            organism = this.f();
            int n6 = this.f.nextInt(n3);
            Organism organism3 = this.e.get(this.e.size() - n6 - 1);
            arrayList.add(organism.a(organism3));
        }
        this.e = arrayList;
    }

    private Organism f() {
        float f2 = this.f.nextFloat();
        for (Organism organism : this.e) {
            if (!(f2 < organism.nProb)) continue;
            return organism;
        }
        return this.e.get(this.e.size() - 1);
    }

    private Organism a(Organism organism) {
        float f2 = this.f.nextFloat();
        for (Organism organism2 : this.e) {
            if (!(f2 < organism2.nProb) || organism2 == organism) continue;
            return organism2;
        }
        return this.e.get(this.e.size() - 1);
    }

    public void d() {
        for (Organism organism : this.e) {
            float f2 = organism.a();
            if (this.d.shouldMinimize) {
                if (!(f2 < this.c)) continue;
                this.c = f2;
                if (this.k) {
                    System.out.println("setting global best");
                }
                this.a = ((Gene)organism.gene).a();
                this.b = this.i;
                continue;
            }
            if (!(f2 > this.c)) continue;
            this.c = f2;
            if (this.k) {
                System.out.println("setting global best " + f2);
            }
            this.a = ((Gene)organism.gene).a();
            this.b = this.i;
        }
    }

    protected static class Organism
    implements Serializable,
    Comparable<Organism> {
        private static final long serialVersionUID = 1L;
        T gene;
        T localBest;
        float bestScore;
        float currentScore;
        float nProb;
        final /* synthetic */ GeneticAlgorithm this$0;

        public Organism(T t2) {
            this.this$0 = var1_1;
            this.bestScore = var1_1.d.shouldMinimize ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
            this.gene = t2;
        }

        public Organism(GeneticAlgorithm geneticAlgorithm, Organism organism, Organism organism2) {
            this.this$0 = geneticAlgorithm;
            this.gene = ((Gene)organism.gene).a((Gene)organism2.gene);
            this.localBest = organism.localBest;
            this.bestScore = organism.bestScore;
        }

        public void a(float f2) {
            ((Gene)this.gene).a(f2);
        }

        public Organism a(Organism organism) {
            return new Organism(this.this$0, this, organism);
        }

        float a() {
            Float f2;
            if (this.this$0.h && (f2 = (Float)this.this$0.m.get(this.gene)) != null) {
                return f2.floatValue();
            }
            float f3 = this.this$0.g.a(this.gene);
            if (this.this$0.h) {
                this.this$0.m.put(this.gene, Float.valueOf(f3));
            }
            if (this.this$0.d.shouldMinimize && f3 < this.bestScore) {
                this.bestScore = f3;
                this.localBest = ((Gene)this.gene).a();
            } else if (!this.this$0.d.shouldMinimize && f3 > this.bestScore) {
                this.bestScore = f3;
                this.localBest = ((Gene)this.gene).a();
            }
            this.currentScore = f3;
            return f3;
        }

        public int b(Organism organism) {
            Organism organism2 = organism;
            if (this.currentScore < organism2.currentScore) {
                return -1;
            }
            if (this.currentScore > organism2.currentScore) {
                return 1;
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.b((Organism)object);
        }
    }

    public static abstract class Gene
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 3890548744321623135L;

        public abstract void a(float var1);

        public abstract Gene a(Gene var1);

        public abstract Gene a();

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.a();
        }
    }

    public static class GaParameters
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -3302682069364049005L;
        public int dimensions = -1;
        public int numOrganisms = -1;
        public int numIterations = 100;
        public boolean shouldMinimize = true;
        public af.b<Float> activitySchedule;
        public float passThroughPercentage = 0.1f;
        public float retainPercentage = 0.1f;

        public GaParameters(int n2, int n3, int n4) {
            this.dimensions = n2;
            this.numOrganisms = n3;
            this.numIterations = n4;
        }
    }

    public static interface a<U> {
        public void a(U var1, List<U> var2);
    }
}

