/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.preferencesNew;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.b;
import com.mimvista.internals.PresetWindowLevel;
import com.mimvista.license.g;
import com.mimvista.license.q;
import com.mimvista.preferences.LegacyMIMPrefsFile;
import com.mimvista.preferencesNew.CompositeMIMPref;
import com.mimvista.preferencesNew.CompositeMIMPrefFactory;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.preferencesNew.MIMPrefFile;
import com.mimvista.preferencesNew.MIMPrefList;
import com.mimvista.preferencesNew.MIMPrefReference;
import com.mimvista.preferencesNew.MIMSubPref;
import com.mimvista.preferencesNew.ParentedCompositeMIMPref;
import com.mimvista.preferencesNew.PrefAccessTypeManager;
import com.mimvista.preferencesNew.PrefConverter;
import com.mimvista.preferencesNew.k;
import com.mimvista.preferencesNew.l;
import com.mimvista.preferencesNew.n;
import com.mimvista.properties.af;
import com.mimvista.update.VersionNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

@l(b=LegacyMIMPrefsFile.CTPRESETS, c=PrefAccessTypeManager.PrefAccess.USER)
public class ContrastPresetsPrefs
extends MIMPrefFile {
    public static final ContrastPresetsList ctPresets = new ContrastPresetsList(LegacyMIMPrefsFile.G, "CT Presets"){

        @Override
        public List<PresetWindowLevel> getDefaultValue() {
            ArrayList arrayList = Lists.newArrayList((Iterable)super.getDefaultValue());
            if (g.a(new com.mimvista.license.k(){

                @Override
                @q(b="Brachy Seed Window/Level Preset", a={LicenseOption.BRACHYTHERAPY})
                public void run() {
                }
            })) {
                arrayList.add(PresetWindowLevel.getSeedPreset());
            }
            return arrayList;
        }

        @Override
        public ArrayList<PresetWindowLevel> getValue() {
            if (this.hasValueOnDisk()) {
                return super.getValue();
            }
            return (ArrayList)this.getDefaultValue();
        }
    };
    @b(a="6.5.999")
    public static final ContrastPresetsList legacyPetPresets = new ContrastPresetsList(LegacyMIMPrefsFile.aZ, "PET Presets"){};
    public static final ContrastPresetsList petPresets = new ContrastPresetsList(LegacyMIMPrefsFile.aZ, "PET Presets 6.6+"){};
    public static final ContrastPresetsList mrPresets = new ContrastPresetsList(LegacyMIMPrefsFile.aM, "MR Presets"){};
    public static final ContrastPresetsList usPresets = new ContrastPresetsList("US Presets"){};
    @Deprecated
    private static final MIMPref<PresetWindowLevel> oldCTPresetDefault = new MIMPrefReference<PresetWindowLevel>("DEFAULT", (MIMPrefList)ctPresets){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.G);
    @Deprecated
    private static final MIMPref<PresetWindowLevel> oldMRPresetDefault = new MIMPrefReference<PresetWindowLevel>("DEFAULT", (MIMPrefList)mrPresets){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.aM);
    @Deprecated
    private static final MIMPref<PresetWindowLevel> oldPTPresetDefault = new MIMPrefReference<PresetWindowLevel>("DEFAULT", (MIMPrefList)petPresets){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.aZ);
    public static final MIMPrefReference<PresetWindowLevel> defaultCTpreset = new MIMPrefReference<PresetWindowLevel>("CT DEFAULT PRESET", (MIMPrefList)ctPresets){}.setNoBackwardsCompatibilityFile();
    public static final MIMPrefReference<PresetWindowLevel> defaultMRpreset = new MIMPrefReference<PresetWindowLevel>("MR DEFAULT PRESET", (MIMPrefList)mrPresets){}.setNoBackwardsCompatibilityFile();
    public static final MIMPrefReference<PresetWindowLevel> defaultPTpreset = new MIMPrefReference<PresetWindowLevel>("PET DEFAULT PRESET", (MIMPrefList)petPresets){}.setNoBackwardsCompatibilityFile();
    public static final MIMPref<List<String>> modalitiesThatWeShouldTryToLoadContrastFromDicom = new MIMPref<List<String>>("MODALITIES THAT SHOULD TRY TO LOAD INITIAL WINDOW LEVEL FROM DICOM"){};
    public static final MIMPrefReference<PresetWindowLevel> defaultUSpreset = new MIMPrefReference<PresetWindowLevel>("US DEFAULT PRESET", (MIMPrefList)usPresets){}.setNoBackwardsCompatibilityFile();
    public static final a loadDcmContrast;

    public static ImmutableList<PresetWindowLevel> getCTPresets() {
        return ImmutableList.copyOf((Collection)ctPresets.getValue());
    }

    public static ImmutableList<PresetWindowLevel> getPETPresets() {
        return ImmutableList.copyOf((Collection)petPresets.getValue());
    }

    public static ImmutableList<PresetWindowLevel> getMRPresets() {
        return ImmutableList.copyOf((Collection)mrPresets.getValue());
    }

    public static ImmutableList<PresetWindowLevel> getUSPresets() {
        return ImmutableList.copyOf((Collection)usPresets.getValue());
    }

    private static PrefConverter<String, PresetWindowLevel> getConverter(final ContrastPresetsList contrastPresetsList) {
        return new PrefConverter<String, PresetWindowLevel>(){

            @Override
            public PresetWindowLevel a(String string) {
                Iterator iterator = ((ArrayList)contrastPresetsList.getValue()).iterator();
                while (iterator.hasNext()) {
                    PresetWindowLevel presetWindowLevel = (PresetWindowLevel)iterator.next();
                    if (!presetWindowLevel.getName().equalsIgnoreCase(string) && !presetWindowLevel.getUniqueId().equalsIgnoreCase(string)) continue;
                    return presetWindowLevel;
                }
                return null;
            }
        };
    }

    static {
        defaultCTpreset.addBackwardsCompatiblePref(oldCTPresetDefault, new VersionNumber("6.5.0"));
        defaultMRpreset.addBackwardsCompatiblePref(oldMRPresetDefault, new VersionNumber("6.5.0"));
        defaultPTpreset.addBackwardsCompatiblePref(oldPTPresetDefault, new VersionNumber("6.5.0"));
        ctPresets.addBackwardsCompatiblePref((MIMPref)new OldStyleCTPresetsList("CT Presets"), new VersionNumber("6.5.0"));
        defaultCTpreset.addBackwardsCompatiblePref(new MIMPref<String>("DEFAULT"){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.G), ContrastPresetsPrefs.getConverter(ctPresets), new VersionNumber("6.5.0"));
        defaultMRpreset.addBackwardsCompatiblePref(new MIMPref<String>("DEFAULT"){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.aM), ContrastPresetsPrefs.getConverter(mrPresets), new VersionNumber("6.5.0"));
        defaultPTpreset.addBackwardsCompatiblePref(new MIMPref<String>("DEFAULT"){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.aZ), ContrastPresetsPrefs.getConverter(petPresets), new VersionNumber("6.5.0"));
        petPresets.addBackwardsCompatiblePref(legacyPetPresets, new PrefConverter<List<PresetWindowLevel>, List<PresetWindowLevel>>(){

            @Override
            public List<PresetWindowLevel> a(List<PresetWindowLevel> list) {
                ArrayList arrayList = Lists.newArrayList();
                for (PresetWindowLevel presetWindowLevel : list) {
                    float f2 = presetWindowLevel.windowCenter - presetWindowLevel.windowWidth / 2.0f;
                    float f3 = presetWindowLevel.windowCenter + presetWindowLevel.windowWidth / 2.0f;
                    boolean bl2 = (double)f2 <= 0.01;
                    boolean bl3 = (double)f3 <= 0.01;
                    arrayList.add(new PresetWindowLevel(presetWindowLevel.name, presetWindowLevel.windowCenter, presetWindowLevel.windowWidth, presetWindowLevel.gamma, presetWindowLevel.nameIsMessagesKey, presetWindowLevel.id, bl2, bl3));
                }
                return arrayList;
            }
        }, new VersionNumber("6.5.0"));
        loadDcmContrast = new a();
    }

    public static class a
    extends k<String, Boolean> {
        private static final String a = " DEFAULT DICOM CONTRAST";

        private a() {
            super(Boolean.class);
        }

        @Override
        protected String a(String string) {
            return string + a;
        }

        @Override
        protected boolean c(String string) {
            return string.endsWith(a);
        }

        protected String b(String string) {
            return string.replace(a, "");
        }

        @Override
        protected boolean ci_() {
            return true;
        }

        protected Boolean e(String string) {
            return false;
        }

        @Override
        protected /* synthetic */ Object d(Object object) {
            return this.e((String)object);
        }

        @Override
        protected /* synthetic */ Object d(String string) {
            return this.b(string);
        }
    }

    public static class ContrastPresetsList
    extends CompositeMIMPrefFactory<ContrastPresetsPref, PresetWindowLevel> {
        ContrastPresetsList(String string) {
            super(ContrastPresetsPrefs.class, string, PresetWindowLevel.class, "NUMBER_OF_PRESETS");
            this.setNoBackwardsCompatibilityFile();
        }

        ContrastPresetsList(com.mimvista.preferences.a a2, String string) {
            super(ContrastPresetsPrefs.class, string, PresetWindowLevel.class, "NUMBER_OF_PRESETS");
            this.setBackwardsCompatibilityFile(a2);
        }

        @Override
        protected ContrastPresetsPref getPrefWithKey(String string) {
            return new ContrastPresetsPref(this, string, this.file);
        }

        @Override
        protected ContrastPresetsPref createPrefWithId(String string) {
            return new ContrastPresetsPref(this, string, this.file);
        }
    }

    public static class ContrastPresetsPref
    extends ParentedCompositeMIMPref<PresetWindowLevel> {
        private final MIMSubPref<PresetWindowLevel, String> name;
        private final MIMSubPref<PresetWindowLevel, Float> winC;
        private final MIMSubPref<PresetWindowLevel, Float> winW;
        private final MIMSubPref<PresetWindowLevel, Float> gamma;

        public ContrastPresetsPref(ContrastPresetsList contrastPresetsList, String string, com.mimvista.preferences.a a2) {
            super(contrastPresetsList, string, ContrastPresetsPrefs.class, PresetWindowLevel.class);
            this.setBackwardsCompatibilityFile(a2);
            this.name = new MIMSubPref<PresetWindowLevel, String>((CompositeMIMPref)this, "PRESET_{0}_NAME", String.class, "name"){}.setBackwardsCompatibilityFile(a2);
            this.winC = new MIMSubPref<PresetWindowLevel, Float>((CompositeMIMPref)this, "PRESET_{0}_CENTER", Float.class, "windowCenter", n.k){}.setBackwardsCompatibilityFile(a2);
            this.winW = new MIMSubPref<PresetWindowLevel, Float>((CompositeMIMPref)this, "PRESET_{0}_WIDTH", Float.class, "windowWidth", n.k){}.setBackwardsCompatibilityFile(a2);
            this.gamma = new MIMSubPref<PresetWindowLevel, Float>((CompositeMIMPref)this, "PRESET_{0}_GAMMA", Float.class, "gamma", n.k){}.setBackwardsCompatibilityFile(a2);
        }

        @Override
        public List<MIMSubPref<PresetWindowLevel, ?>> getComponentPrefs(boolean bl2, af af2) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.name);
            arrayList.add(this.winC);
            arrayList.add(this.winW);
            arrayList.add(this.gamma);
            return arrayList;
        }

        @Override
        public PresetWindowLevel createOldType(af af2, String string) {
            Float f2 = (Float)this.winC.getValue(false, af2);
            Float f3 = (Float)this.winW.getValue(false, af2);
            Float f4 = (Float)this.gamma.getValue(false, af2);
            String string2 = (String)this.name.getValue(false, af2);
            boolean bl2 = PresetWindowLevel.PresetHistoricalNames.containsKey(string2);
            if (bl2) {
                string = string2 = PresetWindowLevel.PresetHistoricalNames.get(string2);
            }
            return new PresetWindowLevel(string2, f2.floatValue(), f3.floatValue(), f4.floatValue(), bl2, string);
        }

        @Override
        public PresetWindowLevel createNewType(String string) {
            return null;
        }
    }

    @Deprecated
    public static class OldStyleCTPresetsList
    extends CompositeMIMPrefFactory<OldStyleCTPresetsPref, PresetWindowLevel> {
        OldStyleCTPresetsList(String string) {
            super(ContrastPresetsPrefs.class, string, PresetWindowLevel.class, "");
            this.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.G);
        }

        @Override
        protected OldStyleCTPresetsPref getPrefWithKey(String string) {
            return new OldStyleCTPresetsPref(this, string);
        }

        @Override
        public List<OldStyleCTPresetsPref> getPrefsInList(af af2, boolean bl2) {
            if (bl2) {
                return super.getPrefsInList(af2, bl2);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (String string : PresetWindowLevel.cspHistoricalNameKeys) {
                PresetWindowLevel presetWindowLevel;
                OldStyleCTPresetsPref oldStyleCTPresetsPref = this.getPrefWithKey(string);
                if (!oldStyleCTPresetsPref.hasValueOnDisk(false, af2) || (presetWindowLevel = (PresetWindowLevel)oldStyleCTPresetsPref.getValue(false, af2)) == null || Float.isNaN(presetWindowLevel.gamma) && Float.isNaN(presetWindowLevel.windowCenter) && Float.isNaN(presetWindowLevel.windowWidth)) continue;
                this.memberPrefs.put(string, oldStyleCTPresetsPref);
                arrayList.add(oldStyleCTPresetsPref);
            }
            for (int i2 = 0; i2 < 10; ++i2) {
                PresetWindowLevel presetWindowLevel;
                OldStyleCTPresetsPref oldStyleCTPresetsPref = this.getPrefWithKey(i2 + "");
                if (!oldStyleCTPresetsPref.hasValueOnDisk(false, af2) || (presetWindowLevel = (PresetWindowLevel)oldStyleCTPresetsPref.getValue(false, af2)) == null || Float.isNaN(presetWindowLevel.gamma) && Float.isNaN(presetWindowLevel.windowCenter) && Float.isNaN(presetWindowLevel.windowWidth)) continue;
                this.memberPrefs.put(i2 + "", oldStyleCTPresetsPref);
                arrayList.add(oldStyleCTPresetsPref);
            }
            return arrayList;
        }

        @Override
        protected OldStyleCTPresetsPref createPrefWithId(String string) {
            return new OldStyleCTPresetsPref(this, string);
        }
    }

    @Deprecated
    private static class OldStyleCTPresetsPref
    extends ParentedCompositeMIMPref<PresetWindowLevel> {
        private final MIMSubPref<PresetWindowLevel, Float> winC;
        private final MIMSubPref<PresetWindowLevel, Float> winW;
        private final MIMSubPref<PresetWindowLevel, Float> gamma;
        private final boolean defaultPreset;

        public OldStyleCTPresetsPref(OldStyleCTPresetsList oldStyleCTPresetsList, String string) {
            super(oldStyleCTPresetsList, string, ContrastPresetsPrefs.class, PresetWindowLevel.class);
            this.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.G);
            boolean bl2 = true;
            try {
                Integer.parseInt(string);
                bl2 = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.defaultPreset = bl2;
            String string2 = bl2 ? string : "KEY_{0}";
            this.winC = new MIMSubPref<PresetWindowLevel, Float>((CompositeMIMPref)this, string2 + "_CENTER", Float.class, "windowCenter", n.k, false){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.G);
            this.winW = new MIMSubPref<PresetWindowLevel, Float>((CompositeMIMPref)this, string2 + "_WIDTH", Float.class, "windowWidth", n.k, false){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.G);
            this.gamma = new MIMSubPref<PresetWindowLevel, Float>((CompositeMIMPref)this, string2 + "_GAMMA", Float.class, "gamma", n.k, false){}.setBackwardsCompatibilityFile(LegacyMIMPrefsFile.G);
        }

        @Override
        public List<MIMSubPref<PresetWindowLevel, ?>> getComponentPrefs(boolean bl2, af af2) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.winC);
            arrayList.add(this.winW);
            arrayList.add(this.gamma);
            return arrayList;
        }

        @Override
        public PresetWindowLevel createOldType(af af2, String string) {
            Float f2 = (Float)this.winC.getValue(false, af2);
            Float f3 = (Float)this.winW.getValue(false, af2);
            Float f4 = (Float)this.gamma.getValue(false, af2);
            if (!this.defaultPreset) {
                string = "KEY_" + this.getId();
            }
            String string2 = string.toUpperCase();
            return new PresetWindowLevel(string2, f2.floatValue(), f3.floatValue(), f4.floatValue(), true, string);
        }

        @Override
        public PresetWindowLevel createNewType(String string) {
            return new PresetWindowLevel(string, 40.0f, 400.0f, 1.0f, false, string);
        }
    }
}

