/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.preferencesNew;

import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.preferences.LegacyMIMPrefsFile;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.preferencesNew.MIMPrefFile;
import com.mimvista.preferencesNew.PrefAccessTypeManager;
import com.mimvista.preferencesNew.l;
import com.mimvista.util.ay;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

@l(b=LegacyMIMPrefsFile.METABASE, c=PrefAccessTypeManager.PrefAccess.MACHINE)
public class MetabasePrefs
extends MIMPrefFile {
    public static final MIMPref<Integer> backupExpirationTimeInDays = new MIMPref<Integer>("BACKUP EXPIRATION TIME IN DAYS"){};
    public static final MIMPref<File> backupPath = new MIMPref<File>("BACKUP PATH"){};
    public static final MIMPref<Integer> backupPeriodInDays = new MIMPref<Integer>("BACKUP PERIOD IN DAYS"){};
    public static final MIMPref<String> backupTime = new MIMPref<String>("BACKUP TIME"){};
    public static final MIMPref<Boolean> deepScanning = new MIMPref<Boolean>("DEEP SCANNING"){};
    public static final MIMPref<String[]> dicomtagsthatshouldnotbetruncated = new MIMPref<String[]>("DICOMTAGSTHATSHOULDNOTBETRUNCATED"){};
    public static final MIMPref<String[]> dicomtagstoignore = new MIMPref<String[]>("DICOMTAGSTOIGNORE"){};
    public static final MIMPref<String[]> dicomTagPathsToNotIgnore = new MIMPref<String[]>("DICOM TAGPATHS TO NOT IGNORE"){};
    public static final MIMPref<Boolean> doMetabaseBackups = new MIMPref<Boolean>("DO METABASE BACKUPS"){};
    public static final MIMPref<Integer> maxdicomsequencelength = new MIMPref<Integer>("MAXDICOMSEQUENCELENGTH"){};
    public static final MIMPref<String> indexes = new MIMPref<String>("INDEXES"){};
    public static final MIMPref<Boolean> metabaseEnableBackups = new MIMPref<Boolean>("METABASE_ENABLE_BACKUPS"){};
    public static final MIMPref<Integer> maxdicomtagvaluewidth = new MIMPref<Integer>("MAXDICOMTAGVALUEWIDTH"){};
    public static final MIMPref<Boolean> purgeemptyseriesfolders = new MIMPref<Boolean>("PURGEEMPTYSERIESFOLDERS"){};
    public static final MIMPref<Boolean> scanallsopinstanceuids = new MIMPref<Boolean>("SCANALLSOPINSTANCEUIDS"){};
    public static final MIMPref<String[]> sopclassesthatneedeverysopinstanceuidscanned = new MIMPref<String[]>("SOPCLASSESTHATNEEDEVERYSOPINSTANCEUIDSCANNED"){};
    public static final MIMPref<Boolean> enableRepairs = new MIMPref<Boolean>("ENABLE REPAIRS"){};

    public static Set<TagPath> getDicomTagsToIgnore() {
        return MetabasePrefs.parseTagPathsForPref(dicomtagstoignore);
    }

    public static Set<TagPath> getDicomTagPathsToNotIgnore() {
        Set<TagPath> set = MetabasePrefs.parseTagPathsForPref(dicomTagPathsToNotIgnore);
        try {
            set.add(TagPath.parse("FractionGroupSequence.NumberOfFractionsPlanned"));
            set.add(new TagPath(0x37733030));
            set.add(new TagPath(930295857));
            set.add(new TagPath(930295858));
        }
        catch (DicomTagParseException dicomTagParseException) {
            throw new RuntimeException("Bad Explosion");
        }
        return set;
    }

    public static Set<TagPath> getDicomTagsThatShouldNotBeTruncated() {
        Set<TagPath> set = MetabasePrefs.parseTagPathsForPref(dicomtagsthatshouldnotbetruncated);
        set.add(new TagPath(0x20000E));
        set.add(new TagPath(524312));
        set.add(new TagPath(0x200052));
        set.add(new TagPath(528725));
        set.add(new TagPath(2097207));
        set.add(new TagPath(5505056));
        set.add(new TagPath(5505040));
        return set;
    }

    private static Set<TagPath> parseTagPathsForPref(MIMPref<String[]> mIMPref) {
        String[] stringArray = mIMPref.getValue();
        HashSet<TagPath> hashSet = new HashSet<TagPath>();
        for (String string : stringArray) {
            try {
                hashSet.add(TagPath.parse(string));
            }
            catch (Exception exception) {
                ay.c((Object)("METABASE: Invalid tag path found in MetabasePrefs." + mIMPref.propName + ": " + string), (Throwable)exception, MetabasePrefs.class);
            }
        }
        return hashSet;
    }
}

