/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.preferencesNew;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.file.MIMFile;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferences.PrefParsers;
import com.mimvista.preferencesNew.HodorFactory;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.preferencesNew.MIMPrefFile;
import com.mimvista.preferencesNew.MIMPrefObservatory;
import com.mimvista.preferencesNew.a;
import com.mimvista.preferencesNew.c;
import com.mimvista.preferencesNew.cascade.CascadeLevel;
import com.mimvista.preferencesNew.h;
import com.mimvista.preferencesNew.k;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.az;
import com.mimvista.util.cm;
import com.mimvista.util.l;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public abstract class PrefCascade
implements com.mimvista.state.c {
    protected final Class<? extends MIMPrefFile> group;
    protected final CascadeLevel level;
    private final Map<MIMPref<Object>, JsonNode> onDisk = new HashMap<MIMPref<Object>, JsonNode>();
    private final Map<MIMPref<Object>, Object> inMemory = new HashMap<MIMPref<Object>, Object>();
    private final Map<String, JsonNode> misfits = new HashMap<String, JsonNode>();
    private transient boolean diskIsCached = false;
    private transient Object cacheLock = new Object();
    private Map<MIMPref<Object>, JsonNode> diskSnapshot = null;
    l diskWriteDAR = new l(5000L, new Runnable(){

        @Override
        public void run() {
            PrefCascade.this.doWriting();
        }
    }, "pref cascade write");

    public PrefCascade(Class<? extends MIMPrefFile> clazz, CascadeLevel cascadeLevel) {
        this.group = clazz;
        this.level = cascadeLevel;
    }

    public final Class<? extends MIMPrefFile> getGrouping() {
        return this.group;
    }

    protected abstract boolean isWriteable();

    protected abstract InputStream createInputStream();

    protected abstract OutputStream createOutputStream();

    protected abstract az<File> getFileOnDisk();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheDiskIfNecessary() {
        Object object = this.cacheLock;
        synchronized (object) {
            if (!this.diskIsCached) {
                this.doActualDiskRead();
            }
            this.diskIsCached = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.inMemory.clear();
            if (this.diskSnapshot == null) {
                this.diskIsCached = false;
                this.onDisk.clear();
            } else {
                this.onDisk.clear();
                this.onDisk.putAll(this.diskSnapshot);
                this.diskIsCached = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForChangesInMapAndFireListenersIfNecessary(Map<MIMPref<Object>, Object> map, Map<MIMPref<Object>, JsonNode> map2) {
        HashSet hashSet;
        this.cacheDiskIfNecessary();
        Iterator iterator = this.cacheLock;
        synchronized (iterator) {
            hashSet = new HashSet(Sets.union(map2.keySet(), this.onDisk.keySet()));
        }
        for (MIMPref mIMPref : hashSet) {
            Object t2;
            Object t3 = PrefCascade.getValue(mIMPref, map, map2);
            if (FuncUtils.b(t3, t2 = this.getValue(mIMPref))) continue;
            MIMPrefObservatory.a().a(mIMPref, this.level, t2);
            h.a().a(this.group).a(mIMPref, this.level, t2);
        }
    }

    public boolean hasValue(MIMPref<?> mIMPref) {
        if (this.inMemory.containsKey(mIMPref)) {
            return true;
        }
        this.cacheDiskIfNecessary();
        return this.onDisk.containsKey(mIMPref);
    }

    public <T> T getValue(MIMPref<T> mIMPref) {
        this.cacheDiskIfNecessary();
        return PrefCascade.getValue(mIMPref, this.inMemory, this.onDisk);
    }

    private static <T> T getValue(MIMPref<T> mIMPref, Map<MIMPref<Object>, Object> map, Map<MIMPref<Object>, JsonNode> map2) {
        if (map.containsKey(mIMPref)) {
            return (T)mIMPref.cloneValue(map.get(mIMPref));
        }
        if (map2.containsKey(mIMPref)) {
            try {
                T t2 = mIMPref.getParser().a(map2.get(mIMPref));
                map.put(mIMPref, t2);
                return PrefCascade.poorMansJsonClone(t2, mIMPref.getParser());
            }
            catch (Exception exception) {
                ay.d((Object)"error from pref parser", (Throwable)exception, PrefCascade.class);
            }
        }
        return null;
    }

    public static <T> T poorMansJsonClone(T t2, PrefParsers.g<T> g2) {
        try {
            return g2.a(g2.b(t2));
        }
        catch (Exception exception) {
            ay.d((Object)("error json cloning object of type " + t2.getClass().getSimpleName()), (Throwable)exception, PrefCascade.class);
            return t2;
        }
    }

    JsonNode getNode(MIMPref<?> mIMPref) {
        this.cacheDiskIfNecessary();
        if (this.onDisk.containsKey(mIMPref)) {
            return this.onDisk.get(mIMPref);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setValue(MIMPref<T> mIMPref, T t2) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.inMemory.put(mIMPref, t2);
            this.cacheDiskIfNecessary();
            JsonNode jsonNode = mIMPref.getParser().b(t2);
            JsonNode jsonNode2 = this.onDisk.get(mIMPref);
            if (!FuncUtils.a(jsonNode, jsonNode2) && this.isWriteable()) {
                this.onDisk.put(mIMPref, jsonNode);
                this.diskSnapshot = new HashMap<MIMPref<Object>, JsonNode>(this.onDisk);
                this.diskWriteDAR.a();
            }
        }
        MIMPrefObservatory.a().a(mIMPref, this.level, t2);
        h.a().a(this.getGrouping()).a(mIMPref, this.level, t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removePrefValue(MIMPref<T> mIMPref) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.inMemory.remove(mIMPref);
            this.inMemory.remove(mIMPref.getCollectionTombstonePref());
            this.cacheDiskIfNecessary();
            if (this.onDisk.containsKey(mIMPref) && this.isWriteable()) {
                this.onDisk.remove(mIMPref);
                this.onDisk.remove(mIMPref.getCollectionTombstonePref());
                this.diskSnapshot = new HashMap<MIMPref<Object>, JsonNode>(this.onDisk);
                this.diskWriteDAR.a();
            }
        }
        MIMPrefObservatory.a().a(mIMPref, this.level, null);
        h.a().a(this.getGrouping()).a(mIMPref, this.level, null);
    }

    private boolean doActualDiskRead() {
        Object object;
        JsonParser jsonParser = null;
        JsonNode jsonNode = null;
        PrefParsers.PrefsObjectMapper prefsObjectMapper = null;
        boolean bl2 = false;
        try {
            prefsObjectMapper = PrefParsers.a();
            object = c.a(prefsObjectMapper, new com.mimvista.util.h<InputStream>(){

                public InputStream a() {
                    return PrefCascade.this.createInputStream();
                }

                @Override
                public /* synthetic */ Object call() {
                    return this.a();
                }
            }, this.getFileOnDisk());
            if (object == null) {
                return false;
            }
            jsonParser = (JsonParser)((Pair)object).x;
            bl2 = (Boolean)((Pair)object).y;
            jsonNode = (JsonNode)prefsObjectMapper.readTree(jsonParser);
        }
        catch (Exception exception) {
            ay.d((Object)("error while json parsing pref file in " + this), (Throwable)exception, this);
            try {
                MIMFile.a(this.getFileOnDisk().b(), new File(this.getFileOnDisk().b().toString() + ".backup"));
            }
            catch (IOException iOException) {
                ay.d((Object)"can't copy the bad json file to a backup", (Throwable)exception, this);
            }
            return false;
        }
        object = jsonNode.fields();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            MIMPref<Object> mIMPref = null;
            try {
                mIMPref = PrefCascade.getPref((String)entry.getKey(), this.group);
            }
            catch (Exception exception) {
                ay.d((Object)"error finding pref", (Throwable)exception, this);
            }
            if (mIMPref == null && this.isWriteable()) {
                this.misfits.put((String)entry.getKey(), (JsonNode)entry.getValue());
            }
            if (mIMPref == null) continue;
            this.onDisk.put(mIMPref, (JsonNode)entry.getValue());
        }
        if (bl2) {
            this.diskSnapshot = new HashMap<MIMPref<Object>, JsonNode>(this.onDisk);
            this.diskWriteDAR.a();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriting() {
        OutputStream outputStream = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l2;
            block16: {
                block15: {
                    if (this.diskSnapshot != null) break block15;
                    this.diskSnapshot = null;
                    cm.a(outputStream);
                    return;
                }
                l2 = System.currentTimeMillis();
                outputStream = this.createOutputStream();
                if (outputStream != null) break block16;
                this.diskSnapshot = null;
                cm.a((Closeable)outputStream);
                return;
            }
            try {
                PrefParsers.PrefsObjectMapper prefsObjectMapper = PrefParsers.a();
                HodorFactory hodorFactory = prefsObjectMapper.a();
                a a2 = hodorFactory.a(outputStream, JsonEncoding.UTF8);
                a2.useDefaultPrettyPrinter();
                a2.writeStartObject();
                TreeMap treeMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
                treeMap.putAll(this.misfits);
                for (Map.Entry<MIMPref<Object>, JsonNode> object2 : this.diskSnapshot.entrySet()) {
                    treeMap.put(object2.getKey().getPropName(), object2.getValue());
                }
                for (Map.Entry<MIMPref<Object>, Object> entry : treeMap.entrySet()) {
                    a2.writeFieldName((String)((Object)entry.getKey()));
                    a2.writeTree((TreeNode)entry.getValue());
                }
                a2.writeRaw(System.getProperty("line.separator"));
                if (!treeMap.isEmpty()) {
                    a2.writeRaw(System.getProperty("line.separator"));
                }
                if (MIMPrefFile.shouldWriteAnyDefaultsToFile(this.group)) {
                    for (MIMPref mIMPref : MIMPrefFile.getAllPrefsInGroup(this.getGrouping())) {
                        if (!mIMPref.shouldWriteDefaultToFile() || this.diskSnapshot.containsKey(mIMPref) || !mIMPref.forwardsCompatPrefs.isEmpty()) continue;
                        String string = PrefCascade.getDefaultValueAsString(mIMPref);
                        a2.a(string);
                    }
                }
                a2.writeEndObject();
                a2.flush();
                double d2 = (double)(System.currentTimeMillis() - l2) / 1000.0;
                if (d2 > 1.5) {
                    ay.c((Object)("Took " + d2 + " seconds to write out " + this.group.getName()), this);
                }
                this.diskSnapshot = null;
            }
            catch (Exception exception) {
                try {
                    ay.d((Object)"error trying to write file to disk", (Throwable)exception, this);
                    this.diskSnapshot = null;
                }
                catch (Throwable throwable) {
                    this.diskSnapshot = null;
                    cm.a(outputStream);
                    throw throwable;
                }
                cm.a((Closeable)outputStream);
            }
            cm.a((Closeable)outputStream);
        }
    }

    private static <ValueType> String getDefaultValueAsString(MIMPref<ValueType> mIMPref) throws JsonGenerationException, IOException {
        ValueType ValueType = h.a().a(mIMPref.getPrefFile()).c(mIMPref);
        JsonNode jsonNode = mIMPref.getParser().b(ValueType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        a a2 = PrefParsers.a().a().a(byteArrayOutputStream);
        a2.useDefaultPrettyPrinter();
        a2.writeStartObject();
        a2.writeFieldName(mIMPref.getPropName());
        a2.writeTree((TreeNode)jsonNode);
        a2.writeEndObject();
        a2.flush();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        string = string.trim();
        if (string.startsWith("{")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("}")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.trim();
        return string;
    }

    public Collection<? extends MIMPref<?>> getAllPrefs() {
        this.cacheDiskIfNecessary();
        return this.onDisk.keySet();
    }

    protected static MIMPref<Object> getPref(String string, Class<? extends MIMPrefFile> clazz) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            MIMPref<Object> mIMPref;
            Object object;
            if (MIMPref.class.isAssignableFrom(field.getType())) {
                field.setAccessible(true);
                object = (MIMPref)field.get(null);
                if (((MIMPref)object).getPropName().equalsIgnoreCase(string)) {
                    return object;
                }
                mIMPref = ((MIMPref)object).getCollectionTombstonePref();
                if (mIMPref != null && mIMPref.getPropName().equalsIgnoreCase(string)) {
                    return mIMPref;
                }
                MIMPref<Object> mIMPref2 = ((MIMPref)object).getCompatHasBeenHandledPref();
                if (mIMPref2 != null && mIMPref2.getPropName().equalsIgnoreCase(string)) {
                    return mIMPref2;
                }
            }
            if (!k.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            object = (k)field.get(null);
            if (((k)object).c(string)) {
                return PrefCascade.getPrefFromSet(object, string);
            }
            if (string.endsWith("_COLLECTION_TOMBSTONE") && ((k)object).c((String)((Object)(mIMPref = string.substring(0, string.lastIndexOf("_COLLECTION_TOMBSTONE")))))) {
                return PrefCascade.getPrefFromSet(object, (String)((Object)mIMPref)).getCollectionTombstonePref();
            }
            if (!string.endsWith("_BACKWARDS_COMPATIBILITY_HANDLED") || !((k)object).c((String)((Object)(mIMPref = string.substring(0, string.lastIndexOf("_BACKWARDS_COMPATIBILITY_HANDLED")))))) continue;
            return PrefCascade.getPrefFromSet(object, (String)((Object)mIMPref)).getCompatHasBeenHandledPref();
        }
        return null;
    }

    private static <T> MIMPref<Object> getPrefFromSet(k<T, Object> k2, String string) {
        return k2.b(k2.d((T)string));
    }

    public boolean isWritePending() {
        return this.diskSnapshot != null;
    }

    public void flush() {
        if (this.isWritePending()) {
            this.doWriting();
        } else {
            this.writeIfEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIfEmpty() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheDiskIfNecessary();
            if (!this.isWritePending() && this.inMemory.isEmpty() && this.onDisk.isEmpty() && this.getFileOnDisk().a() && (!this.getFileOnDisk().b().isFile() || !this.getFileOnDisk().b().exists())) {
                ay.b((Object)("writing empty file for " + this), this);
                this.diskSnapshot = new HashMap<MIMPref<Object>, JsonNode>();
                this.doWriting();
                this.updateTimestamp(0L);
            }
        }
    }

    public boolean updateTimestamp(long l2) {
        az<File> az2 = this.getFileOnDisk();
        if (!(az2 != null && az2.a() && az2.b().exists() && az2.b().isFile())) {
            return false;
        }
        if (l2 < 0L) {
            return false;
        }
        az2.b().setLastModified(l2);
        return true;
    }

    public long getTimestamp() {
        az<File> az2 = this.getFileOnDisk();
        if (!(az2 != null && az2.a() && az2.b().exists() && az2.b().isFile())) {
            return -1L;
        }
        return az2.b().lastModified();
    }

    protected Collection<MIMPref<Object>> getInMemoryPrefs() {
        return Lists.newArrayList(this.inMemory.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileContentsPossiblyChangedOutFromUnderUs() {
        HashMap<MIMPref<Object>, JsonNode> hashMap;
        HashMap<MIMPref<Object>, Object> hashMap2;
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.isWritePending()) {
                ay.c((Object)("file " + this.getGrouping().getSimpleName() + " appears to have been modified on disk while there was a write pending in MIM... concurrency booch city"), this);
            }
            if (!this.diskIsCached) {
                return;
            }
            hashMap2 = new HashMap<MIMPref<Object>, Object>(this.inMemory);
            hashMap = new HashMap<MIMPref<Object>, JsonNode>(this.onDisk);
            this.clearCache();
        }
        this.checkForChangesInMapAndFireListenersIfNecessary(hashMap2, hashMap);
    }
}

