/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.Modality;
import com.mimvista.mui.ColorWheel;
import com.mimvista.preferencesNew.InterfacePrefs;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PatientListModalityColorWidget
extends JPanel {
    private static final long serialVersionUID = -8732137231393983601L;
    private static final Font a = new Font("SansSerif", 0, 16);
    private static final Color b = MIMLookAndFeel.E();
    private static Messages c = Messages.a("GeneralPreferencesCollectionFactory");
    private static final String[] d = new String[]{"BXplan", "SESSION"};
    private Color lastColor;
    private JColorChooser colorChooser;
    private JComboBox<JLabel> modalityChooser;
    private JCheckBox enableColorCheckbox;
    private JCheckBox enableOutlineCheckbox;
    private JCheckBox outlineColorCheckbox;
    private JButton restoreDefaultsButton;
    private DefaultComboBoxModel<JLabel> model;
    private Map<String, Color> outlineColorMap = Maps.newHashMap();

    public PatientListModalityColorWidget() {
        Object object22;
        AbstractColorChooserPanel[] abstractColorChooserPanelArray;
        this.model = new DefaultComboBoxModel();
        ArrayList arrayList = Lists.newArrayList();
        try {
            abstractColorChooserPanelArray = InterfacePrefs.modalityColors.e();
            for (String string : abstractColorChooserPanelArray) {
                this.a(arrayList, string);
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error getting all modality color prefs, only using default modalities.", (Throwable)exception, PatientListModalityColorWidget.class);
            for (Modality serializable2 : Modality.values()) {
                this.a(arrayList, serializable2.get());
            }
            this.a(arrayList);
        }
        Collections.sort(arrayList, new Comparator<JLabel>(){

            public int a(JLabel jLabel, JLabel jLabel2) {
                return jLabel.getText().compareTo(jLabel2.getText());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((JLabel)object, (JLabel)object2);
            }
        });
        for (Object object22 : arrayList) {
            this.model.addElement((JLabel)object22);
        }
        this.modalityChooser = new JComboBox<JLabel>(this.model);
        this.modalityChooser.setToolTipText(c.getProperty("GENERALPREF_MODALITY_COLOR_TIP"));
        this.modalityChooser.setRenderer(new ModalityCheckboxCellRenderer());
        this.modalityChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatientListModalityColorWidget.this.b();
            }
        });
        this.colorChooser = new JColorChooser();
        abstractColorChooserPanelArray = new AbstractColorChooserPanel[]{new ColorWheel(192, ((JLabel)this.model.getSelectedItem()).getForeground())};
        this.colorChooser.setChooserPanels(abstractColorChooserPanelArray);
        this.colorChooser.setPreviewPanel(new JPanel());
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PatientListModalityColorWidget.this.enableColorCheckbox.isSelected()) {
                    JLabel jLabel = (JLabel)PatientListModalityColorWidget.this.modalityChooser.getSelectedItem();
                    if (!PatientListModalityColorWidget.this.outlineColorCheckbox.isSelected()) {
                        jLabel.setForeground(PatientListModalityColorWidget.this.colorChooser.getColor());
                    } else {
                        PatientListModalityColorWidget.this.outlineColorMap.put(jLabel.getText().trim().toUpperCase(), PatientListModalityColorWidget.this.colorChooser.getColor());
                    }
                    PatientListModalityColorWidget.this.firePropertyChange("mimPropertyModified", 0, 1);
                    PatientListModalityColorWidget.this.modalityChooser.repaint();
                }
            }
        });
        this.enableOutlineCheckbox = new JCheckBox();
        this.enableOutlineCheckbox.setText(c.getProperty("GENERALPREF_MODALITY_OUTLINE_ENABLE"));
        this.enableOutlineCheckbox.setSelected(InterfacePrefs.enableModalityOutlineInPL.getValue());
        this.enableOutlineCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatientListModalityColorWidget.this.a(false);
            }
        });
        this.outlineColorCheckbox = new JCheckBox();
        this.outlineColorCheckbox.setText(c.getProperty("GENERALPREF_MODALITY_OUTLINE_EDIT"));
        this.outlineColorCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatientListModalityColorWidget.this.b();
            }
        });
        this.b();
        this.enableColorCheckbox = new JCheckBox();
        this.enableColorCheckbox.setText(c.getProperty("GENERALPREF_MODALITY_COLOR_ENABLE"));
        this.enableColorCheckbox.setSelected(InterfacePrefs.enableModalityColorInPL.getValue());
        this.enableColorCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatientListModalityColorWidget.this.a(true);
            }
        });
        this.a(true);
        this.restoreDefaultsButton = new JButton(c.getProperty("GENERALPREF_MODALITY_DEFAULT"));
        this.restoreDefaultsButton.setToolTipText(c.getProperty("GENERALPREF_MODALITY_DEFAULT_TIP"));
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatientListModalityColorWidget.this.a();
            }
        });
        object22 = Box.createHorizontalBox();
        ((Container)object22).add(this.enableColorCheckbox);
        ((Container)object22).add(Box.createHorizontalGlue());
        Box box = Box.createHorizontalBox();
        box.add(this.enableOutlineCheckbox);
        box.add(Box.createHorizontalGlue());
        Box box2 = Box.createHorizontalBox();
        box2.add(this.outlineColorCheckbox);
        box2.add(Box.createHorizontalGlue());
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalGlue());
        box3.add(this.restoreDefaultsButton);
        box3.add(Box.createHorizontalGlue());
        Box box4 = Box.createVerticalBox();
        box4.add(Box.createVerticalGlue());
        box4.add(box);
        box4.add((Component)object22);
        box4.add(Box.createVerticalGlue());
        box4.add(this.modalityChooser);
        box4.add(box2);
        box4.add(Box.createVerticalGlue());
        box4.add(box3);
        box4.add(Box.createVerticalGlue());
        Box box5 = Box.createVerticalBox();
        box5.add(this.colorChooser);
        Box box6 = Box.createHorizontalBox();
        box6.add(box4);
        box6.add(Box.createHorizontalStrut(5));
        box6.add(box5);
        this.add(box6);
        this.setVisible(true);
    }

    private void a(List<JLabel> list) {
        for (String string : d) {
            this.a(list, string);
        }
    }

    private void a(List<JLabel> list, String string) {
        JLabel jLabel = new JLabel(this.a(string));
        float[] fArray = (float[])InterfacePrefs.modalityColors.b(jLabel.getText().trim().toUpperCase()).getValue();
        jLabel.setForeground(this.a(fArray, false));
        jLabel.setBackground(b);
        this.outlineColorMap.put(jLabel.getText().trim().toUpperCase(), this.a(fArray, true));
        list.add(jLabel);
    }

    protected void a() {
        for (int i2 = 0; i2 < this.model.getSize(); ++i2) {
            JLabel jLabel = this.model.getElementAt(i2);
            MIMPref mIMPref = InterfacePrefs.modalityColors.b(jLabel.getText().trim().toUpperCase());
            jLabel.setForeground(this.a((float[])mIMPref.getDefaultValue(), false));
            this.outlineColorMap.put(jLabel.getText().trim().toUpperCase(), this.a((float[])mIMPref.getDefaultValue(), true));
        }
        this.b();
        this.firePropertyChange("mimPropertyModified", 0, 1);
    }

    protected void b() {
        if (!this.outlineColorCheckbox.isSelected()) {
            this.colorChooser.setColor(((JLabel)this.modalityChooser.getSelectedItem()).getForeground());
        } else {
            this.colorChooser.setColor(this.outlineColorMap.get(((JLabel)this.modalityChooser.getSelectedItem()).getText().trim().toUpperCase()));
        }
        ((ColorWheel)this.colorChooser.getChooserPanels()[0]).a(this.colorChooser.getColor());
    }

    protected void a(boolean bl2) {
        boolean bl3 = this.enableColorCheckbox.isSelected();
        if (!bl3) {
            this.lastColor = new Color(((JLabel)this.modalityChooser.getSelectedItem()).getForeground().getRGB());
        }
        this.colorChooser.setEnabled(bl3);
        this.colorChooser.getChooserPanels()[0].setEnabled(bl3);
        this.modalityChooser.setEnabled(bl3);
        this.outlineColorCheckbox.setSelected(bl3 && this.enableOutlineCheckbox.isSelected() && this.outlineColorCheckbox.isSelected());
        this.outlineColorCheckbox.setEnabled(bl3 && this.enableOutlineCheckbox.isSelected());
        this.firePropertyChange("mimPropertyModified", 0, 1);
        if (bl3 && bl2) {
            JLabel jLabel = (JLabel)this.modalityChooser.getSelectedItem();
            if (this.lastColor != null) {
                jLabel.setForeground(this.lastColor);
            } else {
                Color color = this.a((float[])InterfacePrefs.modalityColors.b(jLabel.getText().trim().toUpperCase()).getValue(), false);
                jLabel.setForeground(color);
            }
        }
        if (bl3) {
            this.b();
        }
    }

    public void c() {
        InterfacePrefs.enableModalityColorInPL.setValue(this.enableColorCheckbox.isSelected());
        InterfacePrefs.enableModalityOutlineInPL.setValue(this.enableOutlineCheckbox.isSelected());
        if (this.enableColorCheckbox.isSelected()) {
            for (int i2 = 0; i2 < this.model.getSize(); ++i2) {
                JLabel jLabel = this.model.getElementAt(i2);
                MIMPref mIMPref = InterfacePrefs.modalityColors.b(jLabel.getText().trim().toUpperCase());
                float[] fArray = this.a(jLabel.getForeground());
                float[] fArray2 = this.a(this.outlineColorMap.get(jLabel.getText().trim().toUpperCase()));
                mIMPref.setValue(new float[]{fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2]});
            }
        }
    }

    public String a(String string) {
        if (string.equals("RTSTRUCT") || string.equals("RTST")) {
            return "RTst";
        }
        if (string.equals("")) {
            return "UNKNOWN";
        }
        return string;
    }

    private Color a(float[] fArray, boolean bl2) {
        if (fArray == null || fArray.length < 3) {
            fArray = InterfacePrefs.getDefaultModalityColor();
        }
        int n2 = bl2 && fArray.length == 6 ? Color.HSBtoRGB(fArray[3], fArray[4], fArray[5]) : Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
        return new Color(n2);
    }

    private float[] a(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    private class ModalityCheckboxCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -4859470288075186665L;

        private ModalityCheckboxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n2, boolean bl2, boolean bl3) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            jLabel.setFont(a);
            jLabel.setText(((JLabel)object).getText());
            jLabel.setForeground(((JLabel)object).getForeground());
            return jLabel;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            this.setOpaque(true);
            Color color = this.getForeground();
            if (PatientListModalityColorWidget.this.enableOutlineCheckbox.isSelected()) {
                this.setForeground(this.a(this));
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.translate(-1.0, 0.0);
                super.paintComponent(graphics2D);
                this.setOpaque(false);
                graphics2D.translate(0.0, -1.0);
                super.paintComponent(graphics2D);
                graphics2D.translate(1.0, 0.0);
                super.paintComponent(graphics2D);
                graphics2D.translate(1.0, 0.0);
                super.paintComponent(graphics2D);
                graphics2D.translate(0.0, 1.0);
                super.paintComponent(graphics2D);
                graphics2D.translate(0.0, 1.0);
                super.paintComponent(graphics2D);
                graphics2D.translate(-1.0, 0.0);
                super.paintComponent(graphics2D);
                graphics2D.translate(-1.0, 0.0);
                super.paintComponent(graphics2D);
                graphics2D.dispose();
            }
            this.setForeground(color);
            super.paintComponent(graphics);
        }

        private Color a(JLabel jLabel) {
            if (PatientListModalityColorWidget.this.enableColorCheckbox.isSelected()) {
                return (Color)PatientListModalityColorWidget.this.outlineColorMap.get(this.getText().trim().toUpperCase());
            }
            return Color.BLACK;
        }
    }
}

