/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.properties.services;

import com.google.common.collect.Lists;
import com.mimvista.archive.PlainLocalSearchSource;
import com.mimvista.archive.remote.MIMpacsServer;
import com.mimvista.archive.remote.i;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.file.MIMFile;
import com.mimvista.metabase.j;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.properties.gui.GenericPropertyPanel;
import com.mimvista.properties.gui.PropertyDialog;
import com.mimvista.properties.services.PatientListPropertyUtils;
import com.mimvista.properties.services.n;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.ch;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressDialog;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.VerticalLayout;

public class MigratePatientListDataPropertyPanel
extends GenericPropertyPanel
implements ActionListener {
    public static Messages props = Messages.a("PatientList");
    JList srcList;
    JList destList;
    JButton migrateButton;

    public MigratePatientListDataPropertyPanel(n n2, JDialog jDialog) {
        super(n2, jDialog);
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new VerticalLayout(8)){

            @Override
            public Insets getInsets() {
                return new Insets(6, 2, 2, 2);
            }
        };
        PropertyDialog propertyDialog = (PropertyDialog)this.getDialog();
        this.destList = PatientListPropertyUtils.a(this.getCollection(), propertyDialog);
        if (this.destList == null) {
            jPanel.add(new JLabel(props.getProperty("PATIENTLIST_PROP_ADD_ONE"), 0));
        } else {
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 8, 0));
            this.srcList = PatientListPropertyUtils.a();
            JPanel jPanel3 = new JPanel(new BorderLayout(4, 4));
            jPanel3.add((Component)new JLabel(props.getProperty("PATIENTLIST_PROP_FROM_LOCAL"), 0), "North");
            jPanel3.add((Component)new JScrollPane(this.srcList), "Center");
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel(new BorderLayout(4, 4));
            jPanel4.add((Component)new JLabel(props.getProperty("PATIENTLIST_PROP_TO_MIMPACS"), 0), "North");
            jPanel4.add((Component)new JScrollPane(this.destList), "Center");
            jPanel2.add(jPanel4);
            this.migrateButton = new JButton(props.getProperty("PATIENTLIST_PROP_MIGRATE"));
            this.migrateButton.setToolTipText(props.getProperty("PATIENTLIST_PROP_MIGRATE_TO"));
            this.migrateButton.addActionListener(this);
            this.migrateButton.setEnabled(0 != this.destList.getModel().getSize());
            jPanel2.setPreferredSize(new Dimension(0, 280));
            jPanel.add(jPanel2);
            jPanel.add(this.migrateButton);
        }
        return jPanel;
    }

    @Override
    protected void a() {
        this.removeAll();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.b(), "Center");
    }

    @Override
    public n getCollection() {
        return (n)super.getCollection();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl2 = this.getCollection().A();
        if (bl2) {
            JOptionPane.showMessageDialog((JComponent)actionEvent.getSource(), props.getProperty("PATIENTLIST_PROP_SAVE_FIRST"), props.getProperty("PATIENTLIST_PROP_NO_MIGRATE"), 1);
            return;
        }
        String[] stringArray = MimpacsPrefs.archiveLocation.getValue();
        ArrayList<MIMFile> arrayList = new ArrayList<MIMFile>();
        for (String string : stringArray) {
            Object object = new MIMFile(string);
            if (string.isEmpty() || !((File)object).isDirectory()) {
                ay.d((Object)("Bad configuration for local patient list location, skipping: " + string), this);
                continue;
            }
            arrayList.add((MIMFile)object);
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog((JComponent)actionEvent.getSource(), props.getProperty("PATIENTLIST_PROP_CONFIG_ERROR"), props.getProperty("PATIENTLIST_PROP_NO_MIGRATE"), 1);
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object : this.destList.getSelectedValues()) {
            arrayList2.add((String)object);
        }
        Object[] objectArray = arrayList2.toArray(new String[0]);
        if (objectArray.length == 0) {
            JOptionPane.showMessageDialog((JComponent)actionEvent.getSource(), props.getProperty("PATIENTLIST_PROP_SELECT_ONE"), props.getProperty("PATIENTLIST_PROP_NO_MIGRATE"), 1);
            return;
        }
        ArrayList<LocalSearchSource> arrayList3 = new ArrayList<LocalSearchSource>();
        for (Object object : this.srcList.getSelectedValues()) {
            arrayList3.add((LocalSearchSource)object);
        }
        Object[] objectArray2 = arrayList3.toArray(new LocalSearchSource[0]);
        if (objectArray2.length == 0) {
            JOptionPane.showMessageDialog((JComponent)actionEvent.getSource(), props.getProperty("PATIENTLIST_PROP_SELECT_LOCAL_HTML"), props.getProperty("PATIENTLIST_PROP_NO_MIGRATE"), 1);
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog(SwingUtilities.getWindowAncestor(this));
        progressDialog.e(true);
        this.a(false);
        progressDialog.b_(props.getProperty("PATIENTLIST_PROP_MIGRATE_PROGRESS"));
        MIMFile[] mIMFileArray = new MIMFile[objectArray2.length];
        for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            mIMFileArray[i2] = new MIMFile(((PlainLocalSearchSource)objectArray2[i2]).a());
        }
        this.a(mIMFileArray, (String[])objectArray, progressDialog);
    }

    private void a(boolean bl2) {
        this.srcList.setEnabled(bl2);
        this.destList.setEnabled(bl2);
        this.migrateButton.setEnabled(bl2);
    }

    private void a(final MIMFile[] mIMFileArray, final String[] stringArray, final Progress progress) {
        assert (progress != null);
        assert (mIMFileArray != null && mIMFileArray.length != 0);
        assert (stringArray != null && stringArray.length > 0);
        m.e.submit(new Runnable(){

            @Override
            public void run() {
                progress.c(true);
                progress.a();
                progress.a(true);
                ArrayList arrayList = Lists.newArrayList();
                for (MIMFile mIMFile : mIMFileArray) {
                    if (!mIMFile.isDirectory()) continue;
                    arrayList.addAll(new ch().a(mIMFile));
                }
                progress.a(false);
                progress.a(arrayList.size());
                progress.b(0);
                boolean bl2 = MIMpacsServer.isRplMode();
                ArrayList arrayList2 = Lists.newArrayList();
                if (bl2) {
                    for (String string : stringArray) {
                        if (MIMpacsServer.getDirForSimpleRPL(string) == null) {
                            ay.d((Object)("Ignoring patient list '" + string + "' for migration because I can't find its archive path"), this);
                            continue;
                        }
                        arrayList2.add(string);
                    }
                } else {
                    for (String string : stringArray) {
                        if (j.a().c(string) == -1L) {
                            ay.d((Object)("Ignoring patient list '" + string + "' for migration because it doesn't have an id assigned in the metabase"), this);
                            continue;
                        }
                        arrayList2.add(string);
                    }
                }
                if (arrayList2.isEmpty()) {
                    ay.d((Object)"I don't have any valid destinations to migrate to", this);
                    return;
                }
                int n2 = 0;
                for (File file : arrayList) {
                    String string;
                    string = file.getName();
                    if (string.length() > 43) {
                        string = string.substring(0, 40) + "...";
                    }
                    progress.b_(MIMFormat.a(props.getProperty("PATIENTLIST_PROP_MIGRATE_SERIES"), string));
                    try {
                        if (bl2) {
                            i.b(file, arrayList2);
                        } else {
                            i.a(file, arrayList2);
                        }
                        ++n2;
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)("Copy Local series \"" + file.getAbsolutePath() + "\" to \"\"MIMpacs patient list failed."), throwable, MigratePatientListDataPropertyPanel.this);
                    }
                    if (Progress.Status.e == progress.n()) {
                        ay.c((Object)"Migration is cancelled by users ", MigratePatientListDataPropertyPanel.this);
                        progress.b_(props.getProperty("PATIENTLIST_PROP_MIGRATE_CANCEL"));
                        progress.b();
                        MigratePatientListDataPropertyPanel.this.a(true);
                        return;
                    }
                    progress.N_();
                }
                progress.b();
                MigratePatientListDataPropertyPanel.this.a(true);
                int n3 = arrayList.size() - n2;
                if (n3 == 0) {
                    JOptionPane.showMessageDialog(MigratePatientListDataPropertyPanel.this, props.getProperty("PATIENTLIST_PROP_MIGRATE_FINISH"));
                } else {
                    JOptionPane.showMessageDialog(MigratePatientListDataPropertyPanel.this, MIMFormat.a(props.getProperty("PATIENTLIST_PROP_MIGRATE_FAIL"), n3));
                }
            }
        });
    }
}

