/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.reconstruct.filter;

import com.mimvista.util.ay;
import java.io.Serializable;

public class DiscreteFrequency
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2698842128609043437L;
    private static final double a = Math.PI * 2;
    private final int numComplexBins;
    private final int binIndex;
    private final int cyclesPerSample;
    private final double nyquistFreq;

    public DiscreteFrequency(int n2, int n3, int n4) {
        this.numComplexBins = n3;
        this.binIndex = n2;
        this.cyclesPerSample = n4;
        this.nyquistFreq = (double)n3 / 2.0;
    }

    public int a() {
        return this.binIndex;
    }

    public int b() {
        return this.numComplexBins;
    }

    public int c() {
        return this.cyclesPerSample;
    }

    public double d() {
        return Math.PI * 2 * (double)this.cyclesPerSample;
    }

    public double e() {
        return (double)this.cyclesPerSample / this.nyquistFreq;
    }

    public double f() {
        return ((double)this.cyclesPerSample + this.nyquistFreq) / (double)(this.numComplexBins - 1);
    }

    public DiscreteFrequency g() {
        try {
            return (DiscreteFrequency)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)"Error cloning frequency", (Throwable)cloneNotSupportedException, this);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DiscreteFrequency) {
            DiscreteFrequency discreteFrequency = (DiscreteFrequency)object;
            return this.numComplexBins == discreteFrequency.numComplexBins && this.binIndex == discreteFrequency.binIndex && this.cyclesPerSample == discreteFrequency.cyclesPerSample;
        }
        return false;
    }

    public int hashCode() {
        return this.numComplexBins + this.binIndex * 313 + this.cyclesPerSample * 1709;
    }

    public String toString() {
        return "[" + this.binIndex + "/" + this.numComplexBins + " " + this.cyclesPerSample + "]";
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.g();
    }
}

