/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.reconstruct.specs;

import com.mimvista.preferencesNew.ReconstructionPrefs;
import com.mimvista.reconstruct.ReconstructionAlgorithm;
import com.mimvista.reconstruct.specs.AbstractReconstructionSpecs;
import java.io.Serializable;

public class OSEMSpecs
extends AbstractReconstructionSpecs
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1990336254184604811L;
    private int subsets;
    private int iterations;

    public OSEMSpecs(AbstractReconstructionSpecs abstractReconstructionSpecs) {
        super(abstractReconstructionSpecs);
        if (abstractReconstructionSpecs instanceof OSEMSpecs) {
            OSEMSpecs oSEMSpecs = (OSEMSpecs)abstractReconstructionSpecs;
            this.subsets = oSEMSpecs.f();
            this.iterations = oSEMSpecs.g();
        } else {
            this.subsets = ReconstructionPrefs.osemSubsets.getValue();
            this.iterations = ReconstructionPrefs.osemIterations.getValue();
        }
    }

    public OSEMSpecs() {
        this.subsets = ReconstructionPrefs.osemSubsets.getValue();
        this.iterations = ReconstructionPrefs.osemIterations.getValue();
    }

    @Override
    public ReconstructionAlgorithm a() {
        return ReconstructionAlgorithm.b;
    }

    public int f() {
        return this.subsets;
    }

    public int g() {
        return this.iterations;
    }

    public void a(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Subsets must be >= 1");
        }
        this.subsets = n2;
        ReconstructionPrefs.osemSubsets.setValue(n2);
    }

    public void b(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Iterations must be >= 1");
        }
        this.iterations = n2;
        ReconstructionPrefs.osemIterations.setValue(n2);
    }

    protected OSEMSpecs h() {
        return (OSEMSpecs)super.e();
    }

    @Override
    protected /* synthetic */ AbstractReconstructionSpecs e() {
        return this.h();
    }

    @Override
    protected /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.h();
    }
}

