/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.registration;

import com.mimvista.numerics.ImageSlice;
import java.awt.BorderLayout;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import org.jdesktop.swingx.graphics.BlendComposite;

public class AAVisualizer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private int targetDim = 512;
    private BufferedImage im;

    public AAVisualizer(ImageSlice.ImageSliceFloat imageSliceFloat, ImageSlice.ImageSliceFloat imageSliceFloat2, int n2) {
        this.setTitle("Assisted Alignment Visualizer");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.b(imageSliceFloat, imageSliceFloat2, n2);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void b(ImageSlice.ImageSliceFloat imageSliceFloat, ImageSlice.ImageSliceFloat imageSliceFloat2, int n2) {
        int n3;
        BufferedImage bufferedImage = new BufferedImage(imageSliceFloat.width, imageSliceFloat.height, 2);
        BufferedImage bufferedImage2 = new BufferedImage(imageSliceFloat.width, imageSliceFloat.height, 1);
        BufferedImage bufferedImage3 = new BufferedImage(imageSliceFloat.width, imageSliceFloat.height, 1);
        for (int i2 = 0; i2 < imageSliceFloat.height; ++i2) {
            for (n3 = 0; n3 < imageSliceFloat.width; ++n3) {
                float f2 = imageSliceFloat.b(n3, i2);
                float f3 = imageSliceFloat2.b(n3, i2);
                if (!(f2 >= 0.0f)) continue;
                int n4 = (int)(f2 * 255.0f / (float)n2);
                bufferedImage2.setRGB(n3, i2, (n4 << 16) + (n4 << 8) + n4);
                if (f3 >= 0.0f) {
                    float f4 = 255.0f * f3 / (float)n2;
                    int n5 = (int)f4;
                    int n6 = (int)(255.0f * Math.max(0.0f, f4 - 121.0f) / 134.0f);
                    int n7 = (int)(255.0f * Math.max(0.0f, f4 - 191.0f) / 64.0f);
                    bufferedImage3.setRGB(n3, i2, (n5 << 16) + (n6 << 8) + n7);
                    continue;
                }
                bufferedImage3.setRGB(n3, i2, 65280);
            }
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.setComposite((Composite)BlendComposite.getInstance((BlendComposite.BlendingMode)BlendComposite.BlendingMode.ADD, (float)1.0f));
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
        graphics2D.dispose();
        n3 = imageSliceFloat.width;
        int n8 = imageSliceFloat.height;
        if (this.targetDim > 0) {
            if (n3 > n8) {
                n3 = this.targetDim;
                n8 = Math.round((float)(this.targetDim * imageSliceFloat.height) / (float)imageSliceFloat.width);
            } else {
                n3 = Math.round((float)(this.targetDim * imageSliceFloat.width) / (float)imageSliceFloat.height);
                n8 = this.targetDim;
            }
        }
        Insets insets = this.getInsets();
        this.setPreferredSize(new Dimension(n3 + insets.left + insets.right, n8 + insets.top + insets.bottom));
        this.setSize(this.getPreferredSize());
        this.im = bufferedImage;
    }

    public void a(ImageSlice.ImageSliceFloat imageSliceFloat, ImageSlice.ImageSliceFloat imageSliceFloat2, int n2) {
        this.b(imageSliceFloat, imageSliceFloat2, n2);
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Insets insets = this.getInsets();
        if (this.im != null) {
            graphics.drawImage(this.im, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom, null);
        } else {
            graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

