/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.automated.service;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.remote.QueryClient;
import com.mimvista.archive.remote.j;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.Automator;
import com.mimvista.automator.database.b;
import com.mimvista.automator.rule.AutomatorException;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.e.a;
import com.mimvista.exodus.MIM;
import com.mimvista.file.PathUtils;
import com.mimvista.license.LicenseClient;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.mui.Session;
import com.mimvista.mui.bm;
import com.mimvista.preferencesNew.AutomatedReportsPrefs;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.report.automated.service.WorkflowProcessArgs;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.m;
import com.mimvista.util.MIMContext;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import com.mimvista.util.bs;
import com.mimvista.util.by;
import com.mimvista.util.cn;
import com.mimvista.util.u;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.workflow.backend.Target;
import com.mimvista.workflow.backend.Workflow;
import com.mimvista.workflow.backend.setup.e;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AutomatedWorkflowSandbox {
    private static String a = "mim.aws.logdirname";
    private static final long b = TimeUnit.MINUTES.toMillis(1L);
    private static final long c = TimeUnit.SECONDS.toMillis(1L);
    private final String d;
    private Process e = null;
    private boolean f = false;

    public AutomatedWorkflowSandbox(boolean bl2) {
        this.d = bl2 ? "ART_Assist" : "assistant_workflows";
    }

    public synchronized boolean a() {
        return this.e == null ? false : this.e.isAlive();
    }

    public synchronized boolean b() {
        return this.f;
    }

    public void a(Workflow workflow, List<DcmSeries> list, UUID uUID) throws IOException, AutomatorException, NumberFormatException, TimeoutException {
        this.a(workflow, list, null, null, null, uUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Workflow workflow, List<DcmSeries> list, @d Map<Target, DcmSeries> map, @d ArtAssistConfig artAssistConfig, @d FractionInformation fractionInformation, UUID uUID) throws IOException, AutomatorException, NumberFormatException, TimeoutException {
        WorkflowProcessArgs workflowProcessArgs = new WorkflowProcessArgs(workflow, list, map, artAssistConfig, fractionInformation, uUID);
        if (LicenseTransformer.isDevelopment() && AutomatedReportsPrefs.runAutomatedWorkflowsInAssistantJvm.getValue().booleanValue()) {
            ay.b((Object)"Running automated workflow in The Assistant's JVM", this);
            String string = com.mimvista.automator.database.b.a().toJson((Object)workflowProcessArgs);
            String[] stringArray = new String[]{com.mimvista.util.d.a(string.getBytes())};
            AutomatedWorkflowSandbox.main(stringArray);
            return;
        }
        Process process = null;
        try {
            process = this.a(workflowProcessArgs);
            AutomatedWorkflowSandbox automatedWorkflowSandbox = this;
            synchronized (automatedWorkflowSandbox) {
                this.e = process;
            }
            int n2 = by.a(process, TimeUnit.MINUTES.toMillis(AutomatedReportsPrefs.autoWorkflowMinutesToTimeout.getValue().intValue()));
            AutomatedWorkflowSandbox automatedWorkflowSandbox2 = this;
            synchronized (automatedWorkflowSandbox2) {
                if (this.f) {
                    ay.a((Object)"Automated workflow exited after cancel/interrupt", this);
                }
                if (!this.f && n2 != WorkflowRunResult.a.code) {
                    throw new RuntimeException("Workflow did not finish successfully, exit status: " + n2);
                }
            }
        }
        finally {
            AutomatedWorkflowSandbox automatedWorkflowSandbox = this;
            synchronized (automatedWorkflowSandbox) {
                this.e = null;
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean c() {
        try {
            Process process = null;
            AutomatedWorkflowSandbox automatedWorkflowSandbox = this;
            synchronized (automatedWorkflowSandbox) {
                process = this.e;
                if (process == null || !this.a()) {
                    this.e = null;
                    return false;
                }
            }
            ay.b((Object)"Trying to kill headless workflow process", this.getClass());
            process.destroy();
            automatedWorkflowSandbox = this;
            synchronized (automatedWorkflowSandbox) {
                this.e = null;
                this.f = true;
            }
            return true;
        }
        catch (Exception exception) {
            ay.d((Object)"Unable to kill headless workflow", (Throwable)exception, AutomatedWorkflowSandbox.class);
            return false;
        }
    }

    private Process a(WorkflowProcessArgs workflowProcessArgs) throws IOException, AutomatorException {
        String string = "-Xmx" + AutomatedReportsPrefs.autoWorkflowMaxHeap.getValue() + "m";
        String string2 = "-XX:NewRatio=9";
        String string3 = "-Djava.awt.headless=" + AutomatedReportsPrefs.autoWorkflowHeadless.getValue();
        String string4 = System.getProperty("java.class.path");
        String string5 = "-D" + a + "=" + this.d;
        String[] stringArray = AutomatedReportsPrefs.autoWorkflowJvmArgs.getValue();
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(PathUtils.getJrePath());
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add("-cp");
        arrayList.add(string4);
        if (LicenseTransformer.isDevelopment()) {
            arrayList.add("-Xdebug");
            arrayList.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=1044");
        }
        arrayList.add(string5);
        arrayList.add("-XX:-OmitStackTraceInFastThrow");
        if (Boolean.getBoolean("nodevelopment")) {
            arrayList.add("-Dnodevelopment=true");
        }
        if (stringArray != null && stringArray.length > 0) {
            for (String string6 : stringArray) {
                arrayList.add(string6);
            }
        }
        arrayList.add(AutomatedWorkflowSandbox.class.getCanonicalName());
        ay.b((Object)("Creating Automated Workflow JVM (DEBUG has full cmd): " + workflowProcessArgs.a().getPath() + " " + string + " " + string5), this);
        ay.a((Object)("Automated Workflow JVM arguments: " + arrayList), this);
        String string7 = com.mimvista.automator.database.b.a().toJson((Object)workflowProcessArgs);
        arrayList.add(com.mimvista.util.d.a(string7.getBytes()));
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        processBuilder.redirectErrorStream(true);
        return processBuilder.start();
    }

    public static void main(String[] stringArray) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                u u2 = new u(b, new Runnable(){

                    @Override
                    public void run() {
                        ay.d((Object)"Shutdown hook has taken longer than 1 minute, HALTING JVM.", this);
                        bs.g();
                        try {
                            Thread.sleep(c);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Runtime.getRuntime().halt(WorkflowRunResult.a.code);
                    }
                });
                u2.b();
            }
        });
        thread.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(thread);
        boolean bl2 = LicenseTransformer.isDevelopment() && AutomatedReportsPrefs.runAutomatedWorkflowsInAssistantJvm.getValue() != false;
        try {
            Object object;
            if (!bl2) {
                boolean bl3 = false;
                object = System.getProperty(a);
                if (object == null) {
                    bl3 = true;
                    object = "headless_workflows";
                }
                com.mimvista.exodus.d.b((String)object, false);
                QueryClient.initSSL();
                if (bl3) {
                    ay.c((Object)("Using generic log dir (" + (String)object + "). Should be explicitly set."), AutomatedWorkflowSandbox.class);
                }
                MIMContext.a(MIMContext.MIMType.l);
            } else {
                ay.b((Object)"Starting workflow in special debug mode", AutomatedWorkflowSandbox.class);
            }
            String string = new String(com.mimvista.util.d.a(stringArray[0]));
            object = (WorkflowProcessArgs)com.mimvista.automator.database.b.a().fromJson(string, WorkflowProcessArgs.class);
            com.mimvista.user.b.a().e();
            Automator.setupAssistantCascade(((WorkflowProcessArgs)object).c());
            Automator.doConfigSync();
            bg.a("load RPL data", true);
            j.b();
            j j2 = j.c();
            j2.a(true);
            bg.e("load RPL data");
            ay.a((Object)"Loading process arguments", AutomatedWorkflowSandbox.class);
            WorkflowProcessArgs workflowProcessArgs = (WorkflowProcessArgs)com.mimvista.automator.database.b.a().fromJson(string, WorkflowProcessArgs.class);
            List<WorkflowCommand> list = workflowProcessArgs.a().getCommands();
            ay.a((Object)"Acquiring Licenses", AutomatedWorkflowSandbox.class);
            Runtime.getRuntime().addShutdownHook(MIM.getFreeLicensesThread());
            CountDownLatch countDownLatch = new CountDownLatch(1);
            com.mimvista.exodus.e.a(countDownLatch, list).run();
            countDownLatch.await(5L, TimeUnit.MINUTES);
            String string2 = Arrays.toString(LicenseClient.getReservedLicenses());
            ay.b((Object)("Workflow VM found the following licenses: " + string2), AutomatedWorkflowSandbox.class);
            Session session = bm.g();
            List<AtomicLoadUnit> list2 = workflowProcessArgs.d();
            SearchSource searchSource = workflowProcessArgs.f();
            AutomatedWorkflowSandbox.a(workflowProcessArgs, session, searchSource, list2);
            ay.a((Object)("Launching workflow: " + workflowProcessArgs.a().getPath()), AutomatedWorkflowSandbox.class);
            com.mimvista.workflow.gui.status.a a2 = new com.mimvista.workflow.gui.status.a();
            com.mimvista.workflow.backend.setup.e.a(session, workflowProcessArgs.a(), list2, workflowProcessArgs.g(), a2, workflowProcessArgs.e(), searchSource);
            int n2 = AutomatedReportsPrefs.sleepSecondsAfterAutoWorkflow.getValue();
            ay.a((Object)("Post-workflow wait, sleeping for " + n2 + " seconds"), AutomatedWorkflowSandbox.class);
            Thread.sleep(TimeUnit.SECONDS.toMillis(n2));
            ay.a((Object)"Automated workflow finished", AutomatedWorkflowSandbox.class);
            if (!bl2) {
                System.exit(a2.b() ? WorkflowRunResult.b.code : WorkflowRunResult.a.code);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error running automated workflow", throwable, AutomatedWorkflowSandbox.class);
            System.exit(WorkflowRunResult.c.code);
        }
    }

    private static void a(WorkflowProcessArgs workflowProcessArgs, Session session, SearchSource searchSource, List<AtomicLoadUnit> list) {
        if (!workflowProcessArgs.c()) {
            return;
        }
        SendToDestination sendToDestination = ag.b(searchSource);
        if (sendToDestination == null) {
            throw new RuntimeException("Unable to associate source to ART Config Store: " + searchSource);
        }
        m m2 = new m(com.mimvista.e.a.a(), sendToDestination);
        ArtAssistConfig artAssistConfig = workflowProcessArgs.a(m2);
        if (artAssistConfig == null) {
            throw new RuntimeException("Unable to get ART Assist Config: " + workflowProcessArgs.b() + " on " + searchSource);
        }
        FractionInformation fractionInformation = workflowProcessArgs.a(artAssistConfig);
        if (fractionInformation == null) {
            throw new RuntimeException("No FractionInformation found associated with the given series' art-config: " + artAssistConfig.J());
        }
        UniqueSeriesPointer uniqueSeriesPointer = fractionInformation.getPlanDose();
        if (uniqueSeriesPointer == null) {
            uniqueSeriesPointer = artAssistConfig.t();
        }
        if (uniqueSeriesPointer == null) {
            throw new RuntimeException("No associated Plan Dose found for ART Assist. Config: " + artAssistConfig.J());
        }
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.searchType = 0;
        seriesParameters.uidList = Collections.singletonList(uniqueSeriesPointer.getSeriesUID());
        List<DcmSeries> list2 = searchSource.a(seriesParameters);
        if (list2.isEmpty()) {
            throw new RuntimeException("Unable to locate Plan Dose for ART Assist. Plan Dose: " + uniqueSeriesPointer.toString() + " Config: " + artAssistConfig.J());
        }
        if (list2.size() > 1) {
            throw new RuntimeException("Found too many Plan Dose's for ART Assist. Plan Dose: " + uniqueSeriesPointer.toString() + " Config: " + artAssistConfig.J());
        }
        DcmSeries dcmSeries = list2.get(0);
        RTDoseSeriesInfo.RxType rxType = artAssistConfig.l();
        Float f2 = artAssistConfig.k();
        session.a(new UIDContainer.SOPInstanceUID(dcmSeries.getOneOfMySOPInstanceUIDs()), rxType, f2);
        boolean bl2 = false;
        for (AtomicLoadUnit atomicLoadUnit : list) {
            for (UIDContainer.SOPInstanceUID sOPInstanceUID : dcmSeries.getAllSopInstanceUids()) {
                if (cn.b(sOPInstanceUID.uid, atomicLoadUnit.getSeries().getOneOfMySOPInstanceUIDs(), false) != 0) continue;
                atomicLoadUnit.setUserWantsToLoadDose(Boolean.TRUE);
                bl2 = true;
            }
        }
        if (!bl2) {
            throw new RuntimeException("Unable to locate RTDOSE specified by plan when running headless workflow!");
        }
        ay.b((Object)("Loaded ART Assist Config into session: " + artAssistConfig.J() + " on " + searchSource), AutomatedWorkflowSandbox.class);
        c c2 = m2.c(artAssistConfig);
        com.mimvista.preferencesNew.cascade.c.a(c2);
        com.mimvista.preferencesNew.cascade.c.b(c2);
    }

    private static enum WorkflowRunResult {
        a(0),
        b(-1),
        c(1);

        public final int code;

        private WorkflowRunResult(int n3) {
            this.code = n3;
        }
    }
}

