/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.automated.service;

import com.google.common.collect.Lists;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.rule.AutomatorException;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.internals.b;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.cbct.config.l;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.az;
import com.mimvista.workflow.backend.Target;
import com.mimvista.workflow.backend.Workflow;
import com.mimvista.workflow.backend.WorkflowFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class WorkflowProcessArgs
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String workflowPath;
    private final List<UniqueSeriesPointer> toLoad;
    private final Map<Integer, UniqueSeriesPointer> mapping;
    private final String artConfigUid;
    private final String searchSourceIdentifier;
    private final UUID ruleInstanceId;
    private final String fractionSeriesUid;
    private final Date fractionSeriesDate;
    private final int fractionNum;
    private final int deliveryNum;
    private transient Workflow a;

    public WorkflowProcessArgs(Workflow workflow, List<DcmSeries> list, @d Map<Target, DcmSeries> map, @d ArtAssistConfig artAssistConfig, @d FractionInformation fractionInformation, @d UUID uUID) throws AutomatorException {
        this.a = workflow;
        this.workflowPath = workflow.getPath();
        this.artConfigUid = artAssistConfig != null ? artAssistConfig.b() : null;
        this.fractionSeriesUid = fractionInformation == null ? null : fractionInformation.getFractionSeriesUID();
        this.fractionSeriesDate = fractionInformation == null ? null : fractionInformation.getSeriesDate();
        this.fractionNum = fractionInformation == null ? -1 : fractionInformation.getFractionNumber();
        this.deliveryNum = fractionInformation == null ? -1 : fractionInformation.getFractionDeliveryNumber();
        this.searchSourceIdentifier = com.mimvista.automator.database.b.a(WorkflowProcessArgs.a(list));
        this.ruleInstanceId = uUID;
        this.toLoad = list.stream().map(dcmSeries -> dcmSeries.getUniqueSeriesPointer()).collect(Collectors.toList());
        if (map != null) {
            this.mapping = new HashMap<Integer, UniqueSeriesPointer>();
            for (Map.Entry<Target, DcmSeries> entry : map.entrySet()) {
                Integer n2 = workflow.getTargetReference(entry.getKey()).g();
                this.mapping.put(n2, entry.getValue().getUniqueSeriesPointer());
            }
        } else {
            this.mapping = null;
        }
    }

    public Workflow a() {
        if (this.a == null) {
            this.a = WorkflowFactory.a(this.workflowPath);
        }
        return this.a;
    }

    public String b() {
        return this.artConfigUid;
    }

    public ArtAssistConfig a(h h2) {
        return l.a(h2, this.artConfigUid);
    }

    public FractionInformation a(ArtAssistConfig artAssistConfig) {
        return artAssistConfig.a(this.fractionSeriesUid, this.fractionSeriesDate, this.fractionNum, this.deliveryNum);
    }

    public boolean c() {
        return this.artConfigUid != null;
    }

    public List<AtomicLoadUnit> d() {
        SearchSource searchSource = this.f();
        ArrayList arrayList = Lists.newArrayList();
        Future<List<az<DcmSeries>>> future = searchSource.a((Collection<UniqueSeriesPointer>)this.toLoad);
        try {
            List<az<DcmSeries>> list = future.get();
            list.forEach(az2 -> arrayList.add(az2.b()));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Can't fetch one or more series from search source " + searchSource.i(), throwable);
        }
        return b.a(arrayList);
    }

    public UUID e() {
        return this.ruleInstanceId;
    }

    public SearchSource f() {
        return com.mimvista.automator.database.b.a(this.searchSourceIdentifier, true, true);
    }

    public Map<Target, Collection<AtomicLoadUnit>> g() {
        if (this.mapping == null) {
            return null;
        }
        SearchSource searchSource = this.f();
        Map<Target, Collection<AtomicLoadUnit>> map = StreamSupport.stream(this.a().getTargetsWithAntisIterable().spliterator(), false).filter(target -> this.mapping.containsKey(this.a().getTargetReference((Target)target).g())).map(target -> {
            try {
                UniqueSeriesPointer uniqueSeriesPointer = this.mapping.get(this.a().getTargetReference((Target)target).g());
                Future<az<DcmSeries>> future = searchSource.a(uniqueSeriesPointer);
                az<DcmSeries> az2 = future.get();
                DcmSeries dcmSeries = az2.b();
                List<AtomicLoadUnit> list = b.a(new DcmSeries[]{dcmSeries});
                return Pair.get(target, list);
            }
            catch (Exception exception) {
                throw new RuntimeException("Can't fetch one or more series from search source " + searchSource.i(), exception);
            }
        }).collect(Collectors.toMap(pair -> (Target)pair.x, pair -> (Collection)pair.y));
        return map;
    }

    private static SearchSource a(List<DcmSeries> list) throws AutomatorException {
        SearchSource searchSource = list.get(0).getSearchSource();
        int n2 = 1;
        while (searchSource == null && n2 < list.size()) {
            searchSource = list.get(n2++).getSearchSource();
        }
        if (searchSource == null) {
            throw new AutomatorException(true, "I have no idea where to get these series", Messages.a("Automator", "AUTOMATOR_EXCEPTION_UNKNOWN_SOURCE_FOR_SERIES"));
        }
        while (n2 < list.size()) {
            SearchSource searchSource2;
            if ((searchSource2 = list.get(n2++).getSearchSource()) != null && !searchSource2.equals(searchSource)) {
                throw new AutomatorException(true, "this data comes from several different search sources: " + searchSource + " and " + searchSource2, Messages.a("Automator", "AUTOMATOR_EXCEPTION_UNKNOWN_SOURCE_FOR_SERIES"));
            }
            ++n2;
        }
        return searchSource;
    }
}

