/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.automated.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.gui.SeriesColumn;
import com.mimvista.archive.m;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.report.automated.service.ArtAssistExceptions;
import com.mimvista.report.automated.service.a;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.util.DateUtils;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class b {
    private final ArtAssistConfig a;
    private final FractionInformation b;
    private final DcmSeries c;

    public b(ArtAssistConfig artAssistConfig, FractionInformation fractionInformation, DcmSeries dcmSeries) {
        this.a = artAssistConfig;
        this.b = fractionInformation;
        this.c = dcmSeries;
    }

    public DcmSeries a() throws ArtAssistExceptions.AlignmentMissingException {
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.modality = Modality.REG.get();
        seriesParameters.searchType = 2;
        seriesParameters.name = this.c.getPatientName();
        seriesParameters.studyDate = this.c.getDate();
        seriesParameters.contentDate = DateUtils.b(new Date());
        seriesParameters.uidList = Lists.newArrayList((Object[])new String[]{this.c.getSeriesInstanceUID(), this.a.r().getSeriesUID()});
        List<DcmSeries> list = this.c.getSearchSource().a(seriesParameters);
        return (DcmSeries)list.stream().sorted((dcmSeries, dcmSeries2) -> dcmSeries2.getSeriesOrStudyDateTime(true).compareTo(dcmSeries.getSeriesOrStudyDateTime(true))).findFirst().orElseThrow(() -> new ArtAssistExceptions.AlignmentMissingException("No alignment data found for " + this.c));
    }

    public Map<String, DcmSeries> b() throws ArtAssistExceptions.ReferencedSeriesMissingException {
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.name = this.c.getPatientName();
        seriesParameters.searchType = 0;
        seriesParameters.uidList = new ArrayList<String>();
        HashSet<UniqueSeriesPointer> hashSet = new HashSet<UniqueSeriesPointer>();
        if (this.a.s() != null) {
            hashSet.add(this.a.s());
        }
        if (this.a.r() != null) {
            hashSet.add(this.a.r());
        }
        if (this.a.t() != null) {
            hashSet.add(this.a.t());
        }
        if (this.a.u() != null) {
            hashSet.add(this.a.u());
        }
        if (this.b.getPlanDose() != null) {
            hashSet.add(this.b.getPlanDose());
        }
        hashSet.stream().map(uniqueSeriesPointer -> uniqueSeriesPointer.getSeriesUID()).collect(Collectors.toCollection(() -> seriesParameters.uidList));
        if (seriesParameters.uidList.isEmpty()) {
            throw new ArtAssistExceptions.ReferencedSeriesMissingException("No referenced series UIDs were specified for the search on " + this.c);
        }
        SearchSource searchSource = this.c.getSearchSource();
        if (searchSource == null) {
            throw new ArtAssistExceptions.ReferencedSeriesMissingException("No search source was set on the incoming series " + this.c);
        }
        List<DcmSeries> list = searchSource.a(seriesParameters);
        return this.a(this.a, list);
    }

    public DcmSeries c() {
        HashMap<String, String> hashMap = m.a("", this.c.getPatientName(), this.c.getPatientID(), this.c.getModality(), "", "", "");
        List<DcmSeries> list = this.c.getSearchSource().b(hashMap);
        DcmSeries dcmSeries2 = null;
        FractionInformation fractionInformation = this.a.a(1, 0);
        if (fractionInformation != null && (dcmSeries2 = (DcmSeries)list.stream().sorted(SeriesColumn.k.e().nullsLast()).filter(dcmSeries -> dcmSeries.getSeriesInstanceUID().equals(fractionInformation.getFractionSeriesUID())).findFirst().orElse(null)) == null) {
            ay.c((Object)("ART Assist Config says first fraction is " + fractionInformation.getFractionSeriesUID() + " but does not exist in patient list"), this);
        }
        if (dcmSeries2 == null) {
            dcmSeries2 = list.stream().sorted(SeriesColumn.k.e().nullsLast()).filter(dcmSeries -> !dcmSeries.getSeriesInstanceUID().equals(this.a.r().getSeriesUID())).filter(dcmSeries -> this.a.a((DcmSeries)dcmSeries, -1, -1) != null || this.a.q().before(dcmSeries.getSeriesOrStudyDateTime(true)) || this.a.q().equals(dcmSeries.getSeriesOrStudyDateTime(true))).findFirst().orElse(null);
        }
        return dcmSeries2;
    }

    private Map<String, DcmSeries> a(ArtAssistConfig artAssistConfig, List<DcmSeries> list) throws ArtAssistExceptions.ReferencedSeriesMissingException {
        HashMap hashMap = Maps.newHashMap();
        LinkedHashMap<String, UniqueSeriesPointer> linkedHashMap = new LinkedHashMap<String, UniqueSeriesPointer>();
        linkedHashMap.put("Planning Series", artAssistConfig.r());
        linkedHashMap.put("Planning RTst", artAssistConfig.u());
        linkedHashMap.put("Planning RTdose", artAssistConfig.t());
        linkedHashMap.put("Planning RTplan", artAssistConfig.s());
        linkedHashMap.put("Fraction RTdose", this.b.getPlanDose());
        boolean bl2 = true;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (bl2 &= this.a((UniqueSeriesPointer)entry.getValue(), list, hashMap)) continue;
            throw new ArtAssistExceptions.ReferencedSeriesMissingException("Series referenced by report setup was not found when processing: " + (String)entry.getKey() + " for " + this.c);
        }
        if (!this.a(hashMap.values())) {
            throw new ArtAssistExceptions.ReferencedSeriesMissingException("Invalid modalities returned by referenced series search for " + this.c);
        }
        return hashMap;
    }

    private boolean a(@d UniqueSeriesPointer uniqueSeriesPointer, List<DcmSeries> list, Map<String, DcmSeries> map) {
        if (uniqueSeriesPointer == null || cn.g(uniqueSeriesPointer.getSeriesUID())) {
            return true;
        }
        for (DcmSeries dcmSeries : list) {
            if (cn.b(uniqueSeriesPointer.getSeriesUID(), dcmSeries.getSeriesInstanceUID(), false) != 0 && cn.b(uniqueSeriesPointer.getSeriesUID(), dcmSeries.getOneOfMySOPInstanceUIDs(), false) != 0) continue;
            map.put(uniqueSeriesPointer.getSeriesUID(), dcmSeries);
            return true;
        }
        return false;
    }

    private boolean a(Iterable<DcmSeries> iterable) {
        for (DcmSeries dcmSeries : iterable) {
            if (com.mimvista.report.automated.service.a.a(dcmSeries) || Modality.RTPLAN.isSameModality(dcmSeries.getModality()) || Modality.RTDOSE.isSameModality(dcmSeries.getModality()) || Modality.RTST.isSameModality(dcmSeries.getModality())) continue;
            return false;
        }
        return true;
    }
}

