/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.cbct;

import com.google.common.collect.Maps;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.numerics.IECFixedPoint3f;
import com.mimvista.numerics.IECFixedVector;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.report.codes.Concept;
import com.mimvista.report.codes.ConceptCode;
import com.mimvista.report.codes.GeneralConcept;
import com.mimvista.report.codes.Units;
import com.mimvista.report.codes.a;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.util.HashMap;
import java.util.Map;

public enum FractionInfoKey implements Concept
{
    a("MIM00147", "99MIM", "SHIFT_EDITOR_FRACTION_NUMBER", Units.i),
    b("MIM00164", "99MIM", "SHIFT_EDITOR_DELIVERY_NUMBER", Units.i),
    c("MIM00165", "99MIM", "CBCT_PLAN_INFO_TITLE", null),
    d("MIM00150", "99MIM", "CBCT_PLAN_STORE_TITLE", null),
    e(GeneralConcept.H.getCode(), null),
    f("MIM00038", "99MIM", "SUPERIOR_OFFSET_NO_UNITS", "SUPERIOR_OFFSET", Units.b),
    g("MIM00039", "99MIM", "ANTERIOR_OFFSET_NO_UNITS", "ANTERIOR_OFFSET", Units.b),
    h("MIM00040", "99MIM", "LATERAL_OFFSET_NO_UNITS", "LATERAL_OFFSET", Units.b),
    i("MIM00041", "99MIM", "ROLL_OFFSET_NO_UNITS", "ROLL_OFFSET", Units.l),
    j("MIM00042", "99MIM", "PITCH_OFFSET_NO_UNITS", "PITCH_OFFSET", Units.l),
    k("MIM00043", "99MIM", "YAW_OFFSET_NO_UNITS", "YAW_OFFSET", Units.l);

    private final String code;
    private final String csd;
    private final String nameWithUnits;
    private final String name;
    private final Units units;

    private FractionInfoKey(String string2, String string3, String string4, Units units) {
        this(string2, string3, string4, string4, units);
    }

    private FractionInfoKey(String string2, String string3, String string4, String string5, Units units) {
        this.code = string2;
        this.csd = string3;
        this.name = Messages.a("Report", string4);
        this.units = units;
        String string6 = Messages.a("Report", string5);
        if (units != null) {
            string6 = MIMFormat.a(string6, units == Units.l ? Messages.a("InfoItem", "DEGREES") : units.getCodeMeaning());
        }
        this.nameWithUnits = string6;
    }

    private FractionInfoKey(ConceptCode conceptCode, Units units) {
        this.code = conceptCode.a();
        this.csd = conceptCode.b();
        this.nameWithUnits = conceptCode.c();
        this.name = conceptCode.c();
        this.units = units;
    }

    public Units a() {
        return this.units;
    }

    public String b() {
        return this.nameWithUnits;
    }

    @Override
    public boolean isHeadingConcept() {
        return false;
    }

    @Override
    public String getCodeMeaning() {
        return this.name;
    }

    @Override
    public ConceptCode getCode() {
        return com.mimvista.report.codes.a.a(this.code, this.csd, this.getCodeMeaning());
    }

    public static FractionInfoKey[] c() {
        return new FractionInfoKey[]{f, g, h, i, j, k};
    }

    public static Map<FractionInfoKey, Float> a(IECFixedVector iECFixedVector, IECFixedVector iECFixedVector2) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(h, Float.valueOf(iECFixedVector.a()));
        hashMap.put(g, Float.valueOf(iECFixedVector.c()));
        hashMap.put(f, Float.valueOf(iECFixedVector.b()));
        hashMap.put(j, Float.valueOf(iECFixedVector2.d()));
        hashMap.put(k, Float.valueOf(iECFixedVector2.f()));
        hashMap.put(i, Float.valueOf(iECFixedVector2.e()));
        return hashMap;
    }

    public static Map<FractionInfoKey, Float> a(TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix) {
        IECFixedVector iECFixedVector = SimpleOrientationHelper.a(typedMatrix);
        IECFixedVector iECFixedVector2 = SimpleOrientationHelper.b(typedMatrix);
        return FractionInfoKey.a(iECFixedVector, iECFixedVector2);
    }
}

