/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.cbct;

import com.google.common.collect.Ordering;
import com.mimvista.archive.gui.fractions.FractionGrade;
import com.mimvista.archive.gui.fractions.FractionStatus;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.d;
import com.mimvista.e;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.numerics.IECFixedPoint3f;
import com.mimvista.numerics.IECFixedVector;
import com.mimvista.numerics.IECOrientationPair;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.report.automated.service.AutomatedWorkflowStatus;
import com.mimvista.report.cbct.FractionInfoKey;
import com.mimvista.report.cbct.f;
import com.mimvista.util.DateUtils;
import com.mimvista.util.ay;
import com.mimvista.util.contrast.a;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

@e
public class FractionInformation
implements f,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_FRACTION_DELIVERY_NUMBER = 0;
    private UniqueSeriesPointer fractionSeries = null;
    private Date seriesDate = null;
    private Date lastAttemptedDate = null;
    private Integer fractionNumber;
    private Integer fractionDeliveryNumber = 0;
    private TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> shiftMatrix;
    private List<UniqueSeriesPointer> relatedSeries = new ArrayList<UniqueSeriesPointer>();
    private FractionStatus status = FractionStatus.UNSUPPORTED;
    private AutomatedWorkflowStatus workflowStatus = AutomatedWorkflowStatus.n;
    private FractionGrade grade = null;
    private String machine = null;
    private UniqueSeriesPointer planDose = null;
    private String reviewer = null;
    private static final Comparator<FractionInformation> a = (fractionInformation, fractionInformation2) -> {
        if (fractionInformation.getFractionNumber() == null) {
            if (fractionInformation2.getFractionNumber() == null) {
                return 0;
            }
            return 1;
        }
        if (fractionInformation2.getFractionNumber() == null) {
            return -1;
        }
        int n2 = fractionInformation.getFractionNumber().compareTo(fractionInformation2.getFractionNumber());
        if (n2 == 0) {
            n2 = fractionInformation.getFractionDeliveryNumber().compareTo(fractionInformation2.getFractionDeliveryNumber());
        }
        return n2;
    };
    private static final Comparator<FractionInformation> b = (fractionInformation, fractionInformation2) -> {
        if (fractionInformation.getSeriesDate().before(fractionInformation2.getSeriesDate())) {
            return -1;
        }
        if (fractionInformation.getSeriesDate().after(fractionInformation2.getSeriesDate())) {
            return 1;
        }
        return 0;
    };
    private static Ordering<FractionInformation> c;

    public FractionInformation(UniqueSeriesPointer uniqueSeriesPointer, Date date) {
        this.setSeriesDate(date);
        this.fractionSeries = uniqueSeriesPointer;
    }

    public Date getSeriesDate() {
        return this.seriesDate;
    }

    public void setSeriesDate(Date date) {
        this.seriesDate = DateUtils.a(date, 14);
    }

    public Date getLastAttemptedDate() {
        return this.lastAttemptedDate;
    }

    public void setLastAttemptedDate(Date date) {
        this.lastAttemptedDate = date;
    }

    @Override
    public Integer getFractionNumber() {
        return this.fractionNumber;
    }

    public void setFractionNumber(Integer n2) {
        this.fractionNumber = n2;
    }

    @Override
    public Integer getFractionDeliveryNumber() {
        return this.fractionDeliveryNumber;
    }

    public void setFractionDeliveryNumber(Integer n2) {
        this.fractionDeliveryNumber = n2 != null ? n2 : Integer.valueOf(0);
    }

    public TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> getShiftMatrix() {
        return this.shiftMatrix;
    }

    public IECFixedVector getTranslation() {
        if (this.shiftMatrix == null) {
            return null;
        }
        return SimpleOrientationHelper.a(this.shiftMatrix);
    }

    public IECFixedVector getRotation() {
        if (this.shiftMatrix == null) {
            return null;
        }
        return SimpleOrientationHelper.b(this.shiftMatrix);
    }

    public List<UniqueSeriesPointer> getRelatedSeries() {
        return new ArrayList<UniqueSeriesPointer>(this.relatedSeries);
    }

    public void setRelatedSeries(List<UniqueSeriesPointer> list) {
        this.relatedSeries = new ArrayList<UniqueSeriesPointer>(list);
    }

    public FractionStatus getStatus() {
        return this.status;
    }

    public void setStatus(FractionStatus fractionStatus) {
        this.status = fractionStatus;
    }

    public AutomatedWorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowStatus(AutomatedWorkflowStatus automatedWorkflowStatus) {
        this.workflowStatus = automatedWorkflowStatus;
    }

    @d
    public FractionGrade getGrade() {
        return this.grade;
    }

    public void setGrade(FractionGrade fractionGrade) {
        this.grade = fractionGrade;
    }

    @d
    public String getMachine() {
        return this.machine;
    }

    public void setMachine(String string) {
        this.machine = string;
    }

    @d
    public UniqueSeriesPointer getPlanDose() {
        return this.planDose;
    }

    public void setPlanDose(UniqueSeriesPointer uniqueSeriesPointer) {
        this.planDose = uniqueSeriesPointer;
    }

    public void setShift(IECFixedVector iECFixedVector, IECFixedVector iECFixedVector2) {
        this.shiftMatrix = IECOrientationPair.a(iECFixedVector, iECFixedVector2);
    }

    public void setShiftMatrix(TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix) {
        this.shiftMatrix = typedMatrix;
    }

    public void setFractionSeries(UniqueSeriesPointer uniqueSeriesPointer) {
        this.fractionSeries = uniqueSeriesPointer;
    }

    public UniqueSeriesPointer getFractionSeries() {
        return this.fractionSeries;
    }

    public String getFractionSeriesUID() {
        if (this.fractionSeries != null) {
            return this.fractionSeries.getSeriesUID();
        }
        return null;
    }

    @d
    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String string) {
        this.reviewer = string;
    }

    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (this.seriesDate != null) {
            stringBuilder.append(DateUtils.a(this.seriesDate, "yyyy-MM-dd HH:mm:ss"));
        } else {
            stringBuilder.append("null-series-date");
        }
        stringBuilder.append("]");
        stringBuilder.append(" (");
        stringBuilder.append(this.getFractionNumber());
        stringBuilder.append(".");
        stringBuilder.append(this.getFractionDeliveryNumber());
        stringBuilder.append(")");
        stringBuilder.append(" ");
        if (this.fractionSeries != null) {
            stringBuilder.append(this.fractionSeries.getSeriesUID());
        } else {
            stringBuilder.append("null-series-uid");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getLogString();
    }

    public String getString(FractionInfoKey fractionInfoKey) {
        Object object = this.get(fractionInfoKey);
        if (object instanceof Date) {
            return DateUtils.a((Date)object, "yyyy-MM-dd HH:mm:ss");
        }
        if (object instanceof Float) {
            Float f2 = (Float)object;
            if (Math.abs((double)f2.floatValue() - 1.0E-4) < 0.001) {
                f2 = Float.valueOf(0.0f);
            }
            DecimalFormat decimalFormat = com.mimvista.util.contrast.a.a();
            String string = decimalFormat.format(f2);
            return string;
        }
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Float getFloat(FractionInfoKey fractionInfoKey) {
        switch (fractionInfoKey) {
            case h: 
            case g: 
            case f: 
            case j: 
            case k: 
            case i: {
                return (Float)this.get(fractionInfoKey);
            }
        }
        return null;
    }

    public Object get(FractionInfoKey fractionInfoKey) {
        switch (fractionInfoKey) {
            case a: {
                return this.getFractionNumber();
            }
            case b: {
                return this.getFractionDeliveryNumber();
            }
            case e: {
                return DateUtils.a(this.getSeriesDate(), "yyyy-MM-dd HH:mm:ss");
            }
        }
        if (this.getShiftMatrix() == null) {
            return null;
        }
        float f2 = 0.0f;
        IECFixedVector iECFixedVector = this.getTranslation();
        IECFixedVector iECFixedVector2 = this.getRotation();
        switch (fractionInfoKey) {
            case h: {
                f2 = iECFixedVector.a();
                break;
            }
            case g: {
                f2 = iECFixedVector.c();
                break;
            }
            case f: {
                f2 = iECFixedVector.b();
                break;
            }
            case j: {
                f2 = iECFixedVector2.d();
                break;
            }
            case k: {
                f2 = iECFixedVector2.f();
                break;
            }
            case i: {
                f2 = iECFixedVector2.e();
                break;
            }
            default: {
                return null;
            }
        }
        if (Math.abs((double)f2 - 1.0E-4) < 0.001) {
            f2 = 0.0f;
        }
        return Float.valueOf(f2);
    }

    public boolean isFractionInstance(@d FractionInformation fractionInformation) {
        if (fractionInformation == null) {
            return false;
        }
        if (!this.getFractionSeries().getSeriesUID().equals(fractionInformation.getFractionSeries().getSeriesUID())) {
            return false;
        }
        if (!this.getSeriesDate().equals(fractionInformation.getSeriesDate())) {
            return false;
        }
        if (this.getPlanDose() != null && fractionInformation.getPlanDose() != null && !this.getPlanDose().equals(fractionInformation.getPlanDose())) {
            return false;
        }
        if (Integer.compare(this.getFractionNumber(), fractionInformation.getFractionNumber()) != 0) {
            return false;
        }
        return Integer.compare(this.getFractionDeliveryNumber(), fractionInformation.getFractionDeliveryNumber()) == 0;
    }

    public FractionInformation clone() {
        try {
            FractionInformation fractionInformation = (FractionInformation)super.clone();
            fractionInformation.relatedSeries = new ArrayList<UniqueSeriesPointer>(this.relatedSeries);
            return fractionInformation;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)"Fraction info not clonable", this);
            return null;
        }
    }

    public static synchronized Ordering<FractionInformation> getFractionOrdering() {
        if (c == null) {
            c = Ordering.from(a).compound(b);
        }
        return c;
    }
}

