/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.cbct.config;

import com.mimvista.archive.gui.fractions.FractionGrade;
import com.mimvista.archive.gui.fractions.FractionStatus;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.numerics.IECFixedPoint3f;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.report.automated.service.AutomatedWorkflowStatus;
import com.mimvista.report.cbct.FractionAuthorizer;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.FractionUpdateField;
import com.mimvista.report.cbct.config.MongoArtAssistConfigQuery;
import com.mimvista.report.cbct.config.l;
import com.mimvista.util.ay;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FractionUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String configUid;
    protected transient ArtAssistConfig a;
    protected FractionInformation fraction;
    protected FractionAuthorizer authorizer;
    protected Map<FractionUpdateField, Object> updateMap;

    public FractionUpdate(ArtAssistConfig artAssistConfig, FractionInformation fractionInformation) {
        this.configUid = artAssistConfig.b();
        this.a = artAssistConfig;
        this.fraction = fractionInformation;
        this.authorizer = null;
        this.updateMap = new HashMap<FractionUpdateField, Object>();
    }

    public FractionUpdate(ArtAssistConfig artAssistConfig, FractionUpdate fractionUpdate) {
        this(artAssistConfig, fractionUpdate.d());
        this.authorizer = fractionUpdate.authorizer;
        this.updateMap.putAll(fractionUpdate.updateMap);
    }

    public FractionInformation d() {
        return this.fraction;
    }

    public ArtAssistConfig e() {
        return this.a;
    }

    public void a(ArtAssistConfig artAssistConfig) {
        this.a = artAssistConfig;
    }

    public boolean a() {
        return this.updateMap.isEmpty();
    }

    public FractionAuthorizer f() {
        return this.authorizer;
    }

    public FractionUpdate a(FractionAuthorizer fractionAuthorizer) {
        this.authorizer = fractionAuthorizer;
        return this;
    }

    protected <T> T a(FractionUpdateField fractionUpdateField) {
        return (T)this.updateMap.get((Object)fractionUpdateField);
    }

    protected void a(FractionUpdateField fractionUpdateField, Object object) {
        if (object != null) {
            this.updateMap.put(fractionUpdateField, object);
        } else {
            this.updateMap.remove((Object)fractionUpdateField);
        }
    }

    public FractionStatus g() {
        return (FractionStatus)((Object)this.a(FractionUpdateField.a));
    }

    public FractionUpdate a(FractionStatus fractionStatus) {
        this.a(FractionUpdateField.a, (Object)fractionStatus);
        return this;
    }

    public AutomatedWorkflowStatus h() {
        return (AutomatedWorkflowStatus)this.a(FractionUpdateField.b);
    }

    public FractionUpdate a(AutomatedWorkflowStatus automatedWorkflowStatus) {
        this.a(FractionUpdateField.b, automatedWorkflowStatus);
        return this;
    }

    public FractionGrade i() {
        return (FractionGrade)((Object)this.a(FractionUpdateField.c));
    }

    public FractionUpdate a(FractionGrade fractionGrade) {
        this.a(FractionUpdateField.c, (Object)fractionGrade);
        return this;
    }

    public Date j() {
        return (Date)this.a(FractionUpdateField.d);
    }

    public FractionUpdate a(Date date) {
        this.a(FractionUpdateField.d, date);
        return this;
    }

    public TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> k() {
        return (TypedMatrix)this.a(FractionUpdateField.e);
    }

    public FractionUpdate a(TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix) {
        this.a(FractionUpdateField.e, typedMatrix);
        return this;
    }

    public Integer l() {
        return (Integer)this.a(FractionUpdateField.f);
    }

    public FractionUpdate a(Integer n2) {
        this.a(FractionUpdateField.f, n2);
        return this;
    }

    public Integer m() {
        return (Integer)this.a(FractionUpdateField.g);
    }

    public FractionUpdate b(Integer n2) {
        this.a(FractionUpdateField.g, n2);
        return this;
    }

    public UniqueSeriesPointer n() {
        return (UniqueSeriesPointer)this.a(FractionUpdateField.h);
    }

    public FractionUpdate a(UniqueSeriesPointer uniqueSeriesPointer) {
        this.a(FractionUpdateField.h, uniqueSeriesPointer);
        return this;
    }

    public Date o() {
        return (Date)this.a(FractionUpdateField.i);
    }

    public FractionUpdate b(Date date) {
        this.a(FractionUpdateField.i, date);
        return this;
    }

    public List<UniqueSeriesPointer> p() {
        return (List)this.a(FractionUpdateField.j);
    }

    public FractionUpdate a(List<UniqueSeriesPointer> list) {
        this.a(FractionUpdateField.j, list);
        return this;
    }

    public String q() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.a == null ? this.configUid : this.a.J());
        stringBuilder.append(" ");
        stringBuilder.append(this.fraction.getLogString());
        stringBuilder.append(this.s());
        return stringBuilder.toString();
    }

    private String s() {
        StringBuilder stringBuilder = new StringBuilder();
        List<FractionUpdateField> list = Arrays.asList(FractionUpdateField.values());
        for (FractionUpdateField fractionUpdateField : list) {
            if (!this.updateMap.containsKey((Object)fractionUpdateField)) continue;
            stringBuilder.append("\n");
            stringBuilder.append(fractionUpdateField.name());
            stringBuilder.append(" => ");
            Object object = this.updateMap.get((Object)fractionUpdateField);
            if (object == null) {
                stringBuilder.append("null");
                continue;
            }
            stringBuilder.append(fractionUpdateField.a(object));
        }
        return stringBuilder.toString();
    }

    public boolean r() {
        boolean bl2;
        boolean bl3 = this.fraction.getStatus() == FractionStatus.REVIEWED;
        boolean bl4 = FractionStatus.NEEDS_REVIEW.equals(this.updateMap.get((Object)FractionUpdateField.a));
        boolean bl5 = bl2 = this.updateMap.containsKey((Object)FractionUpdateField.c) && this.updateMap.size() == 1;
        if (bl3 && !bl4 && !bl2) {
            ay.d((Object)"Trying to modify a reviewed fraction", this);
            return false;
        }
        return true;
    }

    public MongoArtAssistConfigQuery b() {
        BasicDBObjectBuilder basicDBObjectBuilder = new BasicDBObjectBuilder();
        if (this.fraction.getFractionNumber() > 0) {
            if (this.fraction.getFractionDeliveryNumber() >= 0) {
                basicDBObjectBuilder.push("fractions").push("$elemMatch").add("fractionNum", (Object)this.fraction.getFractionNumber()).add("fractionDeliveryNum", (Object)this.fraction.getFractionDeliveryNumber()).pop().pop();
            } else {
                basicDBObjectBuilder.add("fractions.fractionNum", (Object)this.fraction.getFractionNumber());
            }
        }
        if (basicDBObjectBuilder.isEmpty()) {
            if (this.fraction.getFractionSeriesUID() != null) {
                basicDBObjectBuilder.add("fractions.fractionSeries.seriesUid", (Object)this.fraction.getFractionSeriesUID());
            }
            if (this.fraction.getSeriesDate() != null) {
                basicDBObjectBuilder.add("fractions.seriesDate_no_ms", (Object)this.fraction.getSeriesDate());
            }
        }
        if (basicDBObjectBuilder.isEmpty()) {
            ay.c((Object)("Unable to update config's fraction, not enough identifying information: " + this.fraction.getLogString()), l.class);
            return new MongoArtAssistConfigQuery();
        }
        basicDBObjectBuilder.add("configId", (Object)this.configUid);
        return new MongoArtAssistConfigQuery((BasicDBObject)basicDBObjectBuilder.get());
    }

    public MongoArtAssistConfigQuery c() {
        if (this.updateMap.isEmpty()) {
            return new MongoArtAssistConfigQuery();
        }
        BasicDBObjectBuilder basicDBObjectBuilder = new BasicDBObjectBuilder();
        BasicDBObjectBuilder basicDBObjectBuilder2 = new BasicDBObjectBuilder();
        for (FractionUpdateField fractionUpdateField : this.updateMap.keySet()) {
            if (!this.updateMap.containsKey((Object)fractionUpdateField)) continue;
            if (this.updateMap.get((Object)fractionUpdateField) != null) {
                basicDBObjectBuilder.add(fractionUpdateField.a(), fractionUpdateField.a(this.updateMap.get((Object)fractionUpdateField)));
                continue;
            }
            basicDBObjectBuilder2.add(fractionUpdateField.a(), (Object)"");
        }
        BasicDBObjectBuilder basicDBObjectBuilder3 = new BasicDBObjectBuilder();
        if (!basicDBObjectBuilder.isEmpty()) {
            basicDBObjectBuilder3.add("$set", (Object)basicDBObjectBuilder.get());
        }
        if (!basicDBObjectBuilder2.isEmpty()) {
            basicDBObjectBuilder3.add("$unset", (Object)basicDBObjectBuilder2.get());
        }
        return new MongoArtAssistConfigQuery((BasicDBObject)basicDBObjectBuilder3.get());
    }
}

