/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.codes;

import com.mimvista.report.codes.Concept;
import com.mimvista.report.codes.ConceptCode;
import com.mimvista.report.codes.GenericConceptCode;
import com.mimvista.util.Messages;

public enum Units implements Concept
{
    a,
    b,
    c,
    d,
    e,
    f,
    g("[hnsf'U]", "Report", "UNITS_CONCEPT_HU", "HU"),
    h("Gy", "Report", "UNITS_CONCEPT_GY", "Gy"),
    i("[arbU]", "Report", "UNITS_CONCEPT_ARBITRARY_UNITS", ""),
    j("%"),
    k("ms"),
    l("deg", "Report", "DEGREE", "\u00b0"),
    m("MIM00133", "PlanReview", "PR_BEAM_MONITOR_UNITS", "MU"),
    n("MIM00134", "PlanReview", "MU_PER_MINUTE", "MU/min"),
    o("MIM00159", "PlanReview", "MEV", "MeV"),
    p;

    final ConceptCode preferredCode;
    final String codeMeaning;
    final String displayUnit;

    private Units() {
        this.codeMeaning = this.name();
        this.displayUnit = this.name();
        this.preferredCode = new GenericConceptCode(this.name(), "UCUM", null, this.name(), this);
    }

    private Units(String string2) {
        this.codeMeaning = string2;
        this.displayUnit = string2;
        this.preferredCode = new GenericConceptCode(string2, "UCUM", null, string2, this);
    }

    private Units(String string2, String string3, String string4, String string5) {
        this.codeMeaning = Messages.a(string3, string4);
        this.displayUnit = string5;
        this.preferredCode = new GenericConceptCode(string2, "UCUM", null, this.codeMeaning, this);
    }

    public String a() {
        return this.displayUnit;
    }

    @Override
    public ConceptCode getCode() {
        return this.preferredCode;
    }

    @Override
    public String getCodeMeaning() {
        return this.codeMeaning;
    }

    @Override
    public boolean isHeadingConcept() {
        return false;
    }

    public static Units a(ConceptCode conceptCode) {
        for (Units units : Units.values()) {
            if (!units.preferredCode.equals(conceptCode)) continue;
            return units;
        }
        return null;
    }

    public static Units a(String string) {
        for (Units units : Units.values()) {
            if (units.a().equalsIgnoreCase(string)) {
                return units;
            }
            if (!units.getCode().a().equalsIgnoreCase(string)) continue;
            return units;
        }
        return null;
    }

    public static ConceptCode b(String string) {
        Units units = Units.a(string);
        if (units != null) {
            return units.getCode();
        }
        return new GenericConceptCode(string, "UCUM", null, string, null);
    }
}

