/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.gui.content.audio;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.report.comprehensive.nodes.ReportNodeFactory;
import com.mimvista.report.gui.content.ReportContentView;
import com.mimvista.report.gui.content.audio.b;
import com.mimvista.report.gui.content.audio.recording.Stereo;
import com.mimvista.util.progress.Progress;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.text.SimpleDateFormat;
import javax.sound.sampled.AudioFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StereoController
extends ReportContentView<b>
implements Stereo.b,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int d = 12;
    private final Stereo stereo;
    private JButton rewind;
    private JButton record;
    private JButton play;
    private JButton forward;
    private JSlider positionScrubber;
    private JLabel statusLabel;

    public StereoController(b b2) {
        super(b2);
        this.stereo = this.a(b2.G());
        this.e(this.b());
        this.m();
        this.a(this);
    }

    private Stereo a(ReportNodeFactory.Waveform waveform) {
        Stereo stereo = null;
        if (waveform.waveformData == null) {
            stereo = new Stereo();
        } else {
            waveform.getClass();
            int n2 = waveform.sampleSize;
            int n3 = waveform.frameSize;
            waveform.getClass();
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, n2, 2, n3, 44100.0f, false);
            stereo = new Stereo(waveform.waveformData, audioFormat);
        }
        stereo.a(this);
        return stereo;
    }

    @Override
    protected boolean e() {
        return false;
    }

    @Override
    protected void a(Progress progress) {
    }

    @Override
    public void a(long l2, int n2) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                StereoController.this.positionScrubber.setValue(Math.round(StereoController.this.stereo.g() * 100.0f));
                StereoController.this.statusLabel.setText(StereoController.this.n());
                StereoController.this.statusLabel.repaint();
            }
        });
    }

    @Override
    public void a(final Stereo.StereoState stereoState, final Stereo.StereoState stereoState2) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                switch (stereoState2) {
                    case a: {
                        StereoController.this.record.setEnabled(true);
                        StereoController.this.play.setEnabled(true);
                        StereoController.this.record.setIcon(ImageManipulator.c("record", 12));
                        StereoController.this.play.setIcon(ImageManipulator.c("play", 12));
                        if (stereoState != Stereo.StereoState.c) break;
                        ReportNodeFactory.Waveform waveform = new ReportNodeFactory.Waveform(null, StereoController.this.stereo.j(), 0);
                        ((b)StereoController.this.state).a(waveform);
                        StereoController.this.stereo.k();
                        break;
                    }
                    case b: {
                        StereoController.this.record.setEnabled(false);
                        StereoController.this.play.setIcon(ImageManipulator.c("pause", 12));
                        break;
                    }
                    case c: {
                        StereoController.this.play.setEnabled(false);
                        StereoController.this.record.setIcon(ImageManipulator.c("pause", 12));
                    }
                }
                StereoController.this.invalidate();
                StereoController.this.repaint();
            }
        });
    }

    @Override
    public void d() {
        this.rewind = new JButton(ImageManipulator.c("rewind", 12));
        this.rewind.setActionCommand(StereoAction.a.name());
        this.rewind.addActionListener(this);
        this.record = new JButton(ImageManipulator.c("record", 12));
        this.record.setActionCommand(StereoAction.b.name());
        this.record.addActionListener(this);
        this.play = new JButton(ImageManipulator.c("play", 12));
        this.play.setActionCommand(StereoAction.c.name());
        this.play.addActionListener(this);
        this.forward = new JButton(ImageManipulator.c("fast_forward", 12));
        this.forward.setActionCommand(StereoAction.d.name());
        this.forward.addActionListener(this);
        this.positionScrubber = new JSlider();
        this.positionScrubber.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (StereoController.this.positionScrubber.getValueIsAdjusting()) {
                    if (StereoController.this.stereo.f() != Stereo.StereoState.a) {
                        StereoController.this.stereo.n();
                    }
                    StereoController.this.stereo.a((float)StereoController.this.positionScrubber.getValue() / 100.0f);
                }
            }
        });
        this.positionScrubber.setValue(0);
        this.statusLabel = new JLabel(this.n());
        this.statusLabel.setForeground(((b)this.state).q().getBlack());
        this.setLayout(new BoxLayout(this, 2));
        this.setBackground(((b)this.state).q().getWhite());
        this.add(this.rewind);
        this.add(this.record);
        this.add(this.play);
        this.add(this.forward);
        this.add(this.positionScrubber);
        this.add(this.statusLabel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        StereoAction stereoAction = StereoAction.valueOf(string);
        switch (stereoAction) {
            case a: {
                this.stereo.k();
                break;
            }
            case b: {
                if (this.stereo.f() == Stereo.StereoState.a) {
                    this.stereo.o();
                    break;
                }
                this.stereo.n();
                break;
            }
            case c: {
                if (this.stereo.f() == Stereo.StereoState.a) {
                    this.stereo.m();
                    break;
                }
                this.stereo.n();
                break;
            }
            case d: {
                this.stereo.l();
            }
        }
    }

    private String n() {
        Date date = new Date(this.stereo.h());
        Date date2 = new Date(this.stereo.i());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss:SSS");
        return simpleDateFormat.format(date) + " / " + simpleDateFormat.format(date2);
    }

    private static enum StereoAction {
        a,
        b,
        c,
        d;

    }
}

