/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.gui.content.common.filter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.report.gui.content.common.filter.GeneralSearchFilter;
import com.mimvista.report.gui.content.common.filter.SearchField;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SearchFieldFilter<ObjectType, FieldType>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String filterName;
    private String addToolTip;
    private String removeToolTip;
    private SearchField<ObjectType, FieldType> searchField;
    private List<Pair<FieldType, Boolean>> searchStrings;
    private transient com.mimvista.util.d.a<a> a;
    private boolean defaultUseRegex;
    private boolean showIndividualRegexInUI = true;

    public SearchFieldFilter(String string, String string2, String string3, Collection<FieldType> collection, SearchField<ObjectType, FieldType> searchField) {
        this(string, string2, string3, collection, searchField, false);
    }

    public SearchFieldFilter(String string, String string2, String string3, Collection<FieldType> collection, SearchField<ObjectType, FieldType> searchField, boolean bl2) {
        this(string, string2, string3, SearchFieldFilter.a(collection, bl2), searchField, bl2);
    }

    private static <FieldType> List<Pair<FieldType, Boolean>> a(Collection<FieldType> collection, boolean bl2) {
        ArrayList arrayList = Lists.newArrayList();
        for (FieldType FieldType2 : collection) {
            arrayList.add(Pair.get(FieldType2, bl2));
        }
        return arrayList;
    }

    private static <FieldType> List<Pair<FieldType, Boolean>> b(Map<FieldType, Boolean> map) {
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<FieldType, Boolean> entry : map.entrySet()) {
            arrayList.add(Pair.get(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    private static <FieldType> Map<FieldType, Boolean> b(List<Pair<FieldType, Boolean>> list) {
        HashMap hashMap = new HashMap();
        for (Pair<FieldType, Boolean> pair : list) {
            hashMap.put(pair.x, pair.y);
        }
        return hashMap;
    }

    private SearchFieldFilter(String string, String string2, String string3, List<Pair<FieldType, Boolean>> list, SearchField<ObjectType, FieldType> searchField, boolean bl2) {
        this.filterName = string;
        this.addToolTip = string2;
        this.removeToolTip = string3;
        this.searchField = searchField;
        this.searchStrings = list == null ? new ArrayList<Pair<FieldType, Boolean>>() : new ArrayList<Pair<FieldType, Boolean>>(list);
        this.defaultUseRegex = bl2;
        this.a();
    }

    public SearchFieldFilter(List<FieldType> list, SearchField<ObjectType, FieldType> searchField) {
        this(Messages.a("Report", "CONTOUR_NAME_FILTER"), Messages.a("Report", "ADD_NAME_FILTER_TOOLTIP"), Messages.a("Report", "SUBTRACT_NAME_FILTER_TOOLTIP"), list, searchField);
    }

    public void a() {
        this.a = new com.mimvista.util.d.a();
    }

    public String b() {
        return this.filterName;
    }

    public String c() {
        return this.addToolTip;
    }

    public String d() {
        return this.removeToolTip;
    }

    public SearchField<ObjectType, FieldType> e() {
        return this.searchField;
    }

    public int f() {
        return this.searchStrings.size();
    }

    public void g() {
        this.a(this.searchField.b());
    }

    public void a(FieldType FieldType2) {
        this.searchStrings.add(Pair.get(FieldType2, this.defaultUseRegex));
        this.k();
    }

    public void a(Collection<FieldType> collection) {
        this.searchStrings.addAll(SearchFieldFilter.a(collection, this.defaultUseRegex));
        this.k();
    }

    public void a(Map<FieldType, Boolean> map) {
        this.searchStrings.addAll(SearchFieldFilter.b(map));
        this.k();
    }

    public void a(int n2) {
        this.searchStrings.remove(n2);
        this.k();
    }

    public void h() {
        this.searchStrings.clear();
        this.k();
    }

    public void a(int n2, FieldType FieldType2) {
        Pair<FieldType, Boolean> pair = this.searchStrings.get(n2);
        if (pair == null) {
            pair = Pair.get(FieldType2, this.defaultUseRegex);
        } else {
            pair.x = FieldType2;
        }
        this.searchStrings.set(n2, pair);
        this.k();
    }

    public void a(int n2, boolean bl2) {
        Pair<FieldType, Boolean> pair = this.searchStrings.get(n2);
        if (pair == null) {
            ay.d((Object)"trying to set regex value on a search string that doesn't exist", this);
            return;
        }
        pair.y = bl2;
        this.searchStrings.set(n2, pair);
        this.k();
    }

    public boolean b(int n2) {
        Pair<FieldType, Boolean> pair = this.searchStrings.get(n2);
        if (pair == null) {
            ay.d((Object)"trying to set regex value on a search string that doesn't exist", this);
            return false;
        }
        return (Boolean)pair.y;
    }

    public void a(boolean bl2) {
        this.defaultUseRegex = bl2;
        for (Pair<FieldType, Boolean> pair : this.searchStrings) {
            pair.y = bl2;
        }
        this.k();
    }

    public FieldType c(int n2) {
        Pair<FieldType, Boolean> pair = this.searchStrings.get(n2);
        if (pair == null) {
            return null;
        }
        return (FieldType)pair.x;
    }

    public List<FieldType> i() {
        ArrayList arrayList = Lists.newArrayList();
        for (Pair<FieldType, Boolean> pair : this.searchStrings) {
            arrayList.add(pair.x);
        }
        return arrayList;
    }

    public List<ObjectType> a(List<ObjectType> list) {
        HashSet hashSet = Sets.newHashSet();
        ArrayList arrayList = Lists.newArrayList(list);
        for (Pair pair : Lists.newArrayList(this.searchStrings)) {
            for (Object e2 : arrayList) {
                if (!this.searchField.a(e2, pair.x, (Boolean)pair.y)) continue;
                hashSet.add(e2);
            }
            arrayList.removeAll(hashSet);
        }
        return Lists.newArrayList((Iterable)hashSet);
    }

    public void a(a a2) {
        this.a.d(a2);
    }

    private void k() {
        this.a.b(new FuncUtils.m<a>(){

            public void a(a a2) {
                a2.filterChanged();
            }

            @Override
            public /* synthetic */ void doIt(Object object) {
                this.a((a)object);
            }
        });
    }

    public boolean j() {
        return this.showIndividualRegexInUI;
    }

    public void b(boolean bl2) {
        this.showIndividualRegexInUI = bl2;
    }

    public static Map<String, Boolean> a(String string) {
        try {
            return (Map)new ObjectMapper().readValue(string, (TypeReference)new TypeReference<Map<String, Boolean>>(){});
        }
        catch (Exception exception) {
            ay.d((Object)"error deserializing filters", (Throwable)exception, SearchFieldFilter.class);
            return new HashMap<String, Boolean>();
        }
    }

    public static String a(SearchFieldFilter<?, ?> searchFieldFilter) {
        try {
            return new ObjectMapper().writeValueAsString(SearchFieldFilter.b(searchFieldFilter.searchStrings));
        }
        catch (JsonProcessingException jsonProcessingException) {
            ay.d((Object)"error serializing filters", (Throwable)jsonProcessingException, SearchFieldFilter.class);
            return "";
        }
    }

    public static <T> void a(GeneralSearchFilter<T> generalSearchFilter, List<T> list, String string) {
        boolean bl2 = true;
        try {
            CheckedContourJSONWrapper checkedContourJSONWrapper = null;
            String[] stringArray = null;
            try {
                checkedContourJSONWrapper = (CheckedContourJSONWrapper)new ObjectMapper().readValue(string, CheckedContourJSONWrapper.class);
            }
            catch (Throwable throwable) {
                ay.c((Object)"Filter checkbox deserialization first pass failure", throwable, SearchFieldFilter.class);
                stringArray = (String[])new ObjectMapper().readValue(string, String[].class);
            }
            if (checkedContourJSONWrapper != null) {
                stringArray = checkedContourJSONWrapper.contours;
                if (checkedContourJSONWrapper.allContoursChecked) {
                    generalSearchFilter.k();
                }
            }
            if (stringArray == null) {
                throw new NullPointerException("Unable to restore checked contours");
            }
            block4: for (String string2 : stringArray) {
                for (T t2 : list) {
                    if (!string2.equals(generalSearchFilter.e().apply(t2))) continue;
                    if (!generalSearchFilter.g().contains(t2)) continue block4;
                    generalSearchFilter.b(t2);
                    continue block4;
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Unable to restore checked status, defaulting to true...", throwable, SearchFieldFilter.class);
            bl2 = false;
        }
        if (!bl2) {
            generalSearchFilter.k();
        }
    }

    public static <T> String a(GeneralSearchFilter<T> generalSearchFilter) {
        List<T> list = generalSearchFilter.h();
        CheckedContourJSONWrapper checkedContourJSONWrapper = new CheckedContourJSONWrapper();
        if (generalSearchFilter.h().size() == generalSearchFilter.g().size()) {
            CheckedContourJSONWrapper.a(checkedContourJSONWrapper, new String[0]);
            checkedContourJSONWrapper.allContoursChecked = true;
        } else {
            CheckedContourJSONWrapper.a(checkedContourJSONWrapper, new String[list.size()]);
            checkedContourJSONWrapper.allContoursChecked = false;
        }
        for (int i2 = 0; i2 < checkedContourJSONWrapper.contours.length; ++i2) {
            ((CheckedContourJSONWrapper)checkedContourJSONWrapper).contours[i2] = (String)generalSearchFilter.e().apply(list.get(i2));
        }
        String string = null;
        try {
            string = new ObjectMapper().writeValueAsString((Object)checkedContourJSONWrapper);
        }
        catch (JsonProcessingException jsonProcessingException) {
            ay.d((Object)"Unable to saved checked status of stats", (Throwable)jsonProcessingException, SearchFieldFilter.class);
        }
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a();
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class CheckedContourJSONWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean allContoursChecked = false;
        private String[] contours = new String[0];

        public boolean a() {
            return this.allContoursChecked;
        }

        public String[] b() {
            return this.contours;
        }

        static /* synthetic */ String[] a(CheckedContourJSONWrapper checkedContourJSONWrapper, String[] stringArray) {
            checkedContourJSONWrapper.contours = stringArray;
            return stringArray;
        }
    }

    public static interface a {
        public void filterChanged();
    }
}

