/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.report.gui.viewer;

import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.RealLoadState;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.report.gui.viewer.LazyPdfImagePanel;
import com.mimvista.swing.widgets.SpinnyLabel;
import com.mimvista.util.ay;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;

public class PDFPreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel holder;
    private DcmSeries reportSeries;
    private SpinnyLabel loadingSpinny;

    public PDFPreviewPanel(DcmSeries dcmSeries) {
        this.reportSeries = dcmSeries;
        this.setBackground(MIMLookAndFeel.E());
        this.setLayout(new BorderLayout(0, 0));
        this.loadingSpinny = new SpinnyLabel();
        this.loadingSpinny.a(true);
        this.loadingSpinny.a(1.0f);
        Dimension dimension = new Dimension(30, 30);
        this.loadingSpinny.setMinimumSize(dimension);
        this.loadingSpinny.setPreferredSize(dimension);
        this.holder = new FitWidthScrollablePanel();
        this.holder.setBackground(MIMLookAndFeel.E());
        this.holder.setLayout(new BoxLayout(this.holder, 1));
        this.holder.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.holder.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PDFPreviewPanel.this.a();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.holder, 22, 31);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.loadingSpinny, "South");
        this.loadingSpinny.setVisible(false);
        this.b();
    }

    private void a() {
        this.a(this.reportSeries);
    }

    private void a(DcmSeries dcmSeries) {
        RealLoadState.a(dcmSeries.getDataProvider().getFirstDicomObj(), true);
    }

    private void b() {
        m.e.execute(() -> {
            SwingUtilities.invokeLater(() -> {
                this.loadingSpinny.setVisible(true);
                this.loadingSpinny.a();
            });
            LoaderDataProvider loaderDataProvider = this.reportSeries.getDataProvider();
            try (DicomInputStream dicomInputStream = new DicomInputStream(loaderDataProvider.getStream(loaderDataProvider.getFilenames().get(0)));){
                dicomInputStream.setHandler((DicomInputHandler)new StopTagInputHandler(4325393));
                dicomInputStream.readDicomObject();
                try (PDDocument pDDocument = PDDocument.loadNonSeq((InputStream)dicomInputStream, null);){
                    int n2;
                    List list = pDDocument.getDocumentCatalog().getAllPages();
                    ArrayList<LazyPdfImagePanel> arrayList = new ArrayList<LazyPdfImagePanel>(list.size());
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        LazyPdfImagePanel lazyPdfImagePanel = new LazyPdfImagePanel();
                        arrayList.add(n2, lazyPdfImagePanel);
                    }
                    MIMSwingUtils.b(() -> {
                        if (arrayList.isEmpty()) {
                            this.holder.add(Box.createVerticalGlue());
                        } else {
                            Iterator iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                this.holder.add((Component)iterator.next());
                                if (!iterator.hasNext()) continue;
                                this.holder.add(Box.createRigidArea(new Dimension(0, 5)));
                            }
                            this.holder.add(Box.createVerticalGlue());
                        }
                        this.revalidate();
                        this.repaint();
                    });
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        ((LazyPdfImagePanel)arrayList.get(n2)).a((PDPage)list.get(n2), n2);
                    }
                    this.revalidate();
                    this.repaint();
                }
            }
            catch (Exception exception) {
                ay.d((Object)"Error Parsing PDF", (Throwable)exception, PDFPreviewPanel.class);
                return;
            }
            finally {
                SwingUtilities.invokeLater(() -> {
                    this.loadingSpinny.setVisible(false);
                    this.loadingSpinny.c();
                });
            }
        });
    }

    public static Optional<DcmSeries> a(List<DcmSeries> list) {
        return list.stream().filter(dcmSeries -> dcmSeries != null).filter(dcmSeries -> SeriesIdentifier.isEncapsulatedPDF((String)dcmSeries.getTagValue(524310))).findFirst();
    }

    private static class FitWidthScrollablePanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;

        private FitWidthScrollablePanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
            return 50;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
            return 150;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

