/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.response.gui.views;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.ContourPredicate;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.e;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.dicom.DcmCaptureToImageConverter;
import com.mimvista.file.PathUtils;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.overlays.ChrontourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.properties.af;
import com.mimvista.response.a;
import com.mimvista.response.gui.TherapyResponseWindow;
import com.mimvista.response.gui.components.StatisticsTable;
import com.mimvista.response.gui.views.StatisticsView;
import com.mimvista.response.gui.views.c;
import com.mimvista.response.i;
import com.mimvista.response.j;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.h;
import com.mimvista.workflow.backend.VariableReference;
import com.mimvista.workflow.gui.args.b;
import com.mimvista.workflow.gui.args.w;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@e(e="save_stats", f="save_stats", b="save_stats_name", a="Commands", h="view_stats", l={MIMFeatureType.Workflow}, i={com.mimvista.commands.i.class}, k=MIMFeatureCategory.CONTOURING, j={LicenseOption.BASE, LicenseOption.ULTRASOUND_3D}, n={SessionPredicate.NonNull})
@com.mimvista.commands.a(a={ContourPredicate.Non2dContour, ContourPredicate.NonEmptyVolumetric})
public class SaveStatisticsCommand
extends WorkflowCommand {
    public static final String a = "USE_STAT_VIEWER_LAYOUT";
    private List<VolumetricContourOverlayish> b;
    private File c;
    private boolean d;
    private String e;

    public SaveStatisticsCommand(boolean bl2, List<VolumetricContourOverlayish> list, String string, File file) {
        this.d = bl2;
        this.b = list;
        this.c = file;
        this.e = string;
    }

    @Override
    public Object execute() {
        List<ViewController> list = this.p.ad();
        this.computeAllStats(list);
        this.getDestinationFile(list);
        if (this.c == null) {
            this.o.d(Messages.a("Commands", "SAVE_STATS_BAD_PATH"));
            return null;
        }
        List<i> list2 = new j(this.p).a((Collection<ViewController>)list);
        VolumetricContourOverlayish volumetricContourOverlayish = this.getReferenceContourOrNull();
        for (i i2 : list2) {
            this.setReferenceContour(i2, volumetricContourOverlayish);
            String string = com.mimvista.response.gui.views.c.b(i2, "STATS_");
            af af2 = this.getLayoutPrefsForRead();
            Map<a, Boolean> map = StatisticsView.a(i2, string, af2);
            boolean bl2 = af2.getBooleanConfig(string + "_ROW_MAJOR", false);
            StatisticsTable statisticsTable = bl2 ? StatisticsTable.a(i2, map, null) : StatisticsTable.b(i2, map, null);
            File file = this.getSaveFile(i2, list2.size() > 1);
            statisticsTable.a(file);
        }
        return null;
    }

    private af getLayoutPrefsForRead() {
        if (this.e == null || this.e.isEmpty()) {
            this.e = a;
        }
        if (a.equals(this.e)) {
            this.e = TherapyResponseWindow.o();
        }
        if (cn.h(this.e)) {
            ay.c((Object)"couldn't find a layout to use, going with the default", this);
            this.e = TherapyResponseWindow.q();
        }
        return TherapyResponseWindow.a(this.e);
    }

    private void setReferenceContour(i i2, VolumetricContourOverlayish volumetricContourOverlayish) {
        if (volumetricContourOverlayish != null) {
            com.mimvista.response.series.a a2 = null;
            for (com.mimvista.response.series.a a3 : i2.E()) {
                if (!a3.a(volumetricContourOverlayish)) continue;
                a2 = a3;
                break;
            }
            if (a2 != null) {
                i2.a(a2);
            }
        }
    }

    private File getSaveFile(i i2, boolean bl2) {
        File file = null;
        String string = null;
        if (this.c.isDirectory()) {
            file = this.c;
            string = DcmCaptureToImageConverter.getUniqueFilename(i2.B().e());
        } else {
            file = this.c.getParentFile();
            string = this.c.getName();
            string = string.replace(".csv", "");
        }
        if (bl2) {
            string = string + "_" + i2.K();
        }
        file.mkdirs();
        return PathUtils.getUniquelyNamedFile(file, string, ".csv");
    }

    private void getDestinationFile(List<ViewController> list) {
        String string;
        File file;
        if (this.c == null) {
            return;
        }
        if (!this.c.getName().endsWith(".csv")) {
            file = this.c;
            string = DcmCaptureToImageConverter.getUniqueFilename(list.iterator().next().aP().o());
        } else {
            file = this.c.getParentFile();
            string = this.c.getName().substring(0, this.c.getName().length() - ".csv".length());
        }
        if (file == null) {
            this.c = null;
            return;
        }
        try {
            file.mkdirs();
        }
        catch (Exception exception) {
            this.c = null;
            return;
        }
        if (!file.exists() || !file.canWrite() || file.getParentFile() == null) {
            this.c = null;
            return;
        }
        int n2 = 2;
        while (new File(file, string + ".csv").exists()) {
            string = string + "(" + n2 + ")";
            ++n2;
        }
        this.c = new File(file, string + ".csv");
    }

    private void computeAllStats(List<ViewController> list) {
        for (ViewController viewController : list) {
            for (VolumetricContourOverlayish volumetricContourOverlayish : viewController.ba().E()) {
                volumetricContourOverlayish.bF_().x();
                if (!(volumetricContourOverlayish instanceof ChrontourOverlay)) continue;
                for (ChrontourOverlay chrontourOverlay : ((ChrontourOverlay)volumetricContourOverlayish).bT_()) {
                    chrontourOverlay.bF_().x();
                }
            }
        }
    }

    private VolumetricContourOverlayish getReferenceContourOrNull() {
        this.d = this.d && this.b != null && !this.b.isEmpty();
        VolumetricContourOverlayish volumetricContourOverlayish = null;
        if (this.d) {
            volumetricContourOverlayish = this.b.iterator().next();
        }
        if (this.d && this.b.size() > 1) {
            this.o.e(Messages.a("Commands", "SAVE_STATS_MULTIPLE_REFERENCE_CONTOURS"));
        }
        return volumetricContourOverlayish;
    }

    @Override
    public com.mimvista.workflow.gui.args.a<WorkflowCommand>[] createArgumentViews(com.mimvista.workflow.gui.c<WorkflowCommand> c2) {
        com.mimvista.workflow.gui.args.a<WorkflowCommand>[] aArray = super.createArgumentViews(c2);
        com.mimvista.workflow.gui.args.a<WorkflowCommand> a2 = aArray[1];
        a2.a(new h<Boolean>(){

            public Boolean a() {
                VariableReference variableReference = SaveStatisticsCommand.this.n.getInputVarReference(SaveStatisticsCommand.this, 0);
                if (variableReference != null) {
                    return !Boolean.parseBoolean(variableReference.a().toString());
                }
                return true;
            }

            @Override
            public /* synthetic */ Object call() {
                return this.a();
            }
        });
        b b2 = (b)aArray[0];
        b2.f(Messages.a("Commands", "SAVE_STATS_UPDATE_REFERENCE"));
        b2.g(Messages.a("Commands", "SAVE_STATS_NO_UPDATE_REFERENCE"));
        b2.a(false, a2);
        b2.b(true, a2);
        aArray[2] = new w<WorkflowCommand>(c2, 2, this.getLayoutOptions(), null);
        return aArray;
    }

    private List<Pair<String, String>> getLayoutOptions() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(Pair.get(a, Messages.a("Commands", a)));
        List<String> list = TherapyResponseWindow.p();
        for (String string : list) {
            arrayList.add(Pair.get(string, string));
        }
        return arrayList;
    }
}

